 /*  *			c o p y . c  */   
 /*)LIBRARY */   #ifdef	DOCUMENTATION  ' title	copy	Copy a Given Number of Bytese# index		Copy a given number of bytesp   synopsis 	.s.nf 	char *= 	copy(out, in, nbytes)  	char		*out;	/* Output vector	*/ 	char		*in;	/* Input vector		*/h( 	unsigned int	count;	/* Bytes to copy	*/ 	.s.ft Descriptionh  7 	Copy the indicated number of bytes from the input arear8 	to the output area.  Return a pointer to the first free/ 	byte in the output area.  (I.e., &out[count]).l  9 	The copying will be faster if out and in are either bothf 	even or both odd addresses.   Bugs  @ 	Warning, this routine "understands" pdp-11 address conventions. #endif   #ifdef	pdp11 #define	SHIFT	1e #define	LOWBIT	01  #elsev
 #ifdef	vax #define	SHIFT	2t #define	LOWBIT	03g #else	 #ifdef	mc68000 #define	SHIFT	2t #define	LOWBIT	03C #else  #endif #endif #endif   char * copy(out, in, count) register char		*out; register char		*in;  register unsigned int	count; /*  * Copy a given number of bytesi  */l {e 	if (count != 0) { #ifdef	SHIFT 	    if (count > 10) { 		/* 		 * Try to optimize 		 */s, 		if ((((unsigned int) in) & LOWBIT) != 0) { 		    *out++ = *in++;p 		    count--; 		}e- 		if ((((unsigned int) out) & LOWBIT) == 0) {n. 		    count >>= SHIFT;	/* Get a word count		*/
 		    do {$ 			*((int *)out)++ = *((int *)in)++; 		    } while (--count != 0);h 		    goto exit; 		}n 	    }	t #endif 	    /*eA 	     * Here for small copies, strange machines, and copies whereeD 	     * the output buffer isn't the same parity as the input buffer. 	     */	 	    do {* 		*out++ = *in++;i 	    } while (--count != 0); 	} exit:	return (out);{ }	