 /* #define	TESTING  */i /*  *			d o p r n t . c  *  */e  
 /*)LIBRARY */   #ifdef	DOCUMENTATION   title		Output Formatter  index		Output formatter;   internal   synopsis 	.s.nf 	c_doprnt(format, argvec, iov) 	char		*format;  	int		*argvec[]; 	FILE		*iov; 	.s.fa Description   < 	c_doprnt() performs all formatting operations for printf(),@ 	sprintf(), and fprintf().  The formatting options are described" 	in the documentation of printf().   Bugs  = 	c_doprnt() is functionally identical to the _doprnt() module @ 	in Unix and Vax-11 C libraries.  Unfortunately, the initial '_', 	conflicts with RSX FCS library conventions.   Internal  . 	A test routine may be conditionally compiled.   #endif   #include		<stdio.h>	 #include		<ctype.h>g #define	EOS		('\0')  #define	FALSE		0 #define	TRUE		1  #ifdef	PDP10 #define	BITS_PER_CHAR	36 #else, #define	BITS_PER_CHAR	8( #endif   /*H  * WORKSIZE is the dimension of work[] which must hold enough charactersG  * to store a long integer (expanded using the %b format) + '-' and EOSa  */x8 #define	WORKSIZE	(((sizeof (long)) * BITS_PER_CHAR) + 2)   struct	fmtbuf {r- 	char	f_type;		/* Format type ('d', etc.)		*/ 2 	char	f_width;	/* Argument width (INT or LONG)		*/2 	char	f_radix;	/* Argument radix (8, 10, etc.)		*/ };  
 #define	INT	00 #define	LONG	1. #define	NEG	2		/* Signal for output of '-'		*/  
 #ifdef	M68000P ROM_SECT(rom00); #endif /*<  * formatinfo[] stores information about the "value" formats  */s% static struct fmtbuf formatinfo[] = {u 	{ 'b',	INT,	 2 }, 	{ 'd',	INT,	10 }, 	{ 'o',	INT,	 8 }, 	{ 'u',	INT,	10 }, 	{ 'x',	INT,	16 }, 	{ 'B',	LONG,	 2 },c 	{ 'D',	LONG,	10 },t 	{ 'O',	LONG,	 8 },  	{ 'U',	LONG,	10 },r 	{ 'X',	LONG,	16 },L 	{ EOS,	0,	 0 }, };     c_doprnt(format, argp, fildes)$ char		*format;		/* Format string		*/3 register int	*argp;			/* Argument vector pointer	*/ & FILE		*fildes;		/* File descriptor		*/ {* 	register int		c;t 	register union {o 	    struct fmtbuf	*fmt; 	    char		*result;b 	} p;		i0 	char		ljust;		/* TRUE for left-justification	*/+ 	char		work[WORKSIZE];	/* Number buffer		*/'( 	char		fill;		/* '0' or ' ' for fill		*/ 	int		prec;		/* Precision			*/! 	int		slen;		/* Field length			*/'# 	int		width;		/* Argument width		*/  #ifdef	decus. 	unsigned	value;		/* Current argument value	*/ #else	 	unsigned long	value;	 #endif& 	int		temp;		/* Set if '-' needed.		*/' 	short		radix;		/* Conversion radix		*/n  ! 	while ((c = *format++) != EOS) {c 	    /**, 	     * Check for conversion specifications. 	     */ 	    if (c == '%') { 		/* 		 * Check for various options.b 		 */e 		c = *format++;' 		ljust = 0;			/* No left adjustment	*/c& 		fill = ' ';			/* Fill with spaces	*/) 		if (c == '-') {			/* %-	left justify	*/  		    ljust++; 		    c = *format++; 		}	, 		if (c == '0') {			/* %0d	zero fill arg.	*/ 		    fill = c;e 		    c = *format++; 		}f5 		if (c == '?' || c == '*') {	/* %*	width from arg	*/* 		    width = *argp++; 		    c = *format++; 		}   		else {				/* %n	field width	*/ 		    width = 0; 		    while (isdigit(c)) { 			width *= 10;r 			width += (c - '0'); 			c = *format++;; 		    }  		}	( 		if (c == '.') {			/* %n.n	precision	*/+ 		    c = *format++;		/* %n.* (from arg)	*/	! 		    if (c == '?' || c == '*') {+ 			prec = *argp++; 			c = *format++;  		    }	 		    else { 			prec = 0; 			while (isdigit(c)) {  			    prec *= 10; 			    prec += (c - '0');  			    c = *format++;* 			} 		    }  		}g 		else {- 		    prec = 32767;		/* No prec. specified	*/  		}	 		/*3 		 * Process conversion chars, understanding longs.* 		 */  		if (c == 'l' || c == 'L') {* 		    switch (c = *format++) { 		    case 'b':* 		    case 'd':/ 		    case 'o':a 		    case 'u':o 		    case 'x': % 			c = toupper(c);	/* Make %lb %B		*/  		    case 'B':* 		    case 'D':  		    case 'O':  		    case 'U':w 		    case 'X': 	 			break;p- 		    default:		/* Here on %Lfoo ==> %Ufoo	*/c 			c = 'U';* 			format--;	 			break;	 		    }	 		}r 		/*= 		 * Search the numeric format structure for this conversion.e 		 */h 		for (p.fmt = formatinfo;0 			(p.fmt->f_type != c && p.fmt->f_type != EOS); 			p.fmt++)a 		    ;	 		if (p.fmt->f_type != EOS) {/ 		    /*( 		     * A numeric conversion was found.8 		     * Get the value and expand it into the work area.	 		     */a 		    radix = p.fmt->f_radix;  		    temp = p.fmt->f_width;! 		    p.result = &work[WORKSIZE];r0 		    *--p.result = EOS;		/* Terminate result	*/ 		    if (temp == INT) { 			if (c == 'd' && *argp < 0) {i 			    value = -*argp++;) 			    temp = NEG;		/* Remember signal	*/a 			} 			elsem" 			    value = (unsigned) *argp++; 		    }p 		    else { 			value = *((long *) argp)++; 		    }  #ifdef	TESTING 		    fprintf(stderr, : 			"radix %d, value = %d (signed), %u (unsigned), 0x%x\n", 			radix, value, value, value);. #endif 		    if (value == 0)f 			*--p.result = '0';e 		    else { 			/*]* 			 * Convert an unsigned non-zero number. 			 */ 			do {f 			    c = value % radix;=7 			    *--p.result = c + ((c < 10) ? '0' : ('a' - 10));t# 			} while ((value /= radix) != 0);	 			if (temp == NEG)v 			    *--p.result = '-';  		    }  #ifdef	TESTING3 		    fprintf(stderr, "result \"%s\"\n", p.result);G #endif 		}t	 		else {   		    /* 		     * String or something 		     */		x 		    switch (c) {' 		    case 'q':			/* Funny int value	*/u 			/*f. 			 * Convert a word as a pair of octal bytes. 			 */
 			c = 16384;e 			p.result = work;	 			temp = *argp++; 			while (c > 0) {& 			    *p.result++ = (temp / c) + '0'; 			    temp %= c;t 			    if (c == 256) { 				c = 64;	 				*p.result++ = '.'; 			    } 			    else' 				c >>= 3; 			} 			*p.result = EOS;t 			p.result = work;s	 			break;s  % 		    case 'r':			/* Remote format	*/* 			argp = (int *) *argp; 			format = (char *) *argp++;h! 			continue;		/* No print here	*/i   		    case 's':			/* String		*/ - 			if ((p.result = (char *) *argp++) == NULL)=* 			    p.result = "{NULL}";	/* Bug hack	*/	 			break;w  " 		    case 'c':			/* Character		*/ 			c = *argp++;  			/*t 			 * Fall through 			 */% 		    default:			/* %% or whatever	*/  		    	p.result = work;s 			*p.result = c;	 			work[1] = EOS;E	 			break;r 		    }o 		}  		/*0 		 * p.result -> first byte of string to output.  		 * Reuse c as a register temp. 		 */ 1 		c = strlen(p.result);		/* True result length	*/ 3 		slen = (c > prec) ? prec : c;	/* Field length		*/( #ifdef	TESTING> 		fprintf(stderr, "width %d, field length %d, precision %d\n", 		    width, slen, prec);C #endif& 		if (!ljust) {			/* Right justify?	*/ 		    while (--width >= slen) {: 			putc(fill, fildes); 		    }p 		}l 		/*+ 		 * Output the string (up to "prec" bytes)  		 */k1 		for (c = prec; *p.result != EOS && --c >= 0;) {t  		    putc(*p.result++, fildes); 		} $ 		if (ljust) {			/* Left justify?	*/ 		    while (--width >= slen) {h 			putc(' ', fildes);c 		    }: 		}* 	    } 	    else {i 		/*, 		 * Not in a % thing, just output the byte. 		 */  		putc(c, fildes); 	    } 	}$ 	if ((fildes->_flag & _IOSTRG) != 0) 	    putc(EOS, fildes);	 	return; }w   #ifdef	TESTING   char	format[133];; char	inputline[133];	 int	v[3];u   main() { 	extern char	*prompt();	   	for (;;) {=" 	    if (prompt("Format") == NULL) 		break; 	    strcpy(format, inputline); ! 	    v[0] = rdint("v1", 1, 0, 0);	! 	    v[1] = rdint("v2", 1, 0, 0);h! 	    v[2] = rdint("v3", 1, 0, 0);  	    printf("\"");! 	    c_doprnt(format, v, stdout);, 	    printf("\"\n"); 	} }    char * prompt(info) char		*info; /*0  * Prompt, read text from console to input line.#  * Return inputline or NULL at eof.   */r {r 	register char	*result;e 	extern char	*gets();a   	clearerr(stdin);* 	if (info != NULL)$ 	    fprintf(stderr, "%s:  ", info); 	fflush(stderr); 	inputline[0] = EOS; 	result = gets(inputline); 	return (result);  }v   intd! rdint(info, low, high, def_value)d" char		*info;			/* Prompt text			*/* int		low;			/* Minimum acceptable value	*/+ int		high;			/* Maximum acceptable value	*/i% int		def_value;		/* Default value		*/  /*%  * Prompt and read an integer.  Note:   *	info		must be present"  *	low > high	any value acceptable  */t {  	register int		value;r 	register char		*lp;   	for (;;) {  	    if (low <= high) { ( 		fprintf(stderr, "%s <%d..%d> [%d]?  "," 		    info, low, high, def_value); 	    } 	    else { 1 		fprintf(stderr, "%s [%d]?  ", info, def_value);i 	    }5 	    if (prompt(NULL) == NULL || inputline[0] == EOS)a& 		sprintf(inputline, "%d", def_value); 	    value = atoi(inputline);/7 	    if (low > high || (value >= low && value <= high))  		break; 	    fprintf(stderr,; 		"Illegal value %d, range is %d..%d, please try again.\n",	 		value, low, high); 	} 	return (value); }    #endif