 /*  *	n e t u t l - netio  */f  
 /*)LIBRARY */   #ifdef	DOCUMENTATION  3 Title	netio	network io routines for use with netlnk 3 Index	netio	network io routines for use with netlnkn   synopsis 	.s.nf 	  get_net(buf, len, iovp)( 	  char *buf;		/* buffer to read into */! 	  int len;		/* size of buffer */ , 	  NIOV *np;		/* ptr to NIOV of open link */ 	.sI 	  put_net(buf, len, iovp)
 	  char *buf;a 	  int len;  	  NIOV *np; 	.sr 	  gta_net(buf, len, np, ast) 
 	  char *buf;= 	  int len;n 	  NIOV *np; 	  int (*ast)(); 	.s.f* DescriptionA  8 	These routines provide network IO calls similar to the % 	file system fget() and fput() calls.	 	.sr7 	The NIOV pointers are similar to file pointers and are * 	returned by con_net() or acc_net() calls. 	.sr< 	Get_net() and put_net() return the number of bytes received: 	or sent. On error, both return NULL, the error code is in 	$$nerr. 	.sc7 	Both routines are synchronous, they don't return untilb: 	the get or put completes. Note that if you call get_net()9 	and the other node is also waiting for you to send data,e 	both tasks will stall forever.r 	.sh9 	Gta_net() allows specifying an ast function to be called : 	when the network receive completes. This function returns8 	immediately. If the read is successfully started, 1 is 9 	returned, on error, 0 is returned with the error code inr 	$$nerr. 	    Implementation Details  : 	Derived from the original netutl routines. These routines. 	use the NIOV structure defined in <stdnet.h>.   Bugs  5 	Until all current tasks are converted, there will be 6 	two versions of the netutl functions around, with the 	expected confusion.   edit history 	.nf .sn7 	01 13-mar-86 hjj get_net() and put_net() really return - 			NULL on error. Previously returned iosb[1]s 			on error. #endif   #include <stdio.h> #include <cx.h>d #include <stdnet.h>i   extern int $$nerr;     get_net(buf, len, np)r
 char *buf; int len;	 NIOV *np;t {s#   if ((np->status & LINKUP) == 0) {t     $$nerr = IE_NLN;     return(NULL);t   }l;   $$nerr = recwnt(np->lun, np->efn, np->iosb, 0, buf, len);f   if ($$nerr < 0) return(NULL);h  /   if (($$nerr = np->iosb[0]) < 1) return(NULL);n   else return(np->iosb[1]);  }    put_net(buf, len, np) 
 char *buf; int len;	 NIOV *np;r { #   if ((np->status & LINKUP) == 0) {c     $$nerr = IE_NLN;     return(NULL);e   }n;   $$nerr = sndwnt(np->lun, np->efn, np->iosb, 0, buf, len);r   if ($$nerr < 0) return(NULL);   /   if (($$nerr = np->iosb[0]) < 1) return(NULL);I   else return(np->iosb[1]);  }    gta_net(buf, len, np, ast)
 char *buf; int len;	 NIOV *np; 
 int (*ast)();  {u#   if ((np->status & LINKUP) == 0) {b     $$nerr = IE_NLN;     return(NULL);p   }b<   $$nerr = recnt(np->lun, np->efn, np->iosb, ast, buf, len);   if ($$nerr < 0) return(NULL);      $$nerr = np->iosb[0];r   return(1); }e