 /*  *	n e t u t l - netlnkf  */1  
 /*)LIBRARY */   #ifdef	DOCUMENTATION  / Title	netlnk	network link functions for Decus Cn/ Index	netlnk	network link functions for Decus Ce   synopsis 	.s.nf 	  _#include <stdnet.h>T 	.st 	  NIOV *opn_net(nfp)p 	  int (*nfp)(); 	.sh 	  clsnet(); 	.s & 	  NIOV *con_net(dest_node, dest_task) 	  char *dest_node, *dest_task;s 	.st% 	  NIOV *con_obj(dest_node, dest_obj)  	  char *dest_node;s 	  int dest_obj; 	.se 	  NIOV *acc_net(con_buf_ptr),  	  struct a_conblk *con_buf_ptr; 	.st 	  dsc_net(np, msg)A 	  NIOV *np;
 	  char *msg;N 	.s.fl Descriptiono  : 	This group of functions allows openning a Decnet network,7 	reading network data, and establishing and maintainingn 	links.. 	.s < 	Opn_net() connects a task to the network. It must be issued= 	before any other network calls. See the DECnet documentation 	 	on OPN$.s 	.st8 	Opn_net() takes one argument, the address of a function= 	to handle network messages. If the argument is NULL, network = 	messages will still be dequeued from the netword data queue,N 	but will be discarded.  	.sl: 	If specified, the network message function will be called 	as follows: 	.s.nf 		netmsg(iosb, msg)d. 		int iosb[2];	/* stat block from GND$ call */$ 		char *msg;	/* message from GND$ */   	.s.fu9 	You should be familiar with how GND$ returns data beforee8 	using this function. The msg pointer points to a buffer6 	large enough to accept a full connect request message6 	and can be passed directly to the acc_net() function. 	.si7 	Your netmsg() function is called at ast state, and thee6 	buffer pointed to by msg is allocated dynamically. It9 	is freed when your function returns. If you need to save,6 	any data from the message buffer, copy it to your own 	buffer before returning.m 	.s 8 	Cls_net() closes the network data queue and returns the4 	NIOV data structure and lun allocated for the link.8 	Closing the network link while any data links are still& 	up will cause unpredictable problems. 	.s : 	Con_net() will attempt to connect the the remote node and< 	task specified in the arguments. If it succeeds, it returns< 	an NIOV pointer. If the connect fails, NULL is returned and> 	the error condition is returned in $$nerr. You should declare 	$$nerr as:n 	.s.nf 		extern int $$nerr; 	.s.fC9 	if you wish to use it. The pointer returned by con_net()O; 	is required for network IO functions such as put_net() ande 	get_net().  	.s : 	Con_obj() is similar to con_net(), but is used to connect" 	to remote number network objects. 	.sn8 	Acc_net() will attempt to accept a connect request from: 	another node. It is normally called with a connect buffer/ 	retrieved from the task's network data queue. n 	.sn: 	Acc_net() returns an NIOV pointer if successful, and NULL8 	on error. The error condition is availible from $$nerr. 	.s 7 	Dsc_net() disconnects a logical link. The NIOV pointerI; 	must point to an open logical link, if not, unpredicatableo 	errors will result. n 	.s $ 	You may pass a message to the other; 	end of the link when disconnecting by passing a pointer to < 	the message in msg. Set the msg argument to 0 if no message 	is needed.  	.sr8 	Dsc_net() frees the NIOV structure and lun used for the; 	link. The memory area pointed to by np is returned to freeo 	memory, don't try to reuse np.v   Implementation Details  : 	These routines try to mimic the Decus C interface to the + 	file system. NIOV is described in stdio.h.p 	.sa9 	NIOV data structures are allocated with malloc and freedg 	as necessary. 	.so6 	Be sure you understand how the user supplied network 7 	message function is called. The current implimentationa8 	is an attempt to provide the greatest flexibility while= 	still hiding as much of the gory network detail as possible.  	.st: 	The internal function getmsg() will check for the NT.DSC,< 	NT.ABT, and NT.ABO and free the appropriate NIOV structures; 	and luns AFTER calling the user supplied message function.    Bugs  9 	The routines try to do some error checking, but if a bad : 	NIOV pointer is passed to a function, many strange things: 	could happen, not the least of which is clobbering random 	areas of memory. Be careful.r   Edit History  3 	  01 05/08/85 hjj fixed bad check for NDA in gndw.  #endif   #include <stdio.h> #include <cx.h>a #include <stdnet.h>i  9 extern int $$nlun;	/* number of luns available (C RTL) */p  9 int $$nerr;		/* define $$nerr here. We assume any code */p5 			/* using $$nerr will call one of these routines */o  0 NIOV *$$$ndq;		/* pointer to network que niov */  B static int (*netmsg)();	/* pointer to network queue msg handler */   /*
 	functions */   NIOV *opn_net(nfp)+ int (*nfp)();		/* pointer to msg handler */  { 7   NIOV *np_alo();	/* returns a pointer to a new NIOV */    extern word cmpast();u   extern word netast();n  0   if (($$$ndq = np_alo()) == NULL) return(NULL);  C   $$nerr = opnwnt($$$ndq->lun, $$$ndq->efn, $$$ndq->iosb, 0, 0, 0);o.   dirtst($$nerr, $$$ndq->iosb, "opnw failed");     if (nfp) netmsg = nfp;   else netmsg = NULL;o  L   $$nerr = spawnt($$$ndq->lun, $$$ndq->efn, $$$ndq->iosb, &cmpast, &netast);.   dirtst($$nerr, $$$ndq->iosb, "spaw failed");     return($$$ndq);o }e   #ifdef LUNDEBUG  pniov(msg, np)	 NIOV *np;r {r   printf("%s", msg);A   printf("lun %d efn %d rem_nam |%.8s| rem_tsk |%.8s| type %d\n",f:   	np->lun, np->efn, np->rem_nam, np->rem_task, np->type);"   printf("status %o iosb %o %o\n",' 	np->status, np->iosb[0], np->iosb[1]);$8   printf("$$luns[0-7] %o, %o, %o, %o, %o, %o, %o, %o\n",:   	$$luns[0], $$luns[1], $$luns[2], $$luns[3], $$luns[4], $   	$$luns[5], $$luns[6], $$luns[7]);9   printf("$$luns[8-15] %o, %o, %o, %o, %o, %o, %o, %o\n",u=   	$$luns[8], $$luns[9], $$luns[10], $$luns[11], $$luns[12], r(   	$$luns[13], $$luns[14], $$luns[15]);  }e #endif  	 cls_net()r {t	   dsar();y=   $$nerr = clswnt($$$ndq->lun, $$$ndq->efn, $$$ndq->iosb, 0);>.   dirtst($$nerr, $$$ndq->iosb, "clsw failed");-   np_fre($$$ndq);		/* free up NIOV and lun */"  	   enar();o   return(1); }   # NIOV *con_net(dest_node, dest_task), char *dest_node, *dest_task; {    NIOV *np;]   struct c_conblk *conp;  ,   if ((np = np_alo()) == NULL) return(NULL);  :   if ((conp = malloc(sizeof (struct c_conblk))) == NULL) {'     $$nerr = IE_NBF;	/* no room left */$     return(NULL);e   }   =   conb1(conp, dest_node, dest_task);	/* fill con req block */d  1   $$nerr = conwnt(np->lun, np->efn, np->iosb, 0, i1   	conp, (sizeof (struct c_conblk)), 0, 0, 0, 0);      if ($$nerr < 0) {n+     np_fre(np);		/* free up NIOV and lun */t     np = NULL;   }h<   else if (($$nerr = np->iosb[0]) != 1) { /* check status */+     np_fre(np);		/* free up NIOV and lun */t     np = NULL;   }c  8   if (np) {	/* fill in niov data if connect succeeded */+     np->type = conp->n_rot;	/* copy type */N?     if (np->type == 0) {		/* if remote is a task, not object */r?       copy(np->rem_nam, conp->n_rnd, 6);	/* copy remote node */i&       copy(np->rem_task, conp->n_rde, G   	((conp->n_rdec <= 16)?conp->n_rdec:16)); /* copy remote task name */d     }t     np->status |= LINKUP;l   } )   mfree(conp);		/* give back con block */a  
   return(np);e })  " NIOV *con_obj(dest_node, dest_obj) char *dest_node;
 int dest_obj;f {    NIOV *np;i   struct c_conblk *conp;  ,   if ((np = np_alo()) == NULL) return(NULL);  :   if ((conp = malloc(sizeof (struct c_conblk))) == NULL) {'     $$nerr = IE_NBF;	/* no room left *//     return(NULL);*   }   <   conb0(conp, dest_node, dest_obj);	/* fill con req block */  1   $$nerr = conwnt(np->lun, np->efn, np->iosb, 0, t1   	conp, (sizeof (struct c_conblk)), 0, 0, 0, 0);	     if ($$nerr < 0) {*+     np_fre(np);		/* free up NIOV and lun */t     np = NULL;   }r<   else if (($$nerr = np->iosb[0]) != 1) { /* check status */+     np_fre(np);		/* free up NIOV and lun */r     np = NULL;   }(  8   if (np) {	/* fill in niov data if connect succeeded */+     np->type = conp->n_rot;	/* copy type */n?     if (np->type == 0) {		/* if remote is a task, not object */ ?       copy(np->rem_nam, conp->n_rnd, 6);	/* copy remoet node */t&       copy(np->rem_task, conp->n_rde, G   	((conp->n_rdec <= 16)?conp->n_rdec:16)); /* copy remote task name */d     }t     np->status |= LINKUP;l   } )   mfree(conp);		/* give back con block */a  
   return(np);e })   NIOV *acc_net(cp)d struct a_conblk *cp; {    struct a_conblk *acp;l   NIOV *np;a   int aloc_flag;  .   aloc_flag = 0;	/* no memory allocated yet */   if (cp) acp = cp;=   else {;     if ((acp = malloc(sizeof (struct a_conblk))) == NULL) { )       $$nerr = IE_NBF;	/* no room left */        return(NULL);,     }n.     aloc_flag = 1;	/* mark memory allocated */   }*      if ((np = np_alo()) == NULL) {     if (aloc_flag) mfree(acp);     return(NULL);*   } 1   $$nerr = accwnt(np->lun, np->efn, np->iosb, 0, c) 		acp, (sizeof (struct a_conblk)), 0, 0);u     if ($$nerr < 0) {I+     np_fre(np);		/* free up NIOV and lun */;     np = NULL;   }e<   else if (($$nerr = np->iosb[0]) != 1) { /* check status */+     np_fre(np);		/* free up NIOV and lun */      np = NULL;   }      if (np) {	/* if no error */L*     np->type = acp->n_sot;	/* copy type */?     if (np->type == 0) {		/* if remote is a task, not object */f>       copy(np->rem_nam, acp->n_snd, 6);	/* copy remote node */%       copy(np->rem_task, acp->n_sde,  E 	  ((acp->n_sdec <= 16)?acp->n_sdec:16));	/* copy remote task name */      }n     np->status |= LINKUP;n   }    if (aloc_flag) mfree(acp);
   return(np);- }    ]   dsc_net(np, msg)	 NIOV *np; 
 char *msg; {/   if (np == 0) return(0);   1   $$nerr = dscwnt(np->lun, np->efn, np->iosb, 0, L- 		msg, ((strlen(msg) <= 16)?strlen(msg):16));   F   if ($$nerr == 1) $$nerr = np->iosb[0];  /* copy completion status */  )   np_fre(np);		/* free up NIOV and lun */n   np = NULL;   return(($$nerr == 1)?1:0); }   ? /***************************************************************!   internal functions from here onP? **************************************************************/   = static NIOV *np_alo()		/* allocate an NIOV with a free lun */r {)   NIOV *np;r   unsigned *lp, *a_lun();   =   if ((np = malloc(sizeof NIOV)) == NULL) { /* get an NIOV */ '     $$nerr = IE_NBF;	/* no room left */      return(NULL);s   }      zero(np, sizeof NIOV);  <   if ((lp = a_lun(&np->lun)) == NULL) { /* get a free lun */'     $$nerr = IE_ILU;	/* no luns left */*     return(NULL);*   }*  3   *lp = np;		/* insert the NIOV in the lun table */*3   np->efn = np->lun;	/* lun and efn are the same */   9   dirtst(alunx(np->lun, "NS", 0), 0, "link alun failed");r  
   return(np);r }    static np_fre(np))	 NIOV *np;( { 0   $$luns[np->lun-2] = 0;	/* zero out lun slot */   mfree(np); }I   static unsigned *a_lun(lnum)
 int *lnum; { *   unsigned *lp;		/* lun address pointer */   int lcnt;-     lp = $$luns;.   for (lcnt = 0; lcnt < $$nlun; lcnt++, lp++)      if (*lp == NULL) {7       *lnum = lcnt + 2;		/* free luns start at lun 2 */e       return(lp);p     }      return(NULL);  }   = static int conb1(conp, node, task)  /* fmt 1 connect block */u struct c_conblk *conp; char *node, *task; {_
   int i, len;*  )   zero(conp, (sizeof (struct c_conblk)));t:   fill(conp->n_rnd, 040, 6);	/* put spaces in node name */8   fill(conp->n_rde, 040, 16);	/* and destination task */     len = strlen(node);p/   copy(conp->n_rnd, node, (len > 6 ? 6 : len));+C   for (i = 0; i < 6; i++) conp->n_rnd[i] = toupper(conp->n_rnd[i]);n  8   conp->n_rdec = ((len = strlen(task)) > 16) ? 16 : len;(   copy(conp->n_rde, task, conp->n_rdec);D   for (i = 0; i < 16; i++) conp->n_rde[i] = toupper(conp->n_rde[i]);  *   conp->n_rfm = 1;	/* type 1 descriptor */&   conp->n_rot = 0;	/* object type 0 */     return(1); };  < static int conb0(conp, node, obj)  /* fmt 0 connect block */ struct c_conblk *conp; char *node;t int obj; { 
   int i, len;r  )   zero(conp, (sizeof (struct c_conblk)));0:   fill(conp->n_rnd, 040, 6);	/* put spaces in node name */     len = strlen(node);s/   copy(conp->n_rnd, node, (len > 6 ? 6 : len));eC   for (i = 0; i < 6; i++) conp->n_rnd[i] = toupper(conp->n_rnd[i]);o  *   conp->n_rfm = 0;	/* type 0 descriptor */.   conp->n_rot = obj;	/* fill in object type */     return(1); }    static word cmpast() {t%   byte *piosb;	/* pointer  to iosb */c     astset();u&   piosb = gtdp(0);	/* point to iosb */"   dirtst(1, piosb, "spaw failed");    piosb += 2;		/* move 1 word */"   if (*piosb > 0) get_msg(*piosb);
   astx(1); }n   static word netast() {d   astset();c
   get_msg(1);e
   astx(0); }:   static int get_msg(msgcnt) int msgcnt;_ {[   byte *bp;c   struct a_conblk *acp;p  9   if ((acp = malloc(sizeof (struct a_conblk))) == NULL) { '     $$nerr = IE_NBF;	/* no room left */      return(NULL);a   }      bp = $$$ndq->iosb;     while (msgcnt-- > 0) {  @     $$nerr = gndwnt($$$ndq->lun,  $$$ndq->efn, $$$ndq->iosb, 0, " 	acp, (sizeof (struct a_conblk)));?     if (($$nerr == 1) && ($$$ndq->iosb[0] == (IE_NDA & 0377)))  # 			return(1);	/* no data waiting */)0     dirtst($$nerr, $$$ndq->iosb, "gndw failed");       switch (*(bp+1)) { _
 	case NT_DSC:p
 	case NT_ABT:c 	case NT_ABO:	{ 2   		if (netmsg != 0) (*netmsg)($$$ndq->iosb, acp);   		nl_fre(*(bp+3)); 		break; 		}    t 	default: {u2   		if (netmsg != 0) (*netmsg)($$$ndq->iosb, acp); 		}n 	}     } 
   mfree(acp);g   return(1); },  4 static nl_fre(lun)	/* free NIOV and lun given lun */ int lun; {    NIOV *np;r  ,   np = $$luns[lun-2];		/* get possible np */2   if (np->lun == lun) np_fre(np);	/* free if ok */F   else fatal("attempt to free noexistant lun in netlnk getmsg", 0, 0); }T  " static int dirtst(dstat, pio, msg)
 int dstat; char *pio, *msg; {)=   if ((dstat >= 0) && ((pio == 0) || (*pio == 1))) return(0);    fatal(msg, dstat, pio);g }   ! static int fatal(msg, dsw, fiosb)n
 char *msg; word dsw, fiosb[2];e {n+   tmsg('F', "%s: \ndsw:%o, fiosb:%o:%o\n", n! 			msg, dsw, fiosb[0], fiosb[1]); 
   exit(4); }   