#ifndef MX_H
#define MX_H

#include <stdlib.h>
#include <stdarg.h>
#include <iostream.h>
#include <fstream.h>
#include <math.h>

// maximum dimensions in matrix
#define MAX_MX_DIM 200

// define TRUE and FALSE
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

class mx {
         private:
            // rows and columns
            int r,c;
            // pointer to data
            double *x;
            // error-routine
            void error (char *msg);
         public:
            // constructors
            mx ();
            mx (int rr,int cc);
            mx (int rr,int cc,double xx);
            mx (int rr,int cc,char *fnm);
            mx (mx& z);
            // destructor
            ~mx ();
#ifdef DEBUG
            // dump-routine
            void dump ();
#endif
            // operators
            double &operator()(int row,int col)
                              {
                              if ((row<1)||(row>r)) error("Row-index out of range");
                              if ((col<1)||(col>r)) error("Column-index out of range");
                              return (x[(col-1)*r+row-1]);
                              };
            mx operator=(mx& z);
            friend mx operator+(mx& a,mx& b);
            friend mx operator+(double a,mx& b);
            friend mx operator+(mx& a,double b);
            friend mx operator-(mx& a,mx& b);
            friend mx operator-(double a,mx& b);
            friend mx operator-(mx& a,double b);
            friend mx operator*(mx& a,mx& b);
            friend mx operator*(double a,mx& b);
            friend mx operator*(mx& a,double b);
            friend ostream& operator<<(ostream& s,mx& o);
            // special matrix functions
            friend mx tran(mx& z);
            friend mx inv(mx& z);
            friend double det(mx& z);
            friend int row(mx& z);
            friend int col(mx& z);
            friend double *data(mx& z);
            // general overloaded functions
            friend void random(mx& z,double m,double sd);
            // allow matrixgen to manipulate directly
            friend void matrixgen(mx res,int n,va_list ptr);
         };

#endif
