#include "random.h"
#include "ts.h"

// error-routine
void ts::error (char *msg)
               {
               cout << "Fatal error in TS-routines : " << msg << "\n";
               exit(0);
               }

// constructor for time-series
ts::ts ()
       {
       x = new double[MAX_TS_OBS];
       n = 0;
       }
    
// constructor for time-series
ts::ts (int nn)
       {
       if (nn>MAX_TS_OBS) error("Too many observations");
       x = new double[nn];
       n = nn;
       for (int i=0;i<nn;i++) x[i]=0;
       }
    
// constructor for time-series with constant value
ts::ts (int nn,double xx)
       {
       if (nn>MAX_TS_OBS) error("Too many observations");
       x = new double[nn];
       n = nn;
       for (int i=0;i<nn;i++) x[i]=xx;
       }
    
// constructor for time-series loaded from file
ts::ts (int nn,char *fnm)
       {
       if (nn>MAX_TS_OBS) error("Too many observations");
       ifstream data(fnm);
       x = new double[nn];
       n = nn;
       for (int i=0;i<n;i++) data >> x[i];
       }

// constructor for time-sries with copy-initializer
ts::ts (ts& z)
       {
       x = new double[z.n];
       n = z.n;
       for (int i=0;i<n;i++) x[i] = z.x[i];
       }

// destructor
ts::~ts ()
        {
        delete x;
        }

#ifdef DEBUG
// dump-routine
void ts::dump ()
              {
              cout << "N = " << n << " X = " << (int)x << "\n";
              }
#endif

// assignment
ts ts::operator=(ts& z)
                {
                n = z.n;
                for (int i=0;i<n;i++) x[i] = z.x[i];
                return *this;
                }

// time-series + time-series
ts operator+(ts& a,ts& b)
{
   if (a.n!=b.n) a.error("Not equal number of observations in addition");
   ts tmp(a.n);
   for (int i=0;i<tmp.n;i++) tmp.x[i] = a.x[i] + b.x[i];
   return tmp;
}

// number + time-series
ts operator+(double a,ts& b)
{
   ts tmp(b.n);
   for (int i=0;i<tmp.n;i++) tmp.x[i] = a + b.x[i];
   return tmp;
}

// time-series + number
ts operator+(ts& a,double b)
{
   ts tmp(a.n);
   for (int i=0;i<tmp.n;i++) tmp.x[i] = a.x[i] + b;
   return tmp;
}

// time-series - time-series
ts operator-(ts& a,ts& b)
{
   if (a.n!=b.n) a.error("Not equal number of observations in subtraction");
   ts tmp(a.n);
   for (int i=0;i<tmp.n;i++) tmp.x[i] = a.x[i] - b.x[i];
   return tmp;
}

// number - time-series
ts operator-(double a,ts& b)
{
   ts tmp(b.n);
   for (int i=0;i<tmp.n;i++) tmp.x[i] = a - b.x[i];
   return tmp;
}

// time-series - number
ts operator-(ts& a,double b)
{
   ts tmp(a.n);
   for (int i=0;i<tmp.n;i++) tmp.x[i] = a.x[i] - b;
   return tmp;
}

// time-series * time-series
ts operator*(ts& a,ts& b)
{
   if (a.n!=b.n) a.error("Not equal number of observations in multiplication");
   ts tmp(a.n);
   for (int i=0;i<tmp.n;i++) tmp.x[i] = a.x[i] * b.x[i];
   return tmp;
}

// number * time-series
ts operator*(double a,ts& b)
{
   ts tmp(b.n);
   for (int i=0;i<tmp.n;i++) tmp.x[i] = a * b.x[i];
   return tmp;
}

// time-series * number
ts operator*(ts& a,double b)
{
   ts tmp(a.n);
   for (int i=0;i<tmp.n;i++) tmp.x[i] = a.x[i] * b;
   return tmp;
}

// time-series / time-series
ts operator/(ts& a,ts& b)
{
   if (a.n!=b.n) a.error("Not equal number of observations in division");
   ts tmp(a.n);
   for (int i=0;i<tmp.n;i++) tmp.x[i] = a.x[i] / b.x[i];
   return tmp;
}

// number / time-series
ts operator/(double a,ts& b)
{
   ts tmp(b.n);
   for (int i=0;i<tmp.n;i++) tmp.x[i] = a / b.x[i];
   return tmp;
}

// time-series / number
ts operator/(ts& a,double b)
{
   ts tmp(a.n);
   for (int i=0;i<tmp.n;i++) tmp.x[i] = a.x[i] / b;
   return tmp;
}

// write
ostream& operator<<(ostream& s,ts& o)
{
   s << "Number of observations : " << o.n << "\n";
   for (int i=0;i<o.n;i++) s << (i+1) << ". observation = " << o.x[i] << "\n";
   return s;
}

// mean function
double mean(ts& z)
{
   double s = 0;
   for (int i=0;i<z.n;i++) s = s+z.x[i];
   return (s/z.n);
}

// standard deviation function
double stdev(ts& z)
{
   double m = mean(z), s = 0;
   for (int i=0;i<z.n;i++) s = s+(m-z.x[i])*(m-z.x[i]);
   return (sqrt(s/z.n));
}

// number of observations function
int nobs(ts& z)
{
   return (z.n);
}

// address of data function
double *data(ts& z)
{
   return (z.x);
}

// logarithm function
ts log(ts& z)
{
   ts tmp(z.n);
   for (int i=0;i<tmp.n;i++) tmp.x[i] = log(z.x[i]);
   return tmp;
}

// exponential function
ts exp(ts& z)
{
   ts tmp(z.n);
   for (int i=0;i<tmp.n;i++) tmp.x[i] = exp(z.x[i]);
   return tmp;
}

// random function
void random(ts& z,double m,double sd)
{
   for (int i=0;i<z.n;i++) random(&z.x[i],m,sd);
   return;
}
