#ifndef TS_H
#define TS_H

#include <stdlib.h>
#include <stdarg.h>
#include <iostream.h>
#include <fstream.h>
#include <math.h>
#include "mx.h"

// define TRUE and FALSE
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

// maximum number of observations in time-series
#define MAX_TS_OBS 1000

class ts {
         private:
            // number of observations
            int n;
            // pointer to data
            double *x;
            // error-routine
            void error (char *msg);
         public:
            // constructors
            ts ();
            ts (int nn);
            ts (int nn,double xx);
            ts (int nn,char *fnm);
            ts (ts& z);
            // destructor
            ~ts ();
#ifdef DEBUG
            // dump-routine
            void dump ();
#endif
            // operators
            double &operator()(int ix)
                              {
                              if ((ix<1)||(ix>n)) error("Index out of range");
                              return (x[ix-1]);
                              };
            ts operator=(ts& z);
            friend ts operator+(ts& a,ts& b);
            friend ts operator+(double a,ts& b);
            friend ts operator+(ts& a,double b);
            friend ts operator-(ts& a,ts& b);
            friend ts operator-(double a,ts& b);
            friend ts operator-(ts& a,double b);
            friend ts operator*(ts& a,ts& b);
            friend ts operator*(double a,ts& b);
            friend ts operator*(ts& a,double b);
            friend ts operator/(ts& a,ts& b);
            friend ts operator/(double a,ts& b);
            friend ts operator/(ts& a,double b);
            friend ostream& operator<<(ostream& s,ts& o);
            // special time-series functions
            friend double mean(ts& z);
            friend double stdev(ts& z);
            friend int nobs(ts& z);
            friend double *data(ts& z);
            // general overloaded functions
            friend ts log(ts& z);
            friend ts exp(ts& z);
            friend void random(ts& z,double m,double sd);
            // allow matrixgen to manipulate directly
            friend void matrixgen(mx res,int n,va_list ptr);
         };

#define DESCRIP(z) cout << "Time-series : " << #z << "\n" \
                        << "Number of observations : " << nobs(z) << "\n" \
                        << "Mean : " << mean(z) << "\n" \
                        << "Standard deviation : " << stdev(z) << "\n"

#endif
