/*
 *  Author     : Arne Vajhj
 *
 *  Programmed : december 1995
 *
 *  Purpose    : General Archive Browser
 *
 *  Modified   : january 1996
 *               Allow real URL syntax in path instead of only VMS spec.
 *
 *               january 1996
 *               Add GAB4 to decompress files on the fly.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <descrip.h>
#include <rmsdef.h>

#include "cgilib.h"
#include "gab.h"

long lib$find_file();
long lib$find_file_end();
#ifdef VAXC
int shell$from_vms();
int shell$to_vms();
#else
int decc$from_vms();
int decc$to_vms();
#endif

int check_access();
int check_url_access();

char unixfnm[256];
char vmsfnm[256];

int gab_doit_unix(char *s)
{
   strcpy(unixfnm,s);
   return 1;
}

int gab_doit_vms(char *s,int i)
{
   strcpy(vmsfnm,s);
   return 1;
}

main(int argc,char *argv[])
{
   long stat,cntx;
   int i,arc,comp,l,vmsspec;
   char dir[256],dir2[256],fnm[256],url[256],url2[256],*p;
   $DESCRIPTOR(dirdesc,dir);
   $DESCRIPTOR(fnmdesc,fnm);
   cgi_init_env(argc,argv);
   /* get directory and add *.* */
   p=cgi_info("PATH_INFO");
   if(strstr(p,"[")!=NULL) {
      /* VMS directory spec */
      p++;
      strcpy(dir,p);
      vmsspec=1;
   } else {
      /* URL spec */
      cgi_translate_path(p,1,url,sizeof(url)-1,&l);
      url[l-1]='\0';
#ifdef VAXC
      shell$to_vms(url,gab_doit_vms,0,0);
#else
      decc$to_vms(url,gab_doit_vms,0,0);
#endif
      if(strlen(vmsfnm)==0) strcpy(vmsfnm,"nodisk:[nodirectory]");
      strcpy(dir,vmsfnm);
      vmsspec=0;
   }
   /* check access */
   if(vmsspec) {
      strcpy(dir2,dir);
      strcat(dir2,".GAB_BROWSABLE");
      l=check_access(dir2);
   } else {
      strcpy(dir2,url);
      strcat(dir2,"/.GAB_BROWSABLE");
      l=check_url_access(dir2);
   }
   if(!l) {
      cgi_begin_output(1);
      cgi_printf("content-type: text/plain\n\n");
      cgi_printf("No access to archive: %s\n",dir);
      exit(1);
   }
   /* write HTML header */
   cgi_begin_output(1);
   cgi_printf("content-type: text/html\n\n");
   cgi_printf("<HTML>\n");
   cgi_printf("<HEAD>\n");
   cgi_printf("<TITLE>GAB index level 1</TITLE>");
   cgi_printf("</HEAD>\n");
   cgi_printf("<BODY>\n");
   cgi_printf("<H1>GAB index level 1</H1>\n");
   cgi_printf("<H2>Index of %s:</H2>\n",dir);
   cgi_printf("<UL>\n");
   /* loop through all files */
   strcat(dir,"*.*");
   dirdesc.dsc$w_length=strlen(dir);
   cntx=0;
   do {
      stat=lib$find_file(&dirdesc,&fnmdesc,&cntx,0,0,0,0);
      if (stat==RMS$_NORMAL) {
         p=strchr(fnm,' ');
         *p='\0';
         /* test whether an archive */
         arc=0;
         for (i=0;i<narc;i++) {
            if (strstr(fnm,archivefiles[i])>fnm) arc=1;
         }
         /* test whether compressed */
         comp=0;
         for (i=0;i<ncomp;i++) {
            if (strstr(fnm,compressfiles[i])>fnm) comp=1;
         }
         /* remove version number */
         p=strstr(fnm,";");
         *p='\0';
         /* skip device and directory */
         p=strstr(fnm,"]");
         p++;
         if (arc) {
            /* GAB2 link for archives */
            if(vmsspec) {
               cgi_printf("<LI><A HREF=\"/htbin/gab2.exe/%s\">%s</A>\n",fnm,p);
            } else {
               strcpy(url2,url);
               strcat(url2,"/");
               strcat(url2,p);
               cgi_printf("<LI><A HREF=\"/htbin/gab2.exe%s\">%s</A>\n",url2,p);
            }
         } else if (comp) {
            /* GAB4 link for compressed files */
            if(vmsspec) {
               cgi_printf("<LI><A HREF=\"/htbin/gab4.exe/%s\">%s</A>\n",fnm,p);
            } else {
               strcpy(url2,url);
               strcat(url2,"/");
               strcat(url2,p);
               cgi_printf("<LI><A HREF=\"/htbin/gab4.exe%s\">%s</A>\n",url2,p);
            }
         } else if (strstr(fnm,".DIR")>fnm) {
            if(vmsspec) {
               /* [dir.subdir1]*.* + subdir2.dir = [dir.subdir1.subdir2] */
               strcpy(dir2,dir);
               dir2[strlen(dir2)-4]='\0';
               strcat(dir2,".");
               strcat(dir2,p);
               dir2[strlen(dir2)-4]='\0';
               strcat(dir2,"]");
               /* GAB1 link for subdirectories */
               cgi_printf("<LI><A HREF=\"/htbin/gab1.exe/%s\">%s</A>\n",dir2,p);
            } else {
               /* /dir/subdir1 + subdir2 = /dir/subdir1/subdir2 */
               strcpy(url2,url);
               strcat(url2,"/");
               strcat(url2,p);
               url2[strlen(url2)-4]='\0';
               strcat(url2,"/");
               /* GAB1 link for subdirectories */
               cgi_printf("<LI><A HREF=\"/htbin/gab1.exe%s\">%s</A>\n",url2,p);
            }
         } else {
            if(vmsspec) {
               /* translate from VMS to UNIX syntax */
#ifdef VAXC
               shell$from_vms(fnm,gab_doit_unix,0);
#else
               decc$from_vms(fnm,gab_doit_unix,0);
#endif
               /* ordinary link for ordinary files */
               cgi_printf("<LI><A HREF=\"%s\">%s</A>\n",unixfnm,p);
            } else {
               /* ordinary link for ordinary files */
               strcpy(url2,url);
               strcat(url2,"/");
               strcat(url2,p);
               cgi_printf("<LI><A HREF=\"%s\">%s</A>\n",url2,p);
            }
         }
      }
   } while (stat==RMS$_NORMAL);
   lib$find_file_end(&cntx);
   /* write HTML footer */
   cgi_printf("</UL>\n");
   cgi_printf("</BODY>\n");
   cgi_printf("</HTML>\n");
}
