/*
 *  Author     : Arne Vajhj
 *
 *  Programmed : december 1995
 *
 *  Purpose    : General Archive Browser
 *
 *  Modified   : january 1996
 *               Allow real URL syntax in path instead of only VMS spec.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "cgilib.h"
#include "subproc.h"
#include "gab.h"

#ifdef VAXC
int shell$from_vms();
int shell$to_vms();
#else
int decc$from_vms();
int decc$to_vms();
#endif

int check_access();
int check_url_access();

char unixfnm[256];
char vmsfnm[256];

int gab_doit_unix(char *s)
{
   strcpy(unixfnm,s);
   return 1;
}

int gab_doit_vms(char *s,int i)
{
   strcpy(vmsfnm,s);
   return 1;
}

/* split line in columns */
int columnsplit(char *line,char cols[25][256])
{
   int ix,flag;
   char *p1,*p2;
   ix=0;
   flag=0;
   p1=line;
   p2=p1;
   while(*p2) {
      if(*p2==' ') {
         if(flag) {
            strncpy(cols[ix],p1,p2-p1);
            cols[ix][p2-p1]='\0';
            ix++;
            flag=0;
            p1=p2;
         }
         p1++;
      } else {
         flag=1;
      }
      p2++;
   }
   strncpy(cols[ix],p1,p2-p1);
   cols[ix][p2-p1]='\0';
   ix++;
   return ix;
}

main(int argc,char *argv[])
{
   long l,bool,vmsspec;
   int i,ix,fnd,ncol;
   char fnm[256],cmd[306],line[256],url[256],url2[256],cols[25][256],*p;
   cgi_init_env(argc,argv);
   /* get filename for archive */
   p=cgi_info("PATH_INFO");
   if(strstr(p,"[")!=NULL) {
      /* VMS file spec */
      p++;
      strcpy(fnm,p);
      vmsspec=1;
   } else {
      /* URL spec */
      cgi_translate_path(p,1,url,sizeof(url)-1,&l);
      url[l]='\0';
#ifdef VAXC
      shell$to_vms(url,gab_doit_vms,0,0);
#else
      decc$to_vms(url,gab_doit_vms,0,0);
#endif
      if(strlen(vmsfnm)==0) strcpy(vmsfnm,"nodisk:[nodirectory]nofile");
      strcpy(fnm,vmsfnm);
      vmsspec=0;
   }
   /* check if access */
   if(vmsspec) {
      l=check_access(fnm);
   } else {
      l=check_url_access(url);
   }
   if(!l) {
      cgi_begin_output(1);
      cgi_printf("content-type: text/plain\n\n");
      cgi_printf("No access to archive: %s\n",fnm);
      exit(1);
   }
   /* write HTML header */
   cgi_begin_output(1);
   cgi_printf("content-type: text/html\n\n");
   cgi_printf("<HTML>\n");
   cgi_printf("<HEAD>\n");
   cgi_printf("<TITLE>GAB index level 2</TITLE>");
   cgi_printf("</HEAD>\n");
   cgi_printf("<BODY>\n");
   cgi_printf("<H1>GAB index level 2</H1>\n");
   p=strstr(fnm,"]");
   p++;
   cgi_printf("<H2>Index of %s:</H2>\n",p);
   if(vmsspec) {
      /* translate from VMS to UNIX syntax */
#ifdef VAXC
      shell$from_vms(fnm,gab_doit_unix,0);
#else
      decc$from_vms(fnm,gab_doit_unix,0);
#endif
      /* link to entire file */
      cgi_printf("Fetch <A HREF=\"%s\">entire file</A>.<P>\n",unixfnm);
   } else {
      /* link to entire file */
      cgi_printf("Fetch <A HREF=\"%s\">entire file</A>.<P>\n",url);
   }
   /* find type of archive */
   ix=(-1);
   for (i=0;i<narc;i++){
      archivefiles[i][strlen(archivefiles[i])-1]='\0';
      if (strstr(fnm,archivefiles[i])>fnm) ix=i;
   }
   /* send list command to DCL subprocess */
   sprintf(cmd,listfmt[ix],fnm);
   cgi_printf("<UL>\n");
   sub_init();
   sub_put("ON ERROR THEN CONTINUE");
   sub_put("@SYS$MANAGER:PDUTIL_DEF_2"); /* defines UNZIP and VMSTAR commands at HHS */
   sub_put(cmd);
   sub_put("WRITE SYS$OUTPUT \"FfIiNn\"");
   sub_wait(3);
   bool=1;
   while(bool) {
      /* get response lines one by one */
      fnd=sub_get(line,sizeof(line)-1);
      if (memcmp(line,"FfIiNn",6)==0) bool=0;
      if (fnd && bool) {
         /* only lines with files */
         if(linewithfile(line,ix)) {
            cgi_printf("<LI>");
            ncol=columnsplit(line,cols);
            for (i=0;i<ncol;i++) {
               /* loop through all columns */
               if (i==(filecolumn[ix]-1)) {
                  /* GAB3 link to files */
                  /* NB: replace leading dot with ^ in URL */
                  if(cols[i][0]=='.') cols[i][0]='^';
                  if(vmsspec) {
                     sprintf(url2,"/htbin/gab3.exe/%s+%s",fnm,cols[i]);
                  } else {
                     sprintf(url2,"/htbin/gab3.exe%s+%s",url,cols[i]);
                  }
                  if(cols[i][0]=='^') cols[i][0]='.';
                  cgi_printf("<A HREF=\"%s\">%s</A> ",url2,cols[i]);
               } else {
                  /* write out */
                  cgi_printf("%s ",cols[i]);
               }
            }
            cgi_printf("\n");
         }
      }
   }
   sub_end();
   /* write HTML footer */
   cgi_printf("</UL>\n");
   cgi_printf("</BODY>\n");
   cgi_printf("</HTML>\n");
}
