/*
 *  Author     : Arne Vajhj
 *
 *  Programmed : december 1995
 *
 *  Purpose    : General Archive Browser
 *
 *  Modified   : january 1996
 *               Allow real URL syntax in path instead of only VMS spec.
 *
 *  Modified   : february 1996
 *               Include ctype.h and unxio.h to compile with DEC C.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#ifdef __DECC
#include <unixio.h>
#endif

#include "cgilib.h"
#include "scriptlib.h"
#include "subproc.h"
#include "gab.h"

#ifdef VAXC
int shell$to_vms();
#else
int decc$to_vms();
#endif

int check_access();
int check_url_access();

char vmsfnm[256];

int gab_doit_vms(char *s,int i)
{
   strcpy(vmsfnm,s);
   return 1;
}

main(int argc,char *argv[])
{
   FILE *fp;
   int ix,i,j,c,l,vmsspec;
   char anm[256],fnm[256],fnm2[256],url[256],cmd[306],*p;
   cgi_init_env(argc,argv);
   /* get archive name */
   p=cgi_info("PATH_INFO");
   strcpy(cmd,p);
   p=strstr(cmd,"+");
   *p='\0';
   if(strstr(cmd,"[")!=NULL) {
      /* VMS file spec */
      strcpy(anm,cmd+1);
      vmsspec=1;
   } else {
      /* URL spec */
      cgi_translate_path(cmd,1,url,sizeof(url)-1,&l);
      url[l]='\0';
#ifdef VAXC
      shell$to_vms(url,gab_doit_vms,0,0);
#else
      decc$to_vms(url,gab_doit_vms,0,0);
#endif
      if(strlen(vmsfnm)==0) strcpy(vmsfnm,"nodisk:[nodirectory]");
      strcpy(anm,vmsfnm);
      vmsspec=0;
   }
   /* get filename to extract */
   p++;
   strcpy(fnm,p);
   if(fnm[0]=='^') fnm[0]='.';
   p=fnm;
   while(strstr(p,"/")>p) p=strstr(p,"/")+1;
   while(strstr(p,"\\")>p) p=strstr(p,"\\")+1;
   while(strstr(p,"]")>p) p=strstr(p,"]")+1;
   strcpy(fnm2,p);
   /* check if access */
   if(vmsspec) {
      l=check_access(anm);
   } else {
      l=check_url_access(url);
   }
   if(!l) {
      cgi_begin_output(1);
      cgi_printf("content-type: text/plain\n\n");
      cgi_printf("No access to archive: %s\n",anm);
      exit(1);
   }
   /* find type of archive */
   ix=(-1);
   for (i=0;i<narc;i++){
      archivefiles[i][strlen(archivefiles[i])-1]='\0';
      if (strstr(anm,archivefiles[i])>anm) ix=i;
   }
   /* send extract command to DCL subprocess */
   sprintf(cmd,extractfmt[ix],anm,fnm);
   sub_init();
   sub_put("ON ERROR THEN CONTINUE");
   sub_put("@SYS$MANAGER:PDUTIL_DEF_2"); /* defines UNZIP and VMSTAR commands at HHS */
   sub_put("SET DEF [.GAB]");
   sub_put(cmd);
   sub_end();
   /* find type of file (binary or not) */
   ix=(-1);
   for (i=0;i<nbin;i++){
      strcpy(binaryfileslower[i],binaryfilesupper[i]);
      for (j=0;j<strlen(binaryfileslower[i]);j++)
         binaryfileslower[i][j]=tolower(binaryfileslower[i][j]);
      if (strstr(fnm,binaryfilesupper[i])>fnm) ix=i;
      if (strstr(fnm,binaryfileslower[i])>fnm) ix=i;
   }
   /* goto GAB directory */
   cgi_begin_output(1);
   chdir("[.GAB]");
   if(ix==(-1)) {
      /* text file */
      fp=fopen(fnm2,"r");
      if(fp!=NULL) {
         cgi_printf("content-type: text/plain\n\n");
         c=fgetc(fp);
         while(c>=0) {
            cgi_printf("%c",c);
            c=fgetc(fp);
         }
         fclose(fp);
      } else {
         cgi_printf("content-type: text/plain\n\n");
         cgi_printf("Error opening extracted file\n");
      }
   } else {
      /* binary file */
      fp=fopen(fnm2,"rb");
      if(fp!=NULL) {
         cgi_printf("content-type: application/octet-stream\n");
         cgi_printf("content-transfer-encoding: binary\n\n");
         c=fgetc(fp);
         while(c>=0) {
            net_link_write(&c,1);
            c=fgetc(fp);
         }
         fclose(fp);
      } else {
         cgi_printf("content-type: text/plain\n\n");
         cgi_printf("Error opening extracted file\n");
      }
   }
   /* delete extracted file */
   remove(fnm2);
}
