/*
 *  Author     : Arne Vajhj
 *
 *  Programmed : january 1996
 *
 *  Purpose    : General Archive Browser
 *
 *  Modified   : february 1996
 *               Include ctype.h and unxio.h to compile with DEC C.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#ifdef __DECC
#include <unixio.h>
#endif

#include "cgilib.h"
#include "scriptlib.h"
#include "subproc.h"
#include "gab.h"

#ifdef VAXC
int shell$to_vms();
#else
int decc$to_vms();
#endif

int check_access();
int check_url_access();

char vmsfnm[256];

int gab_doit_vms(char *s,int i)
{
   strcpy(vmsfnm,s);
   return 1;
}

main(int argc,char *argv[])
{
   FILE *fp;
   int ix,i,j,c,l,vmsspec;
   char fnm[256],fnm2[256],fnm3[256],url[256],cmd[306],*p;
   cgi_init_env(argc,argv);
   /* get archive name */
   p=cgi_info("PATH_INFO");
   strcpy(cmd,p);
   if(strstr(cmd,"[")!=NULL) {
      /* VMS file spec */
      strcpy(fnm,cmd+1);
      vmsspec=1;
   } else {
      /* URL spec */
      cgi_translate_path(cmd,1,url,sizeof(url)-1,&l);
      url[l]='\0';
#ifdef VAXC
      shell$to_vms(url,gab_doit_vms,0,0);
#else
      decc$to_vms(url,gab_doit_vms,0,0);
#endif
      if(strlen(vmsfnm)==0) strcpy(vmsfnm,"nodisk:[nodirectory]");
      strcpy(fnm,vmsfnm);
      vmsspec=0;
   }
   /* check if access */
   if(vmsspec) {
      l=check_access(fnm);
   } else {
      l=check_url_access(url);
   }
   if(!l) {
      cgi_begin_output(1);
      cgi_printf("content-type: text/plain\n\n");
      cgi_printf("No access to archive: %s\n",fnm);
      exit(1);
   }
   /* find type of compression */
   ix=(-1);
   for (i=0;i<ncomp;i++){
      compressfiles[i][strlen(compressfiles[i])-1]='\0';
      if (strstr(fnm,compressfiles[i])>fnm) ix=i;
   }
   p=fnm+strlen(fnm);
   while((*p!=']')&&(*p!='/')) p--;
   strcpy(fnm2,p+1);
   strcpy(fnm3,fnm2);
   fnm3[strlen(fnm3)-strlen(compressfiles[ix])]='\0';
   /* send decompress command to DCL subprocess */
   sub_init();
   sub_put("ON ERROR THEN CONTINUE");
   sub_put("@SYS$MANAGER:PDUTIL_DEF_2"); /* defines ZDECO, GZIP and LZD commands at HHS */
   sub_put("SET DEF [.GAB]");
   sprintf(cmd,"COPY %s %s",fnm,fnm2);
   sub_put(cmd);
   sprintf(cmd,decompfmt[ix],fnm2,fnm3);
   sub_put(cmd);
   sub_end();
   /* find type of file (binary or not) */
   ix=(-1);
   for (i=0;i<nbin;i++){
      strcpy(binaryfileslower[i],binaryfilesupper[i]);
      for (j=0;j<strlen(binaryfileslower[i]);j++)
         binaryfileslower[i][j]=tolower(binaryfileslower[i][j]);
      if (strstr(fnm3,binaryfilesupper[i])>fnm3) ix=i;
      if (strstr(fnm3,binaryfileslower[i])>fnm3) ix=i;
   }
   /* goto GAB directory */
   cgi_begin_output(1);
   chdir("[.GAB]");
   if(ix==(-1)) {
      /* text file */
      fp=fopen(fnm3,"r");
      if(fp!=NULL) {
         cgi_printf("content-type: text/plain\n\n");
         c=fgetc(fp);
         while(c>=0) {
            cgi_printf("%c",c);
            c=fgetc(fp);
         }
         fclose(fp);
      } else {
         cgi_printf("content-type: text/plain\n\n");
         cgi_printf("Error opening extracted file\n");
      }
   } else {
      /* binary file */
      fp=fopen(fnm3,"rb");
      if(fp!=NULL) {
         cgi_printf("content-type: application/octet-stream\n");
         cgi_printf("content-transfer-encoding: binary\n\n");
         c=fgetc(fp);
         while(c>=0) {
            net_link_write(&c,1);
            c=fgetc(fp);
         }
         fclose(fp);
      } else {
         cgi_printf("content-type: text/plain\n\n");
         cgi_printf("Error opening extracted file\n");
      }
   }
   /* delete extracted file */
   remove(fnm2);
   remove(fnm3);
}
