/*
 *  Author     : Arne Vajhj
 *
 *  Programmed : march 1995
 *
 *  Purpose    : description of DBase DBF database format
 */

/*
 *  Based on information from "Language Reference" manual
 *
 */

/* magic number */
#define BLOCK_CNT 18

#define NAMLEN 12
#define STRLEN 256

#define TRUE 1
#define FALSE 0

/* description of database file-header */
struct F_HEADER_ST {
   char fill1[1];
   char DATE_MODIFIED[3];
   int NO_RECORDS;
   short SIZE_HEADER;
   short SIZE_RECORD;
   char fill2[20];
   };

/* description of field-descriptor */
struct F_VARDES_ST {
   char VAR_NAME[11];
   char VAR_TYPE;
   char fill1[4];
   char FIELD_LENGTH;
   char FIELD_DECIMALCOUNT;
   char fill2[14];
   };

typedef struct F_VARDES_ST *F_VARDES_PTR;

