/*
 *  Author     : Arne Vajhj
 *
 *  Programmed : march 1995
 *
 *  Purpose    : display contents of DBASE database
 *
 *  Modified   : april 1995
 *               Added a SECURE option (which is default on), that will
 *               only use files in a WWW-subdirectory.
 *
 *               april 1995
 *               Changed check to use generic check_access function.
 *
 *               july 1995
 *               The define TABLES will make it generate tables.
 *
 *               september 1995
 *               Test for REQUEST_METHOD HEAD.
 *
 *               february 1996
 *               Include stdlib.h to compile with DEC C.
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "cgilib.h"

#include "dbf.h"

int check_access();

/* convert DBASE-string to C-string */
void copy(char *s1,char *s2,int n)
{
   strncpy(s1,s2,n);
   while(((s1[n-1]=='\0')||(s1[n-1]==' '))&&(n>0)) n--;
   s1[n]='\0';
   return;
}

/* write out header-information */
void hdrinfo(struct F_HEADER_ST fhdr)
{
   int c1,c2,c3;
   c1=fhdr.DATE_MODIFIED[2];
   c2=fhdr.DATE_MODIFIED[1];
   c3=fhdr.DATE_MODIFIED[0];
   cgi_printf("Last modified     : %02d/%02d/%02d\n",c1,c2,c3);
   cgi_printf("Number of records : %d\n",fhdr.NO_RECORDS);
   return;
}

/* write out variable-information */
void varinfo(struct F_VARDES_ST *fvar, char *dbf)
{
   int i;
   char tmp[STRLEN];
   copy(tmp,fvar->VAR_NAME,11);
#ifndef TABLES
   cgi_printf("<A HREF=\"/htbin/dbf2.exe/%s/%s\">%s</A>",dbf,tmp,tmp);
#else
   cgi_printf("<A HREF=\"/htbin/dbf2t.exe/%s/%s\">%s</A>",dbf,tmp,tmp);
#endif
   for(i=strlen(tmp);i<11;i++) cgi_printf(" ");
   switch (fvar->VAR_TYPE) {
      case 'N' :
         cgi_printf("  numeric");
         break;
      case 'C' :
         cgi_printf("  char   ");
         break;
      case 'L' :
         cgi_printf("  logical");
         break;
      default :
         cgi_printf("  unknown");
         break;
      };
   cgi_printf("%8d",fvar->FIELD_LENGTH);
   cgi_printf("%8d",fvar->FIELD_DECIMALCOUNT);
   cgi_printf("\n");
   return;
}


main(int argc,char *argv[])
{
   FILE *dbf;
   struct F_HEADER_ST fhdr;
   F_VARDES_PTR *fvar;
   char *dbfnam;
   int i,nofields;
   char tmp[NAMLEN];
   cgi_init(argc,argv);
   dbfnam=cgi_info("PATH_INFO");
   dbfnam++;
   cgi_printf("content-type: text/html\n\n");
   if(strcmp(cgi_info("REQUEST_METHOD"),"HEAD")==0) exit(1);
   cgi_printf("<HTML>\n");
   cgi_printf("<HEAD>\n");
   cgi_printf("<TITLE>%s</TITLE>\n",dbfnam);
   cgi_printf("</HEAD>\n");
   cgi_printf("<BODY>\n");
   cgi_printf("<PRE>\n");
   /* open dbf-file */
   if(!check_access(dbfnam)) {
      cgi_printf("No access to file: %s\n",dbfnam);
      goto fin;
   }
   dbf=fopen(dbfnam,"rb","ctx=stm");
   if(dbf==NULL) {
       cgi_printf("Can not open file: %s\n",dbfnam);
       goto fin;
   }
   /* read header */
   fread(&fhdr,sizeof(fhdr),1,dbf);
   hdrinfo(fhdr);
   /* read variable descriptors */
   cgi_printf("\nContent:\n\nVariable     Type       Width  Decimals\n\n");
   nofields=(fhdr.SIZE_HEADER-sizeof(struct F_HEADER_ST))/
            sizeof(struct F_VARDES_ST);
   fvar=(F_VARDES_PTR *)malloc(nofields*sizeof(F_VARDES_PTR));
   for(i=0;i<nofields;i++) {
      fvar[i]=(struct F_VARDES_ST *)malloc(sizeof(struct F_VARDES_ST));
      fread(fvar[i],sizeof(*fvar[i]),1,dbf);
      varinfo(fvar[i],dbfnam);
   }
#ifndef TABLES
   cgi_printf("<A HREF=\"/htbin/dbf2.exe/%s/all\">all</A>          (all variables)\n",dbfnam);
#else
   cgi_printf("<A HREF=\"/htbin/dbf2t.exe/%s/all\">all</A>          (all variables)\n",dbfnam);
#endif
   fclose(dbf);
fin:
   cgi_printf("</PRE>\n");
   cgi_printf("</BODY>\n");
   cgi_printf("</HTML>\n");
}
