/*
 *  Author     : Arne Vajhj
 *
 *  Programmed : march 1995
 *
 *  Purpose    : get variable from DBASE database
 *
 *  Modified   : april 1995
 *               Added a SECURE option (which is default on), that will
 *               only use files in a WWW-subdirectory.
 *
 *               april 1995
 *               Changed check to use generic check_access function.
 *
 *               july 1995
 *               The define TABLES will make it generate tables.
 *
 *               february 1996
 *               Include stdlib.h to compile with DEC C.
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "cgilib.h"

#include "dbf.h"

int check_access();

/* convert DBASE-string to C-string */
void copy(char *s1,char *s2,int n)
{
   strncpy(s1,s2,n);
   while(((s1[n-1]=='\0')||(s1[n-1]==' '))&&(n>0)) n--;
   s1[n]='\0';
   return;
}

main(int argc,char *argv[])
{
   FILE *dbf;
   struct F_HEADER_ST fhdr;
   F_VARDES_PTR *fvar;
   char *p,dbfnam[256],varnam[NAMLEN];
   int i,obs,*sel,nofields,dummy,del;
   double v;
   char *datastr,*savstr,tmp[NAMLEN],s[STRLEN];
   cgi_init(argc,argv);
   p=cgi_info("PATH_INFO");
   p++;
   strcpy(dbfnam,p);
   p=strstr(dbfnam,"/");
   *p='\0';
   p++;
   strcpy(varnam,p);
   cgi_printf("content-type: text/html\n\n");
   cgi_printf("<HTML>\n");
   cgi_printf("<HEAD>\n");
   cgi_printf("<TITLE>%s - %s</TITLE>\n",dbfnam,varnam);
   cgi_printf("</HEAD>\n");
   cgi_printf("<BODY>\n");
#ifndef TABLES
   cgi_printf("<PRE>\n");
#else
   cgi_printf("<TABLE>\n");
#endif
   /* open dbf-file */
   if(!check_access(dbfnam)) {
      cgi_printf("No access to file: %s\n",dbfnam);
      goto fin;
   }
   dbf=fopen(dbfnam,"rb","ctx=stm");
   if(dbf==NULL) {
       cgi_printf("Can not open file: %s\n",dbfnam);
       goto fin;
   }
   /* read header */
   fread(&fhdr,sizeof(fhdr),1,dbf);
   /* read variable descriptors */
   nofields=(fhdr.SIZE_HEADER-sizeof(struct F_HEADER_ST))/
            sizeof(struct F_VARDES_ST);
   fvar=(F_VARDES_PTR *)malloc(nofields*sizeof(F_VARDES_PTR));
   sel=(int *)malloc(nofields*sizeof(int));
   for(i=0;i<nofields;i++) {
      fvar[i]=(struct F_VARDES_ST *)malloc(sizeof(struct F_VARDES_ST));
      fread(fvar[i],sizeof(*fvar[i]),1,dbf);
      copy(tmp,fvar[i]->VAR_NAME,11);
      if((strcmp(varnam,"all")==0) || (strcmp(tmp,varnam)==0)) {
         sel[i]=TRUE;
      } else {
         sel[i]=FALSE;
      }
   }
   /* read data blocks */
   fread(&dummy,1,1,dbf);
   obs=0;
   datastr=(char *)malloc(fhdr.SIZE_RECORD*BLOCK_CNT);
   savstr=datastr;
   while (obs<fhdr.NO_RECORDS) {
      if ((obs%BLOCK_CNT)==0) {
          datastr=savstr;
          fread(datastr,fhdr.SIZE_RECORD,BLOCK_CNT,dbf);
      }
      dummy=(*datastr);
      datastr++;
      if(dummy==' ') del=FALSE;
      if(dummy=='*') del=TRUE;
      if(dummy==0x1A) goto fin2;
#ifdef TABLES
      cgi_printf("<TR>");
#endif
      for(i=0;i<nofields;i++) {
         if (sel[i]&&(!del)) {
            switch (fvar[i]->VAR_TYPE) {
                case 'N':
                   copy(s,datastr,fvar[i]->FIELD_LENGTH);
                   if(strlen(s)>0) {
                      sscanf(s,"%f",&v);
#ifndef TABLES
                      cgi_printf(" %f",v);
#else
                      cgi_printf("<TH>%f",v);
#endif
                   } else {
#ifndef TABLES
                      cgi_printf(" NULL");
#else
                      cgi_printf("<TH>NULL");
#endif
                   }
                   break;
                case 'C':
                   copy(s,datastr,fvar[i]->FIELD_LENGTH);
#ifndef TABLES
                   cgi_printf(" %s",s);
#else
                   cgi_printf("<TH>%s",s);
#endif
                   break;
                case 'L':
                   switch (*datastr) {
                      case 'Y':
                      case 'y':
                      case 'T':
                      case 't':
#ifndef TABLES
                         cgi_printf(" True ");
#else
                         cgi_printf("<TH>True ");
#endif
                         break;
                      case 'N':
                      case 'n':
                      case 'F':
                      case 'f':
#ifndef TABLES
                         cgi_printf(" False");
#else
                         cgi_printf("<TH>False");
#endif
                         break;
                      case '?':
#ifndef TABLES
                         cgi_printf(" NULL");
#else
                         cgi_printf("<TH>NULL");
#endif
                         break;
                   }

                   break;
            }
         }
         datastr=datastr+fvar[i]->FIELD_LENGTH;
      }
      cgi_printf("\n");
      obs++;
   }
fin2:
   fclose(dbf);
fin:
#ifndef TABLES
   cgi_printf("</PRE>\n");
#else
   cgi_printf("</TABLE>\n");
#endif
   cgi_printf("</BODY>\n");
   cgi_printf("</HTML>\n");
}
