/*
 *  Author     : Arne Vajhj
 *
 *  Programmed : march 1995
 *
 *  Purpose    : description of SAS V5 database format
 */

/*
 *  Original description of dataset format:
 *      Jim Morrison, NSI Technology Services Corp.
 *      MORRISJ@JACOBS.CS.ORST.EDU
 *
 */

/* magic number */
#define BLOCK_CNT 18

/* missing value for number (missing value for integer is 0x807E) */
#define MISSING_VALUE -170141183460469227009320820846238892032.000000

#define TRUE 1
#define FALSE 0

#define NAMLEN 9
#define STRLEN 41

#define VNUMERIC 1
#define VCHAR 2

/* description of dataset-header */
struct F_HEADER_ST {
   char fill1[24];
   int  TOTAL_FIELDS;
   char fill2[28];
   int  RECORD_LEN,TOTAL_OBS;
   char fill3[36];
   char SAS[8];
   char DATASET_NAME[8],DATASET_TYPE[8];
   char SAS_VERSION[8];
   char HOST_ENV[8];
   char fill4[24];
   char DATE_CREATED[16];
   char fill5[32];
   char DATASET_LBL[40];
   char fill6[8];
   };

/* description of variable-descriptor */
struct F_VARDES_ST {
   int  VAR_TYPE;
   short int VAR_LENGTH;
   char fill1[2];
   char VAR_NAME[8];
   char VAR_LABEL[40];
   char VAR_FORMAT[8];
   char fill2[8];
   char VAR_INFORMAT[8];
   char fill3[56];
   };

typedef struct F_VARDES_ST *F_VARDES_PTR;

