/*
 *  Author     : Arne Vajhj
 *
 *  Programmed : march 1995
 *
 *  Purpose    : display contents of SAS V5 database
 *
 *  Modified   : april 1995
 *               Added a SECURE option (which is default on), that will
 *               only use files in a WWW-subdirectory.
 *
 *               april 1995
 *               Changed check to use generic check_access function.
 *
 *               july 1995
 *               The define TABLES will make it generate tables.
 *
 *               september 1995
 *               Test for REQUEST_METHOD HEAD.
 *
 *               february 1996
 *               Include stdlib.h to compile with DEC C.
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "cgilib.h"

#include "sas.h"

int check_access();

/* convert SAS-string to C-string */
void copy(char *s1,char *s2,int n)
{
   strncpy(s1,s2,n);
   while((s1[n-1]==' ')&&(n>0)) n--;
   s1[n]='\0';
   return;
}

/* write out header-information */
void hdrinfo(struct F_HEADER_ST fhdr)
{
   char tmp[STRLEN];
   copy(tmp,fhdr.DATASET_NAME,8);
   cgi_printf("Dataset name     : %s\n",&tmp);
   copy(tmp,fhdr.SAS_VERSION,8);
   cgi_printf("SAS version      : %s\n",&tmp);
   copy(tmp,fhdr.HOST_ENV,8);
   cgi_printf("Operating system : %s\n",&tmp);
   copy(tmp,fhdr.DATE_CREATED,16);
   cgi_printf("Created          : %c%c/%c%c%c/%c%c %s\n",
              tmp[0],tmp[1],tmp[2],tmp[3],tmp[4],tmp[5],tmp[6],&tmp[8]);
   cgi_printf("Observations     : %d\n",fhdr.TOTAL_OBS);
   copy(tmp,fhdr.DATASET_LBL,40);
   if(*tmp!='\0') cgi_printf("Dataset Label    : %s\n",tmp);
   return;
}

/* write out variable-information */
void varinfo(struct F_VARDES_ST *fvar, char *ssd)
{
   int i;
   char tmp[STRLEN];
   copy(tmp,fvar->VAR_NAME,8);
#ifndef TABLES
   cgi_printf("<A HREF=\"/htbin/sas2.exe/%s/%s\">%s</A>",ssd,tmp,tmp);
#else
   cgi_printf("<A HREF=\"/htbin/sas2t.exe/%s/%s\">%s</A>",ssd,tmp,tmp);
#endif
   for(i=strlen(tmp);i<8;i++) cgi_printf(" ");
   switch (fvar->VAR_TYPE) {
      case VNUMERIC :
         cgi_printf("  numeric");
         break;
      case VCHAR  :
         cgi_printf("  char   ");
         break;
      default :
         cgi_printf("  unknown");
         break;
      };
   copy(tmp,fvar->VAR_LABEL,40);
   if(*tmp!='\0') cgi_printf("  %s",tmp);
   cgi_printf("\n");
   return;
}

main(int argc,char *argv[])
{
   FILE *ssd;
   struct F_HEADER_ST fhdr;
   F_VARDES_PTR *fvar;
   char *ssdnam;
   int i;
   char tmp[NAMLEN];
   cgi_init(argc,argv);
   ssdnam=cgi_info("PATH_INFO");
   ssdnam++;
   cgi_printf("content-type: text/html\n\n");
   if(strcmp(cgi_info("REQUEST_METHOD"),"HEAD")==0) exit(1);
   cgi_printf("<HTML>\n");
   cgi_printf("<HEAD>\n");
   cgi_printf("<TITLE>%s</TITLE>\n",ssdnam);
   cgi_printf("</HEAD>\n");
   cgi_printf("<BODY>\n");
   cgi_printf("<PRE>\n");
   /* open ssd-file */
   if(!check_access(ssdnam)) {
      cgi_printf("No access to file: %s\n",ssdnam);
      goto fin;
   }
   ssd=fopen(ssdnam,"rb","ctx=stm");
   if(ssd==NULL) {
       cgi_printf("Can not open file: %s\n",ssdnam);
       goto fin;
   }
   /* read header */
   fread(&fhdr,sizeof(fhdr),1,ssd);
   hdrinfo(fhdr);
   /* read variable descriptors */
   cgi_printf("\nContent:\n\nVariable  Type     Label\n\n");
   fvar=(F_VARDES_PTR *)malloc(fhdr.TOTAL_FIELDS*sizeof(F_VARDES_PTR));
   for(i=0;i<fhdr.TOTAL_FIELDS;i++) {
      fvar[i]=(struct F_VARDES_ST *)malloc(sizeof(struct F_VARDES_ST));
      fread(fvar[i],sizeof(*fvar[i]),1,ssd);
      varinfo(fvar[i],ssdnam);
   }
#ifndef TABLES
   cgi_printf("<A HREF=\"/htbin/sas2.exe/%s/all\">all</A>       (all variables)\n",ssdnam);
#else
   cgi_printf("<A HREF=\"/htbin/sas2t.exe/%s/all\">all</A>       (all variables)\n",ssdnam);
#endif
   fclose(ssd);
fin:
   cgi_printf("</PRE>\n");
   cgi_printf("</BODY>\n");
   cgi_printf("</HTML>\n");
}
