/*
 *  Author     : Arne Vajhj
 *
 *  Programmed : march 1995
 *
 *  Purpose    : get variable from SAS V5 database
 *
 *  Modified   : april 1995
 *               Added a SECURE option (which is default on), that will
 *               only use files in a WWW-subdirectory.
 *
 *               april 1995
 *               Changed check to use generic check_access function.
 *
 *               july 1995
 *               The define TABLES will make it generate tables.
 *
 *               february 1996
 *               Include stdlib.h to compile with DEC C.
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "cgilib.h"

#include "sas.h"

int check_access();

/* convert SAS-string to C-string */
void copy(char *s1,char *s2,int n)
{
   strncpy(s1,s2,n);
   while((s1[n-1]==' ')&&(n>0)) n--;
   s1[n]='\0';
   return;
}

main(int argc,char *argv[])
{
   FILE *ssd;
   struct F_HEADER_ST fhdr;
   F_VARDES_PTR *fvar;
   char *p,ssdnam[256],varnam[NAMLEN];
   int i,obs,*sel;
   double v;
   char *datastr,*savstr,tmp[NAMLEN],s[STRLEN];
   cgi_init(argc,argv);
   p=cgi_info("PATH_INFO");
   p++;
   strcpy(ssdnam,p);
   p=strstr(ssdnam,"/");
   *p='\0';
   p++;
   strcpy(varnam,p);
   cgi_printf("content-type: text/html\n\n");
   cgi_printf("<HTML>\n");
   cgi_printf("<HEAD>\n");
   cgi_printf("<TITLE>%s - %s</TITLE>\n",ssdnam,varnam);
   cgi_printf("</HEAD>\n");
   cgi_printf("<BODY>\n");
#ifndef TABLES
   cgi_printf("<PRE>\n");
#else
   cgi_printf("<TABLE>\n");
#endif
   /* open ssd-file */
   if(!check_access(ssdnam)) {
      cgi_printf("No access to file: %s\n",ssdnam);
      goto fin;
   }
   ssd=fopen(ssdnam,"rb","ctx=stm");
   if(ssd==NULL) {
       cgi_printf("Can not open file: %s\n",ssdnam);
       goto fin;
   }
   /* read header */
   fread(&fhdr,sizeof(fhdr),1,ssd);
   /* read variable descriptors */
   fvar=(F_VARDES_PTR *)malloc(fhdr.TOTAL_FIELDS*sizeof(F_VARDES_PTR));
   sel=(int *)malloc(fhdr.TOTAL_FIELDS*sizeof(int));
   for(i=0;i<fhdr.TOTAL_FIELDS;i++) {
      fvar[i]=(struct F_VARDES_ST *)malloc(sizeof(struct F_VARDES_ST));
      fread(fvar[i],sizeof(*fvar[i]),1,ssd);
      copy(tmp,fvar[i]->VAR_NAME,8);
      if((strcmp(varnam,"all")==0) || (strcmp(tmp,varnam)==0)) {
         sel[i]=TRUE;
      } else {
         sel[i]=FALSE;
      }
   }
   /* read data blocks */
   obs=0;
   datastr=(char *)malloc(fhdr.RECORD_LEN*BLOCK_CNT);
   savstr=datastr;
   while (obs<fhdr.TOTAL_OBS) {
      if ((obs%BLOCK_CNT)==0) {
          datastr=savstr;
          fread(datastr,fhdr.RECORD_LEN,BLOCK_CNT,ssd);
      }
#ifdef TABLES
      cgi_printf("<TR>");
#endif
      for(i=0;i<fhdr.TOTAL_FIELDS;i++) {
         if(fvar[i]->VAR_TYPE==VNUMERIC) {
            if (sel[i]) {
               v=(*((double *)datastr));
               if(v!=MISSING_VALUE) {
#ifndef TABLES
                  cgi_printf(" %f",v);
#else
                  cgi_printf("<TH>%f",v);
#endif
               } else {
#ifndef TABLES
                  cgi_printf(" .");
#else
                  cgi_printf("<TH>");
#endif
               }
            }
            datastr=datastr+sizeof(double);
         }
         if(fvar[i]->VAR_TYPE==VCHAR) {
            if (sel[i]) {
               copy(s,datastr,fvar[i]->VAR_LENGTH);
#ifndef TABLES
               cgi_printf(" %s",s);
#else
               cgi_printf("<TH>%s",s);
#endif
            }
            datastr=datastr+fvar[i]->VAR_LENGTH;
         }
      }
      cgi_printf("\n");
      obs++;
   }
   fclose(ssd);
fin:
#ifndef TABLES
   cgi_printf("</PRE>\n");
#else
   cgi_printf("</TABLE>\n");
#endif
   cgi_printf("</BODY>\n");
   cgi_printf("</HTML>\n");
}
