/*****************************************************************************/
/*
                                  CopyText.c

VERSION HISTORY
---------------
10-JUN-94  MGD  initial development
*/
/*****************************************************************************/

/* standard C header files */
#include <stdio.h>
#include <ctype.h>

#ifdef __ALPHA
#   pragma nomember_alignment
#endif

#define boolean int
#define true 1
#define false 0

/* external declarations */
extern boolean  Debug;

/*****************************************************************************/
/*
Copy text from one string to another, converting characters forbidden to 
appear as plain-text in HTML.  For example the '<', '&', etc.  Convert these 
to the corresponding HTML character entities.
*/ 

char* CopyTextIntoHtml
( 
register char *bptr,
register char *tptr,
register int  ccnt
)
{
    while (ccnt-- && *tptr)
    {
       switch (*tptr)
       {
          case '\t' : while ((int)(bptr-1) % 8) *bptr++ = ' '; tptr++; break;
          case '<' : strcpy (bptr, "&lt;"); bptr += 4; tptr++; break;
          case '>' : strcpy (bptr, "&gt;"); bptr += 4; tptr++; break;
          case '&' : strcpy (bptr, "&amp;"); bptr += 5; tptr++; break;
          case '\"' : strcpy (bptr, "&quot;"); bptr += 6; tptr++; break;
          default : if (isprint(*tptr)) *bptr++ = *tptr++; else tptr++;
       }
    }
    *bptr = '\0';
    return (bptr);
}

/*****************************************************************************/
/*
Copy text from one string to another, converting characters forbidden to 
appear as plain-text text in an HTTP URL.  For example the '?', '+', '&', etc.  
Convert these to "%nn" hexadecimal escaped characters.
*/ 

char* CopyTextIntoUri
( 
register char *bptr,
register char *tptr,
register int  ccnt
)
{
    while (ccnt-- && *tptr)
    {
       switch (*tptr)
       {
          case '\t' : strcpy (bptr, "%09"); bptr += 3; tptr++; break;
          case ' ' : strcpy (bptr, "%20"); bptr += 3; tptr++; break;
          case '#' : strcpy (bptr, "%23"); bptr += 3; tptr++; break;
          case '+' : strcpy (bptr, "%2b"); bptr += 3; tptr++; break;
          case '/' : strcpy (bptr, "%2f"); bptr += 3; tptr++; break;
          case '=' : strcpy (bptr, "%3d"); bptr += 3; tptr++; break;
          case '?' : strcpy (bptr, "%3f"); bptr += 3; tptr++; break;
          default : if (isprint(*tptr)) *bptr++ = *tptr++; else tptr++;
       }
    }
    *bptr = '\0';
    return (bptr);
}

/*****************************************************************************/
/*
Copy text from one string to another, converting characters forbidden to 
appear as plain-text in an HTTP URL back into plain-text.  For example the 
'?', '+', '&', etc., are converted from "%nn" hexadecimal escaped characters. 
*/ 

char* CopyTextFromUri
(
register char *tptr,
register char *uptr,
register int  ccnt
)
{
   register char  c;
   register char  *sptr;

   while (ccnt-- && *uptr)
   {
      if (*uptr == '%')
      {
         /* an escaped character ("%xx" where xx is a hexadecimal number) */
         uptr++;
         sptr = uptr;
         if (*uptr) { ccnt--; uptr++; }
         if (*uptr) { ccnt--; uptr++; }
         c = *uptr;
         *uptr = '\0';
         *tptr++ = (unsigned char) strtol (sptr, NULL, 16);
         *uptr = c;
      }
      else
         *tptr++ = *uptr++;
   }
   *tptr = '\0';

   return (tptr);
}

/*****************************************************************************/
