$!-----------------------------------------------------------------------------
$! BUILD_HTTPD.COM
$! (P1 == "LINK" to link only, P1 == "VAXC" to compile using VAXC compiler)
$!
$! 06-JAN-96  MGD  build for either UCX or Multinet
$! 01-DEC-95  MGD  HTTPd version 3
$! 24-MAY-95  MGD  build for AXP systems
$! 20-DEC-94  MGD  multi-threaded server
$! 20-JUN-94  MGD  single-threaded server
$!-----------------------------------------------------------------------------
$ IF F$TRNLNM("MULTINET") .EQS. ""
$    THEN VARIETY = "UCX"
$    ELSE VARIETY = "MULTINET"
$ ENDIF
$ WRITE SYS$OUTPUT "Building for ""''F$GETSYI("ARCH_NAME")'"" architecture" + -
                   " and ""''VARIETY'"" TCP/IP."
$ VARIETY = "_" + VARIETY
$!
$ IF F$EDIT(F$GETSYI("ARCH_NAME"),"UPCASE") .EQS. "VAX"
$ THEN
$    OBJECT_DIR = "[.OBJ_VAX]"
$    IF F$SEARCH("OBJ_VAX.DIR") .EQS. "" THEN CREATE /DIR 'OBJECT_DIR'
$    IF P1 .EQS. "VAXC"
$    THEN
$!      (compile using VAXC compiler)
$       CC_OPTIONS = "/VAXC /DEFINE=IP''VARIETY' " +-
                     "/NODEBUG /OBJECT=[.''OBJECTS']"
$       LINK_OPTIONS = "[]HTTPD_VAX_VAXC'VARIETY'.OPT /OPTIONS"
$    ELSE
$!      (compile using DECC compiler)
$       CC_OPTIONS = "/STANDARD=VAXC /DEFINE=IP''VARIETY' " +-
                     "/NODEBUG /OBJECT=''OBJECT_DIR'"
$       LINK_OPTIONS = "[]HTTPD_VAX'VARIETY'.OPT /OPTIONS"
$    ENDIF
$ ELSE
$    OBJECT_DIR = "[.OBJ_AXP]"
$    IF F$SEARCH("OBJ_AXP.DIR") .EQS. "" THEN CREATE /DIR 'OBJECT_DIR'
$!   (only compile using DECC compiler)
$    CC_OPTIONS = "/STANDARD=VAXC /DEFINE=IP''VARIETY' " +-
                  "/NODEBUG /OBJECT=''OBJECT_DIR'"
$    LINK_OPTIONS = "[]HTTPD_AXP'VARIETY'.OPT /OPTIONS"
$ ENDIF
$!
$ IF P1 .NES. "LINK" .AND. P2 .NES. "LINK"
$ THEN
$    SET NOON
$    SET VERIFY
$    CC 'CC_OPTIONS' Auth
$    CC 'CC_OPTIONS' CLI
$    CC 'CC_OPTIONS' Config
$    CC 'CC_OPTIONS' Control
$    CC 'CC_OPTIONS' Dcl
$    CC 'CC_OPTIONS' Dir
$    CC 'CC_OPTIONS' Error
$    CC 'CC_OPTIONS' File
$    CC 'CC_OPTIONS' HTTPd
$    CC 'CC_OPTIONS' IsMap
$    CC 'CC_OPTIONS' Logging
$    CC 'CC_OPTIONS' MapUrl
$    CC 'CC_OPTIONS' Menu
$    CC 'CC_OPTIONS' Request
$    CC 'CC_OPTIONS' sHTML
$    CC 'CC_OPTIONS' Support
$!   'F$VERIFY(0)
$ ENDIF
$ IF VARIETY .EQS. "_UCX" THEN VARIETY = ""
$ SET ON
$ SET VERIFY
$ LINK /NOTRACE /EXECUTABLE=HT_EXE:HTTPD'VARIETY'.EXE -
  'OBJECT_DIR'Auth, -
  'OBJECT_DIR'CLI, -
  'OBJECT_DIR'Config, -
  'OBJECT_DIR'Control, -
  'OBJECT_DIR'Dir, -
  'OBJECT_DIR'Dcl, -
  'OBJECT_DIR'Error, -
  'OBJECT_DIR'File, -
  'OBJECT_DIR'HTTPd, -
  'OBJECT_DIR'IsMap, -
  'OBJECT_DIR'Logging, -
  'OBJECT_DIR'MapUrl, -
  'OBJECT_DIR'Menu, -
  'OBJECT_DIR'Request, -
  'OBJECT_DIR'sHTML, -
  'OBJECT_DIR'Support, -
  'LINK_OPTIONS'
$!
$ PURGE /LOG 'OBJECT_DIR' /KEEP=3
$ SET PROTECTION=W:E HT_EXE:HTTPD'VARIETY'.EXE;*
$!'F$VERIFY(0)
$!-----------------------------------------------------------------------------
