/*****************************************************************************/
/*
                                   echo.c

CGI-compliant script to echo the HTTP stream as plain-text.  Pays no attention
to "Content-Length:", etc., just reads from the HTTP stream until a one second
timeout occurs.

Access via:   <A HREF="/cgi-bin/echo">echo</A>

              <FORM METHOD=POST ACTION="/cgi-bin/echo">
              <INPUT TYPE=submit VALUE="echo">
              </FORM>


BUILD
-----
See BUILD_ECHO.COM


VERSION HISTORY
---------------
22-FEB-96  MGD  v1.0.0, quick hack
*/
/*****************************************************************************/

#ifdef __ALPHA
   char SoftwareID [] = "ECHO AXP-1.0.0";
#else
   char SoftwareID [] = "ECHO VAX-1.0.0";
#endif

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <file.h>

#include <descrip.h>
#include <ssdef.h>
#include <stsdef.h>

#define VMSok(x) ((x) & STS$M_SUCCESS)
#define VMSnok(x) !(((x) & STS$M_SUCCESS))

#define boolean int
#define true 1
#define false 0

char  Utility [] = "ECHO";

boolean  Debug,
         HttpHasBeenOutput;

int  HttpInFd;
FILE  *HttpOut;

/* function prototype */
TimeoutAst ();

/*****************************************************************************/
/*
*/

main ()

{
   int  status,
        Count;
   unsigned long  TimeoutBinTime [2];
   char  HttpRecord [1024];
   static $DESCRIPTOR (TimeoutDsc, "0 00:00:01.00");

   /*********/
   /* begin */
   /*********/

   /* open another output stream so that the '\r' and '\n' are not filtered */
#ifdef __DECC
   if ((HttpOut = fopen ("SYS$OUTPUT", "w", "ctx=bin")) == NULL)
      exit (vaxc$errno);
#else
   if ((HttpOut = fopen ("SYS$OUTPUT", "w", "rfm=udf")) == NULL)
      exit (vaxc$errno);
#endif

   /* open the HTTP input stream */
#ifdef __DECC
   if ((HttpInFd = open ("HTTP$INPUT", O_RDONLY, 0, "ctx=bin")) == -1)
      exit (vaxc$errno);
#else
   if ((HttpInFd = open ("HTTP$INPUT", O_RDONLY, 0, "rfm=udf")) == -1)
      exit (vaxc$errno);
#endif

   fprintf (HttpOut,
"HTTP/1.0 200 Echoed stream follows.\r\n\
Server: %s\r\n\
Content-Type: text/plain\r\n\
\r\n", SoftwareID);

   if (VMSnok (status = sys$bintim (&TimeoutDsc, &TimeoutBinTime)))
      exit (status);

   if (VMSnok (status = sys$setimr (0, &TimeoutBinTime, &TimeoutAst, 0, 0)))
      exit (status);

   while ((Count = read (HttpInFd, HttpRecord, sizeof(HttpRecord))) > 0)
   {
      sys$cantim (0, 0);

      fwrite (HttpRecord, Count, 1, HttpOut);

      if (VMSnok (status = sys$setimr (0, &TimeoutBinTime, &TimeoutAst, 0, 0)))
         exit (status);
   }

   exit (SS$_NORMAL);
}

/****************************************************************************/
/*
*/

TimeoutAst ()

{
   fflush (HttpOut);
   exit (SS$_NORMAL);
}

/*****************************************************************************/

