/*****************************************************************************/
/*
                               SearchFiles.c


VERSION HISTORY
---------------
31-AUG-95  MGD  bugfix; correctly report when no files at all are found
21-APR-95  MGD  added 'FormWhat'
05-DEC-94  MGD  minor revisions
10-JUN-94  MGD  initial development
*/
/*****************************************************************************/

/* standard C header files */
#include <stdio.h>
#include <ctype.h>

/* VMS related header files */
#include <descrip.h>
#include <rmsdef.h>
#include <rms.h>
#include <ssdef.h>
#include <stsdef.h>

#ifdef __ALPHA
#   pragma nomember_alignment
#endif

#define boolean int
#define true 1
#define false 0
 
#define VMSok(x) ((x) & STS$M_SUCCESS)
#define VMSnok(x) !(((x) & STS$M_SUCCESS))

/* external declarations */
extern boolean  Debug;
extern boolean  ExactNumberOfRecords;
extern boolean  HttpHasBeenOutput;
extern int  ExtractNumberOfRecords;
extern char  CgiPathInfo[];
extern char  FormWhat[];
extern char  HtmlFileTypes[];
extern char  Http200Header[];
extern char  SoftwareID[];
extern char  TextFileTypes[];
extern FILE  *HttpOut;

char* MapUrl (char*, char*, char*, char*);

/*****************************************************************************/
/*
Search files in specification for specified string.  Unless a file type 
(extension) matches an HTML type then consider the file to be a plain-text 
file.  The two need to searched differently because of the HTML markup tags 
compsrising an HTML file.
*/ 

SearchFiles
(
char *FileSpec,
int FileSpecLength,
char *SearchString,
boolean CaseSensitive,
boolean DocumentOnly
)
{
   static int  TimerElapsed = 1,
               TimerCpu = 2,
               TimerBio = 3,
               TimerDio = 4;
   static $DESCRIPTOR (ElapsedTimeFaoDsc, "!%T");
   static $DESCRIPTOR (StatisticsFaoDsc,
"Elapsed: <TT>!AZ</TT> CPU: <TT>!2ZL.!UL</TT> \
I/O: <TT>!UL</TT> Disk: <TT>!UL</TT> Records (lines) : <TT>!UL</TT>");

   int  status,
        BioCount,
        CpuTime,
        DioCount,
        FileCount = 0,
        FileHitCount = 0,
        NotSearchedFileCount = 0,
        TotalHitCount = 0,
        RecordCount = 0,
        SearchStringLength;
   unsigned long  ElapsedTime [2];
   unsigned short  Length;
   char  *FilePtr,
         *FileHitPtr,
         *TotalHitPtr;
   char  DocumentName [2048],
         ElapsedString [32],
         ExpandedFileSpec [256],
         FileName [256],
         NotSearchedString [32],
         Statistics [256],
         String [256],
         UriSearchString [256];
   struct FAB  SearchFab;
   struct NAM  SearchNam;
   $DESCRIPTOR (ElapsedStringDsc, ElapsedString);
   $DESCRIPTOR (StatisticsDsc, Statistics);

   /*********/
   /* begin */
   /*********/

   if (Debug)
      fprintf (stdout, "SearchFiles() |%s|%s|\n", FileSpec, UriSearchString);

   lib$init_timer (0);

   if (SearchString[0])
   {
      SearchStringLength = strlen(SearchString);
      CopyTextIntoUri (UriSearchString, SearchString, -1);
   }
   else
   {
      SearchStringLength = 0;
      UriSearchString[0] = '\0';
   }

   fprintf (HttpOut,
"%s\
<HTML>\n\
<!-- SoftwareID: %s -->\n",
   Http200Header, SoftwareID);

   if (FormWhat[0])
      fprintf (HttpOut, "<TITLE>Search %s for \"", FormWhat);
   else
      fprintf (HttpOut, "<TITLE>Search for \"");
   CopyTextIntoHtml (String, SearchString, -1);
   fputs (String, HttpOut);
   fputs ("\"</TITLE>\n", HttpOut);
   if (FormWhat[0])
      fprintf (HttpOut, "<H1>Search <TT>%s</TT> for \"<TT>", FormWhat);
   else
      fprintf (HttpOut, "<H1>Search %s for \"<TT>", FormWhat);
   CopyTextIntoHtml (String, SearchString, -1);
   fputs (String, HttpOut);
   fputs ("</TT>\"</H1>\n<P><HR>\n", HttpOut);
   fflush (HttpOut);
   HttpHasBeenOutput = true;

   SearchFab = cc$rms_fab;
   SearchFab.fab$l_fna = FileSpec;
   SearchFab.fab$b_fns = FileSpecLength;
   SearchFab.fab$l_fop = FAB$M_NAM;
   SearchFab.fab$l_nam = &SearchNam;
   SearchNam = cc$rms_nam;
   SearchNam.nam$l_esa = ExpandedFileSpec;
   SearchNam.nam$b_ess = sizeof(ExpandedFileSpec)-1;
   SearchNam.nam$l_rsa = FileName;
   SearchNam.nam$b_rss = sizeof(FileName)-1;

   if (VMSnok (status = sys$parse (&SearchFab, 0, 0)))
   {
      ErrorVmsStatus (status, CgiPathInfo, FileSpec, __FILE__, __LINE__);
      return (status);
   }

   if (Debug) fprintf (stdout, "ExpandedFileSpec |%s|\n", ExpandedFileSpec);

   /***************/
   /* file search */
   /***************/

   while (VMSok (status = sys$search (&SearchFab, 0, 0)))
   {
      *SearchNam.nam$l_ver = '\0';
      if (Debug) fprintf (stdout, "FileName |%s|\n", FileName);

      if (SameFileType (HtmlFileTypes, SearchNam.nam$l_type))
      {
         FileCount++;
         /* if HTML document's <title> can't be resolved then use file name */
         sprintf (DocumentName, "(file name) %s", SearchNam.nam$l_name);

         status = SearchHtmlFile (FileName, SearchNam.nam$l_ver-FileName,
                                  DocumentName,
                                  UriSearchString,
                                  SearchString, SearchStringLength,
                                  &RecordCount, &FileHitCount, &TotalHitCount,
                                  CaseSensitive, DocumentOnly);
         if (VMSnok (status))
         {
            ErrorVmsStatus (status, MapUrl(NULL,FileName,NULL,NULL),
                            FileName, __FILE__, __LINE__);
            return (SS$_NORMAL);
         }
         else;
      }
      else
      if (SameFileType (TextFileTypes, SearchNam.nam$l_type))
      {
         FileCount++;
         DocumentName[0] = '\0';

         status =
         SearchTextFile (FileName, SearchNam.nam$l_ver-FileName,
                         DocumentName,
                         UriSearchString,
                         SearchString, SearchStringLength,
                         &RecordCount, &FileHitCount, &TotalHitCount,
                         CaseSensitive, DocumentOnly,
                         ExtractNumberOfRecords, ExactNumberOfRecords);
         if (VMSnok (status))
         {
            ErrorVmsStatus (status, MapUrl(NULL,FileName,NULL,NULL),
                            FileName, __FILE__, __LINE__);
            return (SS$_NORMAL);
         }
         else;
      }
      else
         NotSearchedFileCount++;

      *SearchNam.nam$l_ver = ';';
   }

   if (Debug) fprintf (stdout, "sys$search() %%X%08.08X\n", status);

   /*******************/
   /* end file search */
   /*******************/

   /* if its a search list treat directory not found as if file not found */
   if ((SearchNam.nam$l_fnb & NAM$M_SEARCH_LIST) && status == RMS$_DNF)
      status = RMS$_FNF;
   if (status == RMS$_FNF || status == RMS$_NMF) status = SS$_NORMAL;
   if (VMSnok (status))
   {
       ErrorVmsStatus (status, CgiPathInfo, FileSpec, __FILE__, __LINE__);
       return (SS$_NORMAL);
   }

   /*********************/
   /* results of search */
   /*********************/

   lib$stat_timer (&TimerElapsed, &ElapsedTime, 0);
   lib$stat_timer (&TimerCpu, &CpuTime, 0);
   lib$stat_timer (&TimerBio, &BioCount, 0);
   lib$stat_timer (&TimerDio, &DioCount, 0);

   sys$fao (&ElapsedTimeFaoDsc, &Length, &ElapsedStringDsc, &ElapsedTime);
   ElapsedString[Length] = '\0';
   sys$fao (&StatisticsFaoDsc, &Length, &StatisticsDsc,
            ElapsedString+3, CpuTime/100, CpuTime%100,
            BioCount, DioCount, RecordCount);
   Statistics[Length] = '\0';

   if (!NotSearchedFileCount)
      NotSearchedString[0] = '\0';
   else
   if (NotSearchedFileCount == 1)
      strcpy (NotSearchedString, " (1 not)");
   else
      sprintf (NotSearchedString, " (%d not)", NotSearchedFileCount);

   if (TotalHitCount)
   {
      if (FileCount == 1) FilePtr = "file"; else FilePtr = "files";
      if (FileHitCount == 1) FileHitPtr = "file"; else FileHitPtr = "files";
      if (TotalHitCount == 1) TotalHitPtr = "hit"; else TotalHitPtr = "hits";
      if (DocumentOnly)
      {
         fprintf (HttpOut,
"</OL>\n\
<P><HR>\n\
<I>%d %s searched%s with %d %s hit.\n\
<BR>%s</I>\n",
         FileCount, FilePtr, NotSearchedString, FileHitCount, FileHitPtr,
         Statistics);
      }
      else
      {
         fprintf (HttpOut,
"</OL>\n\
<P><HR>\n\
<I>%d %s searched%s with %d %s hit, for a total of %d %s.\n\
<BR>%s</I>\n",
         FileCount, FilePtr, NotSearchedString, FileHitCount, FileHitPtr,
         TotalHitCount, TotalHitPtr,
         Statistics);
      }
   }

   /*
       This cannot be an 'else' statement.
       Something wierd after change of carriage-control from '\r\n' to '\n',
       and, unfortunately, after update to DEC C v5.0 (so I don't know which
       caused it!)
       If it is an else the module access violates!
   */
   if (!TotalHitCount)
   {
      if (FileCount)
      {
         if (FileCount == 1) FilePtr = "file"; else FilePtr = "files";
         fprintf (HttpOut,
"<P><HR>\n\
<I>%d %s searched%s, string not found.\n\
<BR>%s</I>\n",
         FileCount, FilePtr, NotSearchedString,
         Statistics);
      }
      else
         fprintf (HttpOut, "<P><HR>\n<I>No files found.\n<BR>%s</I>\n",
                  Statistics);
   }

   if (VMSnok (status))
   {
       ErrorVmsStatus (status, CgiPathInfo, FileName, __FILE__, __LINE__);
       return (SS$_NORMAL);
   }

   fputs ("</HTML>\n", HttpOut);

   return (status);
}

/*****************************************************************************/
/*
This function accepts a comma-separated list of file types (extensions, e.g.
"TXT,TEXT,COM,C,PAS,FOR") and a VMS file type (e.g. ".TXT;", ".TXT", "TXT").
It returns true if the file type is in the list, false if not.
*/

boolean SameFileType
(
char *TypeList,
char *FileType
)
{
   register char  *cptr, *sptr;

   /*********/
   /* begin */
   /*********/

   if (Debug)
      fprintf (stdout, "SameFileType() |%s|%s|\n", TypeList, FileType);

   if (*FileType == '.') FileType++;
   cptr = TypeList;
   while (*cptr)
   {
      sptr = FileType;
      while (*sptr && *sptr != ';' && *cptr && *cptr != ',' &&
             toupper(*sptr) == toupper(*cptr))
      {
         cptr++;
         sptr++;
      }
      if ((!*sptr || *sptr == ';') && (!*cptr || *cptr == ',')) return (true);
      while (*cptr && *cptr != ',') cptr++;
      if (*cptr) cptr++;
   }
   return (false);
}

/*****************************************************************************/
/*
Case sensitive or case insensistive search of the string pointed to by 'sptr' 
for the string pointed to by 'SearchString'.
*/ 

char* SearchTextString
( 
register char *tpr,
register char *SearchString,
register boolean CaseSensitive
)
{
   register char  *cptr, *sptr;

   sptr = SearchString;
   if (CaseSensitive)
   {
      while (*tpr)
      {
         if (*tpr++ != *sptr) continue;
         /* first character of search string matched record character */
         sptr++;
         cptr = tpr;
         while (*cptr && *sptr)
         {
            if (*cptr != *sptr) break;
            cptr++;
            sptr++;
         }
         if (!*sptr)
         {
            tpr--;
            break;
         }
         sptr = SearchString;
      }
   }
   else
   {
      while (*tpr)
      {
         if (toupper(*tpr++) != toupper(*sptr)) continue;
         /* first character of search string matched record character */
         sptr++;
         cptr = tpr;
         while (*cptr && *sptr)
         {
            if (toupper(*cptr) != toupper(*sptr)) break;
            cptr++;
            sptr++;
         }
         if (!*sptr)
         {
            tpr--;
            break;
         }
         sptr = SearchString;
      }
   }
   return (tpr);
}

/*****************************************************************************/

