/*
 *  Author     : Arne Vajhj
 *
 *  Programmed : april 1995
 *
 *  Purpose    : get fields from Lotus 1-2-3 / Symphony spreadshet
 *
 *  Modified   : april 1995
 *               Added a SECURE option (which is default on), that will
 *               only use files in a WWW-subdirectory.
 *
 *               april 1995
 *               Changed check to use generic check_access function.
 *
 *               july 1995
 *               The define TABLES will make it generate tables.
 *
 *               september 1995
 *               Test for REQUEST_METHOD HEAD.
 *
 *               february 1996
 *               Include stdlib.h and change EOF/BOF to ZEOF/ZBOF
 *               to compile with DEC C.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "cgilib.h"

#include "wks.h"

int check_access();

#define CVT$K_VAX_D 1
#define CVT$K_IEEE_T 5

int cvt$convert_float();

double ieee2vax(char *x)
{
   double tmp;
   cvt$convert_float(x,CVT$K_IEEE_T,&tmp,CVT$K_VAX_D,0);
   return tmp;
}

#ifndef TABLES
#define POS col=(*((short *)(buf+COL))); \
            row=(*((short *)(buf+ROW))); \
            if(row>=maxrow) goto fin2; \
            for(i=currow;i<row;i++) { cgi_printf("\n"); curcol=0; } \
            for(i=curcol;i<col;i++) { cgi_printf("          "); } \
            curcol=col+1; \
            currow=row;
#else
#define POS col=(*((short *)(buf+COL))); \
            row=(*((short *)(buf+ROW))); \
            if(row>=maxrow) goto fin2; \
            for(i=currow;i<row;i++) { cgi_printf("\n<TR>"); curcol=0; } \
            for(i=curcol;i<col;i++) { cgi_printf("<TH>         "); } \
            curcol=col+1; \
            currow=row;
#endif

main(int argc,char *argv[])
{
   FILE *wks;
   char *p,wksnam[256],limit[20];
   int i;
   short typ,len,curcol,currow,col,row,maxrow,vint;
   double vnum;
   char buf[2048],*s;
   cgi_init(argc,argv);
   p=cgi_info("PATH_INFO");
   p++;
   strcpy(wksnam,p);
   p=strstr(wksnam,"/");
   *p='\0';
   p++;
   strcpy(limit,p);
   if(strcmp(limit,"all")==0) {
      maxrow=32767;
   } else {
      maxrow=atoi(limit);
   }
   cgi_printf("content-type: text/html\n\n");
   if(strcmp(cgi_info("REQUEST_METHOD"),"HEAD")==0) exit(1);
   cgi_printf("<HTML>\n");
   cgi_printf("<HEAD>\n");
   cgi_printf("<TITLE>%s - %s</TITLE>\n",wksnam,limit);
   cgi_printf("</HEAD>\n");
   cgi_printf("<BODY>\n");
#ifndef TABLES
   cgi_printf("<PRE>\n");
#else
   cgi_printf("<TABLE>\n");
#endif
   /* open wks-file */
   if(!check_access(wksnam)) {
      cgi_printf("No access to file: %s\n",wksnam);
      goto fin;
   }
   wks=fopen(wksnam,"rb","ctx=stm");
   if(wks==NULL) {
       cgi_printf("Can not open file: %s\n",wksnam);
       goto fin;
   }
   /* read data */
   curcol=0;
   currow=0;
   for(;;) {
      fread(&typ,sizeof(typ),1,wks);
      fread(&len,sizeof(len),1,wks);
      fread(buf,sizeof(char),len,wks);
      switch (typ) {
         case ZBOF:
#ifndef TABLES
            cgi_printf("Created by : ");
#else
            cgi_printf("<TR><TH COLSPAN=4>Created by : ");
#endif
            vint=(*((short *)buf));
            switch (vint) {
               case 0x0404:
                  cgi_printf("LOTUS 1-2-3\n");
                  break;
               case 0x0405:
                  cgi_printf("Symphony\n");
                  break;
               default:
                  cgi_printf("unknown\n");
                  break;
            }
#ifdef TABLES
            cgi_printf("<TR>");
#endif
            break;
         case ZEOF:
            goto fin2;
            break;
         case INTEGER:
            POS;
            vint=(*((short *)(buf+VAL)));
#ifndef TABLES
            cgi_printf(" %9d",vint);
#else
            cgi_printf("<TH>%9d",vint);
#endif
            break;
         case NUMBER:
            POS;
            vnum=ieee2vax(buf+VAL);
#ifndef TABLES
            cgi_printf(" %9f",vnum);
#else
            cgi_printf("<TH>%9f",vnum);
#endif
            break;
         case LABEL:
            POS;
            s=buf+VAL+1;
#ifndef TABLES
            cgi_printf(" %9s",s);
#else
            cgi_printf("<TH>%9s",s);
#endif
            break;
         case FORMULA:
            POS;
            vnum=ieee2vax(buf+VAL);
#ifndef TABLES
            cgi_printf(" %9f",vnum);
#else
            cgi_printf("<TH>%9f",vnum);
#endif
            break;
      }
   }
fin2:
   fclose(wks);
fin:
#ifndef TABLES
   cgi_printf("</PRE>\n");
#else
   cgi_printf("</TABLE>\n");
#endif
   cgi_printf("</BODY>\n");
   cgi_printf("</HTML>\n");
}
