#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "gd.h"
#include "gdfontl.h"
#include "gdfonts.h"

#define PI 3.14159265358979323846
#define XC(x,y,r,v) x+r*cos(v*PI/180)
#define YC(x,y,r,v) y+r*sin(v*PI/180)

main(int argc,char *argv[])
{
   FILE *fp1,*fp2;
   gdImagePtr img;
   int white,black,red,green,blue,yellow,pink,saphir;
   int l,n,i,s,e,col[6];
   double value[10],accval;
   char title[40],name[10][5];
   fp1 = fopen(argv[1],"rb");
   fp2 = fopen(argv[2],"wb");
   img = gdImageCreate(200,200);
   white = gdImageColorAllocate(img,255,255,255);
   black = gdImageColorAllocate(img,0,0,0);
   red = gdImageColorAllocate(img,255,0,0);
   green = gdImageColorAllocate(img,0,255,0);
   blue = gdImageColorAllocate(img,0,0,255);
   yellow = gdImageColorAllocate(img,255,255,0);
   pink = gdImageColorAllocate(img,255,0,255);
   saphir = gdImageColorAllocate(img,0,255,255);
   col[0] = red;
   col[1] = green;
   col[2] = blue;
   col[3] = yellow;
   col[4] = pink;
   col[5] = saphir;
   gdImageRectangle(img,10,10,190,190,black);
   fscanf(fp1,"%s",title);
   l = strlen(title)*gdFontLarge->w;
   gdImageString(img,gdFontLarge,90-l/2,20,title,black);
   n = 0;
   accval = 0.0;
   while(fscanf(fp1,"%s%f",name[n],&value[n])>0) {
      accval = accval+value[n];
      n++;
   }
   l = 160/n;
   s = 0;
   for(i=0;i<n;i++) {
      if(i!=(n-1)) {
         e = s + (value[i]/accval)*360;
      } else {
         e = 360;
      }
      gdImageArc(img,100,100,120,120,s,e,col[i%6]);
      gdImageLine(img,100,100,XC(100,100,60,s),YC(100,100,60,s),col[i%6]);
      gdImageLine(img,100,100,XC(100,100,60,e),YC(100,100,60,e),col[i%6]);
      gdImageFill(img,XC(100,100,30,(s+e)/2),YC(100,100,30,(s+e)/2),col[i%6]);
      s = e;
      gdImageFilledRectangle(img,20+l*i,165,20+l*i+5,170,col[i%6]);
      gdImageString(img,gdFontSmall,20+l*i,180,name[i],black);
   }
   gdImageGif(img,fp2);
   gdImageDestroy(img);
   fclose(fp1);
   fclose(fp2);
}
