

// Base class for states

#ifndef __state
#define __state
#include "StdAfx.h"

typedef enum {Smaller=-1, Equal=0, Larger=1} CompareResult;

typedef struct statelist_node {
	class State *state;
	struct statelist_node *next;
} StateListNode, *OPAQUE_POSITION;

class StateList {
private:
	StateListNode temp;
	StateListNode *first;
	StateListNode *current;
public:
	StateList();
	~StateList();
	void AddState(class State *s);
	State *FindState(class State *s);
	void DeleteState(class State *s);
	class State *FirstState();
	class State *NextState();
	OPAQUE_POSITION GetPosition() { return current; };
	void SetPosition(OPAQUE_POSITION pos) { current=pos;};
};

class State {
friend class SearchAlgorithm;
private:
	double          h,g;
	State           *parent;
	StateList       *children;
	OPAQUE_POSITION NewTraversal() { return children->GetPosition();};
	void            ResetTraversal(OPAQUE_POSITION pos) { children->SetPosition(pos);};
public:
// Functions supplied by this class
	State();
	~State();
	int        SetParent(State *p);
	int        AddChild(State *p);
	int        DeleteChild(State *c);
	void       SetHeuristic(double heur) { h=heur; };
    void       SetPath(double gee) {g=gee;};
	double     GetPath() { return g;};
	double     GetHeuristic() { return h; };
	double     GetF() { return g+h;};
	State     *GetParent();
	State     *FirstChild();
	State     *NextChild();

// Overridables
	virtual CompareResult Compare(State *p);
// GenerateChildren should set g, but not h, since the heuristic
// is not known by the state class.  Instead, SearchAlgorithm-derived
// Classes will set it.
	virtual void          GenerateChildren();
	virtual void          DrawSelf(CDC *dc, CRect *rect);
};


#endif
