// 
#include "UTILS.H"
#include "ASTAR.H"

ASTAR::ASTAR() : SearchAlgorithm(), Edge(), Dead()
{
	status=NotInited;
	numedge=numdead=0;
}

ASTAR::~ASTAR()
{
	Edge.Clear();
	Dead.Clear();
}

void ASTAR::Initialize(Context *c)
{
	SearchAlgorithm::Initialize(c);

	Edge.Clear();
	Dead.Clear();
	startstate->SetPath(0.0);
	startstate->SetHeuristic(context->Heuristic(startstate));
	Edge.AddInOrder(startstate,-(startstate->GetF()));
	status=NotGoal;
	numedge=1;
}

State *ASTAR::Step()
{
	State *state;

	SearchAlgorithm::Step();

	if ((state=Edge.GetNextItem())==NULL) {
		status=NoGoalDone;
		return NULL;
	}

	--numedge;

	if (context->IsGoalState(state)) {
		status=GoalDone;
		return state;
	}

	// This will set the g values for us according to the state space
	state->GenerateChildren();
	// Now we need to set h values for the children and insert them
	// As needed
	State *child, *listnode;
	for (child=state->FirstChild();child!=NULL;child=state->NextChild()) {
		child->SetHeuristic(context->Heuristic(child));
		// Next, we See if it is on the closed list
		if ((listnode=Dead.FindRemove(child))!=NULL) {
			--numdead;
			// If so, and we reached it with a better path, then
			if (child->GetF() < listnode->GetF()) {
				// Remove the node from its current parent's child list
				listnode->GetParent()->DeleteChild(listnode);
				// Make the node's parent the current state
				listnode->SetParent(state);
				// remove the generated child from the current state's child list
				state->DeleteChild(child);
				// Add the node to the current state's child list
				state->AddChild(listnode);
				listnode->SetPath(child->GetPath());
				listnode->SetHeuristic(child->GetHeuristic());
				// And put it back on the open list
				Edge.AddInOrder(listnode,-(listnode->GetF()));
				++numedge;
//				delete child;
			} else {
				// if not on a better path, put it back on the closed list
				Dead.AddAtBack(listnode);
				state->DeleteChild(child);
//				delete child;
				++numdead;
			}
		} else {
			// If the node is on the open list, remove it
			if ((listnode=Edge.FindRemove(child))!=NULL) {
				--numedge;
				// If so, and we reached it with a better path, then
				if (child->GetF() < listnode->GetF()) {
					// Remove the node from its current parent's child list
					listnode->GetParent()->DeleteChild(listnode);
					// Make the node's parent the current state
					listnode->SetParent(state);
					// remove the generated child from the current state's child list
					state->DeleteChild(child);
					// Add the node to the current state's child list
					state->AddChild(listnode);
					listnode->SetPath(child->GetPath());
					listnode->SetHeuristic(child->GetHeuristic());
					// And put it back on the open list
					Edge.AddInOrder(listnode,-(listnode->GetF()));
					++numedge;
//					delete child;
				} else {
					// if not on a better path, put it back on the closed list
					Edge.AddInOrder(listnode,-(listnode->GetF()));
					++numedge;
					state->DeleteChild(child);
//					delete child;
				}
			} else {
				// Normal case, add the child to the open list
				Edge.AddInOrder(child,-(child->GetF()));
				++numedge;
			}
		} 
	}

	Dead.AddAtBack(state);
	++numdead;

	return state;

}


void ASTAR::DrawStatus(CDC *cdc)
{

	int i;
	State *temp;
	CRect rect(0,0,50,50);
	char *temp1="Edge:";
	char *temp2="Dead:";
	char buf[80];


	cdc->TextOut(0,25,temp1,strlen(temp1));
	cdc->TextOut(0,125,temp2,strlen(temp2));

	for (i=1,temp=Edge.First();temp!=NULL;temp=Edge.Next(),i++) {
		rect.left=i*50; 
		rect.right=rect.left+50;
		rect.top=0;
		rect.bottom=50;
		temp->DrawSelf(cdc,&rect);
		sprintf(buf,"%4.1lf",temp->GetF());
		cdc->TextOut(rect.left+10,rect.bottom+10,buf,strlen(buf));
	}

	for (i=1,temp=Dead.First();temp!=NULL;temp=Dead.Next(),i++) {
		rect.left=i*50; 
		rect.right=rect.left+50;
		rect.top=100;
		rect.bottom=150;
		temp->DrawSelf(cdc,&rect);
		sprintf(buf,"%4.1lf",temp->GetF());
		cdc->TextOut(rect.left+10,rect.bottom+10,buf,strlen(buf));
	}
}


void ASTAR::GetStatusRect(CRect *rect)
{

	rect->left=rect->top=0;
	rect->bottom=200; 
	rect->right=110+50*MAX(numedge,numdead);
}

	
	
	