

#define MAKE_LOCAL_UP_SCAN(datatype,op,id)  \
int local_##op##_scan_##datatype##_up(datatype  *inarray, \
				  datatype  *outarray, \
				  datatype  *scanout, \
				  int       numdim, \
				  int       desc[][6], \
				  int       scandim) \
{\
  int outer, start, inner, i;\
  datatype base;\
\
  for (outer=0;outer<prodall;outer+=prodinnerscan) {\
    for (inner=outer;inner<outer+prodinner;inner++) {\
      for (start=inner;start<inner+prodinnerscan;start+=blocksize*prodinner) {\
	base=id;\
	for (i=start;i<start+blocksize*prodinner;i+=prodinner) {\
	  outarray[i]=op(inarray[i],base);\
	  base= op(base,inarray[i]);\
	}\
	*scanout=base;\
	scanout++;\
      }\
    }\
  }\
  return 0;\
} 

#define MAKE_LOCAL_UP_PRESCAN(datatype,op,id)  \
int local_##op##_prescan_##datatype##_up(datatype  *inarray, \
				  datatype  *outarray, \
				  datatype  *scanout, \
				  int       numdim, \
				  int       desc[][6], \
				  int       scandim) \
{\
  int outer, start, inner, i;\
  datatype base;\
\
  for (outer=0;outer<prodall;outer+=prodinnerscan) {\
    for (inner=outer;inner<outer+prodinner;inner++) {\
      for (start=inner;start<inner+prodinnerscan;start+=blocksize*prodinner) {\
	base=id;\
	for (i=start;i<start+blocksize*prodinner;i+=prodinner) {\
          outarray[i]=base;\
	  base= op(base,inarray[i]);\
	}\
	*scanout=base;\
	scanout++;\
      }\
    }\
  }\
  return 0;\
} 

#define MAKE_LOCAL_DOWN_SCAN(datatype,op,id) \
int local_##op##_scan_##datatype##_down(datatype *outarray,\
				        datatype *scanin,\
				        int      numdim,\
				        int      desc[][6],\
				        int      scandim)\
{\
  int outer, start, inner, i;\
  datatype base;\
\
  for (outer=0;outer<prodall;outer+=prodinnerscan) {\
    for (inner=outer;inner<outer+prodinner;inner++) {\
      for (start=inner;start<inner+prodinnerscan;start+=blocksize*prodinner) {\
	base=*scanin;\
	scanin++;\
	for (i=start;i<start+blocksize*prodinner;i+=prodinner) {\
	  outarray[i]=op(base,outarray[i]);\
	}\
      }\
    }\
  }\
  return 0;\
}

#define MAKE_LOCAL_UP_SCAN_MASK(datatype,op,id)  \
int local_##op##_scan_##datatype##_up_mask(datatype  *inarray, \
				  datatype  *outarray, \
                                  LOGICAL   *mask,\
				  datatype  *scanout, \
				  int       numdim, \
				  int       desc[][6], \
				  int       scandim) \
{\
  int outer, start, inner, i;\
  datatype base;\
\
  for (outer=0;outer<prodall;outer+=prodinnerscan) {\
    for (inner=outer;inner<outer+prodinner;inner++) {\
      for (start=inner;start<inner+prodinnerscan;start+=blocksize*prodinner) {\
	base=id;\
	for (i=start;i<start+blocksize*prodinner;i+=prodinner) {\
	  if (mask[i]==LOGICAL_TRUE) { \
   	     outarray[i]=op(inarray[i],base);\
	     base= op(base,inarray[i]);\
	  } else { \
             outarray[i]=base; \
	  }\
	}\
	*scanout=base;\
	scanout++;\
      }\
    }\
  }\
  return 0;\
} 

#define MAKE_LOCAL_UP_PRESCAN_MASK(datatype,op,id)  \
int local_##op##_prescan_##datatype##_up_mask(datatype  *inarray, \
				  datatype  *outarray, \
				  datatype  *scanout, \
                                  LOGICAL   *mask,\
				  int       numdim, \
				  int       desc[][6], \
				  int       scandim) \
{\
  int outer, start, inner, i;\
  datatype base;\
\
  for (outer=0;outer<prodall;outer+=prodinnerscan) {\
    for (inner=outer;inner<outer+prodinner;inner++) {\
      for (start=inner;start<inner+prodinnerscan;start+=blocksize*prodinner) {\
	base=id;\
	for (i=start;i<start+blocksize*prodinner;i+=prodinner) {\
          outarray[i]=base;\
          if (mask[i]==LOGICAL_TRUE) { \
  	     base= op(base,inarray[i]);\
	  }\
	}\
	*scanout=base;\
	scanout++;\
      }\
    }\
  }\
  return 0;\
} 

#define MAKE_LOCAL_UP_SCAN_SEG(datatype,op,id)  \
int local_##op##_scan_##datatype##_up_seg(datatype  *inarray, \
					  datatype  *outarray, \
                                          LOGICAL   *segment, \
					  datatype  *scanout, \
					  LOGICAL   *lrout, \
					  int       numdim, \
					  int       desc[][6], \
					  int       scandim) \
{\
  int outer, start, inner, i;\
  datatype base;\
  LOGICAL sbase;\
  LOGICAL mid;\
\
  for (outer=0;outer<prodall;outer+=prodinnerscan) {\
    for (inner=outer;inner<outer+prodinner;inner++) {\
      for (start=inner;start<inner+prodinnerscan;start+=blocksize*prodinner) {\
        sbase=segment[start];\
	base=id;\
        *lrout=sbase;\
        lrout++;\
        mid=LOGICAL_FALSE;\
	for (i=start;i<start+blocksize*prodinner;i+=prodinner) {\
          if (sbase!=segment[i]) {\
             base=id;\
             sbase=segment[i];\
             outarray[i]=base;\
             mid=LOGICAL_TRUE;\
	  } \
          base=op(base,inarray[i]);\
          outarray[i]=base;\
	}\
	*scanout=base;\
	scanout++;\
        *lrout=mid;\
        lrout++;\
        *lrout=sbase;\
        lrout++;\
      }\
    }\
  }\
  return 0;\
} 

#define MAKE_LOCAL_UP_PRESCAN_SEG(datatype,op,id)  \
int local_##op##_prescan_##datatype##_up_seg(datatype  *inarray, \
					  datatype  *outarray, \
                                          LOGICAL   *segment, \
					  datatype  *scanout, \
					  LOGICAL   *lrout, \
					  int       numdim, \
					  int       desc[][6], \
					  int       scandim) \
{\
  int outer, start, inner, i;\
  datatype base;\
  LOGICAL sbase,mid; \
\
  for (outer=0;outer<prodall;outer+=prodinnerscan) {\
    for (inner=outer;inner<outer+prodinner;inner++) {\
      for (start=inner;start<inner+prodinnerscan;start+=blocksize*prodinner) {\
        sbase=segment[start];\
	base=id;\
        *lrout=sbase;\
        lrout++;\
        mid=LOGICAL_FALSE;\
	for (i=start;i<start+blocksize*prodinner;i+=prodinner) {\
          if (sbase!=segment[i]) {\
             base=id;\
             sbase=segment[i];\
             outarray[i]=base;\
             mid=LOGICAL_TRUE;\
	  } \
          outarray[i]=base;\
          base=op(base,inarray[i]);\
	}\
	*scanout=base;\
	scanout++;\
        *lrout=mid;\
        lrout++;\
        *lrout=sbase;\
        lrout++;\
      }\
    }\
  }\
  return 0;\
} 

#define MAKE_LOCAL_UP_SCAN_SEG_MASK(datatype,op,id)  \
int local_##op##_scan_##datatype##_up_seg_mask(datatype  *inarray, \
					  datatype  *outarray, \
                                          LOGICAL   *segment,\
                                          LOGICAL   *mask,  \
					  datatype  *scanout, \
					  LOGICAL   *lrout, \
					  int       numdim, \
					  int       desc[][6], \
					  int       scandim) \
{\
  int outer, start, inner, i;\
  datatype base;\
  LOGICAL sbase,mid; \
\
  for (outer=0;outer<prodall;outer+=prodinnerscan) {\
    for (inner=outer;inner<outer+prodinner;inner++) {\
      for (start=inner;start<inner+prodinnerscan;start+=blocksize*prodinner) {\
        sbase=segment[start];\
	base=id;\
        *lrout=sbase;\
        lrout++;\
        mid=LOGICAL_FALSE;\
	for (i=start;i<start+blocksize*prodinner;i+=prodinner) {\
          if (sbase!=segment[i]) {\
             base=id;\
             sbase=segment[i];\
             outarray[i]=base;\
             mid=LOGICAL_TRUE;\
	  } \
          if (mask[i]==LOGICAL_TRUE) {\
             base=op(base,inarray[i]);\
	  }\
          outarray[i]=base;\
	}\
	*scanout=base;\
	scanout++;\
        *lrout=mid;\
        lrout++;\
        *lrout=sbase;\
        lrout++;\
      }\
    }\
  }\
  return 0;\
} 


#define MAKE_LOCAL_UP_PRESCAN_SEG_MASK(datatype,op,id)  \
int local_##op##_prescan_##datatype##_up_seg_mask(datatype  *inarray, \
						  datatype  *outarray, \
						  LOGICAL   *segment,\
						  LOGICAL   *mask,  \
						  datatype  *scanout, \
						  LOGICAL   *lrout, \
						  int       numdim, \
						  int       desc[][6], \
						  int       scandim) \
{\
  int outer, start, inner, i;\
  datatype base;\
  LOGICAL sbase, mid; \
\
  for (outer=0;outer<prodall;outer+=prodinnerscan) {\
    for (inner=outer;inner<outer+prodinner;inner++) {\
      for (start=inner;start<inner+prodinnerscan;start+=blocksize*prodinner) {\
        sbase=segment[start];\
	base=id;\
        *lrout=sbase;\
        lrout++;\
        mid=LOGICAL_FALSE;\
	for (i=start;i<start+blocksize*prodinner;i+=prodinner) {\
          if (sbase!=segment[i]) {\
             base=id;\
             sbase=segment[i];\
             outarray[i]=base;\
             mid=LOGICAL_TRUE;\
	  } \
          outarray[i]=base;\
          if (mask[i]==LOGICAL_TRUE) {\
             base=op(base,inarray[i]);\
	  }\
	}\
	*scanout=base;\
	scanout++;\
        *lrout=mid;\
        lrout++;\
        *lrout=sbase;\
        lrout++;\
      }\
    }\
  }\
  return 0;\
} 

#define MAKE_LOCAL_DOWN_SCAN_SEG(datatype,op,id) \
int local_##op##_scan_##datatype##_down_seg(datatype *outarray,\
					    datatype *scanin,\
                                            LOGICAL  *seg,\
					    int      numdim,\
					    int      desc[][6],\
					    int      scandim)\
{\
  int outer, start, inner, i;\
  datatype base;\
  LOGICAL segbase;\
\
  for (outer=0;outer<prodall;outer+=prodinnerscan) {\
    for (inner=outer;inner<outer+prodinner;inner++) {\
      for (start=inner;start<inner+prodinnerscan;start+=blocksize*prodinner) {\
	base=*scanin;\
	scanin++;\
        segbase=seg[start];\
	for (i=start;(i<start+blocksize*prodinner)\
	     && (seg[i]==segbase) ;i+=prodinner) {\
	  outarray[i]=op(base,outarray[i]);\
	}\
      }\
    }\
  }\
  return 0;\
}




#define MAKE_LOCAL_FAMILY(datatype,op,id)\
 MAKE_LOCAL_UP_SCAN(datatype,op,id) \
 MAKE_LOCAL_UP_SCAN_MASK(datatype,op,id)\
 MAKE_LOCAL_UP_SCAN_SEG(datatype,op,id)\
 MAKE_LOCAL_UP_SCAN_SEG_MASK(datatype,op,id)\
 MAKE_LOCAL_UP_PRESCAN(datatype,op,id)\
 MAKE_LOCAL_UP_PRESCAN_MASK(datatype,op,id)\
 MAKE_LOCAL_UP_PRESCAN_SEG(datatype,op,id)\
 MAKE_LOCAL_UP_PRESCAN_SEG_MASK(datatype,op,id)\
 MAKE_LOCAL_DOWN_SCAN(datatype,op,id)\
 MAKE_LOCAL_DOWN_SCAN_SEG(datatype,op,id)






