#include <stdio.h>
#include <nx.h>
#include "scaninterface.h"

#define MAXELTS (64536)


float inarray[MAXELTS];
float outarray[MAXELTS];
LOGICAL segarray[MAXELTS];
LOGICAL maskarray[MAXELTS];

void getdesc(int desc[][6]);

int localdimsize[20];
int localmpysize[20];

void init(float *array,float val,int num)
{
  int i;

  for (i=0;i<num;i++)
    array[i]=val;
}


void print_local1D(float *array, int xsize)
{
  int i;

  puts("");
  for (i=0;i<xsize;i++)
    printf("%3.0f ",array[i]);
  puts("");
}

void print_local2D(float *array, int xsize, int ysize)
{
  int i,j;

  puts("");
  for (i=0;i<ysize;i++) {
    for (j=0;j<xsize;j++) {
      printf("%3.0f ",array[i*xsize+j]);
    }
    puts("");
  }
}

void print_local_recurse(float *array, int dim)
{
  int i;

  if (dim==0) {
    print_local1D(array,localdimsize[0]);
  } else {
    if (dim==1) {
      print_local2D(array,localdimsize[0],localdimsize[1]);
    } else {
      for (i=0;i<localdimsize[dim];i++) {
	printf("%d ",i);
	print_local_recurse(array+localmpysize[dim-1]*i,dim-1);
      }
    }
  }
}
			    

void print_local(float *array, int desc[][6], int numdim)
{

  int i;

  localdimsize[0]=local_size(0,desc);
  localmpysize[0]=localdimsize[0];
  for (i=1;i<numdim;i++) {
    localdimsize[i]=local_size(i,desc);
    localmpysize[i]=localmpysize[i-1]*localdimsize[i];
  }

  print_local_recurse(array,numdim-1);
}

	
    
int numdims=0;

int lookup[64];

main()
{
  int i,j;
  int proc=mynode();
  int scandim;
  int desc[20][6];
  int foo;
  LOGICAL temp;

  for (i=0;i<64;i++)
    lookup[i]=i;

  numdims=2;
  
  for (i=0;i<numdims;i++) {
    desc[i][TSIZE]=32;
    desc[i][TBS]=8;
    desc[i][TSTRIDE]=32;
    desc[i][TNUMPROC]=4;
  }


  for (scandim=0;scandim<numdims;scandim++) {
    init((float *)inarray,1.0,MAXELTS);
    init((float *)outarray,0.0,MAXELTS);
/*
    for(i=0;i<MAXELTS;i+=2) {
      maskarray[i]=LOGICAL_TRUE;
    }
    for(i=1;i<MAXELTS;i+=2) {
      maskarray[i]=LOGICAL_FALSE;
    }
*/
    temp=LOGICAL_FALSE;
    for(i=0;i<MAXELTS;i+=10) {
      for(j=i;j<i+10;j++) {
	segarray[j]=temp;
      }
      temp=(temp==LOGICAL_FALSE)? LOGICAL_TRUE : LOGICAL_FALSE;
    }

    gsync();
    
    
    plus_scan_float((float*)inarray,(float*)outarray,
		    numdims,desc,proc,scandim);
    
    if (proc==0) {
      printf("Processor 0:\n");
      print_local(outarray,desc,numdims);
      csend(9999,&foo,4,proc+1,myptype());
    } else {
      if (proc<(numnodes()-1)) {
	crecvx(9999,&foo,4,proc-1,myptype(),msginfo);
	printf("Processor %d:\n",proc);
	print_local(outarray,desc,numdims);
	csend(9999,&foo,4,proc+1,myptype());
      } else {
	crecvx(9999,&foo,4,proc-1,myptype(),msginfo);
	printf("Processor %d:\n",proc);
	print_local(outarray,desc,numdims);
      }
    }
  }

    gsync();

     
}


void getdesc(int desc[][6])
{
  int i, size, bs, stride, nump;

  for (i=0;i<numdims;i++) {
    printf("Dimension %d\n",i);
    printf("         size?");
    scanf("%d",&size);
    printf("   block size?");
    scanf("%d",&bs);
    printf("     numprocs?");
    scanf("%d",&nump);

    desc[i][TSIZE]=size;
    desc[i][TBS]=bs;
    desc[i][TFIRST] = -1; /* compute later */
    desc[i][TSTRIDE]=nump*bs;
    desc[i][TLAST] = -1; /* compute later */
    desc[i][TNUMPROC] = nump;
      
  }
}











