/* Now assumes alloca */

#define MAKE_SCAN(datatype,op,lsop)\
int op##_##lsop##_##datatype##(datatype *inarray,\
			    datatype *outarray,\
			    int      numdim,\
			    int      desc[][6],\
			    int      proc,\
			    int      scandim)\
{\
  int scanblocks, totalblocks;\
  datatype *scanout, *scanin;\
\
\
  preprocess_local_scan(desc,numdim,scandim,&scanblocks,&totalblocks);\
\
  if ((scanout=(datatype *)alloca(sizeof(datatype)*totalblocks))==NULL) {\
    exit(-1);\
  }\
  if ((scanin=(datatype *)alloca(sizeof(datatype)*totalblocks))==NULL) {\
    exit(-1);\
  }\
\
  local_##op##_##lsop##_##datatype##_up(inarray,outarray,scanout,\
			              numdim,desc,scandim);\
  \
  tree_##op##_scan_##datatype##(desc,numdim,proc,scanout,scanin,\
                             scanblocks,totalblocks,scandim);\
\
  local_##op##_scan_##datatype##_down(outarray,scanin,numdim,desc,scandim);\
\
\
} \
void fx_##op##_##lsop##_##datatype##_(datatype *inarray,\
				    datatype *outarray,\
				    int      *numdim,\
				    int      desc[][6],\
				    int      *proc,\
				    int      *scandim)\
{ op##_##lsop##_##datatype##(inarray,outarray,*numdim,desc,*proc,*scandim);} \



#define MAKE_SCAN_SEG(datatype,op,lsop)\
int op##_##lsop##_##datatype##_seg(datatype *inarray,\
			       datatype *outarray,\
			       LOGICAL *seg,\
			       int   numdim,\
			       int   desc[][6],\
			       int   proc,\
			       int   scandim)\
{\
  int scanblocks, totalblocks;\
  datatype *scanout, *scanin;\
  LOGICAL *lrout;\
\
\
  preprocess_local_scan(desc,numdim,scandim,&scanblocks,&totalblocks);\
\
  if ((scanout=(datatype *)alloca(sizeof(datatype)*totalblocks))==NULL) {\
    exit(-1);\
  }\
  if ((scanin=(datatype *)alloca(sizeof(datatype)*totalblocks))==NULL) {\
    exit(-1);\
  }\
  if ((lrout=(LOGICAL*)alloca(3*sizeof(LOGICAL)*totalblocks))==NULL) {\
    exit(-1);\
  }\
\
  local_##op##_##lsop##_##datatype##_up_seg(inarray,outarray,seg,scanout,\
                        lrout,numdim,desc,scandim);\
\
  tree_##op##_scan_##datatype##_seg(desc,numdim,proc,scanout,scanin,lrout,\
			   scanblocks,totalblocks,scandim);\
\
  local_##op##_scan_##datatype##_down_seg(outarray,scanin,seg,numdim,\
                                            desc,scandim);\
\
} \
void fx_##op##_##lsop##_##datatype##_seg_(datatype *inarray,\
					datatype *outarray,\
					LOGICAL *seg,\
					int   *numdim,\
					int   desc[][6],\
					int   *proc,\
					int   *scandim)\
{ op##_##lsop##_##datatype##_seg(inarray,outarray,seg,*numdim,desc,*proc,\
				 *scandim); }



#define MAKE_SCAN_MASK(datatype,op,lsop)\
int op##_##lsop##_##datatype##_mask(datatype *inarray,\
				datatype *outarray,\
				LOGICAL *mask,\
				int   numdim,\
				int   desc[][6],\
				int   proc,\
				int   scandim)\
{\
  int totalblocks, scanblocks;\
  datatype *scanout, *scanin;\
\
\
  preprocess_local_scan(desc,numdim,scandim,&scanblocks,&totalblocks);\
\
  if ((scanout=(datatype *)alloca(sizeof(datatype)*totalblocks))==NULL) {\
    exit(-1);\
  }\
  if ((scanin=(datatype *)alloca(sizeof(datatype)*totalblocks))==NULL) {\
    exit(-1);\
  }\
\
  local_##op##_##lsop##_##datatype##_up_mask(inarray,outarray,mask,scanout,\
			numdim,desc,scandim);\
  \
  tree_##op##_scan_##datatype##(desc,numdim,proc,scanout,scanin,\
                                  scanblocks,totalblocks,scandim);\
\
  local_##op##_scan_##datatype##_down(outarray,scanin,numdim,\
                                  desc,scandim);\
\
\
} \
void fx_##op##_##lsop##_##datatype##_mask_(datatype *inarray,\
					 datatype *outarray,\
					 LOGICAL *mask,\
					 int   *numdim,\
					 int   *desc[][6],\
					 int   *proc,\
					 int   *scandim)\
{ op##_##lsop##_##datatype##_mask(inarray,outarray,mask,*numdim,desc,*proc,\
				  *scandim);}


#define MAKE_SCAN_SEG_MASK(datatype,op,lsop)\
int op##_##lsop##_##datatype##_seg_mask(datatype *inarray,\
					datatype *outarray,\
					LOGICAL *seg,\
                                        LOGICAL *mask,\
					int   numdim,\
					int   desc[][6],\
					int   proc,\
					int   scandim)\
{\
  int totalblocks, scanblocks;\
  datatype *scanout, *scanin;\
  LOGICAL *lrout;\
\
\
  preprocess_local_scan(desc,numdim,scandim,&scanblocks,&totalblocks);\
\
  if ((scanout=(datatype *)alloca(sizeof(datatype)*totalblocks))==NULL) {\
    exit(-1);\
  }\
  if ((scanin=(datatype *)alloca(sizeof(datatype)*totalblocks))==NULL) {\
    exit(-1);\
  }\
  if ((lrout=(LOGICAL*)alloca(2*sizeof(LOGICAL)*totalblocks))==NULL) {\
    exit(-1);\
  }\
\
  local_##op##_##lsop##_##datatype##_up_seg_mask(inarray,outarray,seg,mask,\
                        scanout,lrout,numdim,desc,scandim);\
\
  tree_##op##_scan_##datatype##_seg(desc,numdim,proc,scanout,scanin,lrout,\
			   scanblocks,totalblocks,scandim);\
\
  local_##op##_scan_##datatype##_down_seg(outarray,scanin,seg,numdim,\
                                            desc,scandim);\
\
} \
void fx_##op##_##lsop##_##datatype##_seg_mask_(datatype *inarray,\
					     datatype *outarray,\
					     LOGICAL *seg,\
					     LOGICAL *mask,\
					     int   *numdim,\
					     int   desc[][6],\
					     int   *proc,\
					     int   *scandim)\
{ op##_##lsop##_##datatype##_seg_mask(inarray,outarray,seg,mask,*numdim,\
				      desc,*proc,scandim); }


#define MAKE_GLUE(datatype,op,id)\
  MAKE_SCAN(datatype,op,scan)\
  MAKE_SCAN_MASK(datatype,op,scan)\
  MAKE_SCAN_SEG(datatype,op,scan)\
  MAKE_SCAN_SEG_MASK(datatype,op,scan)\
  MAKE_SCAN(datatype,op,prescan)\
  MAKE_SCAN_MASK(datatype,op,prescan)\
  MAKE_SCAN_SEG(datatype,op,prescan)\
  MAKE_SCAN_SEG_MASK(datatype,op,prescan)  

 
