#include <stdio.h>
#include <limits.h>

/* All the scan macros */
#include "scan.h"

/* Define our operators - could also use functions */
#define plus(x,y) ((x)+(y))
#define mult(x,y) ((x)*(y))
#define max(x,y) ((x)>(y) ? (x) : y)
#define min(x,y) ((x)>(y) ? (y) : x) 
#define and(x,y) ((x)&(y))
#define or(x,y) ((x)|(y))
#define parity(x,y) (((x)&(~(y)))|((~(x))&(y)))
#define count(x,y) ((x+((y)==LOGICAL_TRUE)))
#define iand(x,y) ((x)&(y))
#define ior(x,y) ((x)|(y))
#define iparity(x,y) (((x)&(~(y)))|((~(x))&(y)))

/*
   Define send and receive primitives - the following is to interface
   with the Fx RTL on the Paragon (NX)
*/
#include <nx.h>
extern int lookup[];
#define SCANMSG 1000
#define PHYSICALIZE(p) (lookup[(p)])
#define SEND(p,b,s)  { \
/*  printf("%d:Send %d bytes to proc %d(%d)..",proc,(s),(p),(lookup[(p)]));*/\
  csend(SCANMSG,(b),(s),(lookup[(p)]),myptype()); \
/*  puts("done");*/ \
}
#define RECV(p,b,s)  { \
/* printf("%d:Recv %d bytes fm proc %d(%d)..",proc,(s),(p),lookup[(p)]);*/ \
crecvx(SCANMSG,(b),(s),(lookup[(p)]),myptype(),msginfo); \
/* puts("done"); */\
}


/* Now build the necessary functions */

/* Numeric functions, ignoring COMPLEX and DOUBLE PRECISION COMPLEX for now*/
MAKE_SCAN_FAMILY(float,plus,0.0)
MAKE_SCAN_FAMILY(float,mult,1.0)
MAKE_SCAN_FAMILY(float,max,-FLT_MAX)
MAKE_SCAN_FAMILY(float,min,+FLT_MAX)
MAKE_SCAN_FAMILY(double,plus,0.0)
MAKE_SCAN_FAMILY(double,mult,1.0)
MAKE_SCAN_FAMILY(double,max,-DBL_MAX)
MAKE_SCAN_FAMILY(double,min,+DBL_MAX)
MAKE_SCAN_FAMILY(int,plus,0)
MAKE_SCAN_FAMILY(int,mult,1)
MAKE_SCAN_FAMILY(int,max,INT_MIN)
MAKE_SCAN_FAMILY(int,min,INT_MAX)

/* Logical functions */
MAKE_SCAN_FAMILY(LOGICAL,and,LOGICAL_TRUE)
MAKE_SCAN_FAMILY(LOGICAL,or,LOGICAL_FALSE)
MAKE_SCAN_FAMILY(LOGICAL,parity,LOGICAL_FALSE)
/* To make count work, we rely on the fact that LOGICAL is an int, so
   it does double duty - the first argument to count is the incoming count,
   the second is the current logical value 
*/
MAKE_SCAN_FAMILY(int,count,0)

/* Bitmap int functions */
MAKE_SCAN_FAMILY(int,iand,INT_MIN) /* Assume 2's complement here */
MAKE_SCAN_FAMILY(int,ior,0x0)
MAKE_SCAN_FAMILY(int,iparity,0x0)


