#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include "defs.h"
#include "stack.h"

#define BIG (1024*1024)

char *stack=NULL;
char *curframe=NULL;
char *curptr=NULL;
unsigned long cursize;

#ifdef ALLOCA
#else
INLINE int init_stack(int desc[][6]) 
{
/* Just punt on size estimation for now */
  if (stack==NULL) {
    if ((stack=malloc(BIG))==NULL) {
      return -1;
    }
  }
  curframe=curptr=stack;
  cursize=BIG;
  
  return 0;
}
#endif

#ifdef ALLOCA
INLINE void test_stack(int numbytes)
{
  if ( cursize - (unsigned long)(curptr-stack) < numbytes) {
    puts("Tree Stack Exhausted.");
    exit(-1);
  }
}
#else
INLINE void realloc_stack(int numbytes)
{
  char *newstack;

  if ( cursize - (unsigned long)(curptr-stack) < numbytes) {
    if ((newstack=realloc(stack,2*cursize))==NULL) {
      exit(-1);
    } else {
      curframe=newstack+(curframe-stack);
      curptr=newstack+(curptr-stack);
      cursize*=2;
      stack=newstack;
    }
  }
}
#endif      

INLINE int push_stack_newlist() 
{
#ifdef ALLOCA
  test_stack(sizeof(char*));
#else
  realloc_stack(sizeof(char*));
#endif
  memcpy((void *)curptr,(void *)&curframe,sizeof(char *));
  curptr+=sizeof(char *);
  curframe=curptr;
}

INLINE int pop_stack_list()
{
  if (curframe!=stack) {
    memcpy((void *)&curframe,(void*)(curframe-sizeof(char*)),sizeof(char*));
    curptr=curframe;
    return 0;
  } else {
    puts("Warning: pop empty stack");
    return -1;
  }
}

INLINE int add_stack_list(void *datum, int size, int num) 
{
#ifdef ALLOCA
  test_stack(size*num);
#else
  realloc_stack(size*num);
#endif
  memcpy(curptr,datum,size*num);
  curptr+=size*num;
}


INLINE int get_stack_list(void *datum, int size,int num) 
{
  memcpy(datum,curptr,size*num);
  curptr+=size*num;
}

#ifdef ALLOCA
#else
INLINE int deinit_stack()
{
  free(stack);
  curptr=curframe=NULL;
}
#endif
