#include <stdio.h>
#include <sys/time.h>
#include <sys/resource.h>
#include "defs.h"

#define NODEBUG


int ceil_log(int p)
{
  int temp,i;
  
  temp=p;
  
  for (i=0;i<sizeof(int)*8 && temp!=1;i++) {
    temp>>=1;
  }
  
  return i+( p-((p>>i)<<i) > 0 ? 1 : 0) ;
}


#define CEIL_POS(X,Y) (((X)/(Y)) + ((X)%(Y)!=0))


int local_size(int dim, int desc[][6]) 
{
#if 1
  return desc[dim][TBS]*(desc[dim][TSIZE]/desc[dim][TSTRIDE] +
		((desc[dim][TSIZE] % desc[dim][TSTRIDE]) != 0));
#else
  return CEIL_POS(desc[i][TSIZE],desc[i][TBS]*desc[i][TNUMPROC])*
                       desc[i][TBS];
#endif
}


int blocksize,prodinner,prodinnerscan,prodall;

int preprocess_local_scan(int desc[][6],int numdim, int scandim,
			  int *scanblocks, int *totalblocks)
{
  int i;
  struct rlimit rl;

  getrlimit(RLIMIT_STACK,&rl);
  rl.rlim_cur=rl.rlim_max;
  setrlimit(RLIMIT_STACK,&rl);
  
  blocksize=desc[scandim][TBS];

  *scanblocks=desc[scandim][TSIZE]/desc[scandim][TSTRIDE];
  
  prodinner=1;
  for (i=0;i<scandim;i++) {
    prodinner*=local_size(i,desc);
  }

  prodinnerscan=prodinner*local_size(scandim,desc);
  prodall=prodinnerscan;
  for (i=scandim+1;i<numdim;i++) {
    prodall*=local_size(i,desc);
  }
  
  *totalblocks=prodall/blocksize;
}
