#define SIZE     512
#define NUMPROCY 4

      program scantest

      real a(SIZE), b(SIZE)
      logical segment(SIZE)

      integer i,j, errs

      template t(SIZE)
      align a(i),b(i),segment(i) with t(i)
      distribute t(CYCLIC(NUMPROCY))

      a=1.0


      call fx_true_barrier()

      print *,"Basic scan"
      b=sum_prefix(a,0,.TRUE.,.TRUE.,.FALSE.)

      pdo i=1,SIZE
      pin (b(i))
      pmvars errs
      pinit
        errs=0
      pbody
        if (b(i) .ne. i) then	
             print *,"b(",i,")=",b(i)
             errs=errs+1
        endif

      pmerge
        errs=left(errs)+right(errs)
      endpdo

      print *,"errs=",errs

      call fx_true_barrier()

      a=1.0
      segment(1:SIZE/4)=.TRUE.
      segment(SIZE/4+1:SIZE/2)=.FALSE.
      segment(SIZE/2+1:SIZE*3/4)=.TRUE.
      segment(SIZE*3/4+1:SIZE)=.FALSE.

      print *,"4-step segmented scan"
      b=sum_prefix(a,0,.TRUE.,segment,.FALSE.)

      pdo i=1,SIZE
      pin (b(i))
      pmvars errs
      pinit
        errs=0
      pbody
           if ( ((i .le. SIZE/4) .and. (b(i) .ne. i)) .or.
     &   ((i .gt. SIZE/4) .and. (i .le. SIZE/4) .and.
     &      (b(i) .ne. i-SIZE/4)) .or.
     &   ((i .gt. SIZE/2) .and. (i .le. SIZE*3/4) .and.
     &      (b(i) .ne. i-SIZE/2)) .or.
     &   ((i .gt. SIZE*3/4) .and. (b(i) .ne. i-SIZE*3/4)))
     &       then
             print *,"b(",i,")=",b(i)
             errs=errs+1
           endif

      pmerge
        errs=left(errs)+right(errs)
      endpdo

      print *,"errs=",errs

      call fx_true_barrier()

      a=1.0
      segment(1:SIZE:6)=.TRUE.
      segment(2:SIZE:6)=.TRUE.
      segment(3:SIZE:6)=.TRUE.
      segment(4:SIZE:6)=.FALSE.
      segment(5:SIZE:6)=.FALSE.
      segment(6:SIZE:6)=.FALSE.

      print *,"3-block segmented segmented scan"
      b=sum_prefix(a,0,.TRUE.,segment,.FALSE.)

      segment=.FALSE.

      segment(1:SIZE:6)=(b(1:SIZE:6) .eq. 1)
      segment(2:SIZE:6)=(b(2:SIZE:6) .eq. 2)
      segment(3:SIZE:6)=(b(3:SIZE:6) .eq. 3)
      segment(4:SIZE:6)=(b(4:SIZE:6) .eq. 1)
      segment(5:SIZE:6)=(b(5:SIZE:6) .eq. 2)
      segment(6:SIZE:6)=(b(6:SIZE:6) .eq. 3)

      pdo i=1,SIZE
      pin segment(i),b(i)
      pmvars errs
      pinit
        errs=0
      pbody
           if (segment(i) .ne. .TRUE.) then
             print *,"b(",i,")=",b(i)
             errs=errs+1
           endif

      pmerge
        errs=left(errs)+right(errs)
      endpdo

      print *,"errs=",errs

      end

