#define SIZE     128
#define NUMPROCZ 4
#define NUMPROCY 4
#define NUMPROCX 4


      program scantest
     
      real a(SIZE,SIZE,SIZE), b(SIZE,SIZE,SIZE)
      logical mask(SIZE,SIZE,SIZE), segment(SIZE,SIZE,SIZE)

      integer i,j,k, errs
      external timer_start, timer_stop
      real timer_stop, totaltime

      template t(SIZE,SIZE,SIZE)
      align a(i,j,k),b(i,j,k),mask(i,j,k),segment(i,j,k)
     &      with t(i,j,k)
      distribute t(BLOCK(NUMPROCX),CYCLIC(NUMPROCY),
     &                BLOCK_CYCLIC(8,NUMPROCZ))



C First, try basic scan along all dimensions - dim 0
      a=1.0

      print *,"Basic Scan - dimension 0"
      b=sum_prefix(a,0,.TRUE.,.TRUE.,.FALSE.)

      pdo (i=1:SIZE, j=1:SIZE, k=1:SIZE)
      pin (b(i,j,k))
      pmvars errs
      pinit
        errs=0
      pbody
           if (b(i,j,k) .ne. i) then
             print *,"b(",i,",",j,",",k,")=",b(i,j,k)
             errs=errs+1
           endif
      pmerge
        errs=left(errs)+right(errs)
      endpdo

      if (errs .eq. 0) then
         print *,"Success"
      endif

C Dimension 1
      a=1.0

      print *,"Basic Scan - dimension 1"
      b=sum_prefix(a,1,.TRUE.,.TRUE.,.FALSE.)

      pdo (i=1:SIZE, j=1:SIZE, k=1:SIZE)
      pin (b(i,j,k))
      pmvars errs
      pinit
        errs=0
      pbody
           if (b(i,j,k) .ne. j) then
             print *,"b(",i,",",j,",",k,")=",b(i,j,k)
             errs=errs+1
           endif
      pmerge
        errs=left(errs)+right(errs)
      endpdo

      if (errs .eq. 0) then
         print *,"Success"
      endif


C Dimension 2
      a=1.0

      print *,"Basic Scan - dimension 2"
      b=sum_prefix(a,2,.TRUE.,.TRUE.,.FALSE.)

      pdo (i=1:SIZE, j=1:SIZE, k=1:SIZE)
      pin b(i,j,k)
      pmvars errs
      pinit
        errs=0
      pbody
           if (b(i,j,k) .ne. k) then
             print *,"b(",i,",",j,",",k,")=",b(i,j,k)
             errs=errs+1
           endif
      pmerge
        errs=left(errs)+right(errs)
      endpdo

      if (errs .eq. 0) then
         print *,"Success"
      endif

C See if prescan is working
      a=1.0

      print *,"Basic Prescan - dimension 1"
      b=sum_prefix(a,1,.TRUE.,.TRUE.,.TRUE.)

      pdo (i=1:SIZE, j=1:SIZE, k=1:SIZE)
      pin b(i,j,k)
      pmvars errs
      pinit
        errs=0
      pbody
           if (b(i,j,k) .ne. j-1) then
             print *,"b(",i,",",j,",",k,")=",b(i,j,k)
             errs=errs+1
           endif
      pmerge
        errs=left(errs)+right(errs)
      endpdo

      if (errs .eq. 0) then
         print *,"Success"
      endif

C Now try scanning dimension 1 with a mask

      a=1.0
      mask(:,1:SIZE:2,:)=.TRUE.
      mask(:,2:SIZE:2,:)=.FALSE.

      print *, "Scan with mask - dimension 1"
      b=sum_prefix(a,1,mask,.TRUE.,.FALSE.)

      pdo (i=1:SIZE, j=1:SIZE, k=1:SIZE)
      pin b(i,j,k), mask(i,j,k)
      pmvars errs
      pinit
           errs=0
      pbody
           if ((mask(i,j,k) .and. (b(i,j,k) .ne. (j+1)/2)) .or.
     &         ((.not. mask(i,j,k)) .and. 
     &              (b(i,j,k) .ne. j/2))) then
             print *,"b(",i,",",j,",",k,")=",b(i,j,k)
             errs=errs+1
           endif
      pmerge
        errs=left(errs)+right(errs)
      endpdo


      if (errs .eq. 0) then
         print *,"Success"
      endif

C Now scan dimension 0 with segment

      a=1.0
      segment(1:SIZE/4,:,:)=.TRUE.
      segment(SIZE/4+1:SIZE/2,:,:)=.FALSE.
      segment(SIZE/2+1:SIZE*3/4,:,:)=.TRUE.
      segment(SIZE*3/4+1:SIZE,:,:)=.FALSE.


      print *, "Scan with segment - dimension 0"
      b=sum_prefix(a,0,.TRUE.,segment,.FALSE.)

      pdo (i=1:SIZE, j=1:SIZE, k=1:SIZE)
      pin b(i,j,k)
      pmvars errs
      pinit
        errs=0
      pbody
           if ( ((i .le. SIZE/4) .and. (b(i,j,k) .ne. i)) .or.
     &   ((i .gt. SIZE/4) .and. (i .le. SIZE/4) .and.
     &      (b(i,j,k) .ne. i-SIZE/4)) .or.
     &   ((i .gt. SIZE/2) .and. (i .le. SIZE*3/4) .and.
     &      (b(i,j,k) .ne. i-SIZE/2)) .or.
     &   ((i .gt. SIZE*3/4) .and. (b(i,j,k) .ne. i-SIZE*3/4)))
     &       then
             if (errs .lt. 5) then
                print *,"b(",i,",",j,",",k,")=",b(i,j,k)
             endif
             errs=errs+1
           endif
      pmerge
        errs=left(errs)+right(errs)
      endpdo


      if (errs .eq. 0) then
         print *,"Success"
      endif

C Now scan dimension 1 with segment

      a=1.0
      segment(:,1:SIZE/4,:)=.TRUE.
      segment(:,SIZE/4+1:SIZE/2,:)=.FALSE.
      segment(:,SIZE/2+1:SIZE*3/4,:)=.TRUE.
      segment(:,SIZE*3/4+1:SIZE,:)=.FALSE.


      print *, "Scan with segment - dimension 1"
      b=sum_prefix(a,1,.TRUE.,segment,.FALSE.)

      pdo (i=1:SIZE, j=1:SIZE, k=1:SIZE)
      pin b(i,j,k)
      pmvars errs
      pinit
        errs=0
      pbody
           if ( ((j .le. SIZE/4) .and. (b(i,j,k) .ne. j)) .or.
     &   ((j .gt. SIZE/4) .and. (j .le. SIZE/4) .and.
     &      (b(i,j,k) .ne. j-SIZE/4)) .or.
     &   ((j .gt. SIZE/2) .and. (j .le. SIZE*3/4) .and.
     &      (b(i,j,k) .ne. j-SIZE/2)) .or.
     &   ((j .gt. SIZE*3/4) .and. (b(i,j,k) .ne. j-SIZE*3/4)))
     &       then
             if (errs .lt. 5) then
                print *,"b(",i,",",j,",",k,")=",b(i,j,k)
             endif
             errs=errs+1
           endif
      pmerge
        errs=left(errs)+right(errs)
      endpdo


      if (errs .eq. 0) then
         print *,"Success"
      endif

C Now scan dimension 2 with segment

      a=1.0
      segment(:,:,1:SIZE/4)=.TRUE.
      segment(:,:,SIZE/4+1:SIZE/2)=.FALSE.
      segment(:,:,SIZE/2+1:SIZE*3/4)=.TRUE.
      segment(:,:,SIZE*3/4+1:SIZE)=.FALSE.


      print *, "Scan with segment - dimension 2"
      b=sum_prefix(a,2,.TRUE.,segment,.FALSE.)

      pdo (i=1:SIZE, j=1:SIZE, k=1:SIZE)
      pin b(i,j,k)
      pmvars errs
      pinit
        errs=0
      pbody
           if ( ((k .le. SIZE/4) .and. (b(i,j,k) .ne. k)) .or.
     &   ((k .gt. SIZE/4) .and. (k .le. SIZE/4) .and.
     &      (b(i,j,k) .ne. k-SIZE/4)) .or.
     &   ((k .gt. SIZE/2) .and. (k .le. SIZE*3/4) .and.
     &      (b(i,j,k) .ne. k-SIZE/2)) .or.
     &   ((k .gt. SIZE*3/4) .and. (b(i,j,k) .ne. k-SIZE*3/4)))
     &       then
             if (errs .lt. 5) then
                print *,"b(",i,",",j,",",k,")=",b(i,j,k)
             endif
             errs=errs+1
           endif
      pmerge
        errs=left(errs)+right(errs)
      endpdo


      if (errs .eq. 0) then
         print *,"Success"
      endif


C Spiffy scan 3-block, dimension 0

      a=1.0
      segment(1:SIZE:6,:,:)=.TRUE.
      segment(2:SIZE:6,:,:)=.TRUE.
      segment(3:SIZE:6,:,:)=.TRUE.
      segment(4:SIZE:6,:,:)=.FALSE.
      segment(5:SIZE:6,:,:)=.FALSE.
      segment(6:SIZE:6,:,:)=.FALSE.

      print *,"3-block segmented scan, dimension 0"

      b=sum_prefix(a,0,.TRUE.,segment,.FALSE.)

      segment=.FALSE.

      segment(1:SIZE:6,:,:)=(b(1:SIZE:6,:,:) .eq. 1)
      segment(2:SIZE:6,:,:)=(b(2:SIZE:6,:,:) .eq. 2)
      segment(3:SIZE:6,:,:)=(b(3:SIZE:6,:,:) .eq. 3)
      segment(4:SIZE:6,:,:)=(b(4:SIZE:6,:,:) .eq. 1)
      segment(5:SIZE:6,:,:)=(b(5:SIZE:6,:,:) .eq. 2)
      segment(6:SIZE:6,:,:)=(b(6:SIZE:6,:,:) .eq. 3)

      pdo (i=1:SIZE, j=1:SIZE, k=1:SIZE)
      pin segment(i,j,k), b(i,j,k)
      pmvars errs
      pinit
        errs=0
      pbody
           if (.not. segment(i,j,k)) then
             print *,"b(",i,j,k,")=",b(i,j,k)
             errs=errs+1
           endif

      pmerge
        errs=left(errs)+right(errs)
      endpdo

      if (errs .eq. 0) then
         print *,"Success"
      endif

C Spiffy scan 3-block, dimension 1

      a=1.0
      segment(:,1:SIZE:6,:)=.TRUE.
      segment(:,2:SIZE:6,:)=.TRUE.
      segment(:,3:SIZE:6,:)=.TRUE.
      segment(:,4:SIZE:6,:)=.FALSE.
      segment(:,5:SIZE:6,:)=.FALSE.
      segment(:,6:SIZE:6,:)=.FALSE.

      print *,"3-block segmented scan, dimension 1"

      b=sum_prefix(a,1,.TRUE.,segment,.FALSE.)

      segment=.FALSE.

      segment(:,1:SIZE:6,:)=(b(:,1:SIZE:6,:) .eq. 1)
      segment(:,2:SIZE:6,:)=(b(:,2:SIZE:6,:) .eq. 2)
      segment(:,3:SIZE:6,:)=(b(:,3:SIZE:6,:) .eq. 3)
      segment(:,4:SIZE:6,:)=(b(:,4:SIZE:6,:) .eq. 1)
      segment(:,5:SIZE:6,:)=(b(:,5:SIZE:6,:) .eq. 2)
      segment(:,6:SIZE:6,:)=(b(:,6:SIZE:6,:) .eq. 3)

      pdo (i=1:SIZE, j=1:SIZE, k=1:SIZE)
      pin segment(i,j,k),b(i,j,k)
      pmvars errs
      pinit
        errs=0
      pbody
           if (.not. segment(i,j,k)) then
             print *,"b(",i,j,k,")=",b(i,j,k)
             errs=errs+1
           endif

      pmerge
        errs=left(errs)+right(errs)
      endpdo

      if (errs .eq. 0) then
         print *,"Success"
      endif

C Spiffy scan 3-block, dimension 2

      a=1.0
      segment(:,:,1:SIZE:6)=.TRUE.
      segment(:,:,2:SIZE:6)=.TRUE.
      segment(:,:,3:SIZE:6)=.TRUE.
      segment(:,:,4:SIZE:6)=.FALSE.
      segment(:,:,5:SIZE:6)=.FALSE.
      segment(:,:,6:SIZE:6)=.FALSE.

      print *,"3-block segmented scan, dimension 2"

      b=sum_prefix(a,2,.TRUE.,segment,.FALSE.)

      segment=.FALSE.

      segment(:,:,1:SIZE:6)=(b(:,:,1:SIZE:6) .eq. 1)
      segment(:,:,2:SIZE:6)=(b(:,:,2:SIZE:6) .eq. 2)
      segment(:,:,3:SIZE:6)=(b(:,:,3:SIZE:6) .eq. 3)
      segment(:,:,4:SIZE:6)=(b(:,:,4:SIZE:6) .eq. 1)
      segment(:,:,5:SIZE:6)=(b(:,:,5:SIZE:6) .eq. 2)
      segment(:,:,6:SIZE:6)=(b(:,:,6:SIZE:6) .eq. 3)

      pdo (i=1:SIZE, j=1:SIZE, k=1:SIZE)
      pin segment(i,j,k),b(i,j,k)
      pmvars errs
      pinit
        errs=0
      pbody
           if (.not. segment(i,j,k)) then
             print *,"b(",i,j,k,")=",b(i,j,k)
             errs=errs+1
           endif

      pmerge
        errs=left(errs)+right(errs)
      endpdo

      if (errs .eq. 0) then
         print *,"Success"
      endif




      

      end

