 IDENTIFICATION DIVISION. PROGRAM-ID.    UIF300. AUTHOR.        R. Poynter.* INSTALLATION.  FLEETWOOD ENTERPRISES, INC. DATE-WRITTEN.  8-MAR-84.  N ****************************************************************************** * E * PROGRAM FUNCTIONS:  User Interface Main Program.  This program will 7 *		      allow a user to run an application either from 8 *		      a menu or by entering a valid transaction name.: *		      The application may run either interactively as a6 *		      subprocess or be submitted as a batch job, by8 *		      design.  In some cases the user will be allowed9 *		      to select whether the application will be run as 9 *		      a batch job or interactively.  In addition, each < *		      user will have a menu tailored to his job function,7 *		      and will not have access to transactions which 1 *		      are not specifically authorized for him.  *  * PROGRAM OPTIONS:  None.  *  * PROGRAM MODIFICATIONS: *  *	AUTHOR   B. Wallis *	DATE     30-Oct-84 *	VERSION  1-B *  *	PROGRAM CHANGES:8 *		1)  Take the GIVING clause out of the call to UIF310.) *		2)  Take out all references to UTL580. ; *		3)  Bring it up to standards (e.g., fix paragraph names)  * N ******************************************************************************   ENVIRONMENT DIVISION.  CONFIGURATION SECTION. SOURCE-COMPUTER.  VAX-11.  OBJECT-COMPUTER.  VAX-11.  SPECIAL-NAMES. INPUT-OUTPUT SECTION. 
 FILE-CONTROL.  	SELECT UIF-MASTER-FILE  		ASSIGN TO "UIF_MASTER" 		ORGANIZATION IS INDEXED  		ACCESS MODE IS DYNAMIC# 		RECORD KEY IS MASTER-PRIMARY-KEY.  	SELECT UIF-USERNAME-FILE  		ASSIGN TO "UIF_USERNAME" 		ORGANIZATION IS INDEXED  		ACCESS MODE IS RANDOM  		RECORD KEY IS USER-USERNAME , 		ALTERNATE RECORD KEY IS USER-GENERIC-NAME. /  DATA DIVISION.
 FILE SECTION.    FD  UIF-MASTER-FILE.. 	COPY "CDD_UIF.MASTER_RECORD" FROM DICTIONARY.   FD  UIF-USERNAME-FILE.0 	COPY "CDD_UIF.USERNAME_RECORD" FROM DICTIONARY. /  WORKING-STORAGE SECTION.   01	PROG-ID				PIC X(09)	 	VALUE "UIF300-1B".   . 	COPY "CDD_UIF.SWITCH_RECORD" FROM DICTIONARY.   01	WS-MASTER_RECORD. 	05  WS-MASTER_PRIMARY_KEY. ) 	    10  WS-MASTER_RECORD_NAME		PIC X(9). & 	    10  WS-MASTER_RECORD_TYPE		PIC X.2 	05  WS-MASTER-RECORD-ACCESS-COUNT	PIC S9(4)	COMP. 	05  WS-MASTER_TRANSACTION. . 	    10  WS-MASTER_TRANSACTION_DESC	PIC X(60).& 	    10  FILLER          		PIC X(202).4 	05  WS-MASTER_MENU REDEFINES WS-MASTER_TRANSACTION.) 	    10  WS-MASTER_MENU_TITLE		PIC X(20). - 	    10	WS-MASTER_MENU_DESCRIPTION	PIC X(60). 1 	    10  WS-MASTER_MENU_NODE_CNT		PIC S9(4)	COMP. ( 	    10  WS-MASTER_MENU_NODE 		PIC X(9)	 		OCCURS 20 TIMES.   01	WS-USER-RECORD.+ 	05  WS-USERNAME				PIC X(12)	VALUE SPACES. 4 	05  WS-TOP-LEVEL-MENU-NAME		PIC X(09)	VALUE SPACES.  , 01	SUBROUTINE-RETURN-STATUS		PIC S9(9)	COMP.  * 01	IMAGE-NAME				PIC X(06)	VALUE "UIF300".   01	ERROR-TYPE				PIC X(1). 	88  FATAL-ERROR				VALUE "F". 	88  NO-ERROR				VALUE "S".  /  PROCEDURE DIVISION.   O *******************************************************************************  INITIALIZATION SECTION. O *******************************************************************************   	 000-INIT.  	OPEN INPUT UIF-MASTER-FILE. 	OPEN INPUT UIF-USERNAME-FILE. 	SET FIRST-TIME TO TRUE. 	SET NO-INVALID-KEY TO TRUE. 	SET NO-ERROR TO TRUE. 	INITIALIZE WS-MASTER-RECORD.   	CALL "UTL560" USING WS-USERNAME% 			  GIVING SUBROUTINE-RETURN-STATUS. ' 	IF SUBROUTINE-RETURN-STATUS IS SUCCESS 
 		GO TO MAIN.  	SET FATAL-ERROR TO TRUE. % 	DISPLAY IMAGE-NAME," - ",ERROR-TYPE, 7 		" ERROR GETTING USER NAME - CONTACT DP IMMEDIATELY.".  	GO TO CLOSING.  / O ******************************************************************************* 
 MAIN SECTION. O *******************************************************************************   
 100-START.  	PERFORM 200-READ-USER-FILE THRU 		200-READ-USER-FILE-EXIT. 	CLOSE UIF-USERNAME-FILE.  	IF INVALID-KEY  		SET FATAL-ERROR TO TRUE < 		DISPLAY "UIF300 - F - USER NOT IN USER FILE.  CONTACT DP." 		GO TO 900-CLOSE." 	PERFORM 300-READ-MASTER-FILE THRU 		300-READ-MASTER-FILE-EXIT. 	CLOSE UIF-MASTER-FILE.  	IF INVALID-KEY  		SET FATAL-ERROR TO TRUE ? 		DISPLAY "UIF300 - F - ERROR READING UIF-MASTER.  CONTACT DP."  		GO TO 900-CLOSE.  	 100-MAIN. > 	CALL "UIF310" USING WS-MASTER-RECORD, WS-USER-RECORD,EXIT-SW. 	IF DONE 		GO TO 900-CLOSE.( 	MOVE MASTER-RECORD TO WS-MASTER-RECORD. 	SET FIRST-TIME TO TRUE. 	GO TO 100-MAIN.   / O *******************************************************************************  SUBROUTINE SECTION. O *******************************************************************************    200-READ-USER-FILE. # 	MOVE WS-USERNAME TO USER-USERNAME.  	READ UIF-USERNAME-FILE RECORD& 		INVALID KEY SET INVALID-KEY TO TRUE. 	IF INVALID-KEY   		GO TO 200-READ-USER-FILE-EXIT.' 	MOVE USER-GENERIC-NAME TO WS-USERNAME. 9 	MOVE USER-TOP-LEVEL-MENU-NAME TO WS-TOP-LEVEL-MENU-NAME.  200-READ-USER-FILE-EXIT. 	EXIT.   300-READ-MASTER-FILE. 3 	MOVE WS-TOP-LEVEL-MENU-NAME TO MASTER-RECORD-NAME. 6 	START UIF-MASTER-FILE KEY IS NOT < MASTER-RECORD-NAME
 		INVALID KEY  			SET INVALID-KEY TO TRUE.  	IF INVALID-KEY " 		GO TO 300-READ-MASTER-FILE-EXIT.7 	READ UIF-MASTER-FILE NEXT RECORD INTO WS-MASTER-RECORD ) 		AT END GO TO 300-READ-MASTER-FILE-EXIT.  300-READ-MASTER-FILE-EXIT. 	EXIT. / O *******************************************************************************  CLOSING SECTION.O *******************************************************************************   
 900-CLOSE.) 	CALL "UTL550" USING PROG-ID, ERROR-TYPE.  	STOP RUN.	 