 IDENTIFICATION DIVISION. PROGRAM-ID.    UIF310. AUTHOR.        R. Poynter.* INSTALLATION.  FLEETWOOD ENTERPRISES, INC. DATE-WRITTEN.  15-MAR-84.   N ****************************************************************************** * J * PROGRAM FUNCTIONS:  User Interface Screen Handler.  This subprogram will? *		      display all user menus.  It will validate user choices = *		      of both menus and transactions and perform security  8 *		      checks on transactions. After validation of the< *		      user's input, it will either call itself to display@ *		      another menu, or it will call the Transaction Processor= *		      once it determines that a valid transaction has been A *		      entered.  It will also determine what to do about errors 1 *		      returned from the Transaction Processor.  *  * PROGRAM OPTIONS:  None.  *  * PROGRAM MODIFICATIONS: *  *	AUTHOR	T. MOORE  *	DATE	20-MAR-86
 *	VERSION	1-G  *  *	PROGRAM CHANGES:; *		Do not call SCPER with the SUBMITTED message, call SCPEN / *		instead (in order to save type-ahead buffer)  * N ****************************************************************************** /    ENVIRONMENT DIVISION.  CONFIGURATION SECTION. SOURCE-COMPUTER.  VAX-11.  OBJECT-COMPUTER.  VAX-11.  SPECIAL-NAMES. INPUT-OUTPUT SECTION. 
 FILE-CONTROL.  	SELECT UIF-MASTER-FILE  		ASSIGN TO DISK 		ORGANIZATION IS INDEXED  		ACCESS MODE IS DYNAMIC.  	SELECT UIF-SECURITY-FILE  		ASSIGN TO DISK 		ORGANIZATION IS INDEXED  		ACCESS MODE IS RANDOM. /    DATA DIVISION.
 FILE SECTION.  FD  UIF-MASTER-FILE * 	COPY "UIF-MASTER-FD" OF "LIB:UIFLIB.TLB".* 	COPY "MASTER-RECORD" OF "LIB:UIFLIB.TLB". /    FD  UIF-SECURITY-FILE , 	COPY "UIF-SECURITY-FD" OF "LIB:UIFLIB.TLB"., 	COPY "SECURITY-RECORD" OF "LIB:UIFLIB.TLB". /    WORKING-STORAGE SECTION.   01	PROG-ID					PIC X(09) 	VALUE "UIF310-1G".   0 	COPY "SCOPE-STATUS-RECORD" OF "LIB:SCPLIB.TLB". /   + 	COPY "FORM-UIF310SCR" OF "LIB:UIFLIB.TLB".  /   ) 01	CLEAR-SCREEN			COMP	PIC S9(9)	VALUE 1.   2 01	DO-NOT-CLEAR-SCREEN		COMP	PIC S9(9)	VALUE ZERO.   01	ERROR-MSG				PIC X(80).  * 01	SCOPE-ERROR-NO-DISPLAY			PIC -Z(9)9(1).  - 01	TRANSACTION-SCOPE-ERROR-NO	COMP	PIC S9(5).    01	HOLD-MENU-TRANS				PIC X(9).   + 01	SUBROUTINE-RETURN-STATUS	COMP	PIC S9(9). ' 	88  ERROR-UNDEFINED-SYMBOL				VALUE 2. , 	88  ERROR-UNDEFINED-SYMBOL-TYPE				VALUE 4.* 	88  ERROR-NO-TRANSACTION-FILE				VALUE 6.% 	88  ERROR-NO-SCOPE-FILE					VALUE 8. $ 	88  ERROR-SCOPE-ERROR					VALUE 10., 	88  ERROR-SCOPE-VALIDITY-CHECK				VALUE 12.# 	88  ERROR-NO-SYMBOLS					VALUE 14. & 	88  ERROR-NO-PROCESSING					VALUE 16.& 	88  ERROR-NO-SYMBOL-FILE				VALUE 18.* 	88  ERROR-IN-SPECIAL-PROCESS				VALUE 20. 	88  ERROR-MENU						VALUE 22.  , 01	SUBROUTINE-STATUS-DISPLAY		PIC -Z(9)9(1).   01	SWITCH-RECORD. ) 	05  INVALID-KEY-SW			PIC X(1)	VALUE "N". & 	    88  NO-INVALID-KEY					VALUE "N".# 	    88  INVALID-KEY					VALUE "Y". # 	05  EXIT-SW				PIC X(1)	VALUE "N".  	    88  DONE						VALUE "Y". & 	    88  TOP-LEVEL-MENU					VALUE "T"." 	    88  FIRST-TIME					VALUE "F".  	    88  NOT-DONE					VALUE "N".) 	05  TRANSACTION-SW			PIC X(1)	VALUE "N". # 	    88  TRANSACTION					VALUE "T".  	    88  USER						VALUE "U". ' 	    88  NOT-TRANSACTION					VALUE "M". + 	05  PREVIOUS-MENU-SW			PIC X(1)	VALUE "N". % 	    88  PREVIOUS-MENU					VALUE "Y". ( 	    88  NOT-PREVIOUS-MENU				VALUE "N".* 	05  CHOICE-VALID-SW			PIC X(1)	VALUE "N".$ 	    88  CHOICE-VALID					VALUE "Y".' 	    88  CHOICE-NOT-VALID				VALUE "N". & 	05  CAPTIVE-SW				PIC X(1)	VALUE "N".# 	    88  NOT-CAPTIVE					VALUE "N".   	    88  CAPTIVE						VALUE "Y".   01	MENU-CHOICE				PIC X(9). % 01	MENU-NUMBER REDEFINES MENU-CHOICE.  	05  MENU-NUMERIC			PIC 9(2).  	05  MENU-FILLER				PIC X(7). ( 01	MENU-ALTERNATE REDEFINES MENU-CHOICE.( 	05  MENU-CHAR OCCURS 9 TIMES		PIC X(1).   01	DIGIT					PIC S9(4) 	COMP.    01	COUNTER					PIC 9(02).   $ 01	CNT-CHARACTERS				PIC S9(9)	COMP.   * : *	This record MUST always look exactly like MASTER-RECORD. *  01	WS-MASTER-RECORD. 	05  WS-MASTER-PRIMARY-KEY. ) 	    10  WS-MASTER-RECORD-NAME		PIC X(9). & 	    10  WS-MASTER-RECORD-TYPE		PIC X." 	05  WS-MASTER-RECORD-ACCESS-COUNT 	    				COMP	PIC S9(4). 	05  WS-MASTER-TRANSACTION. . 	    10  WS-MASTER-TRANSACTION-DESC	PIC X(60).- 	    10  WS-MASTER-TRANSACTION-TYPE	PIC X(1). . 	    10  WS-MASTER-TRANSACTION-FORM	PIC X(31).0 	    10  WS-MASTER-TRANSACTION-SWITCH	PIC X(31). 	    10  FILLER				PIC X(139).4 	05  WS-MASTER-MENU REDEFINES WS-MASTER-TRANSACTION.) 	    10  WS-MASTER-MENU-TITLE		PIC X(20). . 	    10  WS-MASTER-MENU-DESCRIPTION	PIC X(60).0 	    10  WS-MASTER-MENU-NODE-CNT	COMP	PIC S9(4).' 	    10  WS-MASTER-MENU-NODE		PIC X(9)	  		OCCURS 20 TIMES.   01	WS-USER-RECORD.+ 	05  WS-USERNAME				PIC X(12)	VALUE SPACES. 4 	05  WS-TOP-LEVEL-MENU-NAME		PIC X(09)	VALUE SPACES.   01	STACK-RECORD. 	05  MENU-STACK				PIC X(09)	  	    OCCURS 20 TIMES.   ! 01	CALL-LEVEL				PIC 99		VALUE 0.   , 01	SUBPROCESS-RETURN-STATUS		PIC S9(9)	COMP.  ( 01	WS-ERROR-TYPE				PIC X(01)	VALUE "S". 	88  NO-ERROR				VALUE IS "S".! 	88  INFORMATION				VALUE IS "I".  	88  WARNING				VALUE IS "W".  	88  ERRORS				VALUE IS "E". 	88  FATAL				VALUE IS "F".   * 01	SW-FILES-ARE-OPEN			PIC X(1)	VALUE "N".  	88  FILES-ARE-OPEN			VALUE "Y".$ 	88  FILES-ARE-NOT-OPEN			VALUE "N". /    LINKAGE SECTION.  # 01	LINK-MASTER-RECORD			PIC X(274).    01	USER-RECORD.  	05  USERNAME				PIC X(12). % 	05  TOP-LEVEL-MENU-NAME			PIC X(09).    01	LINK-EXIT-SW				PIC X(01).  / G PROCEDURE DIVISION USING LINK-MASTER-RECORD, USER-RECORD, LINK-EXIT-SW. O *******************************************************************************  INITIALIZATION SECTION. O *******************************************************************************   	 000-INIT.  	MOVE LINK-EXIT-SW TO EXIT-SW. 	IF FIRST-TIME4 	    PERFORM 200-OPEN-FILES THRU 200-OPEN-FILES-EXIT" 	    SET NOT-PREVIOUS-MENU TO TRUE! 	    MOVE EXIT-SW TO LINK-EXIT-SW  	    MOVE 0 TO CALL-LEVEL  	END-IF. 	SET NOT-DONE TO TRUE. 	SET NO-INVALID-KEY TO TRUE. 	INITIALIZE WS-MASTER-RECORD.  	INITIALIZE WS-USER-RECORD. - 	MOVE LINK-MASTER-RECORD TO WS-MASTER-RECORD. $ 	MOVE USER-RECORD TO WS-USER-RECORD. *  *	Increment stack pointer. *  	ADD 1 TO CALL-LEVEL.  *  *	Test for stack overflow. *  	IF CALL-LEVEL > 20 A 	    DISPLAY "UIF310 - F - INTERNAL STACK OVERFLOW.  CONTACT DP."  	    GO TO 900-EXIT  	END-IF. * , *	Put current menu (transaction) onto stack. * 6 	MOVE WS-MASTER-RECORD-NAME TO MENU-STACK(CALL-LEVEL). /   O ******************************************************************************* 
 MAIN SECTION. O ******************************************************************************* 
 100-START. *  *	Is it a transaction? *  	IF WS-MASTER-RECORD-TYPE = "T" 5 	    MOVE WS-MASTER-RECORD-NAME TO MASTER-RECORD-NAME 9 	    PERFORM 110-CALL-TRANSACTION-PROCESSOR THRU 110-EXIT ! 	    MOVE EXIT-SW TO LINK-EXIT-SW  	    GO TO 900-EXIT  	END-IF.   100-POP-OFF-STACK.? 	PERFORM 300-SETUP-MENU-RECORD THRU 300-SETUP-MENU-RECORD-EXIT.  /   	 100-MAIN.  * 0 *	Display Menu screen and get the user's choice. * 9 	PERFORM 400-DISPLAY-SCREEN THRU 400-DISPLAY-SCREEN-EXIT.  *  *	Was it valid?  * ; 	PERFORM 500-VALIDATE-CHOICE THRU 500-VALIDATE-CHOICE-EXIT.  *  *	Do it. *  	EVALUATE TRUE 	    WHEN DONE 		MOVE EXIT-SW TO LINK-EXIT-SW 		GO TO 900-EXIT 	    WHEN CHOICE-NOT-VALID$ 		MOVE "Invalid choice" TO ERROR-MSG 		SET CHOICE-VALID TO TRUE 		GO TO 100-MAIN 	    WHEN TOP-LEVEL-MENU 		MOVE EXIT-SW TO LINK-EXIT-SW 		GO TO 900-EXIT 	    WHEN PREVIOUS-MENU  		GO TO 900-EXIT 	    WHEN TRANSACTION ( 		MOVE MENU-CHOICE TO MASTER-RECORD-NAME  		MOVE "T" TO MASTER-RECORD-TYPE' 		PERFORM 615-READ-MASTER THRU 615-EXIT  		IF INVALID-KEY  0 		    MOVE "Master file is corrupt" TO ERROR-MSG 		    GO TO 100-MAIN 		END-IF6 		PERFORM 110-CALL-TRANSACTION-PROCESSOR THRU 110-EXIT 		GO TO 100-MAIN 	END-EVALUATE.> 	MOVE WS-MASTER-MENU-NODE(MENU-NUMERIC) TO MASTER-PRIMARY-KEY., 	PERFORM 610-READ-NEXT-MASTER THRU 610-EXIT.* 	MOVE MASTER-RECORD TO LINK-MASTER-RECORD.> 	IF MASTER-RECORD-NAME NOT = WS-MASTER-MENU-NODE(MENU-NUMERIC) 	    SET INVALID-KEY TO TRUE 	END-IF. 	IF DONE OR INVALID-KEY / 	    MOVE "Master file is corrupt" TO ERROR-MSG  	    GO TO 100-MAIN  	END-IF. 	MOVE EXIT-SW TO LINK-EXIT-SW.( 	CALL "UIF310" USING LINK-MASTER-RECORD, 	    USER-RECORD,LINK-EXIT-SW. /    105-RETURN.  *  *	Preserve control switch. *  	MOVE LINK-EXIT-SW TO EXIT-SW. *  *	Decrement stack pointer. *  	SUBTRACT 1 FROM CALL-LEVEL. * " *	Test return switches and status. *  	IF DONE OR TOP-LEVEL-MENU 	    GO TO 900-EXIT 	 	END-IF.	  * = *	Everything was OK.  Check the switches and act accordingly.  *  	IF NOT-PREVIOUS-MENU  	    GO TO 100-MAIN  	END-IF. 	SET NOT-PREVIOUS-MENU TO TRUE.  	IF CALL-LEVEL < 2 	    GO TO 900-EXIT 	 	END-IF.	  * @ *	No switches set, so put the user back into the menu he was in. * - 	PERFORM 150-GET-MENU THRU 150-GET-MENU-EXIT.  	IF INVALID-KEY / 	    MOVE "Master file is corrupt" TO ERROR-MSG  	    GO TO 100-MAIN  	END-IF. 	GO TO 100-POP-OFF-STACK.  /   O *******************************************************************************  SUBROUTINE SECTION. O *******************************************************************************  110-CALL-TRANSACTION-PROCESSOR.  * . *	Reset transaction switch to prevent looping. *  	SET NOT-TRANSACTION TO TRUE. ? 	CALL "SCPEN" USING BY DESCRIPTOR "Processing, please wait...". 3 	PERFORM 800-CHECK-SCOPE-RETURN-FLAG THRU 800-EXIT. 6 	CALL "SCPRT" USING BY DESCRIPTOR DO-NOT-CLEAR-SCREEN.3 	PERFORM 800-CHECK-SCOPE-RETURN-FLAG THRU 800-EXIT. A 	CALL "UIF320" USING MASTER-RECORD-NAME, MASTER-TRANSACTION-TYPE, 9 	    MASTER-TRANSACTION-FORM, MASTER-TRANSACTION-SWITCH, .9 	    TRANSACTION-SCOPE-ERROR-NO, SUBPROCESS-RETURN-STATUS*% 	    GIVING SUBROUTINE-RETURN-STATUS.* **& *	Make sure the screen is redisplayed. *r, 	PERFORM 810-INITIALIZE-SCOPE THRU 810-EXIT. *   *	Test for errors within UIF320. *a' 	IF SUBROUTINE-RETURN-STATUS IS SUCCESSn 	    IF BATCH-JOB  		MOVE SPACES TO ERROR-MSG 		IF ERROR-MENUa4 		    STRING MASTER-RECORD-NAME DELIMITED BY SPACES,& 			" not submitted!" DELIMITED BY SIZE 			INTO ERROR-MSGr 		ELSE5 		    STRING MASTER-RECORD-NAME DELIMITED BY SPACES,  # 			" submitted " DELIMITED BY SIZE,n0 			MASTER-TRANSACTION-SWITCH DELIMITED BY SPACES 			INTO ERROR-MSGt 		END-IF 	    END-IFr 	    GO TO 110-EXITi 	END-IF.* 	PERFORM 115-PROCESS-ERRORS THRU 115-EXIT.	 110-EXIT.I 	EXIT. /    115-PROCESS-ERRORS.  *AE *	Process the errors from the transaction.  See program documentationP( *	for the meaning of each type of error. *	 	EVALUATE TRUE  	    WHEN ERROR-UNDEFINED-SYMBOL5 		MOVE "Symbol in .JOB not found in symbol table" TO * 		    ERROR-MSG*% 	    WHEN ERROR-UNDEFINED-SYMBOL-TYPEO= 		MOVE "Illegal symbol type in symbol table (must be 9 or X)"E 		    TO ERROR-MSG# 	    WHEN ERROR-NO-TRANSACTION-FILEE 		MOVE SPACES TO ERROR-MSG0 		STRING MASTER-RECORD-NAME DELIMITED BY SPACE, = 		    " not implemented yet" DELIMITED BY SIZE INTO ERROR-MSG	 	    WHEN ERROR-NO-SCOPE-FILEI1 		MOVE "SCOPE file (.REC) not found" TO ERROR-MSGV 	    WHEN ERROR-SCOPE-ERROR 8 	        MOVE "SCOPE error found in UIF320" TO ERROR-MSG$ 	    WHEN ERROR-SCOPE-VALIDITY-CHECK7 		MOVE "Validity checking enabled in form" TO ERROR-MSG  	    WHEN ERROR-NO-SYMBOLS0 		MOVE "No symbols in symbol table" TO ERROR-MSG 	    WHEN ERROR-NO-PROCESSING 9 		MOVE "Illegal data items passed to UIF320" TO ERROR-MSG  	    WHEN ERROR-NO-SYMBOL-FILE1 		MOVE "Symbol table file not found" TO ERROR-MSG " 	    WHEN ERROR-IN-SPECIAL-PROCESS 		MOVE SPACES TO ERROR-MSG< 		MOVE SUBROUTINE-RETURN-STATUS TO SUBROUTINE-STATUS-DISPLAY' 		STRING "Error in special process: ",  @ 		    SUBROUTINE-STATUS-DISPLAY DELIMITED BY SIZE INTO ERROR-MSG 	    WHEN ERROR-MENU2 		MOVE "Transaction has been aborted" TO ERROR-MSG 	    WHEN OTHER  		MOVE SPACES TO ERROR-MSG< 		MOVE SUBROUTINE-RETURN-STATUS TO SUBROUTINE-STATUS-DISPLAY2 		STRING "Undefined subroutine return status of ",@ 		    SUBROUTINE-STATUS-DISPLAY DELIMITED BY SIZE INTO ERROR-MSG 	END-EVALUATE.	 115-EXIT.  	EXIT. /   
 150-GET-MENU.  * $ *	Pop current menu key off of stack. * 3 	MOVE MENU-STACK(CALL-LEVEL) TO MASTER-PRIMARY-KEY.  *  *	Get the master record. * , 	PERFORM 610-READ-NEXT-MASTER THRU 610-EXIT.3 	IF MENU-STACK(CALL-LEVEL) NOT = MASTER-RECORD-NAME  	    SET INVALID-KEY TO TRUE 	ELSE + 	    MOVE MASTER-RECORD TO WS-MASTER-RECORD  	END-IF. 150-GET-MENU-EXIT. 	EXIT.   200-OPEN-FILES.  * ; *	Open the TDMS channel and request library and UIF340.MAS.  *  	IF FILES-ARE-NOT-OPEN! 	    OPEN INPUT UIF-SECURITY-FILE  	    OPEN INPUT UIF-MASTER-FILE / 	    PERFORM 810-INITIALIZE-SCOPE THRU 810-EXIT  	    SET FILES-ARE-OPEN TO TRUE  	END-IF. 200-OPEN-FILES-EXIT. 	EXIT.   210-CLOSE-FILES. * . *	Close UIF340.MAS and the SCOPE library, etc. *  	IF FILES-ARE-OPEN 	    CLOSE UIF-MASTER-FILE 	    CLOSE UIF-SECURITY-FILE 	    CALL "SCPRT" # 	    SET FILES-ARE-NOT-OPEN TO TRUE  	END-IF. 210-CLOSE-FILES-EXIT.  	EXIT. /    300-SETUP-MENU-RECORD. * . *	Setup the record to be mapped to the screen. *  	MOVE HIGH-VALUES TO FORM-SCR.- 	MOVE WS-MASTER-MENU-TITLE TO SCR-MENU-TITLE. " 	MOVE PROG-ID TO SCR-MENU-PROG-ID. 	MOVE 0 TO COUNTER.  * A *	DIGIT is the number of lines we wish to display within the menu  *	where DIGIT <= 20. * ' 	MOVE WS-MASTER-MENU-NODE-CNT TO DIGIT. E 	PERFORM 310-FILL-MENU-LINE THRU 310-FILL-MENU-LINE-EXIT DIGIT TIMES.  300-SETUP-MENU-RECORD-EXIT.  	EXIT.   310-FILL-MENU-LINE.  	ADD 1 TO COUNTER.9 	MOVE WS-MASTER-MENU-NODE(COUNTER) TO MASTER-PRIMARY-KEY. , 	PERFORM 610-READ-NEXT-MASTER THRU 610-EXIT.H 	IF INVALID-KEY OR WS-MASTER-MENU-NODE(COUNTER) NOT = MASTER-RECORD-NAME/ 	    MOVE "Master file is corrupt" TO ERROR-MSG  	    SET DONE TO TRUE " 	    GO TO 310-FILL-MENU-LINE-EXIT 	END-IF.5 	PERFORM 320-MOVE-COUNTER-TO-MENU-ITEM THRU 320-EXIT.  * : *	If the line to be displayed is a menu, we only put out a; *	description.  If it is a transaction, we put out the name 9 *	so that the user can go to it directly after he becomes  *	familiar with it.  *  	IF MASTER-RECORD-TYPE = "M"5 	    PERFORM 330-MOVE-MENU-DESC-TO-DESC THRU 330-EXIT  	ELSE 6 	    PERFORM 335-MOVE-TRANS-DESC-TO-DESC THRU 335-EXIT1 	    PERFORM 340-MOVE-TO-MENU-TRANS THRU 340-EXIT  	END-IF. 310-FILL-MENU-LINE-EXIT. 	EXIT. /    320-MOVE-COUNTER-TO-MENU-ITEM. 	EVALUATE COUNTER + 	    WHEN 1	MOVE COUNTER TO SCR-MENU-ITEM-1 + 	    WHEN 2	MOVE COUNTER TO SCR-MENU-ITEM-2 + 	    WHEN 3	MOVE COUNTER TO SCR-MENU-ITEM-3 + 	    WHEN 4	MOVE COUNTER TO SCR-MENU-ITEM-4 + 	    WHEN 5	MOVE COUNTER TO SCR-MENU-ITEM-5 + 	    WHEN 6	MOVE COUNTER TO SCR-MENU-ITEM-6 + 	    WHEN 7	MOVE COUNTER TO SCR-MENU-ITEM-7 + 	    WHEN 8	MOVE COUNTER TO SCR-MENU-ITEM-8 + 	    WHEN 9	MOVE COUNTER TO SCR-MENU-ITEM-9 - 	    WHEN 10	MOVE COUNTER TO SCR-MENU-ITEM-10 - 	    WHEN 11	MOVE COUNTER TO SCR-MENU-ITEM-11 - 	    WHEN 12	MOVE COUNTER TO SCR-MENU-ITEM-12 - 	    WHEN 13	MOVE COUNTER TO SCR-MENU-ITEM-13 - 	    WHEN 14	MOVE COUNTER TO SCR-MENU-ITEM-14 - 	    WHEN 15	MOVE COUNTER TO SCR-MENU-ITEM-15 - 	    WHEN 16	MOVE COUNTER TO SCR-MENU-ITEM-16 - 	    WHEN 17	MOVE COUNTER TO SCR-MENU-ITEM-17 - 	    WHEN 18	MOVE COUNTER TO SCR-MENU-ITEM-18 - 	    WHEN 19	MOVE COUNTER TO SCR-MENU-ITEM-19 - 	    WHEN 20	MOVE COUNTER TO SCR-MENU-ITEM-20  	END-EVALUATE.	 320-EXIT.    330-MOVE-MENU-DESC-TO-DESC.  	EVALUATE COUNTER ; 	    WHEN 1	MOVE MASTER-MENU-DESCRIPTION TO SCR-MENU-DESC-1 ; 	    WHEN 2	MOVE MASTER-MENU-DESCRIPTION TO SCR-MENU-DESC-2 ; 	    WHEN 3	MOVE MASTER-MENU-DESCRIPTION TO SCR-MENU-DESC-3 ; 	    WHEN 4	MOVE MASTER-MENU-DESCRIPTION TO SCR-MENU-DESC-4 ; 	    WHEN 5	MOVE MASTER-MENU-DESCRIPTION TO SCR-MENU-DESC-5 ; 	    WHEN 6	MOVE MASTER-MENU-DESCRIPTION TO SCR-MENU-DESC-6 ; 	    WHEN 7	MOVE MASTER-MENU-DESCRIPTION TO SCR-MENU-DESC-7 ; 	    WHEN 8	MOVE MASTER-MENU-DESCRIPTION TO SCR-MENU-DESC-8 ; 	    WHEN 9	MOVE MASTER-MENU-DESCRIPTION TO SCR-MENU-DESC-9 = 	    WHEN 10	MOVE MASTER-MENU-DESCRIPTION TO SCR-MENU-DESC-10 = 	    WHEN 11	MOVE MASTER-MENU-DESCRIPTION TO SCR-MENU-DESC-11 = 	    WHEN 12	MOVE MASTER-MENU-DESCRIPTION TO SCR-MENU-DESC-12 = 	    WHEN 13	MOVE MASTER-MENU-DESCRIPTION TO SCR-MENU-DESC-13 = 	    WHEN 14	MOVE MASTER-MENU-DESCRIPTION TO SCR-MENU-DESC-14 = 	    WHEN 15	MOVE MASTER-MENU-DESCRIPTION TO SCR-MENU-DESC-15 = 	    WHEN 16	MOVE MASTER-MENU-DESCRIPTION TO SCR-MENU-DESC-16 = 	    WHEN 17	MOVE MASTER-MENU-DESCRIPTION TO SCR-MENU-DESC-17 = 	    WHEN 18	MOVE MASTER-MENU-DESCRIPTION TO SCR-MENU-DESC-18 = 	    WHEN 19	MOVE MASTER-MENU-DESCRIPTION TO SCR-MENU-DESC-19 = 	    WHEN 20	MOVE MASTER-MENU-DESCRIPTION TO SCR-MENU-DESC-20  	END-EVALUATE.	 330-EXIT.  	EXIT. /    335-MOVE-TRANS-DESC-TO-DESC. 	EVALUATE COUNTER B 	    WHEN 1	MOVE MASTER-TRANSACTION-DESCRIPTION TO SCR-MENU-DESC-1B 	    WHEN 2	MOVE MASTER-TRANSACTION-DESCRIPTION TO SCR-MENU-DESC-2B 	    WHEN 3	MOVE MASTER-TRANSACTION-DESCRIPTION TO SCR-MENU-DESC-3B 	    WHEN 4	MOVE MASTER-TRANSACTION-DESCRIPTION TO SCR-MENU-DESC-4B 	    WHEN 5	MOVE MASTER-TRANSACTION-DESCRIPTION TO SCR-MENU-DESC-5B 	    WHEN 6	MOVE MASTER-TRANSACTION-DESCRIPTION TO SCR-MENU-DESC-6B 	    WHEN 7	MOVE MASTER-TRANSACTION-DESCRIPTION TO SCR-MENU-DESC-7B 	    WHEN 8	MOVE MASTER-TRANSACTION-DESCRIPTION TO SCR-MENU-DESC-8B 	    WHEN 9	MOVE MASTER-TRANSACTION-DESCRIPTION TO SCR-MENU-DESC-9D 	    WHEN 10	MOVE MASTER-TRANSACTION-DESCRIPTION TO SCR-MENU-DESC-10D 	    WHEN 11	MOVE MASTER-TRANSACTION-DESCRIPTION TO SCR-MENU-DESC-11D 	    WHEN 12	MOVE MASTER-TRANSACTION-DESCRIPTION TO SCR-MENU-DESC-12D 	    WHEN 13	MOVE MASTER-TRANSACTION-DESCRIPTION TO SCR-MENU-DESC-13D 	    WHEN 14	MOVE MASTER-TRANSACTION-DESCRIPTION TO SCR-MENU-DESC-14D 	    WHEN 15	MOVE MASTER-TRANSACTION-DESCRIPTION TO SCR-MENU-DESC-15D 	    WHEN 16	MOVE MASTER-TRANSACTION-DESCRIPTION TO SCR-MENU-DESC-16D 	    WHEN 17	MOVE MASTER-TRANSACTION-DESCRIPTION TO SCR-MENU-DESC-17D 	    WHEN 18	MOVE MASTER-TRANSACTION-DESCRIPTION TO SCR-MENU-DESC-18D 	    WHEN 19	MOVE MASTER-TRANSACTION-DESCRIPTION TO SCR-MENU-DESC-19D 	    WHEN 20	MOVE MASTER-TRANSACTION-DESCRIPTION TO SCR-MENU-DESC-20 	END-EVALUATE.	 335-EXIT.O 	EXIT.   340-MOVE-TO-MENU-TRANS.- 	EVALUATE COUNTER"7 	    WHEN 1	MOVE MASTER-RECORD-NAME TO SCR-MENU-TRANS-1 7 	    WHEN 2	MOVE MASTER-RECORD-NAME TO SCR-MENU-TRANS-2 7 	    WHEN 3	MOVE MASTER-RECORD-NAME TO SCR-MENU-TRANS-3 7 	    WHEN 4	MOVE MASTER-RECORD-NAME TO SCR-MENU-TRANS-4h7 	    WHEN 5	MOVE MASTER-RECORD-NAME TO SCR-MENU-TRANS-5P7 	    WHEN 6	MOVE MASTER-RECORD-NAME TO SCR-MENU-TRANS-6a7 	    WHEN 7	MOVE MASTER-RECORD-NAME TO SCR-MENU-TRANS-7-7 	    WHEN 8	MOVE MASTER-RECORD-NAME TO SCR-MENU-TRANS-8 7 	    WHEN 9	MOVE MASTER-RECORD-NAME TO SCR-MENU-TRANS-9s9 	    WHEN 10	MOVE MASTER-RECORD-NAME TO SCR-MENU-TRANS-10	9 	    WHEN 11	MOVE MASTER-RECORD-NAME TO SCR-MENU-TRANS-11s9 	    WHEN 12	MOVE MASTER-RECORD-NAME TO SCR-MENU-TRANS-12H9 	    WHEN 13	MOVE MASTER-RECORD-NAME TO SCR-MENU-TRANS-13D9 	    WHEN 14	MOVE MASTER-RECORD-NAME TO SCR-MENU-TRANS-14E9 	    WHEN 15	MOVE MASTER-RECORD-NAME TO SCR-MENU-TRANS-15-9 	    WHEN 16	MOVE MASTER-RECORD-NAME TO SCR-MENU-TRANS-16e9 	    WHEN 17	MOVE MASTER-RECORD-NAME TO SCR-MENU-TRANS-17 9 	    WHEN 18	MOVE MASTER-RECORD-NAME TO SCR-MENU-TRANS-18L9 	    WHEN 19	MOVE MASTER-RECORD-NAME TO SCR-MENU-TRANS-19	9 	    WHEN 20	MOVE MASTER-RECORD-NAME TO SCR-MENU-TRANS-20O 	END-EVALUATE.	 340-EXIT.s 	EXIT. /    400-DISPLAY-SCREEN.  *O) *	Display the menu screen and any errors.F *E 	MOVE 1 TO SCOPE-NEXT-FIELD. 	MOVE ZERO TO SCOPE-END-FIELD.+ 	CALL "SCPWR" USING BY DESCRIPTOR FORM-SCR."3 	PERFORM 800-CHECK-SCOPE-RETURN-FLAG THRU 800-EXIT.O 	IF ERROR-MSG NOT = SPACES/ 	    CALL "SCPEN" USING BY DESCRIPTOR ERROR-MSGR6 	    PERFORM 800-CHECK-SCOPE-RETURN-FLAG THRU 800-EXIT 	    MOVE SPACES TO ERROR-MSGR 	END-IF.. 	MOVE FNO-SCR-MENU-CHOICE TO SCOPE-NEXT-FIELD.+ 	CALL "SCPRF" USING BY DESCRIPTOR FORM-SCR.S3 	PERFORM 800-CHECK-SCOPE-RETURN-FLAG THRU 800-EXIT.M% 	MOVE SCR-MENU-CHOICE TO MENU-CHOICE.O 400-DISPLAY-SCREEN-EXIT. 	EXIT.   500-VALIDATE-CHOICE. *W= *	Test the user's selection and set the appropriate switches.T* *	Assume he doesn't know what he is doing. *S 	SET CHOICE-NOT-VALID TO TRUE. 	SET NOT-DONE TO TRUE. *U' *	Did he pick a number off of the menu?" *o4 	IF MENU-CHAR(1) IS NUMERIC AND MENU-FILLER = SPACES8 	    PERFORM 510-TEST-NUMERIC THRU 510-TEST-NUMERIC-EXIT# 	    GO TO 500-VALIDATE-CHOICE-EXITt 	END-IF. *M& *	No.  Did he pick a control function? *RB 	IF (MENU-CHAR(1) = "G" OR "M" OR "E") AND (MENU-CHAR(2) = SPACES)8 	    PERFORM 520-SET-SWITCHES THRU 520-SET-SWITCHES-EXIT# 	    GO TO 500-VALIDATE-CHOICE-EXITY 	END-IF. *R! *	No.  Did he pick a transaction?  *I= 	PERFORM 530-TEST-TRANSACTION THRU 530-TEST-TRANSACTION-EXIT.c 500-VALIDATE-CHOICE-EXIT.L 	EXIT. /    510-TEST-NUMERIC.  * ! *	Prevent data conversion errors.O *6 	IF MENU-CHAR(2) IS NOT NUMERIC.( 	    MOVE MENU-CHAR (1) TO MENU-CHAR (2) 	    MOVE 0 TO MENU-CHAR (1) 	END-IF. * ' *	Test to see if his entry is in range.T *R" 	IF MENU-NUMERIC = ZERO OR > DIGIT 		GO TO 510-TEST-NUMERIC-EXIT  	END-IF. 	SET CHOICE-VALID TO TRUE. *r$ *	Yes.  Did he choose a transaction? *O+ 	PERFORM 515-MOVE-MENU-TRANS THRU 515-EXIT. & 	IF HOLD-MENU-TRANS NOT =  HIGH-VALUES% 		MOVE HOLD-MENU-TRANS TO MENU-CHOICE = 		PERFORM 530-TEST-TRANSACTION THRU 530-TEST-TRANSACTION-EXITI 	END-IF. 510-TEST-NUMERIC-EXIT. 	EXIT.   515-MOVE-MENU-TRANS. 	EVALUATE MENU-NUMERIC4 	    WHEN 1	MOVE SCR-MENU-TRANS-1 TO HOLD-MENU-TRANS4 	    WHEN 2	MOVE SCR-MENU-TRANS-2 TO HOLD-MENU-TRANS4 	    WHEN 3	MOVE SCR-MENU-TRANS-3 TO HOLD-MENU-TRANS4 	    WHEN 4	MOVE SCR-MENU-TRANS-4 TO HOLD-MENU-TRANS4 	    WHEN 5	MOVE SCR-MENU-TRANS-5 TO HOLD-MENU-TRANS4 	    WHEN 6	MOVE SCR-MENU-TRANS-6 TO HOLD-MENU-TRANS4 	    WHEN 7	MOVE SCR-MENU-TRANS-7 TO HOLD-MENU-TRANS4 	    WHEN 8	MOVE SCR-MENU-TRANS-8 TO HOLD-MENU-TRANS4 	    WHEN 9	MOVE SCR-MENU-TRANS-9 TO HOLD-MENU-TRANS6 	    WHEN 10	MOVE SCR-MENU-TRANS-10 TO HOLD-MENU-TRANS6 	    WHEN 11	MOVE SCR-MENU-TRANS-11 TO HOLD-MENU-TRANS6 	    WHEN 12	MOVE SCR-MENU-TRANS-12 TO HOLD-MENU-TRANS6 	    WHEN 13	MOVE SCR-MENU-TRANS-13 TO HOLD-MENU-TRANS6 	    WHEN 14	MOVE SCR-MENU-TRANS-14 TO HOLD-MENU-TRANS6 	    WHEN 15	MOVE SCR-MENU-TRANS-15 TO HOLD-MENU-TRANS6 	    WHEN 16	MOVE SCR-MENU-TRANS-16 TO HOLD-MENU-TRANS6 	    WHEN 17	MOVE SCR-MENU-TRANS-17 TO HOLD-MENU-TRANS6 	    WHEN 18	MOVE SCR-MENU-TRANS-18 TO HOLD-MENU-TRANS6 	    WHEN 19	MOVE SCR-MENU-TRANS-19 TO HOLD-MENU-TRANS6 	    WHEN 20	MOVE SCR-MENU-TRANS-20 TO HOLD-MENU-TRANS 	END-EVALUATE.	 515-EXIT.  	EXIT. /t   520-SET-SWITCHES.t 	SET CHOICE-VALID TO TRUE. 	EVALUATE MENU-CHAR(1)
 	    WHEN "G"e 		SET PREVIOUS-MENU TO TRUE 
 	    WHEN "M"R 		SET TOP-LEVEL-MENU TO TRUE
 	    WHEN "E"- 		SET DONE TO TRUE 	    WHEN OTHERP8 		MOVE "Internal error in 520-SET-SWITCHES" TO ERROR-MSG 	END-EVALUATE. *N- *	Preserve the switch across recursive calls.- *E 	MOVE EXIT-SW TO LINK-EXIT-SW. 520-SET-SWITCHES-EXIT. 	EXIT.   530-TEST-TRANSACTION.E/ 	MOVE WS-USERNAME TO SECURITY-GENERIC-USERNAME.U/ 	MOVE MENU-CHOICE TO SECURITY-TRANSACTION-NAME.R+ 	READ UIF-SECURITY-FILE RECORD INVALID KEY R * D *	    If the user/transaction combination isn't present, transparentF *	    security screens him out even if the transaction is a valid one. *U! 	    SET CHOICE-NOT-VALID TO TRUET$ 	    GO TO 530-TEST-TRANSACTION-EXIT
 	END-READ. 	SET CHOICE-VALID TO TRUE. 	SET TRANSACTION TO TRUE.T 530-TEST-TRANSACTION-EXIT. 	EXIT.   610-READ-NEXT-MASTER.W 	SET NO-INVALID-KEY TO TRUE.? 	START UIF-MASTER-FILE KEY NOT < MASTER-PRIMARY-KEY INVALID KEYW 	    SET INVALID-KEY TO TRUE 	END-START.  	IF NO-INVALID-KEY, 	    READ UIF-MASTER-FILE NEXT RECORD AT END 		SET INVALID-KEY TO TRUE 
 	    END-READV 	END-IF.	 610-EXIT.- 	EXIT. /    615-READ-MASTER. 	SET NO-INVALID-KEY TO TRUE.! 	READ UIF-MASTER-FILE INVALID KEYT 	    SET INVALID-KEY TO TRUE
 	END-READ.	 615-EXIT.  	EXIT.   800-CHECK-SCOPE-RETURN-FLAG. 	IF SCOPE-ERRORC2 	    MOVE SCOPE-ERROR-NO TO SCOPE-ERROR-NO-DISPLAY 	    CALL "SCPRT"- 	    DISPLAY " "B 	    DISPLAY "***** Fatal Scope Error #", SCOPE-ERROR-NO-DISPLAY,  		 " *****"- 	    DISPLAY " " 	    GO TO 920-FATAL-ERROR 	END-IF.	 800-EXIT.D 	EXIT.   810-INITIALIZE-SCOPE. 6 	CALL "SCPIN" USING BY DESCRIPTOR SCOPE-STATUS-RECORD.3 	PERFORM 800-CHECK-SCOPE-RETURN-FLAG THRU 800-EXIT.E% 	MOVE "UIF310SCR" TO SCOPE-FORM-NAME.U" 	MOVE SPACES TO SCOPE-BUFFER-NAME.	 810-EXIT.O 	EXIT. /E  O *******************************************************************************- CLOSING SECTION.O *******************************************************************************T	 900-EXIT.C 	IF CALL-LEVEL NOT > 17 	    PERFORM 210-CLOSE-FILES THRU 210-CLOSE-FILES-EXIT N 	END-IF. 	EXIT PROGRAM.	V   920-FATAL-ERROR.
 	STOP RUN.