 IDENTIFICATION DIVISION. PROGRAM-ID.    UIF340., AUTHOR.        K.GAMBLE,W.KARZEN-SD.DIGITAL.* INSTALLATION.  FLEETWOOD ENTERPRISES, INC. DATE-WRITTEN.  16-APR-84.   K ***************************************************************************  * G * PROGRAM FUNCTIONS:  User Interface Maintenance Program.  This program = *		      creates and maintains the master file, username file 2 *		      and security file for the User Interface. * H * PROGRAM OPTIONS:    Addition, change, deletion, and display of recordsK *                     in the Master and Username files.  Automatic creation 5 *                     of the Security file as needed.  *  * PROGRAM MODIFICATIONS: *  *	AUTHOR   T. MOORE  *	DATE     05-AUG-86 *	VERSION  2-B *  *	PROGRAM CHANGES:/ *		Correct 'REWRITE ERROR' in change menu code.  * G ***********************************************************************    ENVIRONMENT DIVISION.  CONFIGURATION SECTION. SOURCE-COMPUTER.  VAX-11.  OBJECT-COMPUTER.  VAX-11.  SPECIAL-NAMES. INPUT-OUTPUT SECTION. 
 FILE-CONTROL.    	SELECT UIF-MASTER-FILE  		ASSIGN TO DISK 		ORGANIZATION IS INDEXED  		ACCESS MODE IS DYNAMIC.    	SELECT UIF-USERNAME-FILE  		ASSIGN TO DISK 		ORGANIZATION IS INDEXED  		ACCESS MODE IS DYNAMIC.    	SELECT UIF-SECURITY-FILE  		ASSIGN TO DISK 		ORGANIZATION IS INDEXED  		ACCESS MODE IS DYNAMIC.    	SELECT UIF-LOG-FILE 		ASSIGN TO DISK.  /  DATA DIVISION.
 FILE SECTION.    FD  UIF-MASTER-FILE & 	COPY "UIF-MASTER-FD" OF "LIB:UIFLIB".  & 	COPY "MASTER-RECORD" OF "LIB:UIFLIB". /  FD  UIF-USERNAME-FILE ( 	COPY "UIF-USERNAME-FD" OF "LIB:UIFLIB".  ( 	COPY "USERNAME-RECORD" OF "LIB:UIFLIB". /  FD  UIF-SECURITY-FILE ( 	COPY "UIF-SECURITY-FD" OF "LIB:UIFLIB".  ( 	COPY "SECURITY-RECORD" OF "LIB:UIFLIB". /  FD  UIF-LOG-FILE   	VALUE OF ID IS "UIF340.PR1".    01	LOG-RECORD. 	05 LOG-MESSAGE		PIC X(50).  	05 LOG-REC		PIC X(30).  /  WORKING-STORAGE SECTION.  + 01	PROG-ID					PIC X(09) VALUE "UIF340-2B".   & 	COPY "SWITCH-RECORD" OF "LIB:UIFLIB".  ' 	COPY "FORM-UIF340SC1" OF "LIB:UIFLIB".   ' 	COPY "FORM-UIF340SC2" OF "LIB:UIFLIB".   ' 	COPY "FORM-UIF340SC3" OF "LIB:UIFLIB".   ' 	COPY "FORM-UIF340SC4" OF "LIB:UIFLIB".   , 	COPY "SCOPE-STATUS-RECORD" OF "LIB:SCPLIB".  + 	COPY "SCOPE-SCREEN-IMAGE" OF "LIB:SCPLIB".   4 	COPY "ABNORMAL-TERMINATION-RECORD" OF "LIB:UTLLIB".   01	WS-MASTER-RECORD. 	05  WS-MASTER-PRIMARY-KEY. ) 	    10  WS-MASTER-RECORD-NAME		PIC X(9). & 	    10  WS-MASTER-RECORD-TYPE		PIC X.2 	05  WS-MASTER-RECORD-ACCESS-COUNT	PIC S9(4) COMP. 	05  WS-MASTER-TRANSACTION.		 3 	    10  WS-MASTER-TRANSACTION-DESC      PIC X(60). - 	    10  WS-MASTER-TRANSACTION-TYPE	PIC X(1). . 	    10  WS-MASTER-TRANSACTION-FORM	PIC X(31).0 	    10  WS-MASTER-TRANSACTION-SWITCH	PIC X(31). 	    10  FILLER				PIC X(139).4 	05  WS-MASTER-MENU REDEFINES WS-MASTER-TRANSACTION.3 	    10  WS-MASTER-MENU-TITLE            PIC X(20). 3 	    10  WS-MASTER-MENU-DESCRIPTION      PIC X(60). 8 	    10  WS-MASTER-MENU-NODE-CNT         PIC S9(4) COMP.B 	    10  WS-MASTER-MENU-NODE             PIC X(9) OCCURS 20 TIMES.   01  WS-MASTER-PRIMARY-KEY-SAVE. - 	    10  WS-MASTER-RECORD-NAME-SAVE	PIC X(9). * 	    10  WS-MASTER-RECORD-TYPE-SAVE	PIC X.   01	WS-USER-RECORD.+ 	05  WS-USERNAME				PIC X(12) VALUE SPACES. . 	05  WS-GENERIC-NAME			PIC X(12) VALUE SPACES.4 	05  WS-TOP-LEVEL-MENU-NAME		PIC X(09) VALUE SPACES.   01	WS-SECURITY-RECORD.2 	05  WS-GENERIC-USERNAME			PIC X(12) VALUE SPACES.2 	05  WS-TRANSACTION-NAME			PIC X(09) VALUE SPACES.  ! 01	WS-HISTORY-SYMBOL			PIC X(01).  01	TRACK-INDEX				PIC 9(02). 01	TRACK-COUNT				PIC 9(02).) 01	MAX-TRACK-COUNT				PIC 9(02) VALUE 50.    01	WS-TRACK-TRANSACTION-COUNT.- 	05  TRACK-TRANSACTION-COUNT OCCURS 50 TIMES. + 	    10  TRANSACTION-NAME-TRACK			PIC X(9). , 	    10  TRANSACTION-TYPE-TRACK			PIC X(01).. 	    10  TRANSACTION-HISTORY-TRACK		PIC X(01).. 		88  TRANSACTION-COUNT-INCREMENTED	VALUE "I".. 		88  TRANSACTION-COUNT-DECREMENTED	VALUE "D".   01	WS-DCL-COMMAND. 	05 DCL						PIC X(08) VALUE   	    "$ RENAME".% 	05 FROM-FILENAME				PIC X(13) VALUE   	    " UIF_SECURITY". $ 	05 TO-FILENAME					PIC X(17) VALUE  	    " UIF_SECURITY_REN".   $ 01	RETURN-STATUS					PIC S9(9) COMP.  " 01	IMAGE-NAME					PIC X(06) VALUE  	    "UIF340".  # 	COPY "WS-RECORD"  OF "LIB:UIFLIB".    01	SCOPE-DATA-ITEMS.( 	05  MAIN-MENU-SCREEN				PIC X(9) VALUE  	    "UIF340SC1". + 	05  GENERIC-USER-SCREEN				PIC X(9) VALUE   	    "UIF340SC2". $ 	05  TRANS-SCREEN				PIC X(9) VALUE  	    "UIF340SC3". $ 	05  MENU-SCREEN					PIC X(9) VALUE  	    "UIF340SC4". " 	05  SCOPE-ERROR-MSG				PIC X(80). 	05  DISPLAY-MSG					PIC X(80).  	05  USER-ESCAPE					PIC X.   	    88  USER-ABORT			VALUE "A". 	    88  USER-MENU			VALUE "M". . 	    88  USER-VALID-ESCAPE		VALUE "A","M"," ".% 	05  DISPLAY-HOLD				PIC X VALUE "D". " 	    88  KILL-DISPLAY			VALUE "K"." 	    88  GIVE-DISPLAY			VALUE "D". 	05  UIF-RESPONSE				PIC X(2). 	05  UIF-FIELD					PIC X(2)./ 	05  SCP-CLEAR-SCREEN		COMP		PIC S9(9)	VALUE 1.    01	PROCESS-COUNT					PIC 9(2).. 01	MAX-TRANSACT-PER-MENU				PIC 9(2) VALUE 20. 01	WS-MESSAGES. & 	05  INITIAL-PROMPT				PIC X(23) VALUE 	    "Enter Selection Number:". ' 	05  STANDARD-PROMPT				PIC X(27) VALUE # 	    "Enter: P=Process, #=Change:". & 	05  DISPLAY-PROMPT				PIC X(15) VALUE    	    "Enter: F=Finish".$ 	05  MENU-PROMPT					PIC X(43) VALUE3 	    "Press RETURN when finished entering options". $ 	05  RECORD-ADDED				PIC X(21) VALUE 	    "Record has been added". % 	05  ADD-CANCELLED				PIC X(13) VALUE  	    "Add Cancelled". " 	05  DELETE-OK					PIC X(24) VALUE 	    "Record has been deleted". # 	05  DELETE-CAN					PIC X(16) VALUE  	    "Delete Canceled". ' 	05  DELETE-QUESTION				PIC X(28) VALUE $ 	    "Delete this record? (Y or N)"." 	05  CHANGE-OK					PIC X(24) VALUE 	    "Record has been changed". & 	05  ACTION-ABORTED				PIC X(29) VALUE$ 	    "Transaction has been aborted"., 	05  ADD-TRANSACTION-QUERY			PIC X(47) VALUE7 	    "Do You Wish To Add A New Transaction - Y or N ?". & 	05  ADD-MENU-QUERY				PIC X(40) VALUE0 	    "Do You Wish To Add A New Menu - Y or N ?".$ 	05  OPTION-VALID				PIC X(25) VALUE! 	    "Option has been validated". ) 	05  NO-CHANGE-ALLOWED				PIC X(35) VALUE + 	    "Change of that field is not allowed". ' 	05  TABLE-FULL-EXIT				PIC X(46) VALUE 3 	    "Transaction aborted Table full, Please exit". ( 	05  TRACK-TABLE-FULL				PIC X(52) VALUE< 	    "No more changes allowed to this menu, Please process".( 	05  INVALID-RESPONSE				PIC X(28) VALUE$ 	    "Invalid Response! Try again.".% 	05  RECORD-EXISTS				PIC X(29) VALUE % 	    "Record already exists on file". $ 	05  WRITE-ERROR					PIC X(22) VALUE 	    "Invalid Write Attempt!".% 	05  REWRITE-ERROR				PIC X(23) VALUE  	    "Error Rewriting Record!". $ 	05  DELETE-ERROR				PIC X(23) VALUE 	    "Error DELETING  Record!". & 	05  NO-SUCH-RECORD				PIC X(29) VALUE% 	    "Record does not exist on file".   	05  NO-TRAN					PIC X(32) VALUE( 	    "Transaction Record Doesn't Exist".  	05  NO-MENU					PIC X(25) VALUE! 	    "Menu Record Doesn't Exist". & 	05  NO-CORR-RECORD				PIC X(59) VALUEC 	    "No Corresponding Record for Menu Option (*), Please Remove!". % 	05  NO-VALID-TYPE				PIC X(48) VALUE 8 	    "Type entered is Invalid, Enter either 'M' or 'T'".* 	05  SCOPE-ERROR-ESCAPE				PIC X(80) VALUE7 	    "Invalid Escape Entered, (A)bort or (M)enu valid".   % * 	AREA TO STORE MASTER FILE RECORDS   *	UP TO 50 RECORDS4 *	USED DURING RECURSIVE TEST AND REBUILD OF SECURITY *  01	WS-LIST-RECORD-TBL.$ 	03  WS-LIST-RECORD OCCURS 51 TIMES. 	    05  WS-LIST-PRIMARY-KEY. % 		10  WS-LIST-RECORD-NAME			PIC X(9). " 		10  WS-LIST-RECORD-TYPE			PIC X.5 	    05  WS-LIST-RECORD-ACCESS-COUNT		PIC S9(4) COMP.  	    05  WS-LIST-TRANSACTION. * 		10  WS-LIST-TRANSACTION-DESC		PIC X(60). 		10  FILLER				PIC X(202). 4 	    05  WS-LIST-MENU REDEFINES WS-LIST-TRANSACTION.% 		10  WS-LIST-MENU-TITLE			PIC X(20). * 		10  WS-LIST-MENU-DESCRIPTION		PIC X(60)., 		10  WS-LIST-MENU-NODE-CNT		PIC S9(4) COMP.# 		10  WS-LIST-MENU-NODE			PIC X(9)   			OCCURS 20 TIMES. 0 	    05  WS-LIST-MENU-CUR-NODE			PIC S9(4) COMP.  + 01  TABLE-MAX						PIC S9(4) COMP VALUE 50.   1 * USED TO VALIDATE USERNAMES AND MASTERFILE NAMES    01	WS-NAME-TABLE					PIC X(12). * 01	WS-NAME-TBL-01 REDEFINES WS-NAME-TABLE.+ 	05  WS-NAME-TBL					PIC X OCCURS 12 TIMES. " 01	WS-NAME-SUB					PIC S9(4) COMP.  4 * TRACKS CHANGES TO THE SYSTEM REQUIRING VALIDATION.6 * FUNCTION A=ADD,D=DELETE   TYPE  U=USER,T=TRANSACTION *  01   WS-OTHER-CHANGE-TBL. , 	05  WS-OTHER-CHANGE-RECORD OCCURS 51 TIMES.' 	    10  WS-OTHER-FUNCTION 			PIC X(1). # 	    10  WS-OTHER-TYPE				PIC X(1). $ 	    10  WS-OTHER-NAME				PIC X(12).  I * THE FOLLOWING STORES INFORMATION TEMPORARILY WHILE PROCESSING SUB MENUS  *    01	WS-STORE-UIF-INFORMATION." 	05  WS-STORE-UIF OCCURS 25 TIMES.' 		10  WS-STORE-UIF-DATA-1			PIC X(118). $ 		10  WS-STORE-INFO OCCURS 20 TIMES.( 		    20  WS-STORE-UIF-OPTION		PIC X(9).& 		    20  WS-STORE-UIF-TYPE		PIC X(1). 		10  FILLER				PIC X(79).  ! 	05  WS-STORE-OPTION				PIC X(9).   # 	05  WS-STORE-MESSAGE				PIC X(60).   2 	05  WS-STORE-UIF-FIELD-NUMERIC  	OCCURS 25 TIMES.# 		10  WS-TEMP-UIF-FIELD			PIC 9(2).   . 	05  WS-STORE-OPTION-INDEX  		OCCURS 25 TIMES.! 		10  WS-TEMP-OPT-IDX			PIC 9(2).   ) 	05  WS-STORE-NODE-CNT			OCCURS 25 TIMES. " 		10  WS-TEMP-NODE-CNT			PIC 9(2).  + 	05  WS-STORE-ACCESS-CNT			OCCURS 25 TIMES. $ 		10  WS-TEMP-ACCESS-CNT			PIC 9(3).  - 	05  WS-STORE-CORRECTION-SW		OCCURS 25 TIMES. ! 		10 WS-TEMP-CORR-SW			PIC X(01).   3 * USED TO SAVE TOP LEVEL MENU IN TEST FOR RECURSION  *  01	WS-01-USER-MENU-TABLE. ) 	05	WS-USER-MENU-TABLE		OCCURS 100 TIMES. $ 		10  WS-TMP-USR-MNU-TBL			PIC X(9). 01	UMT-SUB						PIC S9(4) COMP.  01	U-SUB						PIC S9(4) COMP.A  # 01	UMT-SW						PIC X(01) VALUE "N".S 	88  ON-LIST				VALUE IS "Y".4    3 * TEMPORARY STORAGE AREAS WHILE REORGANINZING NODES* ** 01	WS-STORE-NODE-INFO./ 	05  WS-TMP-NODE-INDEX				PIC 9(2) VALUE ZEROS.e  . 	05  WS-CURR-NODE-END				PIC 9(2) VALUE ZEROS.  1 	05  WS-STORE-NODE-INDEX				PIC 9(2) VALUE ZEROS.s  . 	05  WS-ORIG-NODE-CNT				PIC 9(2) VALUE ZEROS.  ' * SIGNALS CHANGES TO THE MENU STRUCTUREn *i( 01	STRUCTURE-SW					PIC X(01) VALUE "N".& 	88  STRUCTURE-CHANGES			VALUE IS "Y".  ! * SIGNALS CHANGES TO USER RECORDSf *e* 01	USER-CHANGE-SW					PIC X(01) VALUE "N"." 	88  OTHER-CHANGES			VALUE IS "Y".  < * SWITCH TO CONTROL REBUILDING ONE OR ALL USERS FOR SECURITY *	# 01	FIX-SW						PIC X(01) VALUE "N".n& 	88  FROM-FIX-SECURITY			VALUE IS "Y".) 	88  NOT-FROM-FIX-SECURITY		VALUE IS "N".*   * INDICATES IF IN SUB MENU *F$ 01	MENU-SW						PIC X(01) VALUE "N". 	88  FROM-MENU				VALUE IS "Y".1   * INDICATES IF FROM CHANGE MENUC *N* 01	CHANGE-MENU-SW					PIC X(01) VALUE "N".% 	88  FROM-CHANGE-MENU			VALUE IS "Y".   ! * INDICATES IF IN SUB TRANSACTION  *S$ 01	TRANS-SW					PIC X(01) VALUE "N".$ 	88  TRANS-FROM-MENU			VALUE IS "Y".  7 * INDICATES IF PROCESSING OPTIONS WHILE WITHIN SUB MENUI *T$ 01	LEVEL-SW					PIC X(01) VALUE "N". 	88  NEXT-LEVEL				VALUE "Y".L 	88  SAME-LEVEL				VALUE "N".I  # * SHOWS IF FIELD IS BEING CORRECTED  * ) 01	CORRECTION-SW					PIC X(01) VALUE "N".  	88  CORRECTION				VALUE "Y".E  . * SHOWS IF CONTROL-M WAS REQUESTED IN SUB MENU * . 01	CONTROL-M-INDICATOR				PIC X(01) VALUE "N". 	88  CONTROL-M				VALUE "Y".  6 * USED IN RECURSIVE AND REBUILD SECURITY , POINTERS TO3 * LAST MENU PLACED ON LIST AND NODE OF CURRENT MENU  *  01	WS-STORE-RECURSION-POINTERS. % 	05  L-SUB        				PIC S9(4) COMP. ' 	05  FIX-SUB        				PIC S9(4) COMP. % 	05  CHK-SUB      				PIC S9(4) COMP.    * SHOWS OPTION ON MENU SCREEN  * ) 01	OPTION-INDEX					PIC 9(2) VALUE ZEROS. , 01	NEXT-OPTION-NBR					PIC 9(2) VALUE ZEROS.   * MAINIPULATES OPTION STACK  * ' 01	NODE-INDEX					PIC 9(2) VALUE ZEROS.   * * WS FOR # OF OPTIONS/NODES ON MENU RECORD * ( 01	WS-NODE-CNT					PIC 9(2) VALUE ZEROS.   * MANIPULATES CHANGE TABLE * ( 01	CHG-TBL-IDX					PIC 9(2) VALUE ZEROS.   * SHOWS ACTIVE ITEM WITHIN MENU  * 0 01	WS-UIF-FIELD-NUMERIC				PIC 9(2) VALUE ZEROS.5 01	WS-UIF-FIELD-ALPHA	REDEFINES WS-UIF-FIELD-NUMERIC.  	05  WS-UIF-FIELD				PIC X(2).  > * BREAKS UP FIELD FOR DETERMINING IF OPTION OR TYPE PROCESSING * + 01	WS-STORE-FIELD					PIC 9(2) VALUE ZEROS. / 01	WS-STORE-FIELD-ALT	REDEFINES WS-STORE-FIELD. % 	05  FIELD-TENS-POSITION				PIC 9(1). % 	05  FIELD-ONES-POSITION				PIC 9(1). ! 		88  ODD				VALUE 1, 3, 5, 7, 9. ! 		88  EVEN			VALUE 0, 2, 4, 6, 8.    /  PROCEDURE DIVISION. O *******************************************************************************  Initialization Section. O *******************************************************************************   	 000-INIT.    	MOVE "*" TO SCOPE-BUFFER-NAME.  	MOVE 0 TO SCOPE-BACKTAB-LIMIT. ( 	INITIALIZE ABNORMAL-TERMINATION-RECORD.1 	PERFORM 800-OPEN-FILES THRU 800-OPEN-FILES-EXIT.  	INITIALIZE FORM-SC1,  		   FORM-SC2, 		   FORM-SC3, 		   FORM-SC4. * M * Move high values so Scope will not display the PROCESS prompt until desired  * $ 	MOVE HIGH-VALUES TO SC2-UIF-PROMPT, 			    SC3-UIF-PROMPT, 			    SC4-UIF-PROMPT.$ 	MOVE PROG-ID TO SC1-UIF-PROGRAM-ID, 			SC2-UIF-PROGRAM-ID, 			SC3-UIF-PROGRAM-ID, 			SC4-UIF-PROGRAM-ID.! 	INITIALIZE WS-OTHER-CHANGE-TBL,   		   WS-STORE-UIF-INFORMATION, 		   WS-STORE-NODE-INFO,! 		   WS-STORE-RECURSION-POINTERS.  	MOVE ZEROS TO L-SUB.    / O ******************************************************************************* 
 Main Section. O *******************************************************************************   	 100-MAIN. / 	PERFORM 205-MAIN-MENU THRU 205-MAIN-MENU-EXIT.  	EVALUATE SC1-UIF-SELECTION & 		WHEN "1 "	PERFORM 210-ADD-USER THRU  					210-ADD-USER-EXIT( 		WHEN "2 "	PERFORM 220-CHANGE-USER THRU 					220-CHANGE-USER-EXIT ( 		WHEN "3 "	PERFORM 230-DELETE-USER THRU 					230-DELETE-USER-EXIT ) 		WHEN "4 "	PERFORM 240-DISPLAY-USER THRU  					240-DISPLAY-USER-EXIT% 		WHEN "5 "	PERFORM 250-ADD-MENU THRU  					250-ADD-MENU-EXIT( 		WHEN "6 "	PERFORM 260-CHANGE-MENU THRU 					260-CHANGE-MENU-EXIT ( 		WHEN "7 "	PERFORM 270-DELETE-MENU THRU 					270-DELETE-MENU-EXIT ) 		WHEN "8 "	PERFORM 280-DISPLAY-MENU THRU  					280-DISPLAY-MENU-EXIT  , 		WHEN "9 "	PERFORM 290-ADD-TRANSACTION THRU 					290-ADD-TRANSACTION-EXIT / 		WHEN "10"	PERFORM 300-CHANGE-TRANSACTION THRU   					300-CHANGE-TRANSACTION-EXIT/ 		WHEN "11"	PERFORM 310-DELETE-TRANSACTION THRU   					310-DELETE-TRANSACTION-EXIT0 		WHEN "12"	PERFORM 320-DISPLAY-TRANSACTION THRU! 					320-DISPLAY-TRANSACTION-EXIT , 		WHEN "13"	GO TO 900-RECUR-SECUR-ZERO-TESTS  , 		WHEN OTHER	PERFORM 700-RESPONSE-ERROR THRU 					700-RESPONSE-ERROR-EXIT 	END-EVALUATE.   	GO TO 100-MAIN. / O *******************************************************************************  SUBROUTINE SECTION. O *******************************************************************************    205-MAIN-MENU.. 	MOVE "     Main Menu      " TO SC1-UIF-TITLE.' 	MOVE INITIAL-PROMPT TO SC1-UIF-PROMPT. " 	MOVE SPACES TO SC1-UIF-SELECTION. 	MOVE "N" TO INVALID-KEY-SW,   		    TRANS-SW,  		    MENU-SW,   		    CORRECTION-SW.* 	MOVE MAIN-MENU-SCREEN TO SCOPE-FORM-NAME.0 	MOVE FNO-SC1-UIF-SELECTION TO SCOPE-NEXT-FIELD. 	MOVE "K" TO DISPLAY-HOLD.; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.  * H * All versions of user escape will go to the same place for this screen.L * The following statements are here in case future needs require a differentD * branch.  In that case, at least the lines will be here to help the< * programmer realize that the user escape has to be handled. * " 	IF USER-MENU GO TO 205-MAIN-MENU.# 	IF USER-ABORT GO TO 205-MAIN-MENU. . 	IF NOT USER-VALID-ESCAPE GO TO 205-MAIN-MENU. 205-MAIN-MENU-EXIT.  	EXIT. / 
 210-ADD-USER.  	INITIALIZE WS-USER-RECORD,  		   FORM-SC2. 	MOVE "N" TO CORRECTION-SW. $ 	MOVE HIGH-VALUES TO SC2-UIF-PROMPT, 			    SC2-UIF-RESPONSE.$ 	MOVE PROG-ID TO SC2-UIF-PROGRAM-ID.. 	MOVE "   Add User Record  " TO SC2-UIF-TITLE.- 	MOVE GENERIC-USER-SCREEN TO SCOPE-FORM-NAME. 1 	PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXIT.    210-ADD-GENERIC-NAME. 3 	MOVE FNO-SC2-UIF-GENERIC-NAME TO SCOPE-NEXT-FIELD.  	MOVE "K" TO DISPLAY-HOLD.; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT. & 	IF USER-MENU GO TO 210-ADD-USER-EXIT." 	IF USER-ABORT GO TO 210-ADD-USER.5 	IF NOT USER-VALID-ESCAPE GO TO 210-ADD-GENERIC-NAME.  * 9 *  CHECK THAT USERNAME IS IN A VALID VMS FILE SPEC FORMAT  * , 	MOVE SC2-UIF-GENERIC-NAME TO WS-NAME-TABLE.1 	PERFORM 745-CHECK-NAME THRU 745-CHECK-NAME-EXIT.  	EVALUATE SCOPE-ERROR-MSG & 		WHEN SPACES	GO TO 210-USER-READ-CONT' 		WHEN OTHER	INITIALIZE SCOPE-ERROR-MSG  				GO TO 210-ADD-GENERIC-NAME 	END-EVALUATE.   210-USER-READ-CONT. + 	MOVE SC2-UIF-GENERIC-NAME TO WS-USERNAME,   				 WS-GENERIC-NAME. ( 	MOVE WS-USER-RECORD TO USERNAME-RECORD./ 	PERFORM 660-READ-USER THRU 660-READ-USER-EXIT.   # * RECORD SHOULD NOT BE FOUND ON ADD  *  	IF INVALID-KEY  		GO TO 210-GET-TOP-MENU 	ELSE ' 		MOVE RECORD-EXISTS TO SCOPE-ERROR-MSG 1 		PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT  		GO TO 210-ADD-GENERIC-NAME.    210-GET-TOP-MENU.  	IF CORRECTION 		MOVE "N" TO CORRECTION-SW ! 		GO TO 210-GET-PROCESS-RESPONSE.  	MOVE "N" TO INVALID-KEY-SW.5 	MOVE FNO-SC2-UIF-TOP-LEVEL-MENU TO SCOPE-NEXT-FIELD. - 	MOVE GENERIC-USER-SCREEN TO SCOPE-FORM-NAME. ; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT. & 	IF USER-MENU GO TO 210-ADD-USER-EXIT." 	IF USER-ABORT GO TO 210-ADD-USER.1 	IF NOT USER-VALID-ESCAPE GO TO 210-GET-TOP-MENU. 7 	MOVE SC2-UIF-TOP-LEVEL-MENU TO WS-TOP-LEVEL-MENU-NAME.  /  210-GET-PROCESS-RESPONSE. ( 	MOVE STANDARD-PROMPT TO SC2-UIF-PROMPT.- 	MOVE FNO-SC2-UIF-PROMPT TO SCOPE-NEXT-FIELD. 1 	PERFORM 692-CALL-SCPWF THRU 692-CALL-SCPWF-EXIT. / 	MOVE FNO-SC2-UIF-RESPONSE TO SCOPE-NEXT-FIELD. ; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT. & 	IF USER-MENU GO TO 210-ADD-USER-EXIT." 	IF USER-ABORT GO TO 210-ADD-USER.9 	IF NOT USER-VALID-ESCAPE GO TO 210-GET-PROCESS-RESPONSE.-= 	STRING SC2-UIF-RESPONSE DELIMITED BY SIZE INTO UIF-RESPONSE..$ 	MOVE HIGH-VALUES TO SC2-UIF-PROMPT, 			    SC2-UIF-RESPONSE. 	EVALUATE UIF-RESPONSE" 		WHEN "P ",		GO TO 210-WRITE-USER' 		WHEN "1 ",		MOVE "Y" TO CORRECTION-SW1 					GO TO 210-ADD-GENERIC-NAME3$ 		WHEN "2 ",		GO TO 210-GET-TOP-MENU- 		WHEN OTHER		PERFORM 700-RESPONSE-ERROR THRUX 						700-RESPONSE-ERROR-EXIT # 					GO TO 210-GET-PROCESS-RESPONSEA 	END-EVALUATE.   210-WRITE-USER." 	ADD 1 TO CHG-TBL-IDX. * B * If CHG-TBL-IDX is greater than or equal to table-max, give error *   	IF CHG-TBL-IDX NOT < TABLE-MAX ) 		MOVE TABLE-FULL-EXIT TO SCOPE-ERROR-MSG01 		PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT  		GO TO 210-ADD-USER-EXIT.1 	PERFORM 665-WRITE-USER THRU 665-WRITE-USER-EXIT.9 	IF INVALID-KEY % 		MOVE WRITE-ERROR TO SCOPE-ERROR-MSGR1 		PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT8 		MOVE "N" TO INVALID-KEY-SW 		GO TO 210-ADD-USER.N" 	MOVE RECORD-ADDED TO DISPLAY-MSG.1 	PERFORM 808-CALL-SCPEN THRU 808-CALL-SCPEN-EXIT.S  , * SET SWITCH TO INDICATE CHANGE TO USER FILE *O- 	MOVE "A" TO WS-OTHER-FUNCTION (CHG-TBL-IDX).	) 	MOVE "U" TO WS-OTHER-TYPE (CHG-TBL-IDX).I5 	MOVE WS-GENERIC-NAME TO WS-OTHER-NAME (CHG-TBL-IDX).S 	MOVE "Y" TO USER-CHANGE-SW. 	GO TO 210-ADD-USER.   210-ADD-USER-EXIT. 	EXIT.   /O 220-CHANGE-USER. 	INITIALIZE WS-USER-RECORD,  		   FORM-SC2.$ 	MOVE HIGH-VALUES TO SC2-UIF-PROMPT, 			    SC2-UIF-RESPONSE.$ 	MOVE PROG-ID TO SC2-UIF-PROGRAM-ID.. 	MOVE " Change User Record " TO SC2-UIF-TITLE.- 	MOVE GENERIC-USER-SCREEN TO SCOPE-FORM-NAME. 1 	PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXIT.H 220-DISPLAY-GENERIC-NAME.S3 	MOVE FNO-SC2-UIF-GENERIC-NAME TO SCOPE-NEXT-FIELD." 	MOVE "K" TO DISPLAY-HOLD.; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.E) 	IF USER-MENU GO TO 220-CHANGE-USER-EXIT.R% 	IF USER-ABORT GO TO 220-CHANGE-USER.N9 	IF NOT USER-VALID-ESCAPE GO TO 220-DISPLAY-GENERIC-NAME.R+ 	MOVE SC2-UIF-GENERIC-NAME TO WS-USERNAME, A 				 WS-GENERIC-NAME.E( 	MOVE WS-USER-RECORD TO USERNAME-RECORD./ 	PERFORM 660-READ-USER THRU 660-READ-USER-EXIT.M 	IF INVALID-KEYT+ 	    MOVE NO-SUCH-RECORD TO SCOPE-ERROR-MSG	4 	    PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT# 	    GO TO 220-DISPLAY-GENERIC-NAME4 	ELSE : 	    MOVE WS-TOP-LEVEL-MENU-NAME TO SC2-UIF-TOP-LEVEL-MENU8 	    MOVE FNO-SC2-UIF-TOP-LEVEL-MENU TO SCOPE-NEXT-FIELD4 	    PERFORM 692-CALL-SCPWF THRU 692-CALL-SCPWF-EXIT 	END-IF. 	GO TO 220-GET-RESPONSE.   220-GET-TOP-MENU.N 	MOVE "N" TO INVALID-KEY-SW.5 	MOVE FNO-SC2-UIF-TOP-LEVEL-MENU TO SCOPE-NEXT-FIELD. ; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT. ) 	IF USER-MENU GO TO 220-CHANGE-USER-EXIT.-% 	IF USER-ABORT GO TO 220-CHANGE-USER.O1 	IF NOT USER-VALID-ESCAPE GO TO 220-GET-TOP-MENU.M7 	MOVE SC2-UIF-TOP-LEVEL-MENU TO WS-TOP-LEVEL-MENU-NAME.L   220-GET-RESPONSE.O( 	MOVE STANDARD-PROMPT TO SC2-UIF-PROMPT.- 	MOVE FNO-SC2-UIF-PROMPT TO SCOPE-NEXT-FIELD.I1 	PERFORM 692-CALL-SCPWF THRU 692-CALL-SCPWF-EXIT.-/ 	MOVE FNO-SC2-UIF-RESPONSE TO SCOPE-NEXT-FIELD.	; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.	) 	IF USER-MENU GO TO 220-CHANGE-USER-EXIT.I% 	IF USER-ABORT GO TO 220-CHANGE-USER.*1 	IF NOT USER-VALID-ESCAPE GO TO 220-GET-RESPONSE.n= 	STRING SC2-UIF-RESPONSE DELIMITED BY SIZE INTO UIF-RESPONSE.*$ 	MOVE HIGH-VALUES TO SC2-UIF-PROMPT, 			    SC2-UIF-RESPONSE. 	EVALUATE UIF-RESPONSE% 	    WHEN "P " 		GO TO 220-REWRITE-ITI' 	    WHEN "2 ",		GO TO 220-GET-TOP-MENUP0 	    WHEN OTHER		PERFORM 700-RESPONSE-ERROR THRU 					700-RESPONSE-ERROR-EXIT 					GO TO 220-GET-RESPONSE  	END-EVALUATE. /o 220-REWRITE-IT.  	ADD 1 TO CHG-TBL-IDX. *PB * If CHG-TBL-IDX is greater than or equal to table-max, give error *   	IF CHG-TBL-IDX NOT < TABLE-MAX ) 		MOVE TABLE-FULL-EXIT TO SCOPE-ERROR-MSGR1 		PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXITI 		GO TO 220-CHANGE-USER-EXIT.I5 	PERFORM 667-REWRITE-USER THRU 667-REWRITE-USER-EXIT.M 	IF INVALID-KEY ' 		MOVE REWRITE-ERROR TO SCOPE-ERROR-MSGO1 		PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT*  		MOVE "N" TO INVALID-KEY-SW* 		GO TO 220-CHANGE-USER. 	MOVE CHANGE-OK TO DISPLAY-MSG.*1 	PERFORM 808-CALL-SCPEN THRU 808-CALL-SCPEN-EXIT.* ** * CHANGE  = DELETE + ADD *N- 	MOVE "D" TO WS-OTHER-FUNCTION (CHG-TBL-IDX).X) 	MOVE "U" TO WS-OTHER-TYPE (CHG-TBL-IDX)."5 	MOVE WS-GENERIC-NAME TO WS-OTHER-NAME (CHG-TBL-IDX).  	ADD 1 TO CHG-TBL-IDX.- 	MOVE "A" TO WS-OTHER-FUNCTION (CHG-TBL-IDX).	) 	MOVE "U" TO WS-OTHER-TYPE (CHG-TBL-IDX).	5 	MOVE WS-GENERIC-NAME TO WS-OTHER-NAME (CHG-TBL-IDX).- 	MOVE "Y" TO USER-CHANGE-SW.   	GO TO 220-CHANGE-USER.R   220-CHANGE-USER-EXIT.	 	EXIT.   /- 230-DELETE-USER. 	INITIALIZE WS-USER-RECORD,  		   FORM-SC2.$ 	MOVE HIGH-VALUES TO SC2-UIF-PROMPT, 			    SC2-UIF-RESPONSE.$ 	MOVE PROG-ID TO SC2-UIF-PROGRAM-ID.. 	MOVE " Delete User Record " TO SC2-UIF-TITLE.- 	MOVE GENERIC-USER-SCREEN TO SCOPE-FORM-NAME.H1 	PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXIT.F 230-DISPLAY-GENERIC-NAME.T3 	MOVE FNO-SC2-UIF-GENERIC-NAME TO SCOPE-NEXT-FIELD.E 	MOVE "K" TO DISPLAY-HOLD.; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT. ) 	IF USER-MENU GO TO 230-DELETE-USER-EXIT.L% 	IF USER-ABORT GO TO 230-DELETE-USER. 9 	IF NOT USER-VALID-ESCAPE GO TO 230-DISPLAY-GENERIC-NAME.O+ 	MOVE SC2-UIF-GENERIC-NAME TO WS-USERNAME,   				 WS-GENERIC-NAME.O( 	MOVE WS-USER-RECORD TO USERNAME-RECORD./ 	PERFORM 660-READ-USER THRU 660-READ-USER-EXIT.* 	IF INVALID-KEYS+ 	    MOVE NO-SUCH-RECORD TO SCOPE-ERROR-MSG*4 	    PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT# 	    GO TO 230-DISPLAY-GENERIC-NAME" 	ELSE-: 	    MOVE WS-TOP-LEVEL-MENU-NAME TO SC2-UIF-TOP-LEVEL-MENU8 	    MOVE FNO-SC2-UIF-TOP-LEVEL-MENU TO SCOPE-NEXT-FIELD4 	    PERFORM 692-CALL-SCPWF THRU 692-CALL-SCPWF-EXIT 	END-IF.   230-CONFIRM-DELETE-IT.( 	MOVE DELETE-QUESTION TO SC2-UIF-PROMPT.- 	MOVE FNO-SC2-UIF-PROMPT TO SCOPE-NEXT-FIELD.L1 	PERFORM 692-CALL-SCPWF THRU 692-CALL-SCPWF-EXIT.E/ 	MOVE FNO-SC2-UIF-RESPONSE TO SCOPE-NEXT-FIELD.i; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.t) 	IF USER-MENU GO TO 230-DELETE-USER-EXIT.e% 	IF USER-ABORT GO TO 230-DELETE-USER.a6 	IF NOT USER-VALID-ESCAPE GO TO 230-CONFIRM-DELETE-IT.= 	STRING SC2-UIF-RESPONSE DELIMITED BY SIZE INTO UIF-RESPONSE.M$ 	MOVE HIGH-VALUES TO SC2-UIF-PROMPT, 			    SC2-UIF-RESPONSE. 	EVALUATE UIF-RESPONSE! 	    WHEN "Y"	GO TO 230-DELETE-ITN, 	    WHEN "N"	MOVE DELETE-CAN TO DISPLAY-MSG2 			PERFORM 808-CALL-SCPEN THRU 808-CALL-SCPEN-EXIT 			GO TO 230-DELETE-USER/ 	    WHEN OTHER	PERFORM 700-RESPONSE-ERROR THRUS 			700-RESPONSE-ERROR-EXIT 			GO TO 230-CONFIRM-DELETE-IT 	END-EVALUATE.   230-DELETE-IT. 	ADD 1 TO CHG-TBL-IDX. *OB * If CHG-TBL-IDX is greater than or equal to table-max, give error *1  	IF CHG-TBL-IDX NOT < TABLE-MAX ) 		MOVE TABLE-FULL-EXIT TO SCOPE-ERROR-MSGM1 		PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXITE 		GO TO 230-DELETE-USER-EXIT.T! 	DELETE UIF-USERNAME-FILE RECORD R
 		INVALID KEYR' 			MOVE DELETE-ERROR TO SCOPE-ERROR-MSGV2 			PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT 			MOVE "N" TO INVALID-KEY-SWV 			GO TO 230-DELETE-USER-EXIT. 	MOVE "Y" TO USER-CHANGE-SW.- 	MOVE "D" TO WS-OTHER-FUNCTION (CHG-TBL-IDX).K) 	MOVE "U" TO WS-OTHER-TYPE (CHG-TBL-IDX).	5 	MOVE WS-GENERIC-NAME TO WS-OTHER-NAME (CHG-TBL-IDX).I 	MOVE DELETE-OK TO DISPLAY-MSG. 0 	PERFORM 808-CALL-SCPEN THRU 808-CALL-SCPEN-EXIT 	GO TO 230-DELETE-USER.-   230-DELETE-USER-EXIT.M 	EXIT.   /- 240-DISPLAY-USER.V 	INITIALIZE WS-USER-RECORD,  		   FORM-SC2.$ 	MOVE HIGH-VALUES TO SC2-UIF-PROMPT, 			    SC2-UIF-RESPONSE.$ 	MOVE PROG-ID TO SC2-UIF-PROGRAM-ID.. 	MOVE "Display User Record " TO SC2-UIF-TITLE.- 	MOVE GENERIC-USER-SCREEN TO SCOPE-FORM-NAME.L1 	PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXIT.E 240-DISPLAY-GENERIC-NAME.-3 	MOVE FNO-SC2-UIF-GENERIC-NAME TO SCOPE-NEXT-FIELD.  	MOVE "K" TO DISPLAY-HOLD.; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.E* 	IF USER-MENU GO TO 240-DISPLAY-USER-EXIT.& 	IF USER-ABORT GO TO 240-DISPLAY-USER.9 	IF NOT USER-VALID-ESCAPE GO TO 240-DISPLAY-GENERIC-NAME.I+ 	MOVE SC2-UIF-GENERIC-NAME TO WS-USERNAME, R 				 WS-GENERIC-NAME.E( 	MOVE WS-USER-RECORD TO USERNAME-RECORD./ 	PERFORM 660-READ-USER THRU 660-READ-USER-EXIT.T 	IF INVALID-KEYE+ 	    MOVE NO-SUCH-RECORD TO SCOPE-ERROR-MSGN4 	    PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT# 	    GO TO 240-DISPLAY-GENERIC-NAME2 	ELSEC: 	    MOVE WS-TOP-LEVEL-MENU-NAME TO SC2-UIF-TOP-LEVEL-MENU8 	    MOVE FNO-SC2-UIF-TOP-LEVEL-MENU TO SCOPE-NEXT-FIELD4 	    PERFORM 692-CALL-SCPWF THRU 692-CALL-SCPWF-EXIT 	END-IF.   240-GET-DISPLAY-RESPONSE.D' 	MOVE DISPLAY-PROMPT TO SC2-UIF-PROMPT.1- 	MOVE FNO-SC2-UIF-PROMPT TO SCOPE-NEXT-FIELD.N1 	PERFORM 692-CALL-SCPWF THRU 692-CALL-SCPWF-EXIT.H/ 	MOVE FNO-SC2-UIF-RESPONSE TO SCOPE-NEXT-FIELD.S; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.R* 	IF USER-MENU GO TO 240-DISPLAY-USER-EXIT.& 	IF USER-ABORT GO TO 240-DISPLAY-USER.9 	IF NOT USER-VALID-ESCAPE GO TO 240-GET-DISPLAY-RESPONSE.I= 	STRING SC2-UIF-RESPONSE DELIMITED BY SIZE INTO UIF-RESPONSE.F$ 	MOVE HIGH-VALUES TO SC2-UIF-PROMPT, 			    SC2-UIF-RESPONSE. 	EVALUATE UIF-RESPONSE' 	    WHEN "F " 		GO TO 240-DISPLAY-USER"0 	    WHEN OTHER		PERFORM 700-RESPONSE-ERROR THRU 				    700-RESPONSE-ERROR-EXITM& 				    GO TO 240-GET-DISPLAY-RESPONSE 	END-EVALUATE. 240-DISPLAY-USER-EXIT. 	EXIT. / 
 250-ADD-MENU.R 	INITIALIZE WS-USER-RECORD,  		   TRACK-COUNT,-  		   WS-TRACK-TRANSACTION-COUNT, 		   FORM-SC4.$ 	MOVE HIGH-VALUES TO SC4-UIF-PROMPT, 			    SC4-UIF-RESPONSE.$ 	MOVE PROG-ID TO SC4-UIF-PROGRAM-ID.. 	MOVE "  Add Menu Record   " TO SC4-UIF-TITLE.% 	MOVE MENU-SCREEN TO SCOPE-FORM-NAME. 1 	PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXIT.( 	MOVE ZEROS TO WS-NODE-CNT.X 	MOVE "N" TO LEVEL-SW, N 		    CORRECTION-SW.7 	PERFORM 410-ADD-MENU-NAME THRU 410-ADD-MENU-NAME-EXIT.C& 	IF USER-MENU GO TO 250-ADD-MENU-EXIT." 	IF USER-ABORT GO TO 250-ADD-MENU.   250-GET-TITLE.1 	MOVE FNO-SC4-UIF-MENU-TITLE TO SCOPE-NEXT-FIELD.- 	MOVE "K" TO DISPLAY-HOLD.; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.W& 	IF USER-MENU GO TO 250-ADD-MENU-EXIT." 	IF USER-ABORT GO TO 250-ADD-MENU.. 	IF NOT USER-VALID-ESCAPE GO TO 250-GET-TITLE. 250-GET-DESCRIPTION.7 	MOVE FNO-SC4-UIF-MENU-DESCRIPTION TO SCOPE-NEXT-FIELD.W; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.I& 	IF USER-MENU GO TO 250-ADD-MENU-EXIT." 	IF USER-ABORT GO TO 250-ADD-MENU.4 	IF NOT USER-VALID-ESCAPE GO TO 250-GET-DESCRIPTION.! 	MOVE 4 TO WS-UIF-FIELD-NUMERIC, D 		  WS-STORE-FIELD.T 	MOVE ZEROS TO OPTION-INDEX., 	COMPUTE NEXT-OPTION-NBR = OPTION-INDEX + 1.   250-GET-OPTION.-- 	MOVE WS-UIF-FIELD-NUMERIC TO WS-STORE-FIELD.T 	IF CORRECTION1 	    MOVE WS-UIF-FIELD-NUMERIC TO NEXT-OPTION-NBRS$ 	    SUBTRACT 3 FROM NEXT-OPTION-NBR7 	    DIVIDE NEXT-OPTION-NBR BY 2 GIVING NEXT-OPTION-NBRO 	    IF EVEN 		ADD 1 TO NEXT-OPTION-NBR *TG * Keep track of the transaction just overridden for later decrement of X * transaction node count.E * 0 		IF (SC4-UIF-OPTION(NEXT-OPTION-NBR) NOT = " ")# 		    MOVE "D" TO WS-HISTORY-SYMBOL ' 		    PERFORM 726-TRACK-TRANS-HIST THRU  			726-TRACK-TRANS-HIST-EXIT 		END-IF 	    END-IFM 	END-IF. 250-EXECUTE-REQUEST. 	IF EVENC 	    MOVE FNO-SC4-OPTION-ARRAY(NEXT-OPTION-NBR) TO SCOPE-NEXT-FIELDI 	ELSESB 	    MOVE FNO-SC4-TYPE-ARRAY(NEXT-OPTION-NBR) TO SCOPE-NEXT-FIELD.; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.	& 	IF USER-MENU GO TO 250-ADD-MENU-EXIT." 	IF USER-ABORT GO TO 250-ADD-MENU.4 	IF NOT USER-VALID-ESCAPE GO TO 250-EXECUTE-REQUEST. *  / 4 * CHECK THAT MENU NAME OR OPTION IS IN PROPER FORMAT   	IF EVEN; 	    MOVE SC4-UIF-OPTION (NEXT-OPTION-NBR) TO WS-NAME-TABLE 4 	    PERFORM 745-CHECK-NAME THRU 745-CHECK-NAME-EXIT 	    EVALUATE SCOPE-ERROR-MSG ) 		WHEN SPACES	GO TO 250-END-OPTIONS-CHECK8' 		WHEN OTHER	INITIALIZE SCOPE-ERROR-MSGS 				GO TO 250-EXECUTE-REQUESTE 	    END-EVALUATE.   250-END-OPTIONS-CHECK.- 	IF SC4-UIF-OPTION (NEXT-OPTION-NBR) = SPACESC- 	    INITIALIZE SC4-UIF-TYPE(NEXT-OPTION-NBR)LA 	    MOVE FNO-SC4-TYPE-ARRAY(NEXT-OPTION-NBR) TO SCOPE-NEXT-FIELD 4 	    PERFORM 692-CALL-SCPWF THRU 692-CALL-SCPWF-EXIT  	    GO TO 250-PROCESS-RESPONSE. *oI * If EVEN, (WS-UIF-FIELD-NUMERIC) you have only processed the record name + * go back and process the record type (M/T)L *  	IF CORRECTION AND EVENi$ 	    MOVE 3 TO WS-UIF-FIELD-NUMERIC, 		WS-STORE-FIELD 	    GO TO 250-EXECUTE-REQUEST 	ELSE  	    IF EVEN! 		MOVE 3 TO WS-UIF-FIELD-NUMERIC,d 		    WS-STORE-FIELD 		GO TO 250-GET-OPTION 	    END-IFe 	END-IF.9 	PERFORM 720-PROCESS-OPTION THRU 720-PROCESS-OPTION-EXIT."   	IF (SCOPE-ERROR-MSG = " ") " 	    MOVE "I" TO WS-HISTORY-SYMBOL& 	    PERFORM 726-TRACK-TRANS-HIST THRU 		726-TRACK-TRANS-HIST-EXIT  	END-IF. 	IF NOT CORRECTION 	    EVALUATE SCOPE-ERROR-MSG2 		WHEN SPACES # 				MOVE 4 TO WS-UIF-FIELD-NUMERIC,A 				    WS-STORE-FIELD	    				ADD 1 TO OPTION-INDEXs. 				COMPUTE NEXT-OPTION-NBR = OPTION-INDEX + 1. 				IF NEXT-OPTION-NBR > MAX-TRANSACT-PER-MENU" 				    GO TO 250-PROCESS-RESPONSE
 				END-IF 				GO TO 250-GET-OPTION, 		WHEN OTHER	MOVE 4 TO WS-UIF-FIELD-NUMERIC, 				    WS-STORE-FIELD	    				INITIALIZE SCOPE-ERROR-MSG, 				INITIALIZE SC4-UIF-TYPE(NEXT-OPTION-NBR), 				MOVE FNO-SC4-TYPE-ARRAY(NEXT-OPTION-NBR) 				    TO SCOPE-NEXT-FIELDT3 				PERFORM 692-CALL-SCPWF THRU 692-CALL-SCPWF-EXITn 				GO TO 250-EXECUTE-REQUESTe 	    END-EVALUATEV 	ELSES 	    EVALUATE SCOPE-ERROR-MSG"( 		WHEN SPACES	GO TO 250-PROCESS-RESPONSE, 		WHEN OTHER	MOVE 4 TO WS-UIF-FIELD-NUMERIC, 				    WS-STORE-FIELD	    				INITIALIZE SCOPE-ERROR-MSG. 				INITIALIZE SC4-UIF-OPTION(NEXT-OPTION-NBR), 				INITIALIZE SC4-UIF-TYPE(NEXT-OPTION-NBR)- 				MOVE FNO-SC4-TYPE-ARRAY(NEXT-OPTION-NBR) L 				    TO SCOPE-NEXT-FIELDo3 				PERFORM 692-CALL-SCPWF THRU 692-CALL-SCPWF-EXIT" 				GO TO 250-EXECUTE-REQUEST  	    END-EVALUATEP 	END-IF.   /  250-PROCESS-RESPONSE.d( 	MOVE STANDARD-PROMPT TO SC4-UIF-PROMPT.- 	MOVE FNO-SC4-UIF-PROMPT TO SCOPE-NEXT-FIELD.01 	PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXIT.e! 	MOVE "R " TO WS-UIF-FIELD-ALPHA.,/ 	MOVE FNO-SC4-UIF-RESPONSE TO SCOPE-NEXT-FIELD.8; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.'& 	IF USER-MENU GO TO 250-ADD-MENU-EXIT." 	IF USER-ABORT GO TO 250-ADD-MENU.5 	IF NOT USER-VALID-ESCAPE GO TO 250-PROCESS-RESPONSE.E= 	STRING SC4-UIF-RESPONSE DELIMITED BY SIZE INTO UIF-RESPONSE.E& 	MOVE HIGH-VALUES TO SC4-UIF-RESPONSE, 	    SC4-UIF-PROMPT.1 	PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXIT.I 	EVALUATE UIF-RESPONSE2 	    WHEN "P ",	PERFORM 445-RESET-TRAN-COUNT THRU  				445-RESET-TRAN-COUNT-EXITC 			GO TO 250-WRITE-MENU4 	END-EVALUATE.   250-EVALUATE-RESPONSE.- 	MOVE WS-STORE-FIELD TO WS-UIF-FIELD-NUMERIC.03 	PERFORM 710-STORE-FIELD THRU 710-STORE-FIELD-EXIT.I 	EVALUATE WS-UIF-FIELD-NUMERICC 	    WHEN 1,		PERFORM 410-ADD-MENU-NAME THRU 410-ADD-MENU-NAME-EXIT  				GO TO 250-PROCESS-RESPONSE? 	    WHEN 2,     	PERFORM 420-GET-TITLE THRU 420-GET-TITLE-EXITC 				GO TO 250-PROCESS-RESPONSEK 	    WHEN 3,     	PERFORM 430-GET-DESCRIPTION THRU 430-GET-DESCRIPTION-EXIT0 				GO TO 250-PROCESS-RESPONSE. 	    WHEN 4 THRU 43,	MOVE "Y" TO CORRECTION-SW 				GO TO 250-GET-OPTIONH 	    WHEN OTHER		PERFORM 700-RESPONSE-ERROR THRU 700-RESPONSE-ERROR-EXIT 				GO TO 250-PROCESS-RESPONSE 	END-EVALUATE.   250-WRITE-MENU.Y? 	PERFORM 440-BUILD-MENU-RECORD THRU 440-BUILD-MENU-RECORD-EXIT.S 	EVALUATE SCOPE-ERROR-MSGW$ 	    WHEN SPACES		GO TO 250-ADD-MENU+ 	    WHEN OTHER		INITIALIZE SCOPE-ERROR-MSGE 				GO TO 250-PROCESS-RESPONSE 	END-EVALUATE. 250-ADD-MENU-EXIT. 	EXIT.   /- 260-CHANGE-MENU. 	MOVE "Y" TO MENU-SW,  		    CHANGE-MENU-SW.I 	MOVE 1 TO L-SUB.  	INITIALIZE WS-USER-RECORD,  		   TRACK-COUNT,0  		   WS-TRACK-TRANSACTION-COUNT, 		   FORM-SC4.$ 	MOVE HIGH-VALUES TO SC4-UIF-PROMPT, 			    SC4-UIF-RESPONSE.$ 	MOVE PROG-ID TO SC4-UIF-PROGRAM-ID.. 	MOVE " Change Menu Record " TO SC4-UIF-TITLE.% 	MOVE MENU-SCREEN TO SCOPE-FORM-NAME.-1 	PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXIT.C: 	PERFORM	280-DISPLAY-MENU-NAME THRU 280-DISPLAY-MENU-EXIT.) 	IF USER-MENU GO TO 260-CHANGE-MENU-EXIT. % 	IF USER-ABORT GO TO 260-CHANGE-MENU.  *E1 * STORE ORIGINAL INFORMATION FOR LATER COMPARISONT *-+ 	MOVE SC4-UIF-MENU TO WS-STORE-UIF (L-SUB).O 260-GET-RESPONSE. ( 	MOVE STANDARD-PROMPT TO SC4-UIF-PROMPT.- 	MOVE FNO-SC4-UIF-PROMPT TO SCOPE-NEXT-FIELD.01 	PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXIT.W 	MOVE ZEROS TO OPTION-INDEX,   		      WS-UIF-FIELD-NUMERIC,  		      WS-STORE-FIELD.   ! 	MOVE "R " TO WS-UIF-FIELD-ALPHA.E/ 	MOVE FNO-SC4-UIF-RESPONSE TO SCOPE-NEXT-FIELD.P; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.2 	GO TO 260-EVALUATE-RESPONSE.E   260-GET-OPTION.T- 	MOVE WS-UIF-FIELD-NUMERIC TO WS-STORE-FIELD,T 	    			     NEXT-OPTION-NBR. ! 	SUBTRACT 3 FROM NEXT-OPTION-NBR.H4 	DIVIDE NEXT-OPTION-NBR BY 2 GIVING NEXT-OPTION-NBR." 	IF EVEN ADD 1 TO NEXT-OPTION-NBR. 260-EXECUTE-REQUEST. 	IF EVEN *	G * Keep track of the transaction just overridden for later decrement of T * transaction node count.E *I3 	    IF (SC4-UIF-OPTION(NEXT-OPTION-NBR) NOT = " ")C 		MOVE "D" TO WS-HISTORY-SYMBOLC# 		PERFORM 726-TRACK-TRANS-HIST THRUE 		    726-TRACK-TRANS-HIST-EXITE 	    END-IFPC 	    MOVE FNO-SC4-OPTION-ARRAY(NEXT-OPTION-NBR) TO SCOPE-NEXT-FIELDT 	ELSENA 	    MOVE FNO-SC4-TYPE-ARRAY(NEXT-OPTION-NBR) TO SCOPE-NEXT-FIELD- 	END-IF.; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.9) 	IF USER-MENU GO TO 260-CHANGE-MENU-EXIT.T% 	IF USER-ABORT GO TO 260-CHANGE-MENU.T4 	IF NOT USER-VALID-ESCAPE GO TO 260-EXECUTE-REQUEST. / 4 * CHECK THAT MENU NAME OR OPTION IS IN PROPER FORMAT *M   	IF EVEN; 	    MOVE SC4-UIF-OPTION (NEXT-OPTION-NBR) TO WS-NAME-TABLE	4 	    PERFORM 745-CHECK-NAME THRU 745-CHECK-NAME-EXIT 	    EVALUATE SCOPE-ERROR-MSGE) 		WHEN SPACES	GO TO 260-END-OPTIONS-CHECKR' 		WHEN OTHER	INITIALIZE SCOPE-ERROR-MSGM 				GO TO 260-GET-OPTION 	    END-EVALUATE.   260-END-OPTIONS-CHECK.- 	IF SC4-UIF-OPTION (NEXT-OPTION-NBR) = SPACESZ- 	    INITIALIZE SC4-UIF-TYPE(NEXT-OPTION-NBR)-A 	    MOVE FNO-SC4-TYPE-ARRAY(NEXT-OPTION-NBR) TO SCOPE-NEXT-FIELDU4 	    PERFORM 692-CALL-SCPWF THRU 692-CALL-SCPWF-EXIT 	    GO TO 260-GET-RESPONSE  	END-IF. *oI * If EVEN, (WS-UIF-FIELD-NUMERIC) you have only processed the record name6+ * go back and process the record type (M/T)V *E 	IF EVEN$ 	    MOVE 3 TO WS-UIF-FIELD-NUMERIC, 		WS-STORE-FIELD 	    GO TO 260-EXECUTE-REQUEST 	END-IF.9 	PERFORM 720-PROCESS-OPTION THRU 720-PROCESS-OPTION-EXIT.  	IF (SCOPE-ERROR-MSG = " ") " 	    MOVE "I" TO WS-HISTORY-SYMBOL& 	    PERFORM 726-TRACK-TRANS-HIST THRU 		726-TRACK-TRANS-HIST-EXITP 	END-IF. 	EVALUATE SCOPE-ERROR-MSGX' 	    WHEN SPACES	GO TO 260-GET-RESPONSE / 	    WHEN OTHER	MOVE 4 TO WS-UIF-FIELD-NUMERIC,M 				  WS-STORE-FIELD	    			INITIALIZE SCOPE-ERROR-MSG-- 			INITIALIZE SC4-UIF-OPTION(NEXT-OPTION-NBR)P+ 			INITIALIZE SC4-UIF-TYPE(NEXT-OPTION-NBR)U, 			MOVE FNO-SC4-TYPE-ARRAY(NEXT-OPTION-NBR)  			    TO SCOPE-NEXT-FIELD2 			PERFORM 692-CALL-SCPWF THRU 692-CALL-SCPWF-EXIT 			GO TO 260-EXECUTE-REQUEST 	    END-EVALUATE.   260-EVALUATE-RESPONSE.) 	IF USER-MENU GO TO 260-CHANGE-MENU-EXIT.O% 	IF USER-ABORT GO TO 260-CHANGE-MENU.R1 	IF NOT USER-VALID-ESCAPE GO TO 260-GET-RESPONSE.U= 	STRING SC4-UIF-RESPONSE DELIMITED BY SIZE INTO UIF-RESPONSE. & 	MOVE HIGH-VALUES TO SC4-UIF-RESPONSE, 	    SC4-UIF-PROMPT.1 	PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXIT.G 	EVALUATE UIF-RESPONSE1 	    WHEN "P ",	PERFORM 445-RESET-TRAN-COUNT THRUp 				445-RESET-TRAN-COUNT-EXIT	 			GO TO 260-REWRITE-MENUn 	END-EVALUATE.- 	MOVE WS-STORE-FIELD TO WS-UIF-FIELD-NUMERIC.X3 	PERFORM 710-STORE-FIELD THRU 710-STORE-FIELD-EXIT.Y 	EVALUATE WS-UIF-FIELD-NUMERIC8 		WHEN 2,		PERFORM 420-GET-TITLE THRU 420-GET-TITLE-EXIT+ 				IF USER-MENU GO TO 260-CHANGE-MENU-EXIT.
 				END-IF' 				IF USER-ABORT GO TO 260-CHANGE-MENUN
 				END-IF 				GO TO 260-GET-RESPONSEH 		WHEN 3,     	PERFORM 430-GET-DESCRIPTION THRU 430-GET-DESCRIPTION-EXIT+ 				IF USER-MENU GO TO 260-CHANGE-MENU-EXITX
 				END-IF' 				IF USER-ABORT GO TO 260-CHANGE-MENUR
 				END-IF 				GO TO 260-GET-RESPONSE& 		WHEN 4 THRU 43,	GO TO 260-GET-OPTIOND 		WHEN OTHER	PERFORM 700-RESPONSE-ERROR THRU 700-RESPONSE-ERROR-EXIT 				GO TO 260-GET-RESPONSE 	END-EVALUATE.   260-REWRITE-MENU. C 	PERFORM 450-REBUILD-MENU-RECORD THRU 450-REBUILD-MENU-RECORD-EXIT.  	EVALUATE SCOPE-ERROR-MSGA' 	    WHEN SPACES		GO TO 260-CHANGE-MENUO+ 	    WHEN OTHER		INITIALIZE SCOPE-ERROR-MSG5 				GO TO 260-GET-RESPONSE 	END-EVALUATE. 260-CHANGE-MENU-EXIT.I 	EXIT.   /I 270-DELETE-MENU. 	MOVE "Y" TO MENU-SW.I 	INITIALIZE WS-MASTER-RECORD,  		   FORM-SC4.$ 	MOVE HIGH-VALUES TO SC4-UIF-PROMPT, 			    SC4-UIF-RESPONSE.$ 	MOVE PROG-ID TO SC4-UIF-PROGRAM-ID.. 	MOVE " Delete Menu Record " TO SC4-UIF-TITLE.% 	MOVE MENU-SCREEN TO SCOPE-FORM-NAME.a1 	PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXIT.r: 	PERFORM	280-DISPLAY-MENU-NAME THRU 280-DISPLAY-MENU-EXIT.) 	IF USER-MENU GO TO 270-DELETE-MENU-EXIT.S% 	IF USER-ABORT GO TO 270-DELETE-MENU.E 270-CONFIRM-DELETE-IT.( 	MOVE DELETE-QUESTION TO SC4-UIF-PROMPT.- 	MOVE FNO-SC4-UIF-PROMPT TO SCOPE-NEXT-FIELD.E1 	PERFORM 692-CALL-SCPWF THRU 692-CALL-SCPWF-EXIT.7/ 	MOVE FNO-SC4-UIF-RESPONSE TO SCOPE-NEXT-FIELD.= 	MOVE ZEROS TO NODE-INDEX.! 	MOVE "R " TO WS-UIF-FIELD-ALPHA.A; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.I= 	STRING SC4-UIF-RESPONSE DELIMITED BY SIZE INTO UIF-RESPONSE. $ 	MOVE HIGH-VALUES TO SC4-UIF-PROMPT, 	    SC4-UIF-RESPONSE.1 	PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXIT.O) 	IF USER-MENU GO TO 270-DELETE-MENU-EXIT.P% 	IF USER-ABORT GO TO 270-DELETE-MENU. 6 	IF NOT USER-VALID-ESCAPE GO TO 270-CONFIRM-DELETE-IT. 	EVALUATE UIF-RESPONSE  		WHEN "Y " 	GO TO 270-DELETE-IT* 		WHEN "N "	MOVE DELETE-CAN TO DISPLAY-MSG3 				PERFORM 808-CALL-SCPEN THRU 808-CALL-SCPEN-EXITO 				GO TO 270-DELETE-MENUP, 		WHEN OTHER	PERFORM 700-RESPONSE-ERROR THRU 					700-RESPONSE-ERROR-EXIT 				GO TO 270-CONFIRM-DELETE-IT  	END-EVALUATE. /T 270-DELETE-IT. 	ADD 1 TO NODE-INDEX. ( 	IF SC4-UIF-OPTION (NODE-INDEX) = SPACES 		NEXT SENTENCEC 	ELSEP; 		MOVE SC4-UIF-OPTION (NODE-INDEX) TO WS-MASTER-RECORD-NAMES9 		MOVE SC4-UIF-TYPE (NODE-INDEX) TO WS-MASTER-RECORD-TYPEA2 		MOVE WS-MASTER-PRIMARY-KEY TO MASTER-PRIMARY-KEY3 		PERFORM 600-READ-MASTER THRU 600-READ-MASTER-EXIT- 		IF INVALID-KEY) 			MOVE NO-CORR-RECORD TO SCOPE-ERROR-MSGE2 			PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT 			GO TO 270-DELETE-IT 		ELSE0 			SUBTRACT 1 FROM WS-MASTER-RECORD-ACCESS-COUNT: 			PERFORM 655-REWRITE-MASTER THRU 655-REWRITE-MASTER-EXIT 			IF INVALID-KEYP) 				MOVE REWRITE-ERROR TO SCOPE-ERROR-MSGU3 				PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXITP 				GO TO 270-DELETE-MENUP 			ELSEC 				GO TO 270-DELETE-IT.  1 	MOVE SC4-UIF-MENU-NAME TO WS-MASTER-RECORD-NAME. # 	MOVE "M" TO WS-MASTER-RECORD-TYPE..2 	MOVE WS-MASTER-PRIMARY-KEY TO MASTER-PRIMARY-KEY. 	DELETE UIF-MASTER-FILE RECORD P
 		INVALID KEY ' 			MOVE DELETE-ERROR TO SCOPE-ERROR-MSGI2 			PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT 			GO TO 270-DELETE-MENU.R   	MOVE DELETE-OK TO DISPLAY-MSG.C1 	PERFORM 808-CALL-SCPEN THRU 808-CALL-SCPEN-EXIT.	 	MOVE "Y" TO STRUCTURE-SW.   	GO TO 270-DELETE-MENU.C   270-DELETE-MENU-EXIT.W 	EXIT.   /E 280-DISPLAY-MENU.- 	INITIALIZE WS-MASTER-RECORD,  		   FORM-SC4.$ 	MOVE HIGH-VALUES TO SC4-UIF-PROMPT, 			    SC4-UIF-RESPONSE.$ 	MOVE PROG-ID TO SC4-UIF-PROGRAM-ID.. 	MOVE " Display Menu Record" TO SC4-UIF-TITLE.% 	MOVE MENU-SCREEN TO SCOPE-FORM-NAME.-1 	PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXIT.-   280-DISPLAY-MENU-NAME.0 	MOVE FNO-SC4-UIF-MENU-NAME TO SCOPE-NEXT-FIELD.  	MOVE 1 TO WS-UIF-FIELD-NUMERIC. 	MOVE "K" TO DISPLAY-HOLD.; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT. * 	IF USER-MENU GO TO 280-DISPLAY-MENU-EXIT.+ 	IF USER-ABORT GO TO 280-DISPLAY-MENU-NAME.O6 	IF NOT USER-VALID-ESCAPE GO TO 280-DISPLAY-MENU-NAME.1 	MOVE SC4-UIF-MENU-NAME TO WS-MASTER-RECORD-NAME.M# 	MOVE "M" TO WS-MASTER-RECORD-TYPE.-2 	MOVE WS-MASTER-PRIMARY-KEY TO MASTER-PRIMARY-KEY.3 	PERFORM 600-READ-MASTER THRU 600-READ-MASTER-EXIT.I 	IF INVALID-KEYO( 		MOVE NO-SUCH-RECORD TO SCOPE-ERROR-MSG1 		PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT- 		GO TO 280-DISPLAY-MENU-NAME- 	ELSE	 		IF L-SUB = 0 W 			MOVE 1 TO L-SUB 		END-IFC 		MOVE WS-MASTER-RECORD-ACCESS-COUNT TO WS-STORE-ACCESS-CNT (L-SUB)-1 		MOVE WS-MASTER-MENU-TITLE TO SC4-UIF-MENU-TITLEF= 		MOVE WS-MASTER-MENU-DESCRIPTION TO SC4-UIF-MENU-DESCRIPTIONO, 		MOVE WS-MASTER-MENU-NODE-CNT TO UIF-FIELD, 						WS-ORIG-NODE-CNT 		MOVE ZEROS TO NODE-INDEX* 		MOVE MASTER-MENU-NODE-CNT TO WS-NODE-CNT4 		PERFORM 740-GET-OPTIONS THRU 740-GET-OPTIONS-EXIT.2 		PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXIT.   280-GET-DESCRIPTION-RESPONSE.A
 	IF FROM-MENU  		MOVE "N" TO MENU-SWA 		GO TO 280-DISPLAY-MENU-EXIT.  	MOVE "R" TO WS-UIF-FIELD-ALPHA.' 	MOVE DISPLAY-PROMPT TO SC4-UIF-PROMPT.N- 	MOVE FNO-SC4-UIF-PROMPT TO SCOPE-NEXT-FIELD.I1 	PERFORM 692-CALL-SCPWF THRU 692-CALL-SCPWF-EXIT.C/ 	MOVE FNO-SC4-UIF-RESPONSE TO SCOPE-NEXT-FIELD.T; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.E= 	STRING SC4-UIF-RESPONSE DELIMITED BY SIZE INTO UIF-RESPONSE.I$ 	MOVE HIGH-VALUES TO SC4-UIF-PROMPT, 	    SC4-UIF-RESPONSE.1 	PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXIT.T* 	IF USER-MENU GO TO 280-DISPLAY-MENU-EXIT.& 	IF USER-ABORT GO TO 280-DISPLAY-MENU.= 	IF NOT USER-VALID-ESCAPE GO TO 280-GET-DESCRIPTION-RESPONSE.H 	EVALUATE UIF-RESPONSE# 		WHEN "F "		GO TO 280-DISPLAY-MENUV- 		WHEN OTHER		PERFORM 700-RESPONSE-ERROR THRUS 						700-RESPONSE-ERROR-EXITo' 					GO TO 280-GET-DESCRIPTION-RESPONSEe 	END-EVALUATE. 280-DISPLAY-MENU-EXIT. 	EXIT. /  290-ADD-TRANSACTION. 	INITIALIZE WS-MASTER-RECORD,  		   FORM-SC3. 	MOVE "N" TO CORRECTION-SW.-$ 	MOVE HIGH-VALUES TO SC3-UIF-PROMPT, 			    SC3-UIF-RESPONSE.$ 	MOVE PROG-ID TO SC3-UIF-PROGRAM-ID.. 	MOVE "  Add Transaction   " TO SC3-UIF-TITLE.& 	MOVE TRANS-SCREEN TO SCOPE-FORM-NAME.1 	PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXIT.-   290-ADD-TRANSACTION-NAME.S  4 * IF ADD TRANS FROM ADD MENU, ALREADY HAVE MENU NAME *O 	IF TRANS-FROM-MENU  		IF CORRECTION  			MOVE "N" TO CORRECTION-SW+ 			MOVE INVALID-RESPONSE TO SCOPE-ERROR-MSGE2 			PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT 			GO TO 290-GET-TRANS-RESPONSE. 		ELSE3 			MOVE WS-STORE-OPTION TO SC3-UIF-TRANSACTION-NAMEe 			GO TO 290-GET-DESCRIPTION. 7 	MOVE FNO-SC3-UIF-TRANSACTION-NAME TO SCOPE-NEXT-FIELD.L 	MOVE "K" TO DISPLAY-HOLD.; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.-- 	IF USER-MENU GO TO 290-ADD-TRANSACTION-EXIT.Y) 	IF USER-ABORT GO TO 290-ADD-TRANSACTION.99 	IF NOT USER-VALID-ESCAPE GO TO 290-ADD-TRANSACTION-NAME.E0 	MOVE SC3-UIF-TRANSACTION-NAME TO WS-NAME-TABLE.1 	PERFORM 745-CHECK-NAME THRU 745-CHECK-NAME-EXIT.- 	EVALUATE SCOPE-ERROR-MSGI' 		WHEN SPACES	GO TO 290-TRANS-READ-CONT-' 		WHEN OTHER	INITIALIZE SCOPE-ERROR-MSGR" 				GO TO 290-ADD-TRANSACTION-NAME 	END-EVALUATE.   290-TRANS-READ-CONT.8 	MOVE SC3-UIF-TRANSACTION-NAME TO WS-MASTER-RECORD-NAME.# 	MOVE "T" TO WS-MASTER-RECORD-TYPE.X2 	MOVE WS-MASTER-PRIMARY-KEY TO MASTER-PRIMARY-KEY.3 	PERFORM 600-READ-MASTER THRU 600-READ-MASTER-EXIT.E   * SHOULD BE INVALID ON ADD *E 	IF INVALID-KEYE 	    IF CORRECTION 		MOVE "N" TO CORRECTION-SWL 		GO TO 290-GET-TRANS-RESPONSE	 	    ELSEO 		GO TO 290-GET-DESCRIPTIONM 	    END-IFV 	ELSEY' 		MOVE RECORD-EXISTS TO SCOPE-ERROR-MSG 1 		PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXITR! 		GO TO 290-ADD-TRANSACTION-NAME.S /M 290-GET-DESCRIPTION. 	MOVE "N" TO INVALID-KEY-SW.7 	MOVE FNO-SC3-UIF-TRANSACTION-DESC TO SCOPE-NEXT-FIELD.-; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.M- 	IF USER-MENU GO TO 290-ADD-TRANSACTION-EXIT.D) 	IF USER-ABORT GO TO 290-ADD-TRANSACTION.I4 	IF NOT USER-VALID-ESCAPE GO TO 290-GET-DESCRIPTION. 	IF CORRECTION 	    MOVE "N" TO CORRECTION-SW! 	    GO TO 290-GET-TRANS-RESPONSER 	END-IF.  
 290-GET-TYPE.R7 	MOVE FNO-SC3-UIF-TRANSACTION-TYPE TO SCOPE-NEXT-FIELD.N; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.O- 	IF USER-MENU GO TO 290-ADD-TRANSACTION-EXIT.S) 	IF USER-ABORT GO TO 290-ADD-TRANSACTION.T- 	IF NOT USER-VALID-ESCAPE GO TO 290-GET-TYPE.P 	IF CORRECTION 	    MOVE "N" TO CORRECTION-SW! 	    GO TO 290-GET-TRANS-RESPONSE0 	END-IF.
 290-GET-FORM.27 	MOVE FNO-SC3-UIF-TRANSACTION-FORM TO SCOPE-NEXT-FIELD.0; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.O- 	IF USER-MENU GO TO 290-ADD-TRANSACTION-EXIT.R) 	IF USER-ABORT GO TO 290-ADD-TRANSACTION.C- 	IF NOT USER-VALID-ESCAPE GO TO 290-GET-FORM.x 	IF CORRECTION 	    MOVE "N" TO CORRECTION-SW! 	    GO TO 290-GET-TRANS-RESPONSE- 	END-IF. 290-GET-SWITCH.A9 	MOVE FNO-SC3-UIF-TRANSACTION-SWITCH TO SCOPE-NEXT-FIELD.-; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.M- 	IF USER-MENU GO TO 290-ADD-TRANSACTION-EXIT.P) 	IF USER-ABORT GO TO 290-ADD-TRANSACTION. / 	IF NOT USER-VALID-ESCAPE GO TO 290-GET-SWITCH.S 	IF CORRECTION 	    MOVE "N" TO CORRECTION-SW! 	    GO TO 290-GET-TRANS-RESPONSEC 	END-IF.   290-GET-TRANS-RESPONSE. - 	MOVE FNO-SC3-UIF-PROMPT TO SCOPE-NEXT-FIELD.E( 	MOVE STANDARD-PROMPT TO SC3-UIF-PROMPT.1 	PERFORM 692-CALL-SCPWF THRU 692-CALL-SCPWF-EXIT. / 	MOVE FNO-SC3-UIF-RESPONSE TO SCOPE-NEXT-FIELD.B; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT. = 	STRING SC3-UIF-RESPONSE DELIMITED BY SIZE INTO UIF-RESPONSE.W$ 	MOVE HIGH-VALUES TO SC3-UIF-PROMPT, 	    SC3-UIF-RESPONSE.1 	PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXIT. - 	IF USER-MENU GO TO 290-ADD-TRANSACTION-EXIT.U) 	IF USER-ABORT GO TO 290-ADD-TRANSACTION.L7 	IF NOT USER-VALID-ESCAPE GO TO 290-GET-TRANS-RESPONSE.R 	EVALUATE UIF-RESPONSE) 		WHEN "P ",		GO TO 290-WRITE-TRANSACTIONI' 		WHEN "1 ",		MOVE "Y" TO CORRECTION-SWO# 					GO TO 290-ADD-TRANSACTION-NAMEW' 		WHEN "2 ",		MOVE "Y" TO CORRECTION-SW- 					GO TO 290-GET-DESCRIPTION' 		WHEN "3 ",		MOVE "Y" TO CORRECTION-SWV 					GO TO 290-GET-TYPEP' 		WHEN "4 ",		MOVE "Y" TO CORRECTION-SWT 					GO TO 290-GET-FORMR' 		WHEN "5 ",		MOVE "Y" TO CORRECTION-SWS 					GO TO 290-GET-SWITCHS- 		WHEN OTHER		PERFORM 700-RESPONSE-ERROR THRUA 						700-RESPONSE-ERROR-EXIT-! 					GO TO 290-GET-TRANS-RESPONSE	 	END-EVALUATE.   290-WRITE-TRANSACTION.8 	MOVE SC3-UIF-TRANSACTION-NAME TO WS-MASTER-RECORD-NAME.# 	MOVE "T" TO WS-MASTER-RECORD-TYPE.V& 	MOVE SPACES TO WS-MASTER-TRANSACTION.= 	MOVE SC3-UIF-TRANSACTION-DESC TO WS-MASTER-TRANSACTION-DESC.2= 	MOVE SC3-UIF-TRANSACTION-TYPE TO WS-MASTER-TRANSACTION-TYPE.A= 	MOVE SC3-UIF-TRANSACTION-FORM TO WS-MASTER-TRANSACTION-FORM.EA 	MOVE SC3-UIF-TRANSACTION-SWITCH TO WS-MASTER-TRANSACTION-SWITCH.C 	IF TRANS-FROM-MENU ) 		MOVE 1 TO WS-MASTER-RECORD-ACCESS-COUNTO 	ELSE2. 		MOVE ZEROS TO WS-MASTER-RECORD-ACCESS-COUNT.5 	PERFORM 650-WRITE-MASTER THRU 650-WRITE-MASTER-EXIT.W 	IF INVALID-KEYN& 		MOVE WRITE-ERROR TO SCOPE-ERROR-MSG, 				    WS-STORE-MESSAGE1 		PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT  		MOVE "N" TO INVALID-KEY-SW 		GO TO 290-ADD-TRANSACTION.# 	MOVE RECORD-ADDED TO DISPLAY-MSG, O 			     WS-STORE-MESSAGE. 0 	PERFORM 808-CALL-SCPEN THRU 808-CALL-SCPEN-EXIT   	IF TRANS-FROM-MENUH  		GO TO 290-ADD-TRANSACTION-EXIT 	ELSEF 		GO TO 290-ADD-TRANSACTION.   290-ADD-TRANSACTION-EXIT.- 	EXIT.   /  300-CHANGE-TRANSACTION.A 	INITIALIZE WS-MASTER-RECORD,  		   FORM-SC3. 	MOVE "N" TO CORRECTION-SW.O$ 	MOVE HIGH-VALUES TO SC3-UIF-PROMPT, 			    SC3-UIF-RESPONSE.$ 	MOVE PROG-ID TO SC3-UIF-PROGRAM-ID.. 	MOVE " Change Transaction " TO SC3-UIF-TITLE.& 	MOVE TRANS-SCREEN TO SCOPE-FORM-NAME.1 	PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXIT.m 300-ENTER-TRANSACTION-CHANGE.-7 	MOVE FNO-SC3-UIF-TRANSACTION-NAME TO SCOPE-NEXT-FIELD.O 	MOVE "K" TO DISPLAY-HOLD.; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.T= 	STRING SC3-UIF-RESPONSE DELIMITED BY SIZE INTO UIF-RESPONSE.E1 	PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXIT.-0 	IF USER-MENU GO TO 300-CHANGE-TRANSACTION-EXIT., 	IF USER-ABORT GO TO 300-CHANGE-TRANSACTION.= 	IF NOT USER-VALID-ESCAPE GO TO 300-ENTER-TRANSACTION-CHANGE.H8 	MOVE SC3-UIF-TRANSACTION-NAME TO WS-MASTER-RECORD-NAME.# 	MOVE "T" TO WS-MASTER-RECORD-TYPE.E2 	MOVE WS-MASTER-PRIMARY-KEY TO MASTER-PRIMARY-KEY.3 	PERFORM 600-READ-MASTER THRU 600-READ-MASTER-EXIT.  	IF INVALID-KEYR( 		MOVE NO-SUCH-RECORD TO SCOPE-ERROR-MSG1 		PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT $ 		GO TO 300-ENTER-TRANSACTION-CHANGE   	ELSEO$ 		MOVE WS-MASTER-TRANSACTION-DESC TO 				 SC3-UIF-TRANSACTION-DESC % 		MOVE WS-MASTER-TRANSACTION-TYPE TO - 				SC3-UIF-TRANSACTION-TYPE% 		MOVE WS-MASTER-TRANSACTION-FORM TO C 				SC3-UIF-TRANSACTION-FORM' 		MOVE WS-MASTER-TRANSACTION-SWITCH TO   				SC3-UIF-TRANSACTION-SWITCH1 		PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXITM 	END-IF. 	GO TO 300-GET-RESPONSE.  
 300-GET-DESC.  	MOVE "N" TO INVALID-KEY-SW.7 	MOVE FNO-SC3-UIF-TRANSACTION-DESC TO SCOPE-NEXT-FIELD. ; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT. = 	STRING SC3-UIF-RESPONSE DELIMITED BY SIZE INTO UIF-RESPONSE. 1 	PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXIT.60 	IF USER-MENU GO TO 300-CHANGE-TRANSACTION-EXIT., 	IF USER-ABORT GO TO 300-CHANGE-TRANSACTION.- 	IF NOT USER-VALID-ESCAPE GO TO 300-GET-DESC.L 	GO TO 300-GET-RESPONSE.
 300-GET-TYPE.R7 	MOVE FNO-SC3-UIF-TRANSACTION-TYPE TO SCOPE-NEXT-FIELD.-; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.C0 	IF USER-MENU GO TO 300-CHANGE-TRANSACTION-EXIT., 	IF USER-ABORT GO TO 300-CHANGE-TRANSACTION.- 	IF NOT USER-VALID-ESCAPE GO TO 300-GET-TYPE.I 	GO TO 300-GET-RESPONSE.
 300-GET-FORM.I7 	MOVE FNO-SC3-UIF-TRANSACTION-FORM TO SCOPE-NEXT-FIELD.R; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.T0 	IF USER-MENU GO TO 300-CHANGE-TRANSACTION-EXIT., 	IF USER-ABORT GO TO 300-CHANGE-TRANSACTION.- 	IF NOT USER-VALID-ESCAPE GO TO 300-GET-FORM.  	GO TO 300-GET-RESPONSE. 300-GET-SWITCH.T9 	MOVE FNO-SC3-UIF-TRANSACTION-SWITCH TO SCOPE-NEXT-FIELD.C; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.-0 	IF USER-MENU GO TO 300-CHANGE-TRANSACTION-EXIT., 	IF USER-ABORT GO TO 300-CHANGE-TRANSACTION./ 	IF NOT USER-VALID-ESCAPE GO TO 300-GET-SWITCH.E 	GO TO 300-GET-RESPONSE.   300-GET-RESPONSE.O- 	MOVE FNO-SC3-UIF-PROMPT TO SCOPE-NEXT-FIELD.0( 	MOVE STANDARD-PROMPT TO SC3-UIF-PROMPT.1 	PERFORM 692-CALL-SCPWF THRU 692-CALL-SCPWF-EXIT.-/ 	MOVE FNO-SC3-UIF-RESPONSE TO SCOPE-NEXT-FIELD.I; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.E= 	STRING SC3-UIF-RESPONSE DELIMITED BY SIZE INTO UIF-RESPONSE.F$ 	MOVE HIGH-VALUES TO SC3-UIF-PROMPT, 	    SC3-UIF-RESPONSE.1 	PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXIT.E0 	IF USER-MENU GO TO 300-CHANGE-TRANSACTION-EXIT., 	IF USER-ABORT GO TO 300-CHANGE-TRANSACTION.1 	IF NOT USER-VALID-ESCAPE GO TO 300-GET-RESPONSE.A 	EVALUATE UIF-RESPONSE" 		WHEN "P ",		GO TO 300-REWRITE-IT  		WHEN "2 ",		GO TO 300-GET-DESC  		WHEN "3 ",		GO TO 300-GET-TYPE  		WHEN "4 ",		GO TO 300-GET-FORM" 		WHEN "5 ",		GO TO 300-GET-SWITCH- 		WHEN OTHER		PERFORM 700-RESPONSE-ERROR THRUO 						700-RESPONSE-ERROR-EXITM 					GO TO 300-GET-RESPONSEI 	END-EVALUATE. /- 300-REWRITE-IT.A= 	MOVE SC3-UIF-TRANSACTION-DESC TO WS-MASTER-TRANSACTION-DESC.6= 	MOVE SC3-UIF-TRANSACTION-TYPE TO WS-MASTER-TRANSACTION-TYPE.N= 	MOVE SC3-UIF-TRANSACTION-FORM TO WS-MASTER-TRANSACTION-FORM.DA 	MOVE SC3-UIF-TRANSACTION-SWITCH TO WS-MASTER-TRANSACTION-SWITCH.- 	ADD 1 TO CHG-TBL-IDX.  	IF CHG-TBL-IDX NOT < TABLE-MAX ) 		MOVE TABLE-FULL-EXIT TO SCOPE-ERROR-MSG-1 		PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXITO$ 		GO TO 300-CHANGE-TRANSACTION-EXIT.9 	PERFORM 655-REWRITE-MASTER THRU 655-REWRITE-MASTER-EXIT.- 	IF INVALID-KEY ( 			MOVE REWRITE-ERROR TO SCOPE-ERROR-MSG2 			PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT 			MOVE "N" TO INVALID-KEY-SWM  			GO TO 300-CHANGE-TRANSACTION. 	MOVE CHANGE-OK TO DISPLAY-MSG.-1 	PERFORM 808-CALL-SCPEN THRU 808-CALL-SCPEN-EXIT.N   	GO TO 300-CHANGE-TRANSACTION.   300-CHANGE-TRANSACTION-EXIT. 	EXIT.   /N 310-DELETE-TRANSACTION.N 	INITIALIZE WS-MASTER-RECORD,  		   FORM-SC3.$ 	MOVE HIGH-VALUES TO SC3-UIF-PROMPT, 			    SC3-UIF-RESPONSE.$ 	MOVE PROG-ID TO SC3-UIF-PROGRAM-ID.. 	MOVE " Delete Transaction " TO SC3-UIF-TITLE.& 	MOVE TRANS-SCREEN TO SCOPE-FORM-NAME.1 	PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXIT.O 310-DELETE-TRANS-DISPLAY.-7 	MOVE FNO-SC3-UIF-TRANSACTION-NAME TO SCOPE-NEXT-FIELD.X 	MOVE "K" TO DISPLAY-HOLD.; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.C= 	STRING SC3-UIF-RESPONSE DELIMITED BY SIZE INTO UIF-RESPONSE.I0 	IF USER-MENU GO TO 310-DELETE-TRANSACTION-EXIT., 	IF USER-ABORT GO TO 310-DELETE-TRANSACTION.9 	IF NOT USER-VALID-ESCAPE GO TO 310-DELETE-TRANS-DISPLAY.E8 	MOVE SC3-UIF-TRANSACTION-NAME TO WS-MASTER-RECORD-NAME.# 	MOVE "T" TO WS-MASTER-RECORD-TYPE.92 	MOVE WS-MASTER-PRIMARY-KEY TO MASTER-PRIMARY-KEY.3 	PERFORM 600-READ-MASTER THRU 600-READ-MASTER-EXIT.- 	IF INVALID-KEYO( 		MOVE NO-SUCH-RECORD TO SCOPE-ERROR-MSG1 		PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXITE  		GO TO 310-DELETE-TRANS-DISPLAY 	ELSEO$ 		MOVE WS-MASTER-TRANSACTION-DESC TO 				 SC3-UIF-TRANSACTION-DESCT% 		MOVE WS-MASTER-TRANSACTION-TYPE TO 9 				SC3-UIF-TRANSACTION-TYPE% 		MOVE WS-MASTER-TRANSACTION-FORM TO   				SC3-UIF-TRANSACTION-FORM' 		MOVE WS-MASTER-TRANSACTION-SWITCH TO V 				SC3-UIF-TRANSACTION-SWITCH1 		PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXITH 	END-IF. 310-CONFIRM-DELETE-IT.( 	MOVE DELETE-QUESTION TO SC3-UIF-PROMPT.- 	MOVE FNO-SC3-UIF-PROMPT TO SCOPE-NEXT-FIELD.M1 	PERFORM 692-CALL-SCPWF THRU 692-CALL-SCPWF-EXIT.I/ 	MOVE FNO-SC3-UIF-RESPONSE TO SCOPE-NEXT-FIELD. ; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT. = 	STRING SC3-UIF-RESPONSE DELIMITED BY SIZE INTO UIF-RESPONSE. $ 	MOVE HIGH-VALUES TO SC3-UIF-PROMPT, 	    SC3-UIF-RESPONSE.1 	PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXIT.30 	IF USER-MENU GO TO 310-DELETE-TRANSACTION-EXIT., 	IF USER-ABORT GO TO 310-DELETE-TRANSACTION.6 	IF NOT USER-VALID-ESCAPE GO TO 310-CONFIRM-DELETE-IT. 	EVALUATE UIF-RESPONSE  		WHEN "Y " 	GO TO 310-DELETE-IT* 		WHEN "N "	MOVE DELETE-CAN TO DISPLAY-MSG 				PERFORM 808-CALL-SCPEN THRU3 				    808-CALL-SCPEN-EXITC  				GO TO 310-DELETE-TRANSACTION, 		WHEN OTHER	PERFORM 700-RESPONSE-ERROR THRU 					700-RESPONSE-ERROR-EXIT 				GO TO 310-CONFIRM-DELETE-ITV 	END-EVALUATE.   310-DELETE-IT. 	ADD 1 TO CHG-TBL-IDX. *PB * If CHG-TBL-IDX is greater than or equal to table-max, give error *"  	IF CHG-TBL-IDX NOT < TABLE-MAX ) 		MOVE TABLE-FULL-EXIT TO SCOPE-ERROR-MSG"1 		PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXITN$ 		GO TO 310-DELETE-TRANSACTION-EXIT. 	DELETE UIF-MASTER-FILE RECORD 	
 		INVALID KEYE' 			MOVE DELETE-ERROR TO SCOPE-ERROR-MSGT2 			PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT 			MOVE "N" TO INVALID-KEY-SWN  			GO TO 310-DELETE-TRANSACTION.  - 	MOVE "D" TO WS-OTHER-FUNCTION (CHG-TBL-IDX).O) 	MOVE "T" TO WS-OTHER-TYPE (CHG-TBL-IDX). 9 	MOVE WS-TRANSACTION-NAME TO WS-OTHER-NAME (CHG-TBL-IDX).S   	MOVE DELETE-OK TO DISPLAY-MSG.W1 	PERFORM 808-CALL-SCPEN THRU 808-CALL-SCPEN-EXIT.R 	GO TO 310-DELETE-TRANSACTION.   310-DELETE-TRANSACTION-EXIT. 	EXIT.   /M 320-DISPLAY-TRANSACTION. 	INITIALIZE WS-MASTER-RECORD,  		   FORM-SC3.$ 	MOVE HIGH-VALUES TO SC3-UIF-PROMPT, 			    SC3-UIF-RESPONSE.$ 	MOVE PROG-ID TO SC3-UIF-PROGRAM-ID.. 	MOVE "Display Transaction " TO SC3-UIF-TITLE.& 	MOVE TRANS-SCREEN TO SCOPE-FORM-NAME.1 	PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXIT.    320-DISPLAY-TRANSACTION-NAME.07 	MOVE FNO-SC3-UIF-TRANSACTION-NAME TO SCOPE-NEXT-FIELD.R 	MOVE "K" TO DISPLAY-HOLD.; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.P= 	STRING SC3-UIF-RESPONSE DELIMITED BY SIZE INTO UIF-RESPONSE.T1 	IF USER-MENU GO TO 320-DISPLAY-TRANSACTION-EXIT. 2 	IF USER-ABORT GO TO 320-DISPLAY-TRANSACTION-NAME.= 	IF NOT USER-VALID-ESCAPE GO TO 320-DISPLAY-TRANSACTION-NAME.A8 	MOVE SC3-UIF-TRANSACTION-NAME TO WS-MASTER-RECORD-NAME.# 	MOVE "T" TO WS-MASTER-RECORD-TYPE.02 	MOVE WS-MASTER-PRIMARY-KEY TO MASTER-PRIMARY-KEY.3 	PERFORM 600-READ-MASTER THRU 600-READ-MASTER-EXIT.V 	IF INVALID-KEYS( 		MOVE NO-SUCH-RECORD TO SCOPE-ERROR-MSG1 		PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXITe$ 		GO TO 320-DISPLAY-TRANSACTION-NAME   	ELSEC$ 		MOVE WS-MASTER-TRANSACTION-DESC TO 				 SC3-UIF-TRANSACTION-DESC-% 		MOVE WS-MASTER-TRANSACTION-TYPE TO   				SC3-UIF-TRANSACTION-TYPE% 		MOVE WS-MASTER-TRANSACTION-FORM TO O 				SC3-UIF-TRANSACTION-FORM' 		MOVE WS-MASTER-TRANSACTION-SWITCH TO X 				SC3-UIF-TRANSACTION-SWITCH1 		PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXITC 	END-IF.   320-GET-DESCRIPTION-RESPONSE.S' 	MOVE DISPLAY-PROMPT TO SC3-UIF-PROMPT..- 	MOVE FNO-SC3-UIF-PROMPT TO SCOPE-NEXT-FIELD. 1 	PERFORM 692-CALL-SCPWF THRU 692-CALL-SCPWF-EXIT.O/ 	MOVE FNO-SC3-UIF-RESPONSE TO SCOPE-NEXT-FIELD.M; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.V= 	STRING SC3-UIF-RESPONSE DELIMITED BY SIZE INTO UIF-RESPONSE.A$ 	MOVE HIGH-VALUES TO SC3-UIF-PROMPT, 	    SC3-UIF-RESPONSE.1 	PERFORM 691-CALL-SCPWR THRU 691-CALL-SCPWR-EXIT.A1 	IF USER-MENU GO TO 320-DISPLAY-TRANSACTION-EXIT.E- 	IF USER-ABORT GO TO 320-DISPLAY-TRANSACTION.R= 	IF NOT USER-VALID-ESCAPE GO TO 320-GET-DESCRIPTION-RESPONSE.- 	EVALUATE UIF-RESPONSE+ 		WHEN "F ",		GO TO 320-DISPLAY-TRANSACTION-- 		WHEN OTHER		PERFORM 700-RESPONSE-ERROR THRUA 						700-RESPONSE-ERROR-EXITA' 					GO TO 320-GET-DESCRIPTION-RESPONSET 	END-EVALUATE.   320-DISPLAY-TRANSACTION-EXIT.L 	EXIT. /M 410-ADD-MENU-NAME.  % * NAME CHANGE NOT ALLOWED AT SUB MENU   
 	IF FROM-MENUY. 	    MOVE NO-CHANGE-ALLOWED TO SCOPE-ERROR-MSG4 	    PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT" 	    GO TO 410-ADD-MENU-NAME-EXIT.  0 	MOVE FNO-SC4-UIF-MENU-NAME TO SCOPE-NEXT-FIELD.; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.M+ 	IF USER-MENU GO TO 410-ADD-MENU-NAME-EXIT.S, 	IF USER-ABORT GO TO 410-ADD-MENU-NAME-EXIT.2 	IF NOT USER-VALID-ESCAPE GO TO 410-ADD-MENU-NAME.) 	MOVE SC4-UIF-MENU-NAME TO WS-NAME-TABLE.C1 	PERFORM 745-CHECK-NAME THRU 745-CHECK-NAME-EXIT.O 	EVALUATE SCOPE-ERROR-MSG & 		WHEN SPACES	GO TO 410-MENU-READ-CONT' 		WHEN OTHER	INITIALIZE SCOPE-ERROR-MSG  				GO TO 410-ADD-MENU-NAMER 	END-EVALUATE.   410-MENU-READ-CONT.O1 	MOVE SC4-UIF-MENU-NAME TO WS-MASTER-RECORD-NAME.E# 	MOVE "M" TO WS-MASTER-RECORD-TYPE.O2 	MOVE WS-MASTER-PRIMARY-KEY TO MASTER-PRIMARY-KEY.3 	PERFORM 600-READ-MASTER THRU 600-READ-MASTER-EXIT.     * RECORD SHOULD NOT EXIST ON ADD   	IF INVALID-KEYO! 	    GO TO 410-ADD-MENU-NAME-EXITS 	ELSED* 	    MOVE RECORD-EXISTS TO SCOPE-ERROR-MSG4 	    PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT 	    GO TO 410-ADD-MENU-NAME.    410-ADD-MENU-NAME-EXIT.E 	EXIT. /B 420-GET-TITLE. 	MOVE "N" TO INVALID-KEY-SW.
 	IF FROM-MENUE 	    NEXT SENTENCE 		 	ELSEP' 	    MOVE HIGH-VALUES TO SC4-UIF-PROMPT-4 	    MOVE FNO-SC4-UIF-MENU-TITLE TO SCOPE-NEXT-FIELD? 	    PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.N 420-GET-TITLE-EXIT.- 	EXIT.     430-GET-DESCRIPTION.7 	MOVE FNO-SC4-UIF-MENU-DESCRIPTION TO SCOPE-NEXT-FIELD.V; 	PERFORM 690-EXECUTE-REQUEST THRU 690-EXECUTE-REQUEST-EXIT.  430-GET-DESCRIPTION-EXIT.H 	EXIT. /- 440-BUILD-MENU-RECORD.  7 * COMPRESES OPTIONS SO THERE ARE NO BLANK LINES BETWEENM *C 	MOVE ZEROS TO WS-NODE-CNT,  		      WS-CURR-NODE-END,  		      WS-TMP-NODE-INDEX. 	MOVE 21 TO NODE-INDEX.V3 	PERFORM 725-REORG-NODES THRU 725-REORG-NODES-EXIT.G9 	PERFORM 727-COMPRESS-NODES THRU 727-COMPRESS-NODES-EXIT.T  1 	MOVE SC4-UIF-MENU-NAME TO WS-MASTER-RECORD-NAME.M# 	MOVE "M" TO WS-MASTER-RECORD-TYPE.R1 	MOVE SC4-UIF-MENU-TITLE TO WS-MASTER-MENU-TITLE.	= 	MOVE SC4-UIF-MENU-DESCRIPTION TO WS-MASTER-MENU-DESCRIPTION.X
 	IF FROM-MENUC) 		MOVE 1 TO WS-MASTER-RECORD-ACCESS-COUNT	 	ELSET. 		MOVE ZEROS TO WS-MASTER-RECORD-ACCESS-COUNT.- 	MOVE WS-NODE-CNT TO WS-MASTER-MENU-NODE-CNT.Z 	MOVE ZEROS TO NODE-INDEX./ 	PERFORM 730-GET-NODES THRU 730-GET-NODES-EXIT.R5 	PERFORM 650-WRITE-MASTER THRU 650-WRITE-MASTER-EXIT.  	IF INVALID-KEYE' 		MOVE WRITE-ERROR TO SCOPE-ERROR-MSG, L 				    WS-STORE-MESSAGE1 		PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXITE 		MOVE "N" TO INVALID-KEY-SW 	ELSE  		MOVE "Y" TO STRUCTURE-SW$ 		MOVE RECORD-ADDED TO DISPLAY-MSG,  				     WS-STORE-MESSAGE-2 		PERFORM 808-CALL-SCPEN THRU 808-CALL-SCPEN-EXIT. 440-BUILD-MENU-RECORD-EXIT.M 	EXIT. 445-RESET-TRAN-COUNT.O 	IF (TRACK-COUNT NOT = 0) 7 	    PERFORM 446-RESET-COUNT THRU 446-RESET-COUNT-EXIT U( 		VARYING TRACK-INDEX FROM 1 BY 1 UNTIL 9 		TRACK-INDEX > TRACK-COUNT OR SCOPE-ERROR-MSG NOT = " ".  445-RESET-TRAN-COUNT-EXIT.   446-RESET-COUNT.C 	MOVE TRANSACTION-NAME-TRACK(TRACK-INDEX) TO WS-MASTER-RECORD-NAME.TC 	MOVE TRANSACTION-TYPE-TRACK(TRACK-INDEX) TO WS-MASTER-RECORD-TYPE.	2 	MOVE WS-MASTER-PRIMARY-KEY TO MASTER-PRIMARY-KEY.3 	PERFORM 600-READ-MASTER THRU 600-READ-MASTER-EXIT.    	IF NO-INVALID-KEY *6= * If the user "P"rocessed this menu update, must go back and 3E * increment (adds) or decrement (deletes) all transaction node countsF * which were added/deleted.E *E2 	    IF TRANSACTION-COUNT-INCREMENTED(TRACK-INDEX)( 		ADD 1 TO WS-MASTER-RECORD-ACCESS-COUNT	 	    ELSEN/ 		SUBTRACT 1 FROM WS-MASTER-RECORD-ACCESS-COUNTR 	    END-IF	     	END-IF.9 	PERFORM 655-REWRITE-MASTER THRU 655-REWRITE-MASTER-EXIT.E 	IF INVALID-KEY * 	    MOVE REWRITE-ERROR TO SCOPE-ERROR-MSG4 	    PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT  	    GO TO 446-RESET-COUNT-EXIT. 446-RESET-COUNT-EXIT.  /W 450-REBUILD-MENU-RECORD.  6 * COMPRESSES NODES SO THERE ARE NO BLANKS BETWEEN THEM *- 	MOVE ZEROS TO WS-NODE-CNT,  		       WS-CURR-NODE-END, Y 		       WS-TMP-NODE-INDEX.S 	MOVE 21 TO NODE-INDEX.R 	MOVE 1 TO L-SUB.V3 	PERFORM 725-REORG-NODES THRU 725-REORG-NODES-EXIT.MD 	IF SCOPE-ERROR-MSG NOT = SPACES GO TO 450-REBUILD-MENU-RECORD-EXIT.9 	PERFORM 727-COMPRESS-NODES THRU 727-COMPRESS-NODES-EXIT.OD 	IF SCOPE-ERROR-MSG NOT = SPACES GO TO 450-REBUILD-MENU-RECORD-EXIT.1 	MOVE SC4-UIF-MENU-NAME TO WS-MASTER-RECORD-NAME.O# 	MOVE "M" TO WS-MASTER-RECORD-TYPE.A1 	MOVE SC4-UIF-MENU-TITLE TO WS-MASTER-MENU-TITLE..= 	MOVE SC4-UIF-MENU-DESCRIPTION TO WS-MASTER-MENU-DESCRIPTION.R- 	MOVE WS-NODE-CNT TO WS-MASTER-MENU-NODE-CNT.CC 	MOVE WS-STORE-ACCESS-CNT (L-SUB) TO WS-MASTER-RECORD-ACCESS-COUNT.E 	MOVE ZEROS TO NODE-INDEX./ 	PERFORM 730-GET-NODES THRU 730-GET-NODES-EXIT.P9 	PERFORM 655-REWRITE-MASTER THRU 655-REWRITE-MASTER-EXIT.  	IF INVALID-KEY * 	    MOVE REWRITE-ERROR TO SCOPE-ERROR-MSG4 	    PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT 	ELSE. 	    MOVE "Y" TO STRUCTURE-SW6" 	    MOVE CHANGE-OK TO DISPLAY-MSG4 	    PERFORM 808-CALL-SCPEN THRU 808-CALL-SCPEN-EXIT 	END-IF. 450-REBUILD-MENU-RECORD-EXIT.  	EXIT.   /F 600-READ-MASTER. 	MOVE "N" TO INVALID-KEY-SW.2 	READ UIF-MASTER-FILE RECORD INTO WS-MASTER-RECORD 		INVALID KEY  			MOVE "Y" TO INVALID-KEY-SW.   600-READ-MASTER-EXIT.	 	EXIT.   601-READ-MASTER-NEXT.O 	MOVE "N" TO EXIT-SW.S7 	READ UIF-MASTER-FILE NEXT RECORD INTO WS-MASTER-RECORD-	 		AT END E 			MOVE "Y" TO EXIT-SW.T   601-READ-MASTER-NEXT-EXIT. 	EXIT.   650-WRITE-MASTER.N 	MOVE "N" TO INVALID-KEY-SW.* 	WRITE MASTER-RECORD FROM WS-MASTER-RECORD 		INVALID KEY  			MOVE "Y" TO INVALID-KEY-SW.   650-WRITE-MASTER-EXIT. 	EXIT.   655-REWRITE-MASTER.W 	MOVE "N" TO INVALID-KEY-SW., 	REWRITE MASTER-RECORD FROM WS-MASTER-RECORD 		INVALID KEY  			MOVE "Y" TO INVALID-KEY-SW.   655-REWRITE-MASTER-EXIT. 	EXIT.   660-READ-USER. 	MOVE "N" TO INVALID-KEY-SW.2 	READ UIF-USERNAME-FILE RECORD INTO WS-USER-RECORD 		INVALID KEY  			MOVE "Y" TO INVALID-KEY-SW.   660-READ-USER-EXIT.5 	EXIT.   661-READ-USER-NEXT.A 	MOVE "N" TO EXIT-SW.I7 	READ UIF-USERNAME-FILE NEXT RECORD INTO WS-USER-RECORDT	 		AT END L 			MOVE "Y" TO EXIT-SW.7   661-READ-USER-NEXT-EXIT. 	EXIT.   /E 665-WRITE-USER.  	MOVE "N" TO INVALID-KEY-SW.* 	WRITE USERNAME-RECORD FROM WS-USER-RECORD 		INVALID KEY  			MOVE "Y" TO INVALID-KEY-SW.   665-WRITE-USER-EXIT. 	EXIT.   667-REWRITE-USER.A 	MOVE "N" TO INVALID-KEY-SW., 	REWRITE USERNAME-RECORD FROM WS-USER-RECORD 		INVALID KEY  			MOVE "Y" TO INVALID-KEY-SW.   667-REWRITE-USER-EXIT. 	EXIT.   671-READ-SECURITY-NEXT.- 	MOVE "N" TO EXIT-SW.E; 	READ UIF-SECURITY-FILE NEXT RECORD INTO WS-SECURITY-RECORDU	 		AT END E 			MOVE "Y" TO EXIT-SW.    671-READ-SECURITY-NEXT-EXIT. 	EXIT.   675-WRITE-SECURITY.F 	MOVE "N" TO INVALID-KEY-SW.. 	WRITE SECURITY-RECORD FROM WS-SECURITY-RECORD 		INVALID KEY  			MOVE "Y" TO INVALID-KEY-SW.   675-WRITE-SECURITY-EXIT. 	EXIT.   /E 690-EXECUTE-REQUEST. 	EVALUATE SCOPE-FORM-NAME- 	    WHEN MAIN-MENU-SCREEN+ 		CALL "SCPRF" USING BY DESCRIPTOR FORM-SC1- 	    WHEN GENERIC-USER-SCREENL+ 		CALL "SCPRF" USING BY DESCRIPTOR FORM-SC2K 	    WHEN TRANS-SCREEN+ 		CALL "SCPRF" USING BY DESCRIPTOR FORM-SC3U 	    WHEN MENU-SCREENN+ 		CALL "SCPRF" USING BY DESCRIPTOR FORM-SC4T 	END-EVALUATE.B 	IF SCOPE-ERROR PERFORM 805-SCOPE-ERROR THRU 805-SCOPE-ERROR-EXIT.5 	PERFORM 695-CHECK-ESCAPE THRU 695-CHECK-ESCAPE-EXIT.  690-EXECUTE-REQUEST-EXIT.R 	EXIT.   691-CALL-SCPWR.R 	MOVE 1 TO SCOPE-NEXT-FIELD. 	MOVE 0 TO SCOPE-END-FIELD.T 	EVALUATE SCOPE-FORM-NAME  	    WHEN MAIN-MENU-SCREEN+ 		CALL "SCPWR" USING BY DESCRIPTOR FORM-SC1- 	    WHEN GENERIC-USER-SCREENE+ 		CALL "SCPWR" USING BY DESCRIPTOR FORM-SC2  	    WHEN TRANS-SCREEN+ 		CALL "SCPWR" USING BY DESCRIPTOR FORM-SC3R 	    WHEN MENU-SCREENO+ 		CALL "SCPWR" USING BY DESCRIPTOR FORM-SC4- 	END-EVALUATE.B 	IF SCOPE-ERROR PERFORM 805-SCOPE-ERROR THRU 805-SCOPE-ERROR-EXIT. 691-CALL-SCPWR-EXIT.   692-CALL-SCPWF.T 	EVALUATE SCOPE-FORM-NAME- 	    WHEN MAIN-MENU-SCREEN+ 		CALL "SCPWF" USING BY DESCRIPTOR FORM-SC1O 	    WHEN GENERIC-USER-SCREENN+ 		CALL "SCPWF" USING BY DESCRIPTOR FORM-SC2A 	    WHEN TRANS-SCREEN+ 		CALL "SCPWF" USING BY DESCRIPTOR FORM-SC3  	    WHEN MENU-SCREEN"+ 		CALL "SCPWF" USING BY DESCRIPTOR FORM-SC4. 	END-EVALUATE.B 	IF SCOPE-ERROR PERFORM 805-SCOPE-ERROR THRU 805-SCOPE-ERROR-EXIT. 692-CALL-SCPWF-EXIT. 	EXIT.   695-CHECK-ESCAPE.6 	INITIALIZE USER-ESCAPE. 	IF SCOPE-USER-ESCAPE A 	    STRING SCOPE-ESCAPE-WORD DELIMITED BY SIZE INTO USER-ESCAPE E 	    IF GIVE-DISPLAY 		EVALUATE TRUER 		    WHEN SCOPE-MENU % 			MOVE ACTION-ABORTED TO DISPLAY-MSGV2 			PERFORM 808-CALL-SCPEN THRU 808-CALL-SCPEN-EXIT 		    WHEN SCOPE-ABORT% 			MOVE ACTION-ABORTED TO DISPLAY-MSGC2 			PERFORM 808-CALL-SCPEN THRU 808-CALL-SCPEN-EXIT 		    WHEN OTHER- 			MOVE SCOPE-ERROR-ESCAPE TO SCOPE-ERROR-MSGI2 			PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT 		END-EVALUATE 	    END-IF. 	MOVE "D" TO DISPLAY-HOLD. 695-CHECK-ESCAPE-EXIT. 	EXIT.   700-RESPONSE-ERROR. * 	MOVE INVALID-RESPONSE TO SCOPE-ERROR-MSG.1 	PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT.N   700-RESPONSE-ERROR-EXIT. 	EXIT. /T 710-STORE-FIELD.- 	MOVE WS-UIF-FIELD-NUMERIC TO WS-STORE-FIELD.	 	EVALUATE UIF-RESPONSE* 		WHEN "1 "	MOVE 1 TO WS-UIF-FIELD-NUMERIC* 		WHEN "2 "	MOVE 2 TO WS-UIF-FIELD-NUMERIC* 		WHEN "3 "	MOVE 3 TO WS-UIF-FIELD-NUMERIC* 		WHEN "4 "	MOVE 4 TO WS-UIF-FIELD-NUMERIC* 		WHEN "5 "	MOVE 5 TO WS-UIF-FIELD-NUMERIC* 		WHEN "6 "	MOVE 6 TO WS-UIF-FIELD-NUMERIC* 		WHEN "7 "	MOVE 7 TO WS-UIF-FIELD-NUMERIC* 		WHEN "8 "	MOVE 8 TO WS-UIF-FIELD-NUMERIC* 		WHEN "9 "	MOVE 9 TO WS-UIF-FIELD-NUMERIC+ 		WHEN "10"	MOVE 10 TO WS-UIF-FIELD-NUMERIC + 		WHEN "11"	MOVE 11 TO WS-UIF-FIELD-NUMERICM+ 		WHEN "12"	MOVE 12 TO WS-UIF-FIELD-NUMERICN+ 		WHEN "13"	MOVE 13 TO WS-UIF-FIELD-NUMERICX+ 		WHEN "14"	MOVE 14 TO WS-UIF-FIELD-NUMERIC + 		WHEN "15"	MOVE 15 TO WS-UIF-FIELD-NUMERICU+ 		WHEN "16"	MOVE 16 TO WS-UIF-FIELD-NUMERICE+ 		WHEN "17"	MOVE 17 TO WS-UIF-FIELD-NUMERICN+ 		WHEN "18"	MOVE 18 TO WS-UIF-FIELD-NUMERICE+ 		WHEN "19"	MOVE 19 TO WS-UIF-FIELD-NUMERICN+ 		WHEN "20"	MOVE 20 TO WS-UIF-FIELD-NUMERICR+ 		WHEN "21"	MOVE 21 TO WS-UIF-FIELD-NUMERICE+ 		WHEN "22"	MOVE 22 TO WS-UIF-FIELD-NUMERICE+ 		WHEN "23"	MOVE 23 TO WS-UIF-FIELD-NUMERICE+ 		WHEN "24"	MOVE 24 TO WS-UIF-FIELD-NUMERICW+ 		WHEN "25"	MOVE 25 TO WS-UIF-FIELD-NUMERIC + 		WHEN "26"	MOVE 26 TO WS-UIF-FIELD-NUMERICX+ 		WHEN "27"	MOVE 27 TO WS-UIF-FIELD-NUMERICO+ 		WHEN "28"	MOVE 28 TO WS-UIF-FIELD-NUMERIC7+ 		WHEN "29"	MOVE 29 TO WS-UIF-FIELD-NUMERICU+ 		WHEN "30"	MOVE 30 TO WS-UIF-FIELD-NUMERICO+ 		WHEN "31"	MOVE 31 TO WS-UIF-FIELD-NUMERICT+ 		WHEN "32"	MOVE 32 TO WS-UIF-FIELD-NUMERIC-+ 		WHEN "33"	MOVE 33 TO WS-UIF-FIELD-NUMERICN+ 		WHEN "34"	MOVE 34 TO WS-UIF-FIELD-NUMERICO+ 		WHEN "35"	MOVE 35 TO WS-UIF-FIELD-NUMERICM+ 		WHEN "36"	MOVE 36 TO WS-UIF-FIELD-NUMERIC + 		WHEN "37"	MOVE 37 TO WS-UIF-FIELD-NUMERICN+ 		WHEN "38"	MOVE 38 TO WS-UIF-FIELD-NUMERICE+ 		WHEN "39"	MOVE 39 TO WS-UIF-FIELD-NUMERICU+ 		WHEN "40"	MOVE 40 TO WS-UIF-FIELD-NUMERIC	+ 		WHEN "41"	MOVE 41 TO WS-UIF-FIELD-NUMERIC + 		WHEN "42"	MOVE 42 TO WS-UIF-FIELD-NUMERICT+ 		WHEN "43"	MOVE 43 TO WS-UIF-FIELD-NUMERICI 	END-EVALUATE.   710-STORE-FIELD-EXIT.- 	EXIT. */ 720-PROCESS-OPTION.Y* 	MOVE SC4-UIF-OPTION (NEXT-OPTION-NBR) TO ( 		WS-MASTER-MENU-NODE (NEXT-OPTION-NBR). 	ADD 1 TO WS-NODE-CNT.@ 	MOVE SC4-UIF-OPTION (NEXT-OPTION-NBR) TO WS-MASTER-RECORD-NAME.> 	MOVE SC4-UIF-TYPE (NEXT-OPTION-NBR) TO WS-MASTER-RECORD-TYPE.2 	MOVE WS-MASTER-PRIMARY-KEY TO MASTER-PRIMARY-KEY.3 	PERFORM 600-READ-MASTER THRU 600-READ-MASTER-EXIT.E 	IF NO-INVALID-KEY% 	    MOVE OPTION-VALID TO DISPLAY-MSGA4 	    PERFORM 808-CALL-SCPEN THRU 808-CALL-SCPEN-EXIT" 	    GO TO 720-PROCESS-OPTION-EXIT 	ELSE- *TD * Record does not exist, notify user and return to same input field. *R, 	    IF SC4-UIF-TYPE (NEXT-OPTION-NBR) = "T"! 		MOVE NO-TRAN TO SCOPE-ERROR-MSGt1 		PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXITa	 	    ELSEr! 		MOVE NO-MENU TO SCOPE-ERROR-MSG 1 		PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXITl 	    END-IF  	END-IF. 720-PROCESS-OPTION-EXIT. 	EXIT.   725-REORG-NODES.   * LOCATES LAST OPTION ON MENUE *N 	SUBTRACT 1 FROM NODE-INDEX. 	IF NODE-INDEX = ZEROS 		GO TO 725-REORG-NODES-EXIT.O( 	IF SC4-UIF-OPTION (NODE-INDEX) = SPACES 		GO TO 725-REORG-NODES.& 	MOVE NODE-INDEX TO WS-CURR-NODE-END,  			   WS-NODE-CNT. 	MOVE ZEROS TO NODE-INDEX, - 		      WS-TMP-NODE-INDEX.   725-REORG-NODES-EXIT.E 	EXIT.   726-TRACK-TRANS-HIST.E *RB * Save the transaction just input in case the user ABORTS the add.D * If abort (or menu) a procedure will be called which will determineE * all transactions added before the abort and will decrement the nodeR  * count in the master data file. *O 	ADD 1 TO TRACK-COUNT.# 	IF (TRACK-COUNT < MAX-TRACK-COUNT)D, 	    MOVE SC4-UIF-OPTION(NEXT-OPTION-NBR) TO% 		TRANSACTION-NAME-TRACK(TRACK-COUNT)C+ 	    MOVE SC4-UIF-TYPE(NEXT-OPTION-NBR) TO M% 		TRANSACTION-TYPE-TRACK(TRACK-COUNT)ME 	    MOVE WS-HISTORY-SYMBOL TO TRANSACTION-HISTORY-TRACK(TRACK-COUNT)V 	ELSEI- 	    MOVE TRACK-TABLE-FULL TO SCOPE-ERROR-MSGC4 	    PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT 	END-IF. 726-TRACK-TRANS-HIST-EXIT. /E 727-COMPRESS-NODES.E    * COMPRESSES BLANK LINES IN MENU *- 	ADD 1 TO NODE-INDEX,  		 WS-TMP-NODE-INDEX.R! 	IF NODE-INDEX > WS-CURR-NODE-ENDE  		GO TO 727-COMPRESS-NODES-EXIT., 	IF SC4-UIF-OPTION (NODE-INDEX) NOT = SPACES 		GO TO 727-COMPRESS-NODES.O( 	MOVE NODE-INDEX TO WS-STORE-NODE-INDEX.& 	SUBTRACT 1 FROM WS-STORE-NODE-INDEX,  			WS-NODE-CNT.O   727-REMOVE-BLANK-LINES.H 	ADD 1 TO NODE-INDEX. ! 	IF NODE-INDEX > WS-CURR-NODE-END8* 		MOVE WS-STORE-NODE-INDEX TO NODE-INDEX,  					    WS-TMP-NODE-INDEX 		GO TO 727-COMPRESS-NODES. H 	MOVE SC4-UIF-OPTION (NODE-INDEX) TO SC4-UIF-OPTION (WS-TMP-NODE-INDEX). 	ADD 1 TO WS-TMP-NODE-INDEX. 	GO TO 727-REMOVE-BLANK-LINES.   727-COMPRESS-NODES-EXIT. 	EXIT.   730-GET-NODES.  " * REBUILD OPTIONS IN MASTER RECORD *R 	ADD 1 TO NODE-INDEX.C 	IF NODE-INDEX > WS-NODE-CNT 		NEXT SENTENCE0 	ELSEM& 		MOVE SC4-UIF-OPTION (NODE-INDEX) TO # 			WS-MASTER-MENU-NODE (NODE-INDEX)  		GO TO 730-GET-NODES.   730-GET-NODES-EXIT.N 	EXIT.   /	 740-GET-OPTIONS.  % * RETRIEVE OPTIONS FROM MASTER RECORDI *  	ADD 1 TO NODE-INDEX.  	IF NODE-INDEX > WS-NODE-CNT 		NEXT SENTENCEE 	ELSEO+ 		MOVE WS-MASTER-MENU-NODE (NODE-INDEX) TO Y 			SC4-UIF-OPTION (NODE-INDEX) 		GO TO 740-GET-OPTIONS. 	MOVE ZEROS TO NODE-INDEX.   740-VERIFY-OPTIONS.A 	ADD 1 TO NODE-INDEX.O 	IF NODE-INDEX > WS-NODE-CNT 		GO TO 740-GET-OPTIONS-EXIT 	ELSES; 		MOVE SC4-UIF-OPTION (NODE-INDEX) TO WS-MASTER-RECORD-NAMEM% 		MOVE "T" TO WS-MASTER-RECORD-TYPE, E  			    SC4-UIF-TYPE (NODE-INDEX)2 		MOVE WS-MASTER-PRIMARY-KEY TO MASTER-PRIMARY-KEY3 		PERFORM 600-READ-MASTER THRU 600-READ-MASTER-EXITM 		IF INVALID-KEY) 		    MOVE "M" TO WS-MASTER-RECORD-TYPE, E 			SC4-UIF-TYPE (NODE-INDEX)6 		    MOVE WS-MASTER-PRIMARY-KEY TO MASTER-PRIMARY-KEY7 		    PERFORM 600-READ-MASTER THRU 600-READ-MASTER-EXITR 		    IF INVALID-KEY) 			MOVE NO-CORR-RECORD TO SCOPE-ERROR-MSGV2 			PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT) 			MOVE "*" TO SC4-UIF-TYPE (NODE-INDEX).N 	GO TO 740-VERIFY-OPTIONS.   740-GET-OPTIONS-EXIT.N 	EXIT.   /Y 745-CHECK-NAME.D  	MOVE SPACES TO SCOPE-ERROR-MSG. 	MOVE 12 TO WS-NAME-SUB.   745-LAST-BLANK-LOOP.' 	IF WS-NAME-TBL (WS-NAME-SUB)  = SPACE W 		SUBTRACT 1 FROM WS-NAME-SUB	 		IF WS-NAME-SUB = ZERO  			GO TO 745-CHECK-NAME-EXIT 		END-IF 		GO TO 745-LAST-BLANK-LOOP.   745-EMBEDDED-BLANK.U' 	IF WS-NAME-TBL (WS-NAME-SUB)  = SPACE E- 	    MOVE "EMBEDDED BLANK" TO SCOPE-ERROR-MSGC4 	    PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT 	    GO TO 745-CHECK-NAME-EXIT.R. 	IF WS-NAME-TBL (WS-NAME-SUB) NOT  ALPHABETIC / 	    IF WS-NAME-TBL (WS-NAME-SUB) NOT < "0" ANDE& 		WS-NAME-TBL (WS-NAME-SUB) NOT > "9"  		GO TO 745-CONTINUE 	    END-IF-( 	    IF WS-NAME-TBL (WS-NAME-SUB) = "$" 3 		MOVE "$ AND _ ARE NOT ALLOWED" TO SCOPE-ERROR-MSGE1 		PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT. 		GO TO 745-CONTINUE 	    END-IFO( 	    IF WS-NAME-TBL (WS-NAME-SUB) = "_" 3 		MOVE "$ AND _ ARE NOT ALLOWED" TO SCOPE-ERROR-MSGC1 		PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT  		GO TO 745-CONTINUE 	    END-IFA< 	    MOVE "NOT (ALPHA NUMERIC OR $ OR _)" TO SCOPE-ERROR-MSG5 	    PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXIT.W 745-CONTINUE.		  	SUBTRACT 1 FROM WS-NAME-SUB.T 	IF WS-NAME-SUB = ZERO T 		GO TO 745-CHECK-NAME-EXIT. 		 	GO TO 745-EMBEDDED-BLANK.   745-CHECK-NAME-EXIT. 	EXIT. /9 750-RECURSION.  ? *	READ USER FILE FOR STARTING MENUS, THESE ARE TOP LEVEL MENU'SW *U1 	PERFORM 810-CLOSE-USER THRU 810-CLOSE-USER-EXIT.R/ 	PERFORM 800-OPEN-USER THRU 800-OPEN-USER-EXIT.- 	MOVE ZERO TO UMT-SUB.   750-READ-USER-NEXT.I9 	PERFORM 661-READ-USER-NEXT THRU 661-READ-USER-NEXT-EXIT." 	IF DONE 		GO TO 750-RECURSION-EXIT.E& 	IF WS-USERNAME NOT = WS-GENERIC-NAME  		GO TO 750-READ-USER-NEXT.E 	IF WS-USERNAME  = SPACESE 		GO TO 750-READ-USER-NEXT.A  > 	PERFORM 751-CHECK-MENU-TABLE THRU 751-CHECK-MENU-TABLE-EXIT.	 	IF ON-LIST  		GO TO 750-READ-USER-NEXT.U 	ADD 1 TO UMT-SUB.> 	MOVE WS-TOP-LEVEL-MENU-NAME TO  WS-USER-MENU-TABLE (UMT-SUB).7 	MOVE WS-TOP-LEVEL-MENU-NAME TO  WS-MASTER-RECORD-NAME.E# 	MOVE "M" TO WS-MASTER-RECORD-TYPE.N2 	MOVE WS-MASTER-PRIMARY-KEY TO MASTER-PRIMARY-KEY.3 	PERFORM 600-READ-MASTER THRU 600-READ-MASTER-EXIT.  	IF INVALID-KEY 0 		DISPLAY "MENU NAME IN USER RECORD  NOT MENU ", 			WS-MASTER-RECORD-NAMEB 	        MOVE "MENU NAME IN USER RECORD  NOT MENU " TO LOG-MESSAGE' 		MOVE WS-MASTER-RECORD-NAME TO LOG-RECI 		WRITE LOG-RECORD 		GO TO 750-READ-USER-NEXT.E   	MOVE 0 TO L-SUB.  	DISPLAY "TOP LEVEL MENU   ",  		WS-MASTER-PRIMARY-KEY.' 	MOVE "TOP LEVEL MENU " TO LOG-MESSAGE.Q' 	MOVE WS-MASTER-PRIMARY-KEY TO LOG-REC.R 	WRITE LOG-RECORD.   750-PUT-ON-LIST.	T 	ADD 1 TO L-SUB. 	IF L-SUB > TABLE-MAX # 		DISPLAY "LIST GREATER 25 QUITING" 7 		MOVE "LIST GREATER 25 750-PUT-ON-LIST" TO LOG-MESSAGES 		MOVE SPACES TO LOG-REC 		WRITE LOG-RECORD 		MOVE "Y" TO STRUCTURE-SW 		GO TO 750-RECURSION-EXIT.V1 	MOVE WS-MASTER-RECORD TO WS-LIST-RECORD (L-SUB).-? 	MOVE WS-MASTER-MENU-NODE-CNT TO WS-LIST-MENU-CUR-NODE (L-SUB).  /- 750-NO-RIGHT-MOST.) 	IF WS-LIST-MENU-CUR-NODE (L-SUB) = ZERO   		SUBTRACT 1 FROM L-SUB, 		IF L-SUB = ZERO % 			DISPLAY "PASSED RECURSIVE TEST  ",E 				WS-LIST-RECORD-NAME(1)/ 			MOVE "PASSED RECURSIVE TEST " TO LOG-MESSAGED* 			MOVE WS-LIST-RECORD-NAME (1) TO LOG-REC 			WRITE LOG-RECORDT 			GO TO 750-READ-USER-NEXT6 		END-IF/ 		SUBTRACT 1 FROM WS-LIST-MENU-CUR-NODE (L-SUB)Y 		GO TO 750-NO-RIGHT-MOST.? 	MOVE WS-LIST-MENU-NODE (L-SUB , WS-LIST-MENU-CUR-NODE (L-SUB))O 		TO  WS-MASTER-RECORD-NAME.# 	MOVE "M" TO WS-MASTER-RECORD-TYPE. 2 	MOVE WS-MASTER-PRIMARY-KEY TO MASTER-PRIMARY-KEY.3 	PERFORM 600-READ-MASTER THRU 600-READ-MASTER-EXIT.R 	IF INVALID-KEYE# 		MOVE "T" TO WS-MASTER-RECORD-TYPEE2 		MOVE WS-MASTER-PRIMARY-KEY TO MASTER-PRIMARY-KEY3 		PERFORM 600-READ-MASTER THRU 600-READ-MASTER-EXIT  		IF INVALID-KEY 			DISPLAY "NON EXISTANT  ", U 				WS-MASTER-RECORD-NAMEV% 			MOVE "NON EXISTANT" TO LOG-MESSAGEC( 			MOVE WS-MASTER-RECORD-NAME TO LOG-REC 			WRITE LOG-RECORD80 			SUBTRACT 1 FROM WS-LIST-MENU-CUR-NODE (L-SUB) 			GO TO 750-NO-RIGHT-MOST.0 	IF WS-MASTER-RECORD-TYPE = "T"./ 		SUBTRACT 1 FROM WS-LIST-MENU-CUR-NODE (L-SUB)M 		GO TO 750-NO-RIGHT-MOST.# 	IF WS-MASTER-RECORD-TYPE NOT = "M"P/ 		SUBTRACT 1 FROM WS-LIST-MENU-CUR-NODE (L-SUB)3 		GO TO 750-NO-RIGHT-MOST. 	MOVE SPACES TO LOG-MESSAGE. 	PERFORM 750-CHECK-IT  		VARYING CHK-SUB FROM 1 BY 1  			UNTIL CHK-SUB > L-SUB.L 	IF LOG-MESSAGE = "RECURSIVE " D 		GO TO 750-RECURSION-EXIT.	 	GO TO 750-PUT-ON-LIST.E /F
 750-CHECK-IT.K9 	IF WS-MASTER-RECORD-NAME = WS-LIST-RECORD-NAME (CHK-SUB)X  		DISPLAY "     RECURSIVE    ",  			WS-LIST-RECORD-NAME(L-SUB), 			WS-MASTER-RECORD-NAME 		MOVE "Y" TO STRUCTURE-SW" 		MOVE "RECURSIVE " TO LOG-MESSAGE6 		STRING "Menu " WS-LIST-RECORD-NAME(L-SUB) "  Tran. ": 		    WS-MASTER-RECORD-NAME DELIMITED BY SIZE INTO LOG-REC 		WRITE LOG-RECORD 		MOVE ZERO TO L-SUB.-   750-RECURSION-EXIT.M 	EXIT.   751-CHECK-MENU-TABLE.E 	MOVE ZERO TO U-SUB. 	MOVE "N" TO UMT-SW.   751-CHECK-LOOP.X 	ADD 1 TO U-SUB. 	IF U-SUB NOT > UMT-SUB 9 		IF WS-USER-MENU-TABLE (U-SUB) = WS-TOP-LEVEL-MENU-NAME L 			MOVE "Y" TO UMT-SW1" 			GO TO 751-CHECK-MENU-TABLE-EXIT
 		ELSE     			GO TO 751-CHECK-LOOP. S   751-CHECK-MENU-TABLE-EXIT. 	EXIT. /R 760-REBUILD-SECURITY.   9 	PERFORM 810-CLOSE-SECURITY THRU 810-CLOSE-SECURITY-EXIT.R1 	PERFORM 810-CLOSE-USER THRU 810-CLOSE-USER-EXIT.T/ 	PERFORM 800-OPEN-USER THRU 800-OPEN-USER-EXIT.O? 	PERFORM 801-OPEN-NEW-SECURITY THRU 801-OPEN-NEW-SECURITY-EXIT.D   760-READ-USER. 	MOVE 0 TO L-SUB,E 		  CHK-SUB. 	IF FROM-FIX-SECURITYV" 		GO TO 760-REBUILD-SECURITY-EXIT.9 	PERFORM 661-READ-USER-NEXT THRU 661-READ-USER-NEXT-EXIT.  	IF DONE! 		DISPLAY "SECURITY FILE REBUILT"D6 		MOVE "        SECURITY FILE REBUILT " TO LOG-MESSAGE 		MOVE SPACES TO LOG-REC 		WRITE LOG-RECORD" 		GO TO 760-REBUILD-SECURITY-EXIT.  & 	IF WS-USERNAME NOT = WS-GENERIC-NAME  		GO TO 760-READ-USER. 	IF WS-USERNAME  = SPACESC 		DISPLAY "USERNAME = SPACES " 		GO TO 760-READ-USER.   760-GET-TOP-LEVEL-MENU.37 	MOVE WS-TOP-LEVEL-MENU-NAME TO  WS-MASTER-RECORD-NAME.1# 	MOVE "M" TO WS-MASTER-RECORD-TYPE.E2 	MOVE WS-MASTER-PRIMARY-KEY TO MASTER-PRIMARY-KEY.3 	PERFORM 600-READ-MASTER THRU 600-READ-MASTER-EXIT.L 	IF INVALID-KEY	0 		DISPLAY "MENU NAME IN USER RECORD  NOT MENU ", 			WS-MASTER-RECORD-NAMEB 	        MOVE "MENU NAME IN USER RECORD  NOT MENU " TO LOG-MESSAGE' 		MOVE WS-MASTER-RECORD-NAME TO LOG-REC  		WRITE LOG-RECORD 		GO TO 760-READ-USER. /  760-PUT-ON-LIST.  	IF WS-MASTER-MENU-NODE-CNT < 0 ) 		DISPLAY "MASTER MENU NODE COUNT < 0 ", L 			WS-MASTER-PRIMARY-KEY.X! 	IF WS-MASTER-MENU-NODE-CNT > 20 0) 		DISPLAY "MASTER MENU NODE COUNT > 20", O 			WS-MASTER-PRIMARY-KEY4 		MOVE "MASTER MENU NODE COUNT > 20 " TO LOG-MESSAGE' 		MOVE WS-MASTER-RECORD-NAME TO LOG-RECS 		WRITE LOG-RECORD 		MOVE WS-USERNAME TO LOG-RECX 		WRITE LOG-RECORD 		GO TO 760-READ-USER. 	ADD 1 TO L-SUB.1 	MOVE WS-MASTER-RECORD TO WS-LIST-RECORD (L-SUB).D 	O 760-GET-NEXT-NODE. 	ADD 1 TO CHK-SUB.' 	IF CHK-SUB > WS-LIST-MENU-NODE-CNT (1)E 		MOVE 1 TO CHK-SUBS3 		MOVE WS-LIST-RECORD (L-SUB) TO WS-LIST-RECORD (1)L 		SUBTRACT 1 FROM L-SUBE 		IF L-SUB < 1 3 			GO TO 760-READ-USER.   * 	IF WS-LIST-MENU-NODE (1,CHK-SUB) = SPACES 		GO TO 760-GET-NEXT-NODE.= 	MOVE WS-LIST-MENU-NODE (1,CHK-SUB) TO WS-MASTER-RECORD-NAME.O# 	MOVE "M" TO WS-MASTER-RECORD-TYPE.O2 	MOVE WS-MASTER-PRIMARY-KEY TO MASTER-PRIMARY-KEY.3 	PERFORM 600-READ-MASTER THRU 600-READ-MASTER-EXIT.C 	IF INVALID-KEYM# 		MOVE "T" TO WS-MASTER-RECORD-TYPE62 		MOVE WS-MASTER-PRIMARY-KEY TO MASTER-PRIMARY-KEY3 		PERFORM 600-READ-MASTER THRU 600-READ-MASTER-EXITF 		IF INVALID-KEY 			DISPLAY "NON EXISTANT ",  				WS-MASTER-RECORD-NAMEX% 			MOVE "NON EXISTANT" TO LOG-MESSAGEE( 			MOVE WS-MASTER-RECORD-NAME TO LOG-REC 			WRITE LOG-RECORDT 			GO TO 760-GET-NEXT-NODE.T   	IF WS-MASTER-RECORD-TYPE = "T"Y- 		MOVE WS-GENERIC-NAME TO WS-GENERIC-USERNAMEO5 		MOVE WS-MASTER-RECORD-NAME TO WS-TRANSACTION-NAME	 A9 		PERFORM 675-WRITE-SECURITY THRU 675-WRITE-SECURITY-EXITR 		GO TO 760-GET-NEXT-NODE. 	GO TO 760-PUT-ON-LIST.-   760-REBUILD-SECURITY-EXIT. 	EXIT. /R 770-FIX-SECURITY.X 	MOVE 0 TO FIX-SUB.S   770-NEXT-CHANGE. 	ADD 1 TO FIX-SUB. 	IF FIX-SUB > TABLE-MAXP 		DISPLAY "LIST GREATER 25 " 		GO TO 770-FIX-SECURITY-EXIT.> 	EVALUATE WS-OTHER-FUNCTION (FIX-SUB), WS-OTHER-TYPE (FIX-SUB)2 		WHEN "A", "U"	PERFORM 770-ADD-USER-SECURITY THRU& 				        770-ADD-USER-SECURITY-EXIT5 		WHEN "D", "U"	PERFORM 770-DELETE-USER-SECURITY THRUN" 					770-DELETE-USER-SECURITY-EXIT% 		WHEN "A", "T"	GO TO 770-NEXT-CHANGET5 		WHEN "D", "T"	PERFORM 770-DELETE-TRAN-SECURITY THRUR" 					770-DELETE-TRAN-SECURITY-EXIT( 		WHEN OTHER	GO TO 770-FIX-SECURITY-EXIT 	END-EVALUATE. 	GO TO 770-NEXT-CHANGE.T   770-ADD-USER-SECURITY. 	MOVE 0 TO CHK-SUB,H
 		  L-SUB. 	MOVE "Y" TO FIX-SW.- 	MOVE WS-OTHER-NAME (FIX-SUB) TO WS-USERNAME.O( 	MOVE WS-USER-RECORD TO USERNAME-RECORD./ 	PERFORM 660-READ-USER THRU 660-READ-USER-EXIT.B 	IF INVALID-KEYE# 		GO TO 770-ADD-USER-SECURITY-EXIT.F? 	PERFORM 760-GET-TOP-LEVEL-MENU THRU 760-REBUILD-SECURITY-EXIT.1 	MOVE "N" TO FIX-SW.   770-ADD-USER-SECURITY-EXIT.R 	EXIT.   770-DELETE-USER-SECURITY.O9 	PERFORM 810-CLOSE-SECURITY THRU 810-CLOSE-SECURITY-EXIT. 8 	PERFORM 800-OPEN-SECURITY THRU 800-OPEN-SECURITY-EXIT.	   770-READ-SECURITY.A 	PERFORM 671-READ-SECURITY-NEXT THRU 671-READ-SECURITY-NEXT-EXIT.A	 	IF DONE -& 		GO TO 770-DELETE-USER-SECURITY-EXIT.2 	IF WS-GENERIC-USERNAME = WS-OTHER-NAME (FIX-SUB)  		DELETE UIF-SECURITY-FILE 			INVALID KEY U 				DISPLAY "NOT DELETED ",  				WS-SECURITY-RECORD.  	GO TO 770-READ-SECURITY.A   770-DELETE-USER-SECURITY-EXIT. 	EXIT. /8 770-DELETE-TRAN-SECURITY.-9 	PERFORM 810-CLOSE-SECURITY THRU 810-CLOSE-SECURITY-EXIT.-8 	PERFORM 800-OPEN-SECURITY THRU 800-OPEN-SECURITY-EXIT.	   770-DELETE-TRAN-READ.	A 	PERFORM 671-READ-SECURITY-NEXT THRU 671-READ-SECURITY-NEXT-EXIT. 	 	IF DONE G& 		GO TO 770-DELETE-TRAN-SECURITY-EXIT.1 	IF WS-TRANSACTION-NAME = WS-OTHER-NAME (FIX-SUB)- 		DELETE UIF-SECURITY-FILE 			INVALID KEY 5 				DISPLAY "DELETED ",  				WS-SECURITY-RECORD.C 	GO TO 770-DELETE-TRAN-READ.   770-DELETE-TRAN-SECURITY-EXIT. 	EXIT.   770-FIX-SECURITY-EXIT. 	EXIT.   780-ZERO-ACCESS-COUNT.5 	PERFORM 810-CLOSE-MASTER THRU 810-CLOSE-MASTER-EXIT.24 	PERFORM 800-OPEN-MASTER THRU 800-OPEN-MASTER-EXIT.	   780-ZERO-READ.	H= 	PERFORM 601-READ-MASTER-NEXT THRU 601-READ-MASTER-NEXT-EXIT.S 	IF DONE# 		GO TO 780-ZERO-ACCESS-COUNT-EXIT.F$ 	IF MASTER-RECORD-ACCESS-COUNT  = 0   		DISPLAY "ZERO ACCESS COUNT ",  			WS-MASTER-PRIMARY-KEY, 		MOVE "  ZERO ACCESS COUNT " TO LOG-MESSAGE' 		MOVE WS-MASTER-PRIMARY-KEY TO LOG-REC  		WRITE LOG-RECORD.Y 	GO TO 780-ZERO-READ.R   780-ZERO-ACCESS-COUNT-EXIT.. 	EXIT. /6 800-OPEN-FILES.R   800-OPEN-MASTER. 	OPEN I-O UIF-MASTER-FILE.   800-OPEN-MASTER-EXIT.R 	EXIT.   800-OPEN-USER. 	OPEN I-O UIF-USERNAME-FILE.   800-OPEN-USER-EXIT.R 	EXIT.   800-OPEN-SECURITY. 	OPEN I-O UIF-SECURITY-FILE.   800-OPEN-SECURITY-EXIT.- 	EXIT.  
 800-OPEN-LOG.U 	OPEN OUTPUT UIF-LOG-FILE.   800-OPEN-LOG-EXIT. 	EXIT.   800-OPEN-SCOPE.-6 	CALL "SCPIN" USING BY DESCRIPTOR SCOPE-STATUS-RECORD.B 	IF SCOPE-ERROR PERFORM 805-SCOPE-ERROR THRU 805-SCOPE-ERROR-EXIT. 800-OPEN-FILES-EXIT. 	EXIT.   801-OPEN-NEW-SECURITY. 	OPEN OUTPUT UIF-SECURITY-FILE.I   801-OPEN-NEW-SECURITY-EXIT.5 	EXIT.   805-SCOPE-ERROR.5 	CALL "SCPSS" USING BY DESCRIPTOR SCOPE-SCREEN-IMAGE.E1 	CALL "UTL587" USING ABNORMAL-TERMINATION-RECORD,  			    SCOPE-ERROR-NO,	  			    SCOPE-SCREEN-IMAGE, 			    PROG-ID.U 	CALL "SCPRT".3 	PERFORM 810-CLOSE-FILES THRU 810-CLOSE-FILES-EXIT.  805-SCOPE-ERROR-EXIT.D   807-CALL-SCPER. 2 	CALL "SCPER" USING BY DESCRIPTOR SCOPE-ERROR-MSG.B 	IF SCOPE-ERROR PERFORM 805-SCOPE-ERROR THRU 805-SCOPE-ERROR-EXIT. 807-CALL-SCPER-EXIT.   808-CALL-SCPEN.D. 	CALL "SCPEN" USING BY DESCRIPTOR DISPLAY-MSG.B 	IF SCOPE-ERROR PERFORM 805-SCOPE-ERROR THRU 805-SCOPE-ERROR-EXIT. 808-CALL-SCPEN-EXIT. /R 810-CLOSE-FILES.   810-CLOSE-MASTER.S 	CLOSE UIF-MASTER-FILE.D   810-CLOSE-MASTER-EXIT. 	EXIT.   810-CLOSE-USER.M 	CLOSE UIF-USERNAME-FILE.M   810-CLOSE-USER-EXIT. 	EXIT.   810-CLOSE-SECURITY.E 	CLOSE UIF-SECURITY-FILE.P   810-CLOSE-SECURITY-EXIT. 	EXIT.   810-CLOSE-LOG. 	CLOSE UIF-LOG-FILE.   810-CLOSE-LOG-EXIT.D 	EXIT.   810-CLOSE-FILES-EXIT.K 	EXIT.   /PP ******************************************************************************** *CLOSING SECTION.XP ********************************************************************************   900-RECUR-SECUR-ZERO-TESTS.O3 	CALL "SCPRT" USING BY DESCRIPTOR SCP-CLEAR-SCREEN.-  K * IF A MENU HAS BEEN ADDED OR CHANGED THE WHOLE MASTER FILE MUST BE CHECKEDT3 * FOR RECURSION AND THE WHOLE SECURITY FILE REBUILTL *B 	IF STRUCTURE-CHANGES 
 		DISPLAY " "M$ 		DISPLAY "STARTING RECURSIVE TEST "8 		MOVE "        STARTING RECURSIVE TEST " TO LOG-MESSAGE 		MOVE SPACES TO LOG-REC 		WRITE LOG-RECORD 		MOVE "N" TO STRUCTURE-SW/ 		PERFORM 750-RECURSION THRU 750-RECURSION-EXITL 		IF STRUCTURE-CHANGES R7 		    CALL "SCPST" USING BY DESCRIPTOR SCP-CLEAR-SCREEN-: 		    MOVE "Recursive Menu Found, Use Option 6 to Correct" 			TO LOG-MESSAGEK( 		    MOVE LOG-RECORD TO SCOPE-ERROR-MSG5 		    PERFORM 807-CALL-SCPER THRU 807-CALL-SCPER-EXITE 		    GO TO 100-MAIN 		END-IF& 		DISPLAY "STARTING REBUILD SECURITY ": 		MOVE "        STARTING REBUILD SECURITY " TO LOG-MESSAGE 		MOVE SPACES TO LOG-REC 		WRITE LOG-RECORD= 		PERFORM 760-REBUILD-SECURITY THRU 760-REBUILD-SECURITY-EXIT-& 		DISPLAY "STARTING ZERO ACCESS COUNT"; 		MOVE "        STARTING ZERO ACCESS COUNT " TO LOG-MESSAGEP 		MOVE SPACES TO LOG-REC 		WRITE LOG-RECORD? 		PERFORM 780-ZERO-ACCESS-COUNT THRU 780-ZERO-ACCESS-COUNT-EXITM 		GO TO 999-REAL-EXIT.  H * IF THERE ARE NO MENU CHANGES THEN WE DON'T NEED TO CHECK FOR RECURSION, * AND ONLY NEED TO UPDATE THE SECURITY FILE  *- 	IF OTHER-CHANGES 
 		DISPLAY " "C! 		DISPLAY "STARTING SECURITY FIX"R5 		MOVE "        STARTING SECURITY FIX" TO LOG-MESSAGEP 		MOVE SPACES TO LOG-REC 		WRITE LOG-RECORD5 		PERFORM 770-FIX-SECURITY THRU 770-FIX-SECURITY-EXITR& 		DISPLAY "STARTING ZERO ACCESS COUNT"; 		MOVE "        STARTING ZERO ACCESS COUNT " TO LOG-MESSAGEE 		MOVE SPACES TO LOG-REC 		WRITE LOG-RECORD@ 		PERFORM 780-ZERO-ACCESS-COUNT THRU 780-ZERO-ACCESS-COUNT-EXIT. 999-REAL-EXIT.3 	CALL "SCPRT" USING BY DESCRIPTOR SCP-CLEAR-SCREEN.E1 	PERFORM 810-CLOSE-FILES THRU 810-CLOSE-LOG-EXIT.O 	STOP RUN .L