/***************** data.h - sequence data type. ********************/
/*************************** Population ADT ******************************

        This data structure is part of a package of object oriented
        C code for molecular biological applications developed by
        Andrew F. Neuwald.

	Define: P = <S,A>
	  where
		S is a set of biological sequence entities
		A is the sequence alphabet 

**************************************************************************/
#if !defined (DATA)
#define DATA
#include "stdinc.h"
#include "afnio.h"
#include "alphabet.h"
#include "sequence.h"
/******************************* PRIVATE ***********************************/
/****************************** population type ****************************/
typedef struct {
	/* ENTITIES (Pi) */
	char		*name;		/* input filename for entities */
	e_type		*entity;	/* array of sequence entities */
	int		nent;		/* number of input entities */
	int		max_leng;	/* sequence entity maximumlength */
	int		min_leng;	/* sequence entity minimum length */
	/* RESIDUE FREQUENCIES */
	long		*counts;	/* number of b residues */
	long		total;		/* total # residues */
	double		*tfreq;		/* residue total freqs for seqs */ 
	/* ALPHABET */
	a_type		A;		/* sequence alphabet */
} population_type;
typedef population_type	*p_type;

/******************************* private *************************************/
void	pop_error(char *s);
p_type  calcpopfreq(p_type P);
int	count_pop_entities(FILE *fptr, p_type P,int nsize[]);
FILE    *OpenPopFile(p_type P);
p_type  population(char *filename,a_type A);
p_type  fptr_population(FILE *fptr,a_type A);
p_type  Pop_fptr(FILE *fptr,a_type A);

/******************************* PUBLIC *************************************/
/************************** population operations ***************************/
p_type  Pop(char *name,a_type A);
p_type  Pop1(char *filename,e_type E,a_type A);
p_type  NilPop(p_type P);
double  PopEntropy(p_type P);
int     *PopSeqLengths(p_type P);
p_type	PutPop(FILE *fptr,p_type P);		/* show population data */
p_type  PutPopPIDs(FILE *fptr, p_type P);
p_type	PutPopEs(FILE *fptr,p_type P);
p_type	PutPopE(FILE *fptr,int i, p_type P);
p_type	PutPoptFreqs(FILE *fptr,p_type P);
p_type	ShufflePop(p_type P); 		/* shuffle population */
p_type  ShufflePop2(p_type P);
double  LogL0Pop(p_type P);
/************************** population defines ***************************/
#define MAX_NUMBER_SEQS	3000
#define PopA(P)		(P->A)
#define nLetPop(P)	(nAlpha(P->A))
#define CountsPop(r,P)	((P)->counts[(r)])
#define TotalPop(P)	((P)->total)
#define	tFreqPop(P)	((P)->tfreq)
#define SeqP(n,i,P)	ResSeq(i,(P)->entity[(n)])
#define NSeqsPop(P)	((P)->nent)
#define LenSeqP(n,P)	LenSeq((P)->entity[(n)])
#define	SeqPop(n,P)	SeqPtr((P)->entity[(n)])
#define PopE(n,P)	((P)->entity[(n)])
#define NamePop(P)	((P)->name)
#define MinSeqPop(P)	((P)->min_leng)
#define MaxSeqPop(P)	((P)->max_leng)
#define	CntsPop(P)	((P)->counts)

#endif

