#include "gibbs.h"

void	PutFinalSites(FILE *fptr,st_type S,int t,m_type M,g_type G,p_type P)
{
	int	n,s,p,*pos=G->pos,leng;
	double	**site_prob;
	a_type	A=PopA(P);
	boolean	*null;
	
	null = G->null;
	NEWP(site_prob, NSeqsPop(P)+1,double);
	for(n = 1; n <= NSeqsPop(P); n++) {
		NEW(site_prob[n], MaxSeqPop(P)+1,double);
		for(s = 1; s <= G->nsite[t][n]; s++) {
			p = G->site_pos[t][n][s];
			VacateSite(t,n,p,S);
		}
		GetFreqProb(t, n, M, G, NULL);
		GetFinalSites(t,n,M,S,G,site_prob[n]);
	}
	PutSitesGibbs(fptr, t, S, G, site_prob);
	for(n = 1; n <= NSeqsPop(P); n++) free(site_prob[n]);
	free(site_prob);
}

int	GetFinalSites(int t,int n,m_type M,st_type S,g_type G,
	double *site_prob)
{
	p_type	P=G->data;
	char	*seq;
	double	v,*log_prob,mean,N,sum_var,std_dev,*freq_prob;
	int	s,site,p,i,j,end,b, *array, ptr, number;
	dh_type	H;

	freq_prob = PosProbSite(t,n,S);
	H = dheap(LenSeqP(n,P),3);
	seq = SeqPop(n,P);
	NEW(log_prob, LenSeqP(n,P), double);
	MEW(array, LenSeqP(n,P), int);
	end = LenSeqP(n,P) - SiteLen(t,S) + 1;
	for(i= 1; i<= end; i++){
	    if(!OccupiedSite(t,n,i,S)){
		if(freq_prob[i] > 0.0){
			log_prob[i] = log(freq_prob[i]);
			insrtHeap(i,-(keytyp) log_prob[i],H);
		}
	    } 
	}
	number = ItemsInHeap(H);
	for(ptr=0, i=1; i<=G->nsite[t][n]; i++){
		site = delminHeap(H);
		array[ptr++] = site;
	}
	N = (double) ItemsInHeap(H);
	for(mean = 0.0; (site = delminHeap(H)) != 0; ){
		array[ptr++] = site;
		mean += log_prob[site];
	}
	mean = mean/N;
	for(sum_var = 0.0,i=G->nsite[t][n]; i < ptr; i++){
		site = array[i];
		v = log_prob[site] - mean;
		sum_var += v*v;
	}
	std_dev = sqrt(sum_var/(N-1.0)); 
	for(s=1,i=0; TRUE; i++){
		site=array[i];
		site_prob[site] = (log_prob[site]-mean)/std_dev;
		if(site_prob[site] > 4.0 || i<G->nsite[t][n]){
		    if(!OccupiedSite(t,n,site,S)) {
			s++; AddSite(t,n,site,S);
		    }
		} else break;
	}
	Nildheap(H); 
	free(array); free(log_prob);
}

void	PutSitesGibbs(FILE *fptr, int t, st_type S, g_type G,
	double **site_prob)
{
	p_type	P=G->data;
	int	i,r,n,s,*pos=G->pos,leng;
	a_type	A=PopA(P);
	boolean	are_sites = FALSE;
	int	e,end;
	int	start,length;
	 e_type E;
	char	c;
   
	fprintf(fptr,"\n\n");
	length = SiteLen(t,S);
	for(n=1; n<= NSeqsPop(P); n++){
	   PosTSites(t,n,pos,S);
	   E=PopE(n,P);
	   for(s=1; s<= nSites(t,n,S); s++){
		are_sites = TRUE;
	   	fprintf(fptr,"%2d-%-2d ",n,s);
		start= pos[s];
		fprintf(fptr,"%4d  ",start);
		e = start + length - 1;
		end = e + 10;
		for(i=start-10; i <= end; i++){
		   if(i < 1 || i > (int) LenSeq(E)) fprintf(fptr," ");
		   else{
			r = ResSeq(i,E);
			if(OpenPos(n,i,S)) c = AlphaCharLow(r,A);
			else c = AlphaChar(r,A);
			if(i == e) fprintf(fptr,"%c ", c);
			else if(i == start) fprintf(fptr," %c", c);
			else fprintf(fptr,"%c", c);
		   }
		}
		fprintf(fptr," %4d",e);
		if(site_prob != NULL)
			fprintf(fptr," (%0.2f)\n",site_prob[n][start]);
		else fprintf(fptr,"\n");
	   }
	}
	if(are_sites){
	   fprintf(fptr,"%*s", 23, "");
	   for(i=1; i<= SiteLen(t,S); i++) {
		if(i%5==0) fprintf(fptr,"%5d",i);
	   }
	}
	fprintf(fptr,"\n\n");
}

