/****************** gibbs.h - .***************
 Varible definitions for multi site gibbs program
 An algorithm for finding multiple sites in multiple sequences 

        This data structure is part of a package of object oriented
        C code for molecular biological applications developed by
        Andrew F. Neuwald.

*************************************************************************/
#if !defined(GIBBS)
#define GIBBS
#include "stdinc.h"
#include "model.h"
#include "sites.h"
#include "data.h"
#include "order.h"

/********************************* PRIVATE ********************************/
typedef struct {
        p_type		data;
        st_type		sites;
        m_type		*model;
	int		*nres;		/* number of residues in model t */
	int		ntyps,nseq;
	int		*order;
        int		nconverge;
        int		ncycles;
	int		*pos;
        double		**tmpfreq;
        double		*tmpratio;
        double		pseudo;
        double		qseudo;
        FILE		*fptr;
        a_type		A;
	boolean		*null;
	boolean		use_order;
        int		**nsite,***site_pos;
} gibbs_type;

typedef gibbs_type *g_type;


/********************************* PUBLIC ********************************/

g_type MkGibbs(int nconv, int ncycl, double pseudo,
        double qseudo, a_type A, p_type data);
void	gibbs(FILE *fptr, g_type G, int nruns);
boolean MoveColumn(g_type G, int t, m_type M);
boolean Metropolis(g_type G, int t, m_type M);
long	*GetSiteFreqM(boolean left, g_type G, int t, int d, p_type P);
m_type	*InitGibbs(st_type S, p_type P, double qseudo,boolean **null);
void	InitSitesGibbs(g_type G);
void    PutFinalSites(FILE *fptr,st_type S,int t,m_type M,g_type G,p_type P);
int     GetFinalSites(int t,int n,m_type M,st_type S,g_type G,
	double *site_prob);
void	ReadSites(g_type G);
int     GetFreqProb(int t, int n, m_type M, g_type G, o_type R);
void    PutSitesGibbs(FILE *fptr, int t, st_type S, g_type G,double 
	**site_prob);

/********************************* MACROS ********************************/
#define GIBBS_USAGE "\nUsage: \
gibbs file [options] \n\
  options:\n\
\t-n          - use nucleic acid alphabet\n\
\t-o          - use element order in probabilities\n\
\t-r          - randomly shuffle input sequences\n\
\t-s<seed>    - give seed for random number generator\n\
\t-t<#times>  - maximum number of independent starts\n\
\t-c<#cycles> - number of cycles between shifts\n\
\t-m<#cycles> - maximum number of cycles in each run\n"

#endif
