#include "gibbs.h"

main(int argc, char *argv[] )
{
	long int time1;
	char	str[80];
	unsigned long seed;
	int	arg,i,nconv=500, ncycl=1,nruns=10;
	FILE	*fptr;
	double 	pseudo=0.05,qseudo=0.5;
	a_type	A=NULL;
	g_type G;
	boolean	shuffle = FALSE, flag=TRUE,use_order=FALSE;

	if(argc < 2) print_error(GIBBS_USAGE);
	strcpy(str,argv[1]);
	for(arg = 2; arg < argc; arg++){
		if(argv[arg][0] != '-') print_error(GIBBS_USAGE);
		switch(argv[arg][1]) {
		   case 'n': A = Alpha("NACGT",NULL); break;
		   case 'o': use_order = TRUE; break;
		   case 'm':
			if(sscanf(argv[arg],"-m%d", &nconv)!= 1)
			  		print_error(GIBBS_USAGE);
		   break;
		   case 't':
			if(sscanf(argv[arg],"-t%d", &nruns)!= 1)
			  		print_error(GIBBS_USAGE);
		   break;
		   case 'r': shuffle = TRUE; break;
		   case 's':
		  	  if(sscanf(argv[arg],"-s%d", &seed) != 1 )
			  		print_error(GIBBS_USAGE);
			flag = FALSE;
		   break;
		   case 'q':	/* number of pseudo counts  for model */
		  	  if(sscanf(argv[arg],"-q%f", &qseudo) != 1 )
			  		print_error(GIBBS_USAGE);
		   break;
		   case 'p':	/* number of pseudo counts */
		  	  if(sscanf(argv[arg],"-p%f", &pseudo) != 1 )
			  		print_error(GIBBS_USAGE);
		   break;
		   case 'c':	/* number of cycles per shift */
		  	  if(sscanf(argv[arg],"-c%d", &ncycl) != 1 )
			  		print_error(GIBBS_USAGE);
		   break;
		   default: print_error(GIBBS_USAGE);
		}
	}
	if(A==NULL) A = Alpha("XARNDCQEGHILKMFPSTWYV",NULL);
	if(flag) seed = (unsigned int) time(NULL)/2;
	RandomSeed(seed);
	fptr = stdout; 
	G=MkGibbs(nconv,ncycl, pseudo, qseudo, A, Pop(str,A));
	G->use_order = use_order;
	ReadSites(G);
	time1=time(NULL);
	if(shuffle){
		fprintf(stderr,"shuffling data...\n");
		ShufflePop(G->data);
		fprintf(stderr,"running gibbs...\n");
		gibbs(fptr,G,nruns);
	} else {
		fprintf(fptr,"\n");
		PutPopPIDs(fptr,G->data);	/* OFF */
		fprintf(stderr,"running gibbs...\n");
		gibbs(stdout,G,nruns);
	}
	fprintf(stderr,"\tseed: %d\n", seed);
	fprintf(stderr,"\ttime: %ld seconds (%0.2f minutes)\n",
                time(NULL)-time1,(float)(time(NULL)-time1)/60.0);
}

void	ReadSites(g_type G)
/* Ask how many sites in each sequence, give option to all have 
   the same number & the length of the sites.  */
{
	char	c;
	int	n,i,isite,t,nsite_all,ntyps,newsite;
	st_type	S;
        int     *site_len;
	p_type	P=G->data;

    do {
    	GETINT("How many types of elements?",&ntyps);
    } while(ntyps < 1 || ntyps > MAX_NO_TYPESITES);
    NEW(site_len, ntyps +1, int);
    NEW(G->nres, ntyps +1, int);
    NEWP(G->nsite,ntyps+1,int);
    NEWPP(G->site_pos, ntyps+1,int);
    for(t = 1; t <= ntyps; t++){
	NEW(G->nsite[t],NSeqsPop(P)+1,int);
	NEWP(G->site_pos[t], NSeqsPop(P)+1,int);
	fprintf(stderr,"For element %d...\n",t);
	GETINT("\tHow long are the sites?",&site_len[t]);
	G->nres[t] = site_len[t];
	GETCHAR("\tDo all seqs have the same # of sites (Y/N)?",&c);
	if(c == 'Y' || c == 'y'){
	   do {
	   	GETINT("\tHow many sites in each seq?", &nsite_all);
	   } while(nsite_all < 1);
	   fprintf(stderr,"%d sites for each\n",nsite_all);
	   for(n = 1; n <= NSeqsPop(P); n++) {
		G->nsite[t][n] = nsite_all;
		NEW(G->site_pos[t][n],nsite_all+1,int);
	   }
	} else {
	   for(n = 1; n <= NSeqsPop(P); n++){
	      do{
		fprintf(stderr, "\tsequence %d:",n);
		GETINT(" how many sites?", &G->nsite[t][n]);
	      } while(G->nsite[t][n] < 1);
	      MEW(G->site_pos[t][n],G->nsite[t][n]+1,int);
	      for(isite = 1; isite <= G->nsite[t][n]; isite++){
			G->site_pos[t][n][isite] = 0;
	      }
	   }
	}
   }
   G->ntyps = ntyps;
   G->sites = Sites(ntyps, site_len, NSeqsPop(P),PopSeqLengths(P));
}

