#include "gibbs.h"

boolean	Metropolis(g_type G, int t, m_type M)
{
	p_type	P=G->data;
	st_type S=G->sites;
	long	*site_freq[2][15];
	double	ratio[2][15], total,rand_no;
	int	end[2],i,j,o,d,n,k,shift;
	boolean	left[2];
	char	c;
	a_type	A=PopA(P);

	shift = MIN(int,LenModel(M)/2,10);
	shift = MAX(int,shift,1);
	end[0] = shift; left[0]=FALSE;	/* note: right == 0 == FALSE */
	end[1] = shift; left[1]=TRUE;	/* note: left == 1 ==TRUE */
	for(total=1.0,i=0; i<2; i++){
	   ratio[i][0] = 1.0;
	   for(d=1; d<= end[i]; d++){
		site_freq[i][d] = GetSiteFreqM(left[i],G,t,d,P);
		if(site_freq[i][d] == NULL) { end[i] = d-1; break; }
		ratio[i][d] = RatioModel(left[i],site_freq[i][d],d, M);
		ratio[i][d] *= ratio[i][d-1];
		total += ratio[i][d];
	   }
	}
	rand_no = (double)RandomNum()/(double)LONG_MAX;
	rand_no *= total;
	for(total=0.0, i=0; i < 2; i++){
	   if(left[i]) c= '+'; else c = '-';
	   for(d=1; d<= end[i]; d++){
	      if((total += ratio[i][d]) >= rand_no) {
		fprintf(stderr,"\r[");
		/* PutSites(stderr,t,S,G,NULL); /** OFF **/
		for(j=1; j<=d; j++){
			fprintf(stderr,"%c", c);
			ShiftModel(site_freq[i][j], left[i], M); 
			ShiftSites(S,t,left[i]);;
		}
		fprintf(stderr,"] %g ",ratio[i][d]);
		for(j=d+1; j<=end[i]; j++){
			if(site_freq[i][j]!=NULL) free(site_freq[i][j]);
		}
		for(o=(i+1)%2,j=1; j<=end[o]; j++){
			if(site_freq[o][j]!=NULL) free(site_freq[o][j]);
		}
		/* PutSites(stderr,t,S,G,NULL); /** OFF **/
		if(!left[i]) d = -d;
		for(n=1; n<= NSeqsPop(P); n++){
		   for(k=1; k<=G->nsite[t][n]; k++)
				G->site_pos[t][n][k] += d;
		}
		return TRUE; 
	      }
	   }
	}
	for(i=0; i<2; i++){
	   for(d=1; d<= end[i]; d++){
		if(site_freq[i][d]!=NULL) free(site_freq[i][d]);
	   }
	}
	return FALSE;
}

long	*GetSiteFreqM(boolean left, g_type G, int t, int d, p_type P)
/* returns the residue frequencies for a site d residues left (or right)
   of sites of type t in S; if shift is impossible NULL is returned. */
{
	long	*site_freq;
	st_type	S=G->sites;
	int	n,k,b,p,*pos;
	e_type	E;
	a_type	A=PopA(P);

	NEW(site_freq, nAlpha(A)+2,long);
	for(b=1;b<= nAlpha(A); b++) site_freq[b] = 0;
	for(n=1; n <=NSeqsPop(P); n++){
	   E = PopE(n,P);
	   for(k=1; k<=G->nsite[t][n]; k++){
		if(left){ 		/* if shift impossible then abort */
		   p=G->site_pos[t][n][k];
		   p += SiteLen(t,S)+d-1;
		   if((p-1) == LenSeqP(n,P) || !OpenPos(n,p,S)){
				free(site_freq); return (long*) NULL;
		   } else {
			b = ResSeq(p,E);
			site_freq[b] += 1;
		   }
		} else {
		   p = G->site_pos[t][n][k] - d;
		   if(p <= 0 || !OpenPos(n,p,S)) {
				free(site_freq); return (long*) NULL;
		   } else {		/* else add to new site freq */
			b = ResSeq(p,E);
			site_freq[b] += 1;
		   }
		}
	   }
	}
	return site_freq;
}

