/****************** model.h - model abstract data type.***************/
#if !defined(MODEL)
#define MODEL
#include "stdinc.h"
#include "alphabet.h"
#include <float.h>
/**************************** model ADT *****************************

        This data structure is part of a package of object oriented
        C code for molecular biological applications developed by
        Andrew F. Neuwald.

********************************************************************/
typedef struct {
	a_type	A;		/* alphabet */
	int	length;		/* length of motif model */
	long	**site_freq;	/* site_freq(j,b)=# b's at pos j of site*/
	double	**likelihood;	
	double	npseudo;	/* npseudo = # pseudo priors */
	double	*N0;		/* N0(r) = # pseudo residues by type */
        double	*freq;          /* freq(b)= total frequency of b's */ 
	int	totsites;	/* number of sites in model */
	long	tot_cnts;	/* total number of residues */
	long	*counts;	/* total number of b residues in sequences */
	double	log_alpha;	/* log of the number of letters in alphabet */
	boolean	update;		/* update the normalized freq */
	double	*temp;		/* temp(r) = temp double array */
} model_type;
typedef model_type *m_type;

/********************************* PRIVATE ********************************/
void    update_model_freqN(m_type M);

/********************************* PUBLIC ********************************/
m_type  Model(int length, double npseudo, long *counts, a_type A);
void    InitModel(m_type M);
void    ShiftModel(long *site_freq, boolean left, m_type M);
double  RatioModel(boolean left, long *site_freq, int d, m_type M);
void    Add2Model(char *seq, int site, m_type M);
void    RmModel(char *seq, int site, m_type M);
double	RelProbModel(register char *seq, register m_type M);
m_type  NilModel(m_type M);
double  LogLikeModel(m_type  M);
void    PutModel(FILE *fptr, m_type M);

/********************************* MACROS ********************************/
#define LenModel(M)	((M)->length)

#endif
