#if !defined (OLIST)
#define OLIST
#include "stdinc.h"
/**************************  ADT olist ********************************

        This data structure is part of a package of object oriented
        C code for molecular biological applications developed by
        Andrew F. Neuwald.

 Header file for data structure representing ordered list of small 
positive integers.

	list: x  x  x   ... x   where x < x < x < ... < x
               1  2  3       n         1   2   3         n

	and 0 < n <= N.	(note: next[x ] = x   .)
				     i     i+1
**********************************************************************/

typedef struct {
	int	N;		/* list defined on ints in {1,...,N} */
	int	n;		/* number of elements in list */
	int	*next;		/* next[i] is successor of i in list */
} orderlist_type;

typedef orderlist_type *ol_type;

void olist_error(char *s);
/****************************** PUBLIC ***************************/
ol_type	Olist(int N);
int	RmOlist(int i, ol_type L);
int	InsertOlist(int i, ol_type L); /* access item i in THETA(i) time */
void	PutOlist(FILE *fptr, ol_type L);		/* print item i on list */
void    GetOlist(int *array, ol_type L);
void	NilOlist(ol_type L);

/********************** MACROS **********************************/

/* Return number of elements in list */
#define LengthOlist(L)	((L)->n)
#define ClearOlist(L)	((L)->next[0]=0)

#endif
