#include "sequence.h"

e_type	ReadSeq(FILE *fptr, int I, int size, a_type A)
{
	char	c='x',*id,*seq;
	int	length,i;
	e_type	E;

        while(c != EOF){ if((c=fgetc(fptr)) == '>') break; }
	if(c==EOF) return NULL;
	NEW(id,60,char);
        for(i=0; (c=fgetc(fptr))!=EOF; i++){ 
		if(c=='\n') { if(i<60)id[i]= '\0'; break; }
		else if(i<59) id[i] = c;
		else if(i==59) id[i] = '\0';
	}
	NEW(seq,size+1, char);
        for(length=1; (c=fgetc(fptr))!=EOF; ){ 
		if(c == '>') { ungetc(c,fptr); break; }
		else if(isalpha(c)) {
			if(islower(c)) c = toupper(c);
			seq[length++] = AlphaCode(c,A);
		}
        }
	length--;
	if(length > size) seq_error("size and length inconsistency");
	NEW(E,1,sequence_type); 
	E->info=id;  E->n = (unsigned short) length;
	E->I = (unsigned short) I; 
	E->S = seq;  
	return E; 
}

/************************* Randomization Routines ***********************/
e_type	RandomizeSeq(e_type E, double *freq, a_type A)
/* destroy E and return a randomly generated new sequence of same 
length with residue frequency " freq" */
{
	int 	i,c;
	double	r;

	for(i=1;i<=(int)E->n; i++) {
		r = (double) RandomNum()/(double) LONG_MAX; /* 0 <= r <= 1 */
		for(E->S[i]=0,c=1; c <= nAlpha(A); c++){
			r=r-freq[c];
			if(r <= 0.0){ E->S[i]=c; break; }
		}
	}
	if(E->info!=NULL)free(E->info); E->info = NULL; return E;
}

char	RandomResSeq(register e_type E)
/* return a randomly obtained residue in sequence E */
{
	register int	i;
	register double	r;

	do {
		r = (double) RandomNum()/(double) LONG_MAX; /* 0 <= r <= 1 */
		i = (int) (r*E->n + 1); 
	} while(i < 1 && i > (int) E->n);
	return E->S[i];
}

e_type	RtnShuffleSeq(e_type E)
/* randomly permute the sequence E.S using a heap */
{
	char	*S;
	e_type	rE;
	int 	i,n;
	dh_type	H;

	NEW(rE,1,sequence_type); 
	rE->I = 0; n = rE->n = E->n;
	NEW(rE->S,n+1,char);
	H = dheap(n+1,4);
	for(i=1;i<=n;i++){ insrtHeap(i,((keytyp)RandomNum()),H);}
	for(i=1;i<=n;i++) rE->S[i] = E->S[delminHeap(H)];
	Nildheap(H); rE->info=NULL; 
	return rE;
}

e_type	ShuffleSeq(e_type E)
/* randomly permute the sequence E.S using a heap */
{
	char	*S;
	int 	i,s;
	dh_type	H;

	NEW(S,E->n+1,char);
	H = dheap(E->n+1,4);
	for(i=1;i<=(int)E->n; i++) 
		{ S[i]=E->S[i];insrtHeap(i,((keytyp)RandomNum()),H);}
	for(i=1;i<=(int)E->n; i++) E->S[i] = S[delminHeap(H)];
	Nildheap(H); free(S); 
	if(E->info!=NULL)free(E->info); E->info = NULL; 
	return E;
}

void	PutSeqID(FILE *fptr,e_type E)
{	if(E->info !=NULL) fprintf(fptr,"%s\n", E->info); 
	else fprintf(fptr,"random%d   \n",E->I);}

void    PutSeq(FILE *fptr,e_type E,a_type A)
{
	int 	j;

	fprintf(fptr,">"); PutSeqID(fptr,E);
	for(j=1; (int)j <= (int)E->n; j++) {
	   fprintf(fptr,"%c",AlphaChar(E->S[j],A));
	   if(j%10 == 0) fprintf(fptr," ");
	   if(j%50 == 0) fprintf(fptr,"\n");
	}
	fprintf(fptr,"\n\n");
}


void    PutSeqRegion(FILE *fptr,int start, int length, e_type E, a_type A)
{
	int	e,end,i;

	fprintf(fptr,"%4d  ",start);
	e = start + length - 1;
	end = e + 10;
	for(i=start-10; i <= end; i++){
		if(i < 1 || i > (int) E->n) fprintf(fptr," ");
		else if(i == e) {
			fprintf(fptr,"%c ", AlphaChar(E->S[i],A));
		} else if(i == start) {
			fprintf(fptr," %c", AlphaChar(E->S[i],A));
		} else {
			fprintf(fptr,"%c", AlphaChar(E->S[i],A));
		}
	}
	fprintf(fptr," %4d",e);
}

e_type	NilSeq(e_type E)
{
	if(E!=NULL){
		free(E->S);
		if(E->info!=NULL)free(E->info);
		free(E);
	}
	return NULL;
}

int	seq_error(char *s){fprintf(stderr,"Seq: %s\n",s);exit(1);}

