/* entity.h - entity data type. */
#if !defined(SEQUENCE)
#define SEQUENCE
#include "stdinc.h"
#include "alphabet.h"
#include "dheap.h"
#include <stdlib.h>
/**************************** Sequence ADT ***************************

        This data structure is part of a package of object oriented
        C code for molecular biological applications developed by
        Andrew F. Neuwald.

		E == <I,S>	2-tuple

		I == 'unique' sequence identification key
		S == biological sequence 

**********************************************************************/

/******************************** PRIVATE **********************************/
/******************************** entity type *****************************/
typedef struct {
	unsigned short		I;	/* identifier for entity */
	unsigned short		n;	/* length of entity sequence */
	char			*S;	/* sequence */
	char			*info;	/* description of entity */
} sequence_type;

typedef sequence_type	*e_type;

int     seq_error(char *s);

/******************************** PUBLIC **********************************/
/************************* Sequence Operations **************************/
e_type  ReadSeq(FILE *fptr, int I, int size, a_type A);
e_type	NilSeq(e_type E);			/* undefine entity */
void    PutSeqID(FILE *fptr,e_type E);
void    PutSeq(FILE *fptr,e_type E,a_type A);
int     ProcessSeq(e_type E,a_type A,double lambda,double K,double H);
e_type	ShuffleSeq(e_type E);
e_type	RtnShuffleSeq(e_type E);
e_type  RandomizeSeq(e_type E, double *freq, a_type A);
void    PutSeqRegion(FILE *fptr,int start, int length, e_type E, a_type A);
char    RandomResSeq(register e_type E);

/************************* Macro Operations ****************************/
/************************* Sequenceuence Definitions **************************/
#define	LenSeq(E)		((E)->n)
#define	ResSeq(i,E)		((E)->S[(i)])
#define EqSeq(i,x,E)		((E)->S[(i)]=(char) (x))
#define EqSeqKey(x,E)		((E)->info=(x))
#define RmSeq(E)		((E)->I=NULL)
#define EqSeqI(i,E)		((E)->I=(unsigned short) (i))
#define SeqI(E)			((E)->I)
#define SeqKey(E)		((E)->info)
#define SeqPtr(E)		((E)->S)
#endif

