/****************** sites.h - sites abstract data type.***************/
#if !defined(SITES)
#define SITES
#include "stdinc.h"
#include "olist.h"
/*************************** ADT sites *********************************

        This data structure is part of a package of object oriented
        C code for molecular biological applications developed by
        Andrew F. Neuwald.

Defines regions of sequences to different types of elements.  

ntyp = 6; 	t = ( A  B  C  D  E  F)
len_elem = 	      5  5  3  3  5  6
maxinc = min(len_elem) - 1 = 2

type[1]   =    A  F  B  E  D
pos[1]    =    3 18 30 40 50 
 
type[2]   =    E  D  C  B  F  A  D  D
pos[2]    =    6 13 21 24 33 42 52 55

type[3]   =    C  E  A  F  D  B
pos[3]    =    4 10 18 23 32 38

nseq = 3	( 1   2   3)
len_seq =	 57  59  51
nsites[A] =       1   1   1
nsites[B] =       1   1   1
nsites[C] =       0   1   1
nsites[D] =       1   3   1
nsites[E] =       1   1   1
nsites[F] =       1   1   1

type[1]:     ..Axxxx..........Fxxxxx......Bxxxx.....Exxxx.....Dxx.....
type[2]:     .....Exxxx..Dxx.....CxxBxxxx....Fxxxxx...Axxxx.....DxxDxx..
type[3]:     ...Cxx...Exxxx...AxxxxFxxxxx...Dxx...Bxxxx.........
 	     ....:....|....:....|....:....|....:....|....:....|....:....|
                 5   10   15   20   25    30  35   40   45   50   55   60

Note: '.' = VACANT; 'x' = BLOCKED.

pos_prob(t,n,i) = probability of a t site in sequence n at position i.
	NOTE: pos_prob[t][n][0] = sum of probs. 
 ********************************************************************/

typedef struct {
	int	nseq;		/* number of sequences */
	int	*len_seq;	/* length of sequences */
	int	ntyp;		/* ntyp = number of types of elements. */
	int	*len_elem;	/* len_elem(t) = the length of element t */
	int	maxinc;		/* maxinc = length of shortest element - 1 */
	int	**nsites;	/* nsites(t,n) = # of type t sites in seq n */
	char	**type;		/* type(n,i) = type of ith element in seq n */
	ol_type *pos;		/* ordered list of site positions in seq n */
	int	*tmp;		/* temp. buffer for site positions */
	double	***pos_prob;	/* probability of a t site at pos i in seq n*/
} sites_type;

typedef sites_type *st_type;

/********************************* PRIVATE ********************************/
#define VACANT			0
#define BLOCKED			-1
#define MAX_NO_TYPESITES	100

void    sites_error(char *s);
/********************************* PUBLIC ********************************/
st_type Sites(int ntyp,int *site_len, int nseq, int *len_seq);
st_type	CopySites(st_type S);
void	NilSites(st_type S);
void    ShiftSites(st_type S, int t, boolean left);
void    ShiftSitesM(st_type S, int t, int d);
void    ShiftSites2(st_type S, int t, boolean left);
void	GrowSites(int t, st_type S);
void	ShrinkSites(int t, st_type S);
void	VacateSite(int t, int n, int site, st_type S);
void    AddSite(int t, int n, int site, st_type S);
int     AddRandomSite(int t,int n,st_type S);
boolean OccupiedSite(register int t, register int n, register int site, 
        register st_type S);
double	MissInfoSites(int typ, st_type S);
void	PosSites(int n, int *pos, st_type S);
void    PosTSites(int t, int n, int *pos, st_type S);
void	OrderSites(int n, int *order, st_type S);
void    GetSitePos(int ***site_pos, st_type S);
int     ChooseSite(int t, int n, st_type S);
void    InitSites(st_type S);
void	PutSites(FILE *fptr, st_type S);

/********************************* MACROS ********************************/
#define TypeSite(n,s,S)		((S)->type[(n)][(s)])
#define StartSite(n,s,S)	((S)->type[(n)][(s)] > 0)
#define nSites(t,n,S)		((S)->nsites[(t)][(n)])
#define SiteLen(t,S)		((S)->len_elem[(t)])
#define nTypeSites(S)		((S)->ntyp)
#define OpenPos(n,s,S)		(!(S)->type[(n)][(s)])
#define PosProbSite(t,n,S)	((S)->pos_prob[(t)][(n)])

#endif

