/* The dokey routine handles a keypress event. */
/* Return Values: */
/* 0	The program should exit becuase the user selected quit */
/* 1	This routine handled the key press */
/* 2	There was nothing to do for this key press, so treat it normally. */

/* Sam Southard, Jr. */
/* Created: 17-Sep-1991 (from mainloop.c) */
/*  1-Oct-1991	SNS/CIT	Now knows about row and column plots */
/*  3-Oct-1991	SNS/CIT	Now knows about increasing, decreasing, and resetting */
/*			the slit width. */
/*  7-Oct-1991	SNS/CIT	Now looks up all keys in a table.  Key to inhibit */
/*			interpretation of other keys added. */
/*  8-Oct-1991	SNS/CIT	Now gets global variables from globals.h */
/* 21-Nov-1991	SNS/CIT	Now recenters properly at non-zero zoom factors */
/* 25-Nov-1991	SNS/CIT	Now handles separate X & Y zoom factors */
/*  8-Apr-1992	SNS/CIT	Title string now updated. */
/* 10-Apr-1992	SNS/CIT	Now takes into account winxoff & winyoff */
/* 14-Apr-1992	SNS/CIT	Modified to run under VMS. */
/* 24-Jun-1992	SNS/CIT	Now knows about histogram equalization */
/* 25-Jun-1992	SNS/CIT	Now flushes the display if we handled the key press. */
/* 30-Sep-1992	SNS/CIT	LUT_WRAP no longer a compile-time definition.  RCS id */
/*			string added.  Now uses calclinear and newmapping */
/*			functions. */
/*  4-Oct-1992	SNS/CIT	No longer needs #ifdef KECK. */
/* 13-Oct-1992	ARC/HI	histkey now cycles between histogram, linear ramp */
/*			within limits, and linear ramp.  Boxmode key added. *
/*			Modification of the transformation from image data */
/*			value to LUT entry now done in imagescale routine. */

#ifndef lint
static char rcsid[]="@(#)$Id: dokey.c,v 1.12 1992/11/26 01:22:31 figaro Exp $";
#endif

/* The program include files */
#include "figdisp.h"
#include "commands.h"
#include "globals.h"
#include "messages.h"

/* The system include files */
#include <stdio.h>

/* The window shift factor */
#define SHIFT 0.75

int dokey(event)
XKeyEvent event;	/* the event which prompted this. */
{
	int imx, imy;	/* the image coordinates */
	char dum;	/* a dummy character */
	KeySym keysym;	/* the key that was pressed */
	char newtitle[80];		/* the new title window */
	char *strptr= &newtitle[0];	/* a pointer to the new title window */
	static int inhibit=0;	/* inhibit other key translations */
	int max;	/* The maximum number of colors */
	int i,j;	/* silly loop variables */
	int itmp;	/* an integer temporary */
	int lutent;	/* A lut entry */
	int *tmpptr;	/* a temporary pointer. */

	void updatetitle();	/* update the title bar */
	void zoomim();		/* update the zoom factor */
	void showloc();		/* show the location windo */
	void printhelp();	/* print the help message */
	void redrawim();	/* redraw the image */
	void updatepatch();	/* update the patch window */
	void lwprintwin();	/* print an area of the image in PostScript */
	void transluts();	/* update the lookup tables */
	int doseeing();	/* calculate the seeing near a given point */
	void doslit();		/* make the line drawing */
	void calchist();	/* Calculate the histogram equalization data */

#ifndef _AIX
#ifndef VMS
	char *sprintf();
#endif
#endif

	/* first we handle the three function keys for toggle */
	/* cursor, zoom out, and zoom in */
	(void)XLookupString(&event, &dum, 1, &keysym, (XComposeStatus *)NULL);

	if (event.window == bm.win)
	{
		imx=display_to_imagecol(event.x);
		imy=display_to_imagerow(event.y);
	} else if (event.window == loc.win) {
		imx=(event.x-BLANK_WIDTH)*((double)bm.imwidth/loc.width);
		imy=(event.y-BLANK_WIDTH)*((double)bm.imheight/loc.height);
	} else imx=imy= -1;

	if (inhibit && keysym != res.keys[INHIBIT]) return(2);

	if (keysym == res.keys[CURSOR])
	{
		if (bm.showcur)
		{
			bm.showcur=0;
			(void)sprintf(&newtitle[0],"bitmap graphics #%d",
				res.id);
			if (XStringListToTextProperty(&strptr, 1, &bm.winname))
				XSetWMName(display, bm.win, &bm.winname);
		} else {
			bm.showcur=1;
			if (event.window == bm.win)
				updatetitle(event.x, event.y, 1);
			else updatetitle(-1, -1, 1);
		}
	} else if (keysym == res.keys[ZOOMOUT]) {
		zoomim(bm.xzoom-1, bm.yzoom-1);
		if (event.window == bm.win) updatetitle(event.x,event.y, 0);
		showloc();
	} else if (keysym == res.keys[ZOOMNORM]) {
		zoomim(0, 0);
		if (event.window == bm.win) updatetitle(event.x,event.y, 0);
		showloc();
	} else if (keysym == res.keys[ZOOMIN]) {
		zoomim(bm.xzoom+1, bm.yzoom+1);
		if (event.window == bm.win) updatetitle(event.x, event.y, 0);
		showloc();
	} else if (keysym == res.keys[ZOOMXIN]) {
		zoomim(bm.xzoom+1, bm.yzoom);
		if (event.window == bm.win) updatetitle(event.x, event.y, 0);
		showloc();
	} else if (keysym == res.keys[ZOOMXOUT]) {
		zoomim(bm.xzoom-1, bm.yzoom);
		if (event.window == bm.win) updatetitle(event.x, event.y, 0);
		showloc();
	} else if (keysym == res.keys[ZOOMYIN]) {
		zoomim(bm.xzoom, bm.yzoom+1);
		if (event.window == bm.win) updatetitle(event.x, event.y, 0);
		showloc();
	} else if (keysym == res.keys[ZOOMYOUT]) {
		zoomim(bm.xzoom, bm.yzoom-1);
		if (event.window == bm.win) updatetitle(event.x, event.y, 0);
		showloc();
	} else if (keysym == res.keys[HELP]) printhelp();
	else if (keysym == res.keys[RECENTER]) {
		bm.xoff= bm.imwidth >> 1;
		bm.yoff= bm.imheight >> 1;

		if (bm.xzoom >= 0) bm.xoff -= (bm.width >> (bm.xzoom+1));
		else if (bm.xzoom < -1) bm.xoff -= (bm.width << (-bm.xzoom-1));
		else bm.xoff -= bm.width;

		if (bm.yzoom >= 0) bm.yoff -= (bm.height >> (bm.yzoom+1));
		else if (bm.yzoom < -1) bm.yoff -= (bm.height << (-bm.yzoom-1));
		else bm.yoff -= bm.height;
		XFillRectangle(display, bm.win, bitgcclear, 0, 0, bm.width,
			bm.height);
		redrawim(display_to_imagecol(0), display_to_imagerow(0),
			display_to_imagecol(bm.width-1),
			display_to_imagerow(bm.height-1));
		if (event.window == bm.win)  updatetitle(event.x,event.y, 0);
		showloc();
	} else if (keysym == res.keys[SHIFTL]) {
		if (bm.xzoom >= 0) bm.xoff -= ((int)(SHIFT*bm.width) >> (bm.xzoom+1));
		else if (bm.xzoom < -1) bm.xoff -= ((int)(SHIFT*bm.width) << (-bm.xzoom-1));
		else bm.xoff -= SHIFT*bm.width;

		XFillRectangle(display, bm.win, bitgcclear, 0, 0, bm.width,
			bm.height);
		redrawim(display_to_imagecol(0), display_to_imagerow(0),
			display_to_imagecol(bm.width-1),
			display_to_imagerow(bm.height-1));

		if (event.window == bm.win)  updatetitle(event.x,event.y, 0);
		showloc();
	} else if (keysym == res.keys[SHIFTR]) {
		if (bm.xzoom >= 0) bm.xoff += ((int)(SHIFT*bm.width) >> (bm.xzoom+1));
		else if (bm.xzoom < -1) bm.xoff += ((int)(SHIFT*bm.width) << (-bm.xzoom-1));
		else bm.xoff += SHIFT*bm.width;

		XFillRectangle(display, bm.win, bitgcclear, 0, 0, bm.width,
			bm.height);
		redrawim(display_to_imagecol(0), display_to_imagerow(0),
			display_to_imagecol(bm.width-1),
			display_to_imagerow(bm.height-1));

		if (event.window == bm.win)  updatetitle(event.x,event.y, 0);
		showloc();
	} else if (keysym == res.keys[SHIFTU]) {
		if (bm.yzoom >= 0) bm.yoff -= ((int)(SHIFT*bm.height) >> (bm.yzoom+1));
		else if (bm.yzoom < -1) bm.yoff -= ((int)(SHIFT*bm.height) << (-bm.yzoom-1));
		else bm.yoff -= SHIFT*bm.height;

		XFillRectangle(display, bm.win, bitgcclear, 0, 0, bm.width,
			bm.height);
		redrawim(display_to_imagecol(0), display_to_imagerow(0),
			display_to_imagecol(bm.width-1),
			display_to_imagerow(bm.height-1));

		if (event.window == bm.win)  updatetitle(event.x,event.y, 0);
		showloc();
	} else if (keysym == res.keys[SHIFTD]) {
		if (bm.yzoom >= 0) bm.yoff += ((int)(SHIFT*bm.height) >> (bm.yzoom+1));
		else if (bm.yzoom < -1) bm.yoff += ((int)(SHIFT*bm.height) << (-bm.yzoom-1));
		else bm.yoff += SHIFT*bm.height;

		XFillRectangle(display, bm.win, bitgcclear, 0, 0, bm.width,
			bm.height);
		redrawim(display_to_imagecol(0), display_to_imagerow(0),
			display_to_imagecol(bm.width-1),
			display_to_imagerow(bm.height-1));

		if (event.window == bm.win)  updatetitle(event.x,event.y, 0);
		showloc();
	} else if (keysym == res.keys[SHOWPAT]) {
		if (patch.mapped && event.window == patch.win)
		{
			XUnmapWindow(display, patch.win);
			patch.mapped=0;
		} else if (event.window == bm.win || event.window == loc.win) {
			XMapWindow(display, patch.win);
			updatepatch(imx, imy);
			patch.mapped=1;
		}
	} else if (keysym == res.keys[SHOWLOC]) {
		if (loc.mapped)
		{
			XUnmapWindow(display, loc.win);
			loc.mapped=0;
		} else {
			XMapWindow(display, loc.win);
			loc.mapped=1;
		}
	} else if (keysym == res.keys[IMPS])
		lwprintwin(0, 0, bm.imwidth, bm.imwidth);
	else if (keysym == res.keys[WINPS]) lwprintwin(display_to_imagecol(0),
		display_to_imagerow(0), display_to_imagecol((int)bm.width-1)-
		display_to_imagecol(0)+1,
		display_to_imagerow((int)bm.height-1)-
		display_to_imagerow(0)+1);
	else if (keysym == res.keys[INVERT]) {
		bm.invert = !bm.invert;
		transluts();
	} else if (keysym == res.keys[HISTOGRAM]) {
		if (!usehist && !useramp) usehist=1;
		else if (usehist && !useramp) {
			usehist=0;
			useramp=1;
		} else usehist=useramp=0;
		imagescale(usehist, useramp);
		/* re-map the image with the new translation */
		newmapping();
	} else if (keysym == res.keys[MOUSEMODE]) {
		mousemode = !mousemode;
		display_mousemode();
	} else if (keysym == res.keys[DOBOX]) {
		if (box.mapped && event.window == box.win) {
			box.mapped=0;
			XUnmapWindow(display, box.win);
		} else do_box();
	} else if (keysym == res.keys[SEEING]) {
		if (seeing.mapped && event.window == seeing.win)
		{
			seeing.mapped=0;
			XUnmapWindow(display, seeing.win);
		} else if (event.window == bm.win || event.window == loc.win) {
			seeing.mapped=1;
			if (!doseeing(imx,imy))
				seeing.mapped = 0;
			else
				XMapWindow(display, seeing.win);
		}
	} else if (keysym == res.keys[SHOWCM]) {
		if (cwin.mapped)
		{
			XUnmapWindow(display, cwin.win);
			cwin.mapped=0;
		} else {
			XMapWindow(display, cwin.win);
			cwin.mapped=1;
		}
	} else if (keysym == res.keys[ROW]) {
		if (event.window == bm.win || event.window == loc.win)
			doslit(display_to_imagecol(0), imy,
				display_to_imagecol((int)bm.width-1), imy);
	} else if (keysym == res.keys[COL]) {
		/* the plot goes from bottom to top, not top to bottom */
		if (event.window == bm.win || event.window == loc.win)
			doslit(imx, display_to_imagerow((int)bm.height-1), imx,
				display_to_imagerow(0));
	} else if (keysym == res.keys[INCSLIT]) {
		++lg.xzoom;
		(void)printf("Now averaging %d pixels\n", (1 << lg.xzoom)+1);
	} else if (keysym == res.keys[DECSLIT]) {
		--lg.xzoom;
		if (lg.xzoom < 0) lg.xzoom = 0;
		if (lg.xzoom > 0)
			(void)printf("Now averaging %d pixels\n",
				(1 << lg.xzoom)+1);
		else (void)printf("No longer averaging pixels\n");
	} else if (keysym == res.keys[RESSLIT]) {
		lg.xzoom=0;
		(void)printf("No longer averaging pixels\n");
	} else if (keysym == res.keys[QUIT]) return(0);
	else if (keysym == res.keys[INHIBIT]) {
		if (inhibit) inhibit=0;
		else inhibit=1;
	} else if (keysym == res.keys[DECLUTWRAP]) {
		if ((tmpptr=(int *)realloc(histpix,
			(lutwrap-1)*bm.colors*sizeof(int))) == NULL)
		{
			(void)fprintf(stderr,MSG_MALLOC);
		} else {
			histpix=tmpptr;
			--lutwrap;
			/* The histogram data is now invalid */
			goodhist=0;
			calclinear();
			newmapping();
		}
	} else if (keysym == res.keys[INCLUTWRAP]) {
		if ((tmpptr=(int *)realloc(histpix,
			(lutwrap+1)*bm.colors*sizeof(int))) == NULL)
		{
			(void)fprintf(stderr,MSG_MALLOC);
		} else {
			histpix=tmpptr;
			++lutwrap;
			/* The histogram data is now invalid */
			goodhist=0;
			calclinear();
			newmapping();
		}
	} else if (keysym == res.keys[RESLUTWRAP]) {
		if ((tmpptr=(int *)realloc(histpix, bm.colors*sizeof(int)))
		    == NULL)
		{
			(void)fprintf(stderr,MSG_MALLOC);
		} else {
			histpix=tmpptr;
			lutwrap=1;
			/* The histogram data is now invalid */
			goodhist=0;
			calclinear();
			newmapping();
		}
	}
	/* we didn't handle it, so just treat it as normal */
	else return(2);

	/* we did handle it */
	XFlush(display);
	return(1);
}
