      SUBROUTINE CMP_COMP_LZW_12BIT(OLDSTR,NEWSTR,NEWLEN)
      INTEGER*4 NEWLEN
      CHARACTER*(*) OLDSTR
      CHARACTER*(*) NEWSTR
C
C     Global variables
      INCLUDE 'LZW.INC'
C
C     Compress
      RETAB=LZW_DYN
      MAXBIT=12
      NCHAR=8
      NBUF=4095
      STOR=LZW_HASH
      CALL CMP_COMP_LZW(OLDSTR,NEWSTR,NEWLEN)
C
      RETURN
      END
C*****************
      SUBROUTINE CMP_COMP_LZW_16BIT(OLDSTR,NEWSTR,NEWLEN)
      INTEGER*4 NEWLEN
      CHARACTER*(*) OLDSTR
      CHARACTER*(*) NEWSTR
C
C     Global variables
      INCLUDE 'LZW.INC'
C
C     Compress
      RETAB=LZW_DYN
      MAXBIT=16
      NCHAR=16
      NBUF=65535
      STOR=LZW_HASH
      CALL CMP_COMP_LZW(OLDSTR,NEWSTR,NEWLEN)
C
      RETURN
      END
C*****************
      SUBROUTINE CMP_EXP_LZW_12BIT(OLDSTR,NEWSTR,NEWLEN)
      INTEGER*4 NEWLEN
      CHARACTER*(*) OLDSTR
      CHARACTER*(*) NEWSTR
C
C     Global variables
      INCLUDE 'LZW.INC'
C
C     Expand
      RETAB=LZW_DYN
      MAXBIT=12
      NCHAR=8
      NBUF=4095
      STOR=LZW_SEQ
      CALL CMP_EXP_LZW(OLDSTR,NEWSTR,NEWLEN)
C
      RETURN
      END
C*****************
      SUBROUTINE CMP_EXP_LZW_16BIT(OLDSTR,NEWSTR,NEWLEN)
      INTEGER*4 NEWLEN
      CHARACTER*(*) OLDSTR
      CHARACTER*(*) NEWSTR
C
C     Global variables
      INCLUDE 'LZW.INC'
C
C     Expand
      RETAB=LZW_DYN
      MAXBIT=16
      NCHAR=16
      NBUF=65535
      STOR=LZW_SEQ
      CALL CMP_EXP_LZW(OLDSTR,NEWSTR,NEWLEN)
C
      RETURN
      END
C*****************
      SUBROUTINE CMP_LZW_CLEAR
C
C     Global variables
      INCLUDE 'LZW.INC'
C
C     Local variables
      INTEGER*4 I
C
C     Clear hash-table
      IF(STOR.EQ.LZW_HASH) CALL HSH_INIT(NHSH,HSHSTR,HSHNXT,HSHFRE)
C
C     Initialise string buffer
      NLZW=-1
      DO 100 I=0,255
        CALL CMP_LZW_ADD(CHAR(I))
100   CONTINUE
      NBIT=9
C
      RETURN
      END
C*****************
      SUBROUTINE CMP_COMP_LZW(OLDSTR,NEWSTR,NEWLEN)
      INTEGER*4 NEWLEN
      CHARACTER*(*) OLDSTR
      CHARACTER*(*) NEWSTR
C
C     Global variables
      INCLUDE 'LZW.INC'
C
C     Local variables
      INTEGER*4 I,J,K,L
C
C     Functions
      INTEGER*4 CMP_LZW_FIND
C
C     Initialize
      CALL CMP_LZW_INIT(1)
C
C     Loop through string
      J=1
      I=1
      L=LEN(OLDSTR)
100   IF(I.LE.L) THEN
        K=CMP_LZW_FIND(OLDSTR(I:L))
        CALL BF_PACK(NEWSTR,J,NBIT,K)
        J=J+NBIT
        I=I+LZWLEN(K)
        IF(RETAB.EQ.LZW_DYN.AND.NLZW.GE.NBUF) THEN
          IF(3*NBIT.GT.8*LZWLEN(K)) THEN
            BAD=BAD+1
          ELSE
            GOOD=GOOD+1
          ENDIF
        ENDIF
        IF(NLZW.LT.NBUF.AND.LZWLEN(K).LT.NCHAR.AND.I.LE.L) THEN
          CALL CMP_LZW_ADD(OLDSTR(I-LZWLEN(K):I))
          IF(RETAB.EQ.LZW_DYN.AND.NLZW.GE.NBUF) THEN
            GOOD=0
            BAD=0
          ENDIF
        ENDIF
        IF(NBIT.LT.MAXBIT.AND.NLZW.GT.2**NBIT-1) NBIT=NBIT+1
        GOTO 100
      ENDIF
      IF((RETAB.EQ.LZW_AUTO.AND.NLZW.GE.NBUF).OR.
     +   (RETAB.EQ.LZW_DYN.AND.NLZW.GE.NBUF.AND.GOOD+100.LT.BAD)) THEN
        CALL CMP_LZW_CLEAR
      ENDIF
      IF(J.GE.NBIT-1) THEN
        NEWLEN=(J-2)/8+1
      ELSE
        NEWLEN=0
      ENDIF
C
      RETURN
      END
C*****************
      SUBROUTINE CMP_EXP_LZW(OLDSTR,NEWSTR,NEWLEN)
      INTEGER*4 NEWLEN
      CHARACTER*(*) OLDSTR
      CHARACTER*(*) NEWSTR
C
C     Global variables
      INCLUDE 'LZW.INC'
C
C     Local variables
      INTEGER*4 I,J,K,K2,L,L2
C
C     Initialize
      CALL CMP_LZW_INIT(2)
C
C     Loop through string
      L=LEN(OLDSTR)*8
      I=1
      J=1
      LASTK=-1
100   IF(I+NBIT-1.LE.L) THEN
        CALL BF_UNPACK(OLDSTR,I,NBIT,K)
        I=I+NBIT
        IF(K.LE.NLZW) THEN
          NEWSTR(J:J+LZWLEN(K)-1)=LZWSTR(K)(1:LZWLEN(K))
          J=J+LZWLEN(K)
          K2=K
          L2=LZWLEN(K)
        ELSE
          NEWSTR(J:J+LZWLEN(LASTK)-1)=LZWSTR(LASTK)(1:LZWLEN(LASTK))
          NEWSTR(J+LZWLEN(LASTK):J+LZWLEN(LASTK))=LZWSTR(LASTK)(1:1)
          J=J+LZWLEN(LASTK)+1
          K2=LASTK
          L2=LZWLEN(LASTK)+1
        ENDIF
        IF(LASTK.GE.0.AND.LZWLEN(LASTK).LT.NCHAR.AND.NLZW.LT.NBUF) THEN
          CALL CMP_LZW_ADD(LZWSTR(LASTK)(1:LZWLEN(LASTK))//
     +                     LZWSTR(K2)(1:1))
          IF(RETAB.EQ.LZW_DYN.AND.NLZW.GE.NBUF) THEN
            GOOD=0
            BAD=0
          ENDIF
        ENDIF
        IF(RETAB.EQ.LZW_DYN.AND.NLZW.GE.NBUF) THEN
          IF(3*NBIT.GT.8*L2) THEN
            BAD=BAD+1
          ELSE
            GOOD=GOOD+1
          ENDIF
        ENDIF
        IF(LZWLEN(K).LT.NCHAR.AND.I+NBIT+1-1.LE.L.AND.
     +     NBIT.LT.MAXBIT.AND.NLZW+1.GT.2**NBIT-1) NBIT=NBIT+1
        LASTK=K
        GOTO 100
      ENDIF
      IF((RETAB.EQ.LZW_AUTO.AND.NLZW.GE.NBUF).OR.
     +   (RETAB.EQ.LZW_DYN.AND.NLZW.GE.NBUF.AND.GOOD+100.LT.BAD)) THEN
        CALL CMP_LZW_CLEAR
      ENDIF
      NEWLEN=J-1
C
      RETURN
      END
C*****************
      SUBROUTINE CMP_LZW_ADD(ADDSTR)
      CHARACTER*(*) ADDSTR
C
C     Global variables
      INCLUDE 'LZW.INC'
C
C     Local variables
      INTEGER*4 LA
      INTEGER*4 I,J
*     INTEGER*4 I2,L,BOT,TOP
      INTEGER*4 P
      CHARACTER*16 TMP
C
C     Functions
      INTEGER*4 HSH_INS
C
C     Add string
      LA=LEN(ADDSTR)
      NLZW=NLZW+1
      LZWLEN(NLZW)=LA
      LZWSTR(NLZW)(1:LA)=ADDSTR
      IF(STOR.EQ.LZW_SEQ.OR.(STOR.EQ.LZW_SORT.AND.NLZW.LE.255)) THEN
        LZWIX(NLZW)=NLZW
      ELSE IF(STOR.EQ.LZW_SORT) THEN
*        BOT=0
*        TOP=NLZW
*        I=-1
*100     I2=I
*        I=(TOP+BOT)/2
*        L=LZWLEN(LZWIX(I))
*        IF(ADDSTR.LT.LZWSTR(LZWIX(I))(1:L)) THEN
*          TOP=I
*        ELSE
*          BOT=I
*        ENDIF
*        IF(I.NE.I2.AND.TOP.GE.BOT) GOTO 100
        I=SAVI
        I=I+1
        DO 200 J=NLZW,I+1,-1
          LZWIX(J)=LZWIX(J-1)
200     CONTINUE
        LZWIX(I)=NLZW
      ELSE IF(STOR.EQ.LZW_HASH) THEN
        CALL STR_INIT(TMP,CHAR(255))
        TMP(1:LA)=ADDSTR
        P=HSH_INS(TMP,NHSH,HSHSTR,HSHNXT,HSHFRE)
        HSHIX(P)=NLZW
      ENDIF
C
      RETURN
      END
C*****************
      INTEGER*4 FUNCTION CMP_LZW_FIND(FNDSTR)
      CHARACTER*(*) FNDSTR
C
C     Global variables
      INCLUDE 'LZW.INC'
C
C     Local variables
      INTEGER*4 LF
      INTEGER*4 I,I2,L,TOP,BOT
      INTEGER*4 P,P2,ML
      CHARACTER*16 TMP
C
C     Functions
      INTEGER*4 HSH_FND
C
C     Find match
      LF=LEN(FNDSTR)
      IF(STOR.EQ.LZW_SORT) THEN
        BOT=0
        TOP=NLZW
        I=-1
100     I2=I
        I=(TOP+BOT)/2
        L=MIN(LF,LZWLEN(LZWIX(I)))
        IF(FNDSTR(1:L).LT.LZWSTR(LZWIX(I))(1:L).or.
     +     (LF.LT.LZWLEN(LZWIX(I)).AND.
     +     FNDSTR(1:L).EQ.LZWSTR(LZWIX(I))(1:L))) THEN
          TOP=I
        ELSE
          BOT=I
        ENDIF
        IF(I.NE.I2.AND.TOP.GE.BOT) GOTO 100
        IF(I.LT.NLZW) THEN
          L=LZWLEN(LZWIX(I+1))
          IF(LF.GE.L.AND.FNDSTR(1:L).EQ.LZWSTR(LZWIX(I+1))(1:L)) I=I+1
        ENDIF
        IF(NLZW.LT.NBUF) SAVI=I
200     L=LZWLEN(LZWIX(I))
        IF(LF.LT.L.OR.FNDSTR(1:L).NE.LZWSTR(LZWIX(I))(1:L)) THEN
          I=I-1
          GOTO 200
        ENDIF
        CMP_LZW_FIND=LZWIX(I)
      ELSE IF(STOR.EQ.LZW_HASH) THEN
        CALL STR_INIT(TMP,CHAR(255))
        ML=0
300     IF(ML+1.LE.NCHAR.AND.ML+1.LE.LF) THEN
          TMP(1:ML+1)=FNDSTR(1:ML+1)
          P=HSH_FND(TMP,NHSH,HSHSTR,HSHNXT,HSHFRE)
          IF(P.GT.0.AND.LZWLEN(HSHIX(P)).EQ.ML+1) THEN
            P2=P
            ML=ML+1
            GOTO 300
          ENDIF
        ENDIF
        CMP_LZW_FIND=HSHIX(P2)
      ENDIF
C
      RETURN
      END
C*****************
      SUBROUTINE CMP_LZW_INIT(CNTX)
      INTEGER*4 CNTX
C
C     Global variables
      INCLUDE 'LZW.INC'
C
C     Local variables
      INTEGER*4 CONTXT
      LOGICAL*4 FIRST
C
C     Data initialization
      DATA FIRST/.TRUE./
      DATA CONTXT/0/
C
C     Test if already done
      IF(.NOT.FIRST.AND.CNTX.EQ.CONTXT) RETURN
      FIRST=.FALSE.
      CONTXT=CNTX
C
C     Initialise string buffer
      CALL CMP_LZW_CLEAR
C
      RETURN
      END
