G c     ***************************************************************** / c     INSTRUCTIONS FOR INPUT DATA FILE SETUP   < c     Data to be read by this program are set up as follows: c + c     lx (x dimension of 3 layer structure) + c     ly (y dimension of 3 layer structure) ! c     ls (thickness of top layer) , c     ks (thermal conductivity of top layer)% c     lc (thickness of middle layer)  / c     kc (thermal conductivity of middle layer) % c     li (thickness of bottom layer)  / c     ki (thermal conductivity of bottom layer) - c     nup (upper limit of n sum, x direction) - c     mup (upper limit of m sum, y direction)  c = c     iedgex (=0 for default, =1 to alter range of x values)  = c     IF iedgex=1 THEN the follwoing segment of input is read @ c                 ilx (the number of increments in x to be used)? c                     (ilx+1=the number of x values to be used) 8 c                 x1 (the value of the first point in x), c                 stepx (the increment in x)3 c     ELSE iedgex=0  read x1 (the constant x value)  c = c     iefgey (=0 for default, =1 to alter range of y values)  = c     IF iedgey=1 THEN the following segment of input is read @ c                 ily (the number of increments in y to be used)? c                     (ily+1=the number of y values to be used) 8 c                 y1 (the value of the first point in y), c                 stepy (the increment in y)3 c     ELSE iedgex=0  read x1 (the constant x value)  c = c     iedgez (=0 for default, =1 to alter range of z values)  = c     IF iedgez=1 THEN the following segment of input is read A c                 ilz (then number of increments in z to be used) ? c                     (ilz+1=the number of z values to be used) 8 c                 z1 (the value of the first point in z), c                 stepz (the increment in z)3 c     ELSE iedgex=0  read x1 (the constant x value)  c     B c     NOTE: As the calculation takes the z variable to be zero or @ c           negative, enter z1 and stepz as positive quantities.@ c           The program changes the sign of z1 and stepz to make+ c           the calculation for negative z.  c   . c     nsour (number of heat sources, up to 20) c     p0 (power density)6 c     xsour(1) (x coordinate of origin of 1st source) 6 c     ysour(1) (y coordinate of origin of 1st source) 8 c     lxsour(1) (length along x direction of 1st source)8 c     lysour(1) (length along y direction of 1st source)9 c     remaining heat sources with same input structure as  c G c     *****************************************************************  c 7       dimension x(0:500),y(0:500),z(0:500),cosyt(0:500) 7       dimension aruzer(0:500,0:500),arfunz(0:500,0:500) #       dimension xsour(20),ysour(20)         real lxsour(20),lysour(20)"       real ks,kc,ki,lx,ly,ls,lc,li$       common ks,kc,ki,lx,ly,ls,lc,li,       common nsour,xsour,ysour,lxsour,lysour c D c     ************************************************************** c & c     DOCUMENTATION AND BACKGROUND   H c     This program calculates the surface temperature T(x,y,z) due to dcE c     power inputs only.  The temperature is the temperature relative @ c     to the ambient.  The specific equations used are given in = c     equations (13)-(23), with s=0 (steady-state condition), A c     in the paper by Kokkas (ref: "Thermal Analysis of Multiple- G c     Layered Structures" by Achilles G. Kokkas, IEEE Trans. Elec. Dev. * c     Vol. ED-21, No. 11, 674-681 (1974)).? c     VARIABLES USED: The variables listed as real in the above D c     are the following-ks,kc, and ki are the thermal conductivitiesC c     of the semiconductor, conductor, and insulator, respectively. ; c     lx and ly are the lateral dimension of the chip while A c     ls,lc, and li are the thicknesses of the semiconductor, the 1 c     conductor, and the insulator, respectively. B c     IMPORTANT NOTE:  While the variables have the notation whichD c     seems to imply a semiconductor, a conductor, and an insulator,D c     these refer to the way in which Kokkas formulated the problem.B c     The thing to keep in mind is that the top layer has (ls,ks),E c     the middle layer has (lc,kc), and the bottom layer has (li,ki). E c     It is not necessary that they be what they seem to be, they areoH c     determined by the respective thicknesses, l, and conductivities,k. c C c     *************************************************************a c)  1    format(1h1)sE  2    format(1x,'Steady-State Thermal Analysis Calculation using eqs.       1 (13)-(23) of Kokkas',/)?  3    format(1x,'Thermal Conductivities and Layer Thicknesses')i9  4    format(1x,'ks= ',f10.8,' kc= ',f10.8,' ki= ',f10.8) 9  5    format(1x,'ls= ',f10.5,' lc= ',f10.5,' li= ',f10.5) :  6    format(/,1x,'Upper Summation Limits:',2x,' nup=',i5,      1 '  mup=',i5,/)r0  7    format(//,1x,'Number of Heat Sources=',i5)G  8    format(/,1x,'Coordinates, Lengths, and Widths of Heat Sources',/) B  9    format(1x,'Heat Source#',7x,'xsour',10x,'ysour',9x,'lxsour',      1 9x,'lysour',/)e7  10   format(7x,i3,5x,f10.5,5x,f10.5,5x,f10.5,5x,f10.5)*'  11   format(1x,'Power Density=',f12.6) F  12   format(/,1x,'Calculating ',i3,' X points with a first point of '*      $  ,f5.1,' and a step size of ',f7.3)7  13   format(/,1x,'The constant X coordinate is ',f5.1)uF  14   format(/,1x,'Calculating ',i3,' Y points with a first point of '*      $  ,f5.1,' and a step size of ',f5.1)7  15   format(/,1x,'The constant Y coordinate is ',f5.1)*F  16   format(/,1x,'Calculating ',i3,' Z points with a first point of '*      $  ,f5.1,' and a step size of ',f5.1)7  17   format(/,1x,'The constant Z coordinate is ',f5.1)sG  18   format(//,1x,'The processing date is ',a9,' and the time is ',a8)t,  27   format(1x,'Lx= ',f7.2,3x,' Ly= ',f7.2)9  25   format(//,1x,'X VALUES',3X,'Y VALUES',3X,'Z VALUES')       1      ,3X,'TEMPERATURE',/)!  22   format(1x,3(f8.2,3X),f10.4)   31   format(1x,6i7) csG c     *****************************************************************12 c     DATA INPUT SECTION (DATA READ FROM FOR010) H c     ****************************************************************** ch       ixflg = 0i       iyflg = 0t       izflg = 0 
       ilx=0.0i
       ily=0.0c
       ilz=0.0        stepx=1.0        stepy=1.0        stepz=-1.0         write(11,1)        write(11,2)        write(11,3)rH c     lx and ly are the x and y dimmensions of the rectangluar structure       read(10,*)lx,lya       write(11,27)lx,lyiN c     ls is the thickness and  ks is the thermal conductivity of the top layer       read(10,*)ls,ksiM c     lc is the thickness and kc is the thermal conductivity the middle layer        read(10,*)lc,kcsM c     li is the thickness and ki is the thermal conductivity the bottom layer        read(10,*)li,kih       write(11,5)ls,lc,lio       write(11,4)ks,kc,kimF c     nup is the upper limit of the summation over the index n (x-dir)F c     mup is the upper limit of the summation over the index m (y-dir)       read(10,*)nup,mupm       write(11,6)nup,mup.       if (nup.gt.500.or.mup.gt.500) go to 3999H  888  format(1x,'Your upper limit of summation is too large. Try again')       read(10,*)iedgex. c     set iedgex=0 to get constant point for x? c     set iedgex=1 to set the limits of the calculation along x        if(iedgex.eq.0) go to 115        read(10,*)ilx,x1,stepx       write(11,12)ilx,x1,stepx       go to 125   115  read(10,*)x1       write(11,13)x1       ixflg = 1   125  read(10,*)iedgey. c     set iedgey=0 to get constant point for yA c     set iedgey=1 to set the limits of the calculation along y  c       if(iedgey.eq.0) go to 135        read(10,*)ily,y1,stepy       write(11,14)ily,y1,stepy       go to 150   135  read(10,*)y1       write(11,15)y1       iyflg = 1s  150  read(10,*)iedgez. c     set iedgez=0 to get constant point for z? c     set iedgez=1 to set the limits of the calculation along zv        if (iedgez.eq.0) go to 160       read (10,*)ilz,z1,stepzp       write(11,16)ilz,z1,stepz       z1=-1.0*z1       stepz=-1.0*stepz       goto 175  160  read(10,*)z1       write(11,17)z1       z1 = -1.0*z1 l       izflg = 1l  175  read(10,*)nsour,p0> c     p0 is the power density, assumed uniform for all heatersI c     nsour is the total number of heating elements on the surface of thez+ c     the top layer (up to 20 are possible)        write(11,7)nsour       write(11,11) p0        write(11,8)        write(11,9)eA c     the next loop reads in the coordinates of the origin of the : c     heating elements along with their lengths and widths       area = 0.0       do 100 i=1,nsour5       read(10,*)xsour(i),lxsour(i),ysour(i),lysour(i)a)       area = area + lxsour(i) * lysour(i)fG c     xsour(i) is the x coordinate of the origin of i-th heater elementfF c     lxsour(i) is the length of the i-th heater along the x directionG c     ysour(i) is the y coordinate of the origin of i-th heater elementcF c     lysour(i) is the length of the i-th heater along the y direction9       write(11,10)i,xsour(i),ysour(i),lxsour(i),lysour(i)y  100  continue c      ilx=int(lx) c      ily=int(ly) c      total=ls+lc+li5 c      ilz=int(total)        write(11,1)d c E c     ***************************************************************  cr% c     END OF DATA INPUT SECTION      ? c     End of Input Section.  The thermal conductivities of the kE c     semiconductor, conductor, and insulator, the thicknesses of thenE c     semiconductor, conductor, and insulator, the x and y dimensionsmB c     of the chip, the number of heating sources and their x,y and) c     lenght and width have been entered.8 c G c     *****************************************************************  cd   180 pi=3.14159265e       close (10)#       p04lk = 4.0 * p0 / (lx*ly*ks)x       pilx = pi / lx       pily = pi / ly c H c     ******************************************************************A c     CALCULATE THE X(0:INTX), Y(0:INTY), AND Z(0:INTZ) ARRAYS   H c     ****************************************************************** ct
       x(0)=x1p       do 200 i=1,ilx       x(i)=x(i-1)+stepxs  200  continue
       y(0)=y1        do 220 i=1,ily       y(i)=y(i-1)+stepy,  220  continue
       z(0)=z11       do 240 i=1,ilz       z(i)=z(i-1)+stepz,  240  continue c1E c     ***************************************************************  c ' c     BEGIN CALCULATION OF T(X,Y,Z)   t2 c     The subroutines used in the calculation are:E c     1) uzero(n,m) - calculates the Fourier cosine transform of the (D c        function, U(x,y), the power density function for all of the c        heat sources.D c     2) funz(n,m,z) - calculates the z-dependent portion of the sum> c        remembering that this is a function of the summation  c        indices (n,m).  csE c     ***************************************************************  ch coG c     *****************************************************************1D c     CALCULATE THE FOURIER COMPONENTS OF THE HEAT SOURCES, U(N,M) G C     *****************************************************************g ct       do 300 m=0,mup       do 250 n=0,nup          aruzer(n,m)=uzero(n,m)e  250  continue  300  continue c,G c     *****************************************************************  c C c     END OF U(N,M) CALCULATION AND BEGINNING OF MAJOR LOOP FOR Z s ceG c     *****************************************************************  cr       l = 0  cg       do 3000 iz=0,ilz c G c     ***************************************************************** < c     CALCULATE THE Z DEPENDENT POTION, I.E., FUNZ(N,M,Z)  G c     *****************************************************************5 c        do 400 m=0,mup       do 350 n=0,nup0          arfunz(n,m)=funz(n,m,z(iz))*aruzer(n,m)  350  continue  400  continue c'          write (20,25)       do 3000  iy=0,ily        do 700 m=0,mup#          cosyt(m)=cos(m*y(iy)*pily)   700  continue ca       do 3000 ix=0,ilx          sum=0.0          do 1900 n=0,nup          do 1700 m=0,mup             ndn=0c             ndm=0e             if (n.eq.0) ndn=1,             if (m.eq.0) ndm=1t<             top = arfunz(n,m) * cos(n*x(ix)*pilx) * cosyt(m)"             bottom=(ndn+1)*(ndm+1)             tsum=top/bottom              sum=sum+tsum  1700    continue   1900    continue8          temp = p04lk * sum ,          write (20,22)x(ix),y(iy),z(iz),temp  3000 continue       go to 4000  3999 write(6,888)	  4000 end) c2E c     ****************************************************************! c     END OF THE MAIN PROGRAM  *4 c     Begin Listing of the Subroutines and FunctionsF c     These are: uzero(n,m) - the double Fourier transform of the heat& c                             sources,F c                funz(n,m,z) - the z dependent portion of the functionE c     ***************************************************************0 c        function uzero(n,m)r#       dimension xsour(20),ysour(20)         real lxsour(20),lysour(20)"       real ks,kc,ki,lx,ly,ls,lc,li$       common ks,kc,ki,lx,ly,ls,lc,li,       common nsour,xsour,ysour,lxsour,lysour ceE c     ***************************************************************c. c     DESCRIPTION OF THE FUNCTION UZERO(N,M) B c     This function calculates the double Fourier cosine transformC c     of the power density function, U(x,y).  This is the transform C c     for ALL of the heat sources.  The assumption is made that theeB c     power density is uniform and equal to unity over the surface( c     of the heating elements.  That is,7 c       U(x,y)=1  (xsour(i)<=x<=xsour(i)+lxsour(i)  andf5 c                  ysour(i)<=y<=yxour(i)+lysour(i) ).d c       U(x,y)=0  otherwise.E c     Under these conditions, it is possible to analytically evaluate*C c     the double integral for each heating element.  As the heatingMC c     elements are assumed to be independent, the contribution from*= c     each element may be added to obtain the U(n,m) for all.  c E c     **************************************************************** c*       pi=3.14159265*       uzero=0.0        do 500 i=1,nsour          if(n.eq.0) go to 100ZH            termx=sin(n*pi*(xsour(i)+lxsour(i))/lx)-sin(n*pi*xsour(i)/lx)             termx=termx*lx/(n*pi)            go to 150  100     termx=lxsour(i)  150     if(m.eq.0) go to 200tH            termy=sin(m*pi*(ysour(i)+lysour(i))/ly)-sin(m*pi*ysour(i)/ly)             termy=termy*ly/(m*pi)            go to 250  200     termy=lysour(i)  250     termi=termx*termy          uzero=uzero+termi  500  continue       return	       end  c G c     *****************************************************************  cf       function funz(n,m,z)#       dimension xsour(20),ysour(20)x        real lxsour(20),lysour(20)"       real ks,kc,ki,lx,ly,ls,lc,li$       common ks,kc,ki,lx,ly,ls,lc,li,       common nsour,xsour,ysour,lxsour,lysour cmF c     **************************************************************** cn/ c     DESCRIPTION OF THE FUNCTION FUNZ(N,M,Z) nE c     This function is used to calculate the z dependent part of the *G c     function using the s=0 versions of equations (15)-(17) of Kokkas.bF c     These are used in conjunction with equations (18)-(22) also for B c     s=0 (steady-state condition).  The specific form of funz is G c     determined by the value of z, i.e., if z falls in the top, middle F c     or bottom layer of the structure.  In addition, special care is G c     taken as to evaluate funz for the case where gamma=0 as these arelD c     simple, but the computer does not know how to evaluate limits.F c     In addition, the form of the three solutions has been changed toA c     get rid of the artificial overflow problems coming from the*B c     hyperbolic functions, cosh and sinh, for the cases where the c     arguments become large.  crF c     **************************************************************** c        pi=3.14159265 /       gamma=sqrt((n*pi/lx)**2.0+(m*pi/ly)**2.0)a       vs=gamma*ls        vc=gamma*lci       vi=gamma*lin       vt=gamma*(ls+z)        vm=gamma*(ls+lc+z)       vb=gamma*(ls+lc+li+z)1       bot1=tanh(vs)*tanh(vi))       bot1=bot1+(ki/kc)*tanh(vs)*tanh(vc)=,       bot2=(kc/ks)*tanh(vi)*tanh(vc)+(ki/ks)       gfunc=1.0/(bot1+bot2)d       az=abs(z)*       if (az.gt.ls) go to 500d c G c     *****************************************************************x$ c            TOP LAYER CALCULATION B c     This portion is the top layer calculation which is defaulted& c     to if z falls into the top layer cN!       if (gamma.eq.0.0) go to 100S&       terms1=tanh(vi)+(ki/kc)*tanh(vc)9       terms2=(kc/ks)*tanh(vt)*(tanh(vi)*tanh(vc)+(ki/kc))        terms=terms1+terms2        if (z.eq.0.0) go to 90+       if (vs.gt.5.0.and.vt.gt.5.0) go to 80        if (vs.lt.5.0) go to 10o       c1=2.0*exp(-vs)        go to 20  10   c1=1.0/cosh(vs)+  20   continue       if (vt.lt.5.0) go to 30*       c2=0.5*exp(vt)       go to 40  30   c2=cosh(vt)   40   continue"       funz=gfunc*terms*c1*c2/gamma       return)  80   funz=gfunc*terms*exp(gamma*z)/gammam       return  90   funz=gfunc*terms/gamma       return'  100  funz=(ls+z)+(ks/kc)*lc+(ks/ki)*lif       return  500  total=ls+lch$       if (az.gt.total) go to 1500    cuG c     *****************************************************************i( c            MIDDLE LAYER CALCULATION  C c     This is the middle layer calculation which is defaulted to if*( c     z falls into this domain of depths c*"       if (gamma.eq.0.0) go to 1000%       termc=tanh(vi)+(ki/kc)*tanh(vm)H:       if (vs.gt.5.0.and.vc.gt.5.0.and.vm.gt.5.0) go to 800       if (vs.lt.5.0) go to 250       c1=2.0*exp(-vs)*       go to 260   250  c1=1.0/cosh(vs)   260  continue       if (vc.lt.5.0) go to 270       c2=2.0*exp(-vc)        go to 280   270  c2=1.0/cosh(vc)   280  continue       if (vm.lt.5.0) go to 320       c3=0.5*exp(vm)       go to 330e  320  c3=cosh(vm)p  330  continue%       funz=gfunc*termc*c1*c2*c3/gammab       return-  800  funz=gfunc*termc*2.0*exp(gamma*z)/gamma*       return'  1000 funz=(ks/ki)*li+(ks/kc)*(ls+lc+z)*       return c9G c     ***************************************************************** ' c           BOTTOM LAYER CALCULATION  +C c     This is the bottom layer calculation which is used if z fallsc c     into the bottom layert ce"  1500 if (gamma.eq.0.0) go to 20004       if (vs.gt.5.0.and.vc.gt.5.0.and.vi.gt.5.0.and.      1 vb.gt.5.0) go to 1900G       if(vb.gt.5.0.and.vs.gt.5.0.and.vc.lt.5.0.and.vi.lt.5.0)go to 2100cG       if(vb.gt.5.0.and.vs.lt.5.0.and.vc.gt.5.0.and.vi.lt.5.0)go to 2200sG       if(vb.gt.5.0.and.vs.lt.5.0.and.vc.lt.5.0.and.vi.gt.5.0)go to 2300 G       if(vb.gt.5.0.and.vs.gt.5.0.and.vc.gt.5.0.and.vi.lt.5.0)go to 2400)G       if(vb.gt.5.0.and.vs.gt.5.0.and.vc.lt.5.0.and.vi.gt.5.0)go to 2500.G       if(vb.gt.5.0.and.vs.lt.5.0.and.vc.gt.5.0.and.vi.gt.5.0)go to 2600*       if (vs.lt.5.0) go to 1550T       c1=2.0*exp(-vs)        go to 1560  1550 c1=1.0/cosh(vs)l  1560 continue       if (vc.lt.5.0) go to 1570o       c2=2.0*exp(-vc)        go to 1580  1570 c2=1.0/cosh(vc)m  1580 continue       if (vi.lt.5.0) go to 1590)       c3=2.0*exp(-vi)h       go to 1600  1590 c3=1.0/cosh(vi)   1600 continue       c4=sinh(vb) "       funz=gfunc*c1*c2*c3*c4/gamma       return'  1900 funz=gfunc*4.0*exp(gamma*z)/gamma-       return  2000 funz=(ks/ki)*(ls+lc+li+z)2       return5  2100 funz=gfunc*exp(vb-vs)/(gamma*cosh(vc)*cosh(vi))        return5  2200 funz=gfunc*exp(vb-vc)/(gamma*cosh(vs)*cosh(vi))r       return5  2300 funz=gfunc*exp(vb-vi)/(gamma*cosh(vs)*cosh(vc))m       return3  2400 funz=gfunc*2.0*exp(vb-vs-vc)/(gamma*cosh(vi))        return3  2500 funz=gfunc*2.0*exp(vb-vs-vi)/(gamma*cosh(vc))h       return3  2600 funz=gfunc*2.0*exp(vb-vc-vi)/(gamma*cosh(vs))*       return	       end*