   #include <stdio.h> #include <math.h>  #ifndef VMS  #include <sys/types.h> #include <sys/timeb.h> #include <sys/times.h> #endif   #include "ipstruct.h"  #include "simconst.h"  #include "simstruct.h" #include "simglbdef.h" #include "simmac.h"  #include "mstruct.h" #include "dcsol.h" #include "timer.h"  ' /* flags to print stuff in dc solver */  /* #define  DCDEBUG     #define  NODE_STATE_ONLY     #define  IC_ONLY     #define DUMP_STATS     #define  DCITER    #define TIMER_INFO */    # /* global variables in this file */ K int DCMode = 0; /* 0=Newton-Raphson, 1=SRC-Stepping, 2=Logic-Initialization  		   3=Gmin-stepping */  int totalIterations = 0; double maxDeltaV; % static double StartTime, ElapsedTime;  int numberOfNodesProcessed = 0;  double high = 0.0, low = 0.0;  struct event { 	struct event *next; 	int next_node;  }; struct state { 	double voltage; 	int strength; };> struct event *event_list_head = NULL, *event_list_tail = NULL;< struct event *free_list_head = NULL, *free_list_tail = NULL;$ int free_list_counter, numRallocs=0;% struct event *input_list_head = NULL; % int super_node_list[MAX_WIRED_NODES]; + int event_list_array[MAX_NODES_IN_CIRCUIT]; ( struct state node_state, internal_state;; int nodeContention,forcedSchedule,first_node=0,last_node=0;  double previousVoltage; < int dcitercnt; /* moved out of dcnewton for Bipolar Model */  
 subdc(subptr)  struct subcircuit *subptr; {  int i; int rampingInputs; struct waveform *waveptr;  double waveval(); $ double *savedInputs,*savedSolutions; double srcStep,rampVal;  double ratio, startgmin=1.0e-3;  int numnriter; int srcmaxdciter=20;   #ifndef VMS  starttimer;  #endif" /* Set the time to starttime. */  " subptr->newtime->time = starttime;  A /* UseNodeSet(); 	grab the nodeset values provided by the user */    maxDeltaV = nralpha;( if(DCMode == 2) { /* logic simulation */F   LogicSim(subptr);  /* go off and get a good guess for DC voltages */B   DCMode = 0; /* force regular dc analysis after logic analysis */N   maxDeltaV = 5.0;  /* after logic, the solutions are allowed to swing more */
 #ifdef DCITER  printf(" Logic Solution\n"); #endif }   . if(DCMode == 0 ) { /* regular Newton method *// /* Get the inputs, ground and initial guess. */ C   for(i=subptr->external; i<0; i++) subptr->newtime->nodevolt[i] =  B 	 waveval(subptr->waveptrarray[i]->present,subptr->newtime->time);#   subptr->newtime->nodevolt[0] = 0; "   for(i=1; i<=subptr->size; i++) {  	subptr->newtime->nodevolt[i] = I          waveval(subptr->waveptrarray[i]->present,subptr->newtime->time); 
 #ifdef DCITER Q printf(" net %s value %g\n",NODE_NAME(subptr->waveptrarray[i]->present->nodenum),  	subptr->newtime->nodevolt[i]);  #endif   } 
 #ifdef DCITER :   printf("Size for the DC solution = %d\n", subptr->size); #endif /* Do the newton. */C   i = dcnewton(subptr->newtime->current, subptr->present->nodevolt, ; 		subptr->newtime->nodevolt, subptr->rhs, subptr, maxdcnr);    if(i != TRUE) { M     if(i == SING) printf("No dc convergence due to singular jacobian!!!!\n"); E     else printf("No dc convergence in %d iterations!!!!\n", maxdcnr);      DCMode = 3;    }  } & if(DCMode == 3) { /* gmin stepping. */
 #ifdef DCITER    printf("gmin stepping\n"); #endif* /* Set up parameters for gmin stepping. */   maxDeltaV = 2.0;   maxdcnr = 50; - /* Store initial guesses in separate array */ N   savedSolutions = (double *) ralloc((abs(subptr->size) + 1), sizeof(double));  / /* Get the inputs, ground and initial guess. */ B   for(i=subptr->external; i<0; i++) subptr->newtime->nodevolt[i] =B 	 waveval(subptr->waveptrarray[i]->present,subptr->newtime->time);#   subptr->newtime->nodevolt[0] = 0;   !   for(i=1; i<=subptr->size; i++)  3 	subptr->newtime->nodevolt[i] = savedSolutions[i] = A 	waveval(subptr->waveptrarray[i]->present,subptr->newtime->time);   1   for(numnriter=1 , ratio=2.0 , gmin = startgmin; & 					 numnriter != 0; gmin /= ratio) {
 #ifdef DCITER      printf("gmin=%g\n", gmin); #endif   /* Do the newton. */E     i = dcnewton(subptr->newtime->current, subptr->present->nodevolt, M         subptr->newtime->nodevolt, subptr->rhs, subptr, maxdcnr, &numnriter); $     if(i == TRUE) { /* Converged. */:       if((numnriter < 10) && (ratio < 10.0)) ratio += 1.0;%       for(i=1; i<=subptr->size; i++)  3 		savedSolutions[i] = subptr->newtime->nodevolt[i];      }      else if(i == SING) {A       printf("No dc convergence due to singular jacobian!!!!\n");        exit(0);     } N     else { /* Didn't converge.  Reduce the ratio of increase and try again. */(       if(gmin < startgmin) gmin *= 10.0;       gmin *= ratio;&       ratio = 1.0 + (ratio - 1.0)/2.0;%       for(i=1; i<=subptr->size; i++)  3 		subptr->newtime->nodevolt[i] = savedSolutions[i];      }    }  } ' if(DCMode == 1) { /* source stepping */ 
 #ifdef DCITER    printf("src-stepping\n");  #endif(   srcStep = NOMINAL_STEP; rampVal = 0.0;E /* Store final input values and initial guesses in separate arrays */ O   savedInputs = (double *) ralloc((abs(subptr->external) + 1), sizeof(double)); N   savedSolutions = (double *) ralloc((abs(subptr->size) + 1), sizeof(double));  / /* Get the inputs, ground and initial guess. */ 9   for(i=subptr->external; i<0; i++) savedInputs[abs(i)] = B 	 waveval(subptr->waveptrarray[i]->present,subptr->newtime->time);  ( /* Initialize external inputs to zero */%   for(i=subptr->external; i<0; i++) { $ 	subptr->newtime->nodevolt[i] = 0.0;   } #   subptr->newtime->nodevolt[0] = 0; !   for(i=1; i<=subptr->size; i++)  3 	subptr->newtime->nodevolt[i] = savedSolutions[i] = A 	waveval(subptr->waveptrarray[i]->present,subptr->newtime->time); 
 #ifdef DCITER :   printf("Size for the DC solution = %d\n", subptr->size); #endif     rampingInputs = TRUE;   ; /* Enter source-stepping loop and start with srcFraction */    while (rampingInputs) { C       rampVal += srcStep; /* ramp up supplies by another srcStep */ 
 #ifdef DCITER ;       printf(" percentage of final value = %g \n",rampVal);  #endif)       for(i=subptr->external; i<0; i++) { B 	    subptr->newtime->nodevolt[i] = rampVal * savedInputs[abs(i)]; #ifdef DCDEBUGI 	    printf(" input node %d value %g\n",i,subptr->newtime->nodevolt[i]);   #endif       }      /* Do the newton. */G       i = dcnewton(subptr->newtime->current, subptr->present->nodevolt, @ 		 subptr->newtime->nodevolt, subptr->rhs, subptr,srcmaxdciter);       if(i != TRUE) {  	if(i == SING) {@ 	    printf("No dc convergence due to singular jacobian!!!!\n");
 	    exit(0);  	} 	else { 
 #ifdef DCITER F 	    printf("No dc convergence in %d iterations!!!!\n", srcmaxdciter); #endif@ 	    /* should retry with a smaller source step and reinitialize 	       solution vector */ 	    rampVal -= srcStep; 	    srcStep /= 2.0; 	    if(srcStep < MIN_STEP) { G 	    	printf("No dc convergence in %d iterations!!!!\n", srcmaxdciter); 
 		exit(0); 	    }&   	    for(i=1; i<=subptr->size; i++) 3 		subptr->newtime->nodevolt[i] = savedSolutions[i];  	}       } H       else {  /* modify srcStep if necessary and check to see if done */"   	for(i=1; i<=subptr->size; i++) 3 		savedSolutions[i] = subptr->newtime->nodevolt[i]; 9 	if ((rampVal + srcStep) >= 1.0) srcStep = 1.0 - rampVal; 0 	else if(srcStep < NOMINAL_STEP)	srcStep *= 2.0;3 	if(srcStep > NOMINAL_STEP) srcStep = NOMINAL_STEP;        }        if (rampVal >= 1.0)  	rampingInputs = FALSE;       } /* while */ }  #ifndef VMS 
 stoptimer;<   printf(" Cpu time used during DC solution = %g\n", dtime); #endif #ifdef TIMER_INFO B   printf(" Total number of DC Iterations = %d\n",totalIterations); #endif  G /* Store the dc result in the present and previous waveform buffers. */ )   storewave(subptr->newtime, 0, subptr);  
 #ifdef DCITER    printf(" DC Solution\n");  #endif #ifdef IC_ONLY   printf(".IC ");  #endifG   for(i=1; i <= subptr->size; i++) { /* Rotate the waveform buffers. */ /     waveptr = subptr->waveptrarray[i]->present; I     subptr->waveptrarray[i]->present = subptr->waveptrarray[i]->previous; 0     subptr->waveptrarray[i]->previous = waveptr;
 #ifdef DCITER Q printf(" net %s value %g\n",NODE_NAME(subptr->waveptrarray[i]->present->nodenum),  	subptr->newtime->nodevolt[i]);  #endif #ifdef IC_ONLYM     printf(" V(%s)=%g", NODE_NAME(subptr->waveptrarray[i]->present->nodenum),  	subptr->newtime->nodevolt[i]);      if((i%5) == 0) 	printf("\n+ "); #endif   } )   storewave(subptr->newtime, 0, subptr);     #ifdef IC_ONLY 	printf("\n"); #endif   /* Deallocate the Matrix. */C /*  if(subptr->sparse == TRUE) DeallocateMatrix(subptr->matrix); */     }   E dcnewton(current, tempvolt, nodevolt, rhs, subptr,maxDCIter,pnumiter) , double *current, *tempvolt, *nodevolt, *rhs; struct subcircuit *subptr; int maxDCIter, *pnumiter;  { 9 double temp, nodemin, nodemax, newnorm, cost, thresh=0.0;  int convergence, giter;  register int j,lsize; 
 #ifdef DCITER  int largeChange; #endif  
 /* Set up. */    lsize = subptr->size;    /* Main loop. */O   for(dcitercnt=1 , convergence = FALSE; dcitercnt <= maxDCIter; dcitercnt++) {      totalIterations++;"   /* Generate Newton direction. */%     dcloadall(nodevolt, rhs, subptr); = /*    disinvect(nodevolt, subptr->size, subptr->external); */   =   /* Compute the sum of the currents, and bound by 1/gmin. */ )     for(cost=0.0, j=1; j <= lsize; j++) { . /*      if(rhs[j] > 1.0/gmin) rhs[j] = 1/gmin;.       if(rhs[j] < -1.0/gmin) rhs[j] = -1/gmin; */$       cost = max(cost,dabs(rhs[j]));     }   %   /* Decompose and solve Jacobian. */  #ifdef mc5002     if(ludecompose(subptr) == FALSE) return(SING); #else 2     if(ludecompose(subptr) == FALSE) return(SING); #endif     lusol(rhs,subptr);  M   /* Compute the max norm of newton step and limit step in voltage vector. */ H     for(newnorm=0.0 , nodemax=0.0 , nodemin=0.0 ,j=1; j <= lsize; j++) {       temp = dabs(rhs[j]);  "       newnorm = max(newnorm,temp);K       if(temp > maxDeltaV) {  /* Corrupt newton direction. My apologies. */ 6 	rhs[j] = ( (rhs[j] > 0) ? maxDeltaV : -(maxDeltaV) );       } /       nodemax = max(nodemax,dabs(nodevolt[j]));      }     
 #ifdef DCITER I   /* Check to see how many nodes changed significantly this iteration. */ +     for(largeChange=0,j=1; j<=lsize; j++) { /     	if( dabs(rhs[j]) > 0.0001 ) largeChange++;      } H     printf("dcitercnt = %d.  %g percent of nodes changed.\n", dcitercnt,0 	100.0 * (double)(largeChange)/(double)(lsize));I     printf("nodemax=%g delvmax=%g costmax =%g\n", nodemax, newnorm,cost);  #endif!   /* Check on the convergence. */ H     if( (newnorm <= nrvabs + (nrvrel * nodemax)) && (cost <= nrcabs) ) {+ 					          convergence = TRUE; break; }   C   /* Move nodevolt in the newton (possibly corrupted) direction. */ 2     for(j=1; j<=lsize; j++) nodevolt[j] -= rhs[j];   }   N /* If convergence achieved, set gmin to 0, and reevalute the node currents. */   if(convergence == TRUE) {      temp = gmin;
     gmin = 0; #     dcrhsload(nodevolt,rhs,subptr); G     for(cost=0.0 , j=1; j <= lsize; j++) cost = max(cost,dabs(rhs[j]));      gmin = temp;!   /* Check on the convergence. */ H     if(cost >= nrcabs) { /* If the node currents not zero, warn user. */       if(DCMode != 3) { M         printf("Warning: Gmin=%g may be effecting the DC solution.\n", gmin); J         printf("Consider rerunning the simulation with a smaller gmin\n");       }      } H     else if(DCMode == 3) dcitercnt = 0; /* Note sol. not eff by gmin. */   }   
 #ifdef DCITER O   if(convergence == TRUE) printf("Newton converged in %d iters.\n", dcitercnt);  #endif(   if(DCMode == 3) *pnumiter = dcitercnt;   return(convergence); }    SetDCSolverControl(str) 
 char *str; {    	DCMode = 0;! 	if( strcmp( "NR", str ) == 0 ) { 
 		DCMode = 0; 	 		return;  	}, 	else if( strcmp( "src-step", str ) == 0 ) {
 		DCMode = 1; 	 		return;  	}) 	else if( strcmp( "logic", str ) == 0 ) { 
 		DCMode = 2; 	 		return;  	}- 	else if( strcmp( "gmin-step", str ) == 0 ) { 
 		DCMode = 3; 	 		return;  	}N 	printf( "Illegal mode. Use either src-step, NR, logic-init or gmin-step.\n"); }      UseNodeSet() {    int i;  ?   for(i=1; i < maxnode; i++) { /* Run through all the nodes. */ *     /* if(NODESET_USED(i) == USER_VALUE) {) 	PRESENT_STATE( i ) = NODESET_VALUE( i ); * 	PREVIOUS_STATE( i ) = NODESET_VALUE( i );     } )     else if (WAVETYPE(i) != USERSRC) { */       	NODESET_USED(i) = NOT_USED; 	NODESET_VALUE( i ) = 0.0;     /* } */    }  }    struct event *GetInputList()   { '   struct event *list_head, *next_event; 
   int i,j; 	 >   list_head = (struct event *) ralloc(1,sizeof(struct event));   list_head->next = NULL;    next_event = list_head; ?   for(i=1; i < maxnode; i++) { /* Run through all the nodes. */ :     if(WAVETYPE(i) == USERSRC) {  /* identify src nodes */ #ifdef DCDEBUG2        printf(" input node %s with wavesize=%d\n",, 		NODE_NAME(i), waves[i].present->wavesize); #endif 	   next_event->next_node = i;G 	   next_event->next = (struct event *) ralloc(1,sizeof(struct event)); " 	   next_event = next_event->next;   	   next_event->next = NULL;* 	   high = max( high, PRESENT_STATE( i ));     } 
     else {' 	PREVIOUS_STATE( i ) = UNDEFINED_STATE; " 	NODESET_USED( i ) = FORCED_VALUE;     }    }  #ifdef DCDEBUG+   printf(" HIGH %g and LOW %g\n",high,low);  #endif   return(list_head); }    ReprocessUndefNodes()  {    int j,i,node;  #ifdef DCDEBUG&   printf(" In ReprocessUndefNodes\n"); #endifP   for(i=1; i < maxnode; i++) { /* Run through all the nodes.>>> in rank order */     if(WAVETYPE(i) != USERSRC)  -      if((NODESET_USED(i) == FORCED_VALUE) ||  , 		(PREVIOUS_STATE(i) == UNDEFINED_STATE)) {  	ProcessNode( i );  # 	while( event_list_head != NULL ) { $ 		node = event_list_head->next_node; 		if(free_list_head == NULL) {$ 			free_list_head = event_list_head;$ 			free_list_tail = event_list_head; 		}  		else {* 			free_list_tail->next = event_list_head;$ 			free_list_tail = event_list_head; 		} * 		event_list_head = event_list_head->next; 		if(node > 0) { 		   ProcessNode( node ); / 		   if(numberOfNodesProcessed > 5 * maxnode) { 4 			printf("Note: Cycle Limit in Initialization.\n");!   			for(i=1; i < maxnode; i++) { 6      			   if(PREVIOUS_STATE(i) == UNDEFINED_STATE) { , 				PRESENT_STATE( i ) = NODESET_VALUE( i );- 				PREVIOUS_STATE( i ) = NODESET_VALUE( i );  			   } "     			   PRESENT_STRENGTH(i) = 0; 			   NODESET_USED(i) = 0; 			}
 			return; 		   } 		}  	}     }  #ifdef DCDEBUG7     printf(" node %s  prev %g pres %g \n",NODE_NAME(i), )      PREVIOUS_STATE(i),PRESENT_STATE(i));  #endif   } I   for(i=1; i < maxnode; i++) { /* Run through nodes and reset time[0]. */ + 	if(PREVIOUS_STATE(i) == UNDEFINED_STATE) {  		PRESENT_STATE( i ) = 0.0;  		PREVIOUS_STATE( i ) = 0.0; 	}3 	if(PRESENT_STRENGTH(i) == HI_Z) { /* node decay */  		PRESENT_STATE( i ) = 0.0;  		PREVIOUS_STATE( i ) = 0.0; 	}     	PRESENT_STRENGTH(i) = 0;    }  }    schednode(nodenum) int nodenum; {      struct event *list;  #ifdef DCDEBUGO     printf("checking whether or not to schedule node %s\n",NODE_NAME(nodenum));  #endif,     if(WAVETYPE(nodenum) == USERSRC) return;!     if(event_list_head == NULL) {  	if(free_list_head == NULL) { H   	   event_list_head = (struct event *) ralloc(1,sizeof(struct event)); 	   numRallocs++; 	         }  	else { % 	   event_list_head = free_list_head; * 	   free_list_head = free_list_head->next; 	}& 	event_list_head->next_node = nodenum; 	event_list_head->next = NULL;# 	event_list_tail = event_list_head;  #ifdef DCDEBUGC     printf("scheduled node %s first in list\n",NODE_NAME(nodenum));  #endif     } 0     else { /* check to see if in list already */? 	for( list = event_list_head; list != NULL; list = list->next ) ( 		if(list->next_node == nodenum) return; 	if(free_list_head == NULL) { N   	   event_list_tail->next = (struct event *) ralloc(1,sizeof(struct event)); 	   numRallocs++; 	         }  	else { + 	   event_list_tail->next = free_list_head; * 	   free_list_head = free_list_head->next; 	}) 	event_list_tail = event_list_tail->next; & 	event_list_tail->next_node = nodenum; 	event_list_tail->next = NULL; #ifdef DCDEBUG=     printf("scheduled node %s in list\n",NODE_NAME(nodenum));  #endif     }  }      SchedAndInitAllOtherNodes()  { 
   int i,j;  ?   for(i=1; i < maxnode; i++) { /* Run through all the nodes. */ 9     if(WAVETYPE(i) != USERSRC) {  /* not an input node */ > 	if(NODESET_USED( i ) != USER_VALUE) {  /* nodeset not used */2 		PREVIOUS_STATE( i ) = UNDEFINED_STATE;   /* X */# 		NODESET_USED( i ) = FORCED_VALUE;  		schednode(i);  	}     }    }  }   " ScheduleFanoutsOfThisNode( node ) 	 int node;  {  int i; struct event *next_item; struct deventry *pentry; struct fet1 *pm1;  struct fet2 *pm2;  struct fetti *pmti;  struct fet3 *pm3;  struct lcap *cptr; struct lres *rptr; struct diode *dptr;         i = node; #ifdef DCDEBUG2        printf(" input node %s with wavesize=%d\n",, 		NODE_NAME(i), waves[i].present->wavesize); #endifJ      if(WAVETYPE(i) == USERSRC && waves[i].present->wavesize <= 1) return;  L      for(pentry= devarray[i].deventptr; pentry!=NULL; pentry=pentry->next) {! 	 switch(pentry->devptr->utype) {  	   case FET1:  3 	     pm1 = (struct fet1 *) pentry->devptr->devptr;  #ifdef DCDEBUG+ 	     printf(" fet1 s %s d %s g %s b %s\n", \ NODE_NAME(pm1->snode), NODE_NAME(pm1->dnode), NODE_NAME(pm1->gnode), NODE_NAME(pm1->bnode)); #endif< 	     if( i == pm1->gnode) { /* gate node so sched. d + s */ 	      if (i != pm1->snode)  	       schednode(pm1->snode); 	      if (i != pm1->dnode)  	       schednode(pm1->dnode); 	     } 8 	     else if ((i == pm1->snode) && (i != pm1->dnode)) { 	       schednode(pm1->dnode); 	     } 8 	     else if ((i == pm1->dnode) && (i != pm1->snode)) { 	       schednode(pm1->snode); 	     }  	     break; 	   case FETTI: 5 	     pmti = (struct fetti *) pentry->devptr->devptr; = 	     if( i == pmti->gnode) { /* gate node so sched. d + s */  	      if (i != pmti->snode) 	       schednode(pmti->snode);  	      if (i != pmti->dnode) 	       schednode(pmti->dnode);  	     } 4 	     else if (i == pmti->snode && i != pmti->dnode) 	       schednode(pmti->dnode); 4 	     else if (i == pmti->dnode && i != pmti->snode) 	       schednode(pmti->snode);  	     break; 	   case FET3:  3 	     pm3 = (struct fet3 *) pentry->devptr->devptr; < 	     if( i == pm3->gnode) { /* gate node so sched. d + s */ 	      if (i != pm3->snode)  	       schednode(pm3->snode); 	      if (i != pm3->dnode)  	       schednode(pm3->dnode); 	     } 2 	     else if (i == pm3->snode && i != pm3->dnode) 	       schednode(pm3->dnode);2 	     else if (i == pm3->dnode && i != pm3->snode) 	       schednode(pm3->snode); 	     break; 	   case LRES:5 	      rptr = (struct lres *) pentry->devptr->devptr;  	      if (i != rptr->node1) 	       schednode(rptr->node1);  	      if (i != rptr->node2) 	       schednode(rptr->node2);  	     break; 	   case DIODE: 5 	     dptr = (struct diode *) pentry->devptr->devptr;  #ifdef DCDEBUGI printf(" d  p %s n %s\n",NODE_NAME(dptr->anode), NODE_NAME(dptr->cnode));  #endif 	      if (i != dptr->anode) 	       schednode(dptr->anode);  	      if (i != dptr->cnode) 	       schednode(dptr->cnode);  	     break; 	   case LCAP: 	      /* if (i != cptr->node1)  	       schednode(cptr->node1);  	      if (i != cptr->node2)" 	       schednode(cptr->node2); */
 	      break;  	   case ISRC : break; 	   default : 4 	     printf("Unknown dev in DC solver\n"); exit(0); 	 }         } }       ! removeNodeFromEventList(thisNode) 
 int thisNode;  {      struct event *list;  #ifdef DCDEBUGL     printf("In removeNodeFromEventList: looking for node %s in this list: ", 		NODE_NAME(thisNode));  #endif"     if(event_list_head == NULL ) { #ifdef DCDEBUG"         printf(" empty list!!\n"); #endif     } D     for( list = event_list_head; list != NULL; list = list->next ) {         if(list->next_node > 0) { #ifdef DCDEBUG2         printf(" %s ",NODE_NAME(list->next_node)); #endif# 		if(list->next_node == thisNode) {  			list->next_node = -thisNode;  #ifdef DCDEBUG          printf(" found it!!\n"); #endif
 			return; 		}         }     }  #ifdef DCDEBUG(         printf(" couldn't find it!!\n"); #endif }      putNodeInSuperNodeList(node)	 int node;  {  #ifdef DCDEBUG0 	if(super_node_list[node] != NOT_IN_NODE_LIST) {R 		printf("putNodeInSuperNodeList: node %d is in list but it shouldn't be\n",node);
 		exit(0); 	} #endif 	if(first_node == 0) { 		first_node = node; 		last_node = node;  	} 	else {  #ifdef DCDEBUG 	if(last_node == 0) { @ 		printf("putNodeInSuperNodeList: last node %d is undefined\n");
 		exit(0); 	} #endif$ 		super_node_list[last_node] = node; 		last_node = node;  	} 	super_node_list[node] = 0;  }   0 mosdevice(vto,type,dnode,gnode,snode,bnode,node) double vto, type; ! int dnode,gnode,snode,bnode,node;  {  double vd,vg,vs,vgs,vtemp; int i, gateOn; int source,drain;       gateOn = TRUE;  #ifdef DCDEBUG2      printf(" fet %g s %s d %s g %s b %s\n", type,H NODE_NAME(snode), NODE_NAME(dnode), NODE_NAME(gnode), NODE_NAME(bnode));<      printf("  s %g d %g g %g b %g\n", PRESENT_STATE(snode),, PRESENT_STATE(dnode), PRESENT_STATE(gnode),  PRESENT_STATE(bnode)); #endif&    /* process source and drain only */'    if(node == snode || node == dnode) {    #ifdef DCDEBUGG printf(" fanin fet encountered with gate %g\n", PREVIOUS_STATE(gnode));  #endifA       vg = PRESENT_STATE( gnode );  /* >>> may be wrong value! */        if(vg > (high + low)/3.0)  	vg = high; 
       else
 	vg = low;       source = snode;        drain = dnode;!       if(type > 0.0) { /* NMOS */  #ifdef DCDEBUGH printf("nmos: vs=%g vd=%g\n",PRESENT_STATE(snode),PRESENT_STATE(dnode)); #endif6 	   if((vg <= vto) && (vto > 0.0)) {  /* device off */ 		gateOn = FALSE;  		vgs = low; 	   }  	   else
 		vgs = high; ' 	   /* >>> wrong value for vs and vd */ % 	   if((vs = PRESENT_STATE( snode)) > 3 		(vd = PRESENT_STATE( dnode))) {  /* swap D + S */  	      vtemp = vs; 	      vs = vd;  	      vd = vtemp; 	      source = dnode; 	      drain = snode;  	   }         }        else { /* PMOS */ #ifdef DCDEBUGH printf("pmos: vs=%g vd=%g\n",PRESENT_STATE(snode),PRESENT_STATE(dnode)); #endif7 	   if((vg == high) && (vto > 0.0)) {  /* device off */  		gateOn = FALSE;  		vgs = low; 	   }  	   else
 		vgs = high; ' 	   /* >>> wrong value for vs and vd */ & 	   if((vs = PRESENT_STATE( snode )) <3 		(vd = PRESENT_STATE( dnode ))) { /* swap D + S */  	      vtemp = vs; 	      vs = vd;  	      vd = vtemp; 	      source = dnode; 	      drain = snode;  	   }  	} #ifdef DCDEBUG# printf(" vto=%g vgs=%g\n",vto,vgs);  #endif+ 	/* >>> if vg is unknown, then assume ON */ 3 	if( PREVIOUS_STATE( gnode ) == UNDEFINED_STATE ) { ! 	   if(type == 1.0) {  /* NMOS */ ? 		PRESENT_STATE( gnode ) = high;  /* >>> what value is high? */ @ 		PREVIOUS_STATE( gnode ) = high;  /* >>> what value is high? */ 	   	vgs = high; 	   	gateOn = TRUE;  	   }  	   else {  /* PMOS */? 		PRESENT_STATE( gnode ) = high;  /* >>> what value is high? */ @ 		PREVIOUS_STATE( gnode ) = high;  /* >>> what value is high? */ 	   	vgs = low;  	   	gateOn = FALSE; 	   } D 	   NODESET_USED( gnode ) = FORCED_VALUE; /* >>> set nodeset flag */ #ifdef DCDEBUG( printf(" vg=X vto=%g vgs=%g\n",vto,vgs); #endif> 	   /* if (gnode != source) forcedSchedule = TRUE;  >>> why */ 	}  8 	if( vgs >= vto && gateOn == TRUE) {  /* device is on */H 	     if((WAVETYPE(snode) == USERSRC) || (WAVETYPE(dnode) == USERSRC)) { 		/* unidirectional gate */ ) 		if (vto < 0.0) { /* depletion device */  		   if( node == source) 			internal_state.voltage = vd; 	 		   else  			internal_state.voltage = vs; = 		   if (gnode == source || gnode == drain) { /* res. load */ ' 		      internal_state.strength = WEAK;  #ifdef DCDEBUG# printf(" device is on and weak\n");  #endif 		   } 		   else { * 		      internal_state.strength = FORCING; #ifdef DCDEBUG& printf(" device is on and forcing\n"); #endif 		   } 		} ) 		else if (vto > 0.0) { /* enh. driver */  		      if( node == source) " 			   internal_state.voltage = vd; 		      else /* drain node */ " 			   internal_state.voltage = vs;* 		      internal_state.strength = FORCING; #ifdef DCDEBUG& printf(" device is on and forcing\n"); #endif 		}  		else {: 		    printf("Unexpected case in DC Solver: vto = 0.0\n"); 		    exit(0); 		}  	    }$ 	    else { /* bidirectional gate */ #ifdef DCDEBUG/ 		printf("bidir: adding other node to list\n");  #endif9 		if (gnode == source || gnode == drain) { /* resistor */  		      if( node == drain) { 			internal_state.voltage = vs; ( 		      	internal_state.strength = WEAK;	 		      } + 		      else { /* processing source node */  			internal_state.voltage = vd; ( 		      	internal_state.strength = WEAK;	 		      }  		} 7 		else if(snode == node) { /* put drain node in list */ 0 			if(NODE_NOT_IN_LIST(dnode,super_node_list)) {" 				putNodeInSuperNodeList(dnode);# 				removeNodeFromEventList(dnode);  			} 		} 3 		else if(dnode == node) { /* put source in list */ 0 			if(NODE_NOT_IN_LIST(snode,super_node_list)) {" 				putNodeInSuperNodeList(snode);# 				removeNodeFromEventList(snode);  			} 		}  	    } 	} 	else {  /* device is off */H 	     if((WAVETYPE(snode) == USERSRC) || (WAVETYPE(dnode) == USERSRC)) { 		/* unidirectional */ 		      if( node == drain ) { # 			/* source connected to supply */  			if(gnode == drain) { " 			   internal_state.voltage = vs;. 		      	   internal_state.strength = FORCING; 			}	 			else { / 			   internal_state.voltage = previousVoltage; + 		      	   internal_state.strength = HI_Z;  			}	 		      } + 		      else { /* processing source node */  			if (gnode == source) { " 			   internal_state.voltage = vd;. 		      	   internal_state.strength = FORCING; 			}
 			else { / 			   internal_state.voltage = previousVoltage; + 		      	   internal_state.strength = HI_Z;  			}	 		      }  		}  		else {1 		      internal_state.voltage = previousVoltage; ' 		      internal_state.strength = HI_Z;  #ifdef DCDEBUG. printf(" device is off and high impedance\n"); #endif
 	        } 	 }       } }    ProcessNode( starting_node ) int starting_node; {  struct event *next_item; struct deventry *pentry; struct fet1 *pm1;  struct fet2 *pm2;  struct fetti *pmti;  struct fet3 *pm3;  struct lcap *cptr; struct lres *rptr; struct diode *dptr;  struct inmtimodel *mtiptr; struct ita_fet_model *m3ptr; struct ita_fet_model *m2ptr;	 int node;  int i;  4  /* Evaluate new voltage state for node and schedule$   *  fanouts if state change occurs.   */ #ifdef DCDEBUG<  printf(">>>processing node %s\n",NODE_NAME(starting_node)); #endif    numberOfNodesProcessed++;0  forcedSchedule = FALSE; nodeContention = FALSE;  first_node = 0;'  putNodeInSuperNodeList(starting_node); &  node_state.voltage = UNDEFINED_STATE;(  node_state.strength = UNKNOWN_STRENGTH;  9  for( i = first_node; i != 0 ; i = super_node_list[i] ) { -     internal_state.voltage = UNDEFINED_STATE; /     internal_state.strength = UNKNOWN_STRENGTH; 
     node = i;    #ifdef DCDEBUG1  printf(">processing node %s\n",NODE_NAME(node));  #endif  -     previousVoltage = PREVIOUS_STATE( node );   5     /* process every device connected to this node */ O     for(pentry = devarray[node].deventptr; pentry!=NULL; pentry=pentry->next) { !  	switch(pentry->devptr->utype) {     	case FET1:  3 	     pm1 = (struct fet1 *) pentry->devptr->devptr; : 	     mosdevice(pm1->mptr->vto,pm1->mptr->type,pm1->dnode,) 		pm1->gnode,pm1->snode,pm1->bnode,node);  	     break;    	case FETTI: 5 	     pmti = (struct fetti *) pentry->devptr->devptr; 0 	     mtiptr = (struct inmtimodel *) pmti->mptr;5 	     printf(" fetti not allowed for dc solution\n");  	     exit(0); 	     break;    	case FET3:  3 	     pm3 = (struct fet3 *) pentry->devptr->devptr; : 	     mosdevice(pm3->mptr->vto,pm3->mptr->type,pm3->dnode,. 	     pm3->gnode,pm3->snode,pm3->bnode,node);  	     break;    	case LRES:4 	     rptr = (struct lres *) pentry->devptr->devptr; #ifdef DCDEBUG; 	     printf(" r %s %s cond %g\n", NODE_NAME(rptr->node1),  ) 		NODE_NAME(rptr->node2), rptr->condval);  #endif6 	     if(rptr->node1 == node) { /* put node in list */+ 		if( WAVETYPE( rptr->node2 ) == USERSRC) {  #ifdef DCDEBUG, 	     printf(" r setting values of node\n"); #endif9 			internal_state.voltage = PRESENT_STATE( rptr->node2 ); % 			internal_state.strength = FORCING;  		} : 		else if(NODE_NOT_IN_LIST(rptr->node2,super_node_list)) {' 			putNodeInSuperNodeList(rptr->node2); ( 			removeNodeFromEventList(rptr->node2); 		}  	     } ; 	     else if(rptr->node2 == node) { /* put node in list */ + 		if( WAVETYPE( rptr->node1 ) == USERSRC) { 9 			internal_state.voltage = PRESENT_STATE( rptr->node1 ); % 			internal_state.strength = FORCING;  		} : 		else if(NODE_NOT_IN_LIST(rptr->node1,super_node_list)) {' 			putNodeInSuperNodeList(rptr->node1); ( 			removeNodeFromEventList(rptr->node1); 		}  	     }  	     break; 	   case DIODE: 5 	     dptr = (struct diode *) pentry->devptr->devptr;  #ifdef DCDEBUG9 	     printf(" d  p %d n %d\n",dptr->anode, dptr->cnode);  #endif 	     if(dptr->cnode == node) { , 		if( PRESENT_STATE( dptr->anode ) == low) {  			/* ignore device, it's off */ 		}  		else {9 			internal_state.voltage = PRESENT_STATE( dptr->anode ); ; 			internal_state.strength = PRESENT_STRENGTH(dptr->anode);  		}  	     } ; 	     else if(dptr->anode == node) { /* put node in list */ - 		if( PRESENT_STATE( dptr->cnode ) == high) {   			/* ignore device, it's off */ 		}  		else {9 			internal_state.voltage = PRESENT_STATE( dptr->cnode ); ; 			internal_state.strength = PRESENT_STRENGTH(dptr->cnode);  		}  	     }  	     break;3 	   case LCAP: break;  /* caps are open circuits */  	   case ISRC : break; 	   default : D 	     printf("ProcessNode: Unknown device in DC Solver\n"); exit(0); 	 } & 	 /* keep track of strongest device */ #ifdef DCDEBUG.      printf("int state %g and strength %d.\n",6      internal_state.voltage, internal_state.strength); #endif7 	 if (internal_state.strength > node_state.strength ) {  		nodeContention = FALSE; 0 		node_state.strength = internal_state.strength;. 		node_state.voltage = internal_state.voltage; 	 } < 	 else if (node_state.strength == internal_state.strength &&8 	 	    (node_state.voltage != internal_state.voltage)) { 		nodeContention = TRUE;0 		node_state.strength = internal_state.strength;' 		node_state.voltage = UNDEFINED_STATE;  	 }         } #ifdef DCDEBUG2      printf("so far state %g and strength %d. \n",.      node_state.voltage, node_state.strength); #endif      }      if(nodeContention == TRUE) & 	node_state.voltage = UNDEFINED_STATE; #ifdef DCDEBUG  printf("super node list:\n");7  for( i = first_node; i != 0 ; i = super_node_list[i] )   	printf(" %d * ",i);   printf("\n"); #endif      node = 0;=      for( i = first_node; i != 0 ; i = super_node_list[i] ) { * 	super_node_list[node] = NOT_IN_NODE_LIST;         node = i; 1         if(NODESET_USED(node) == FORCED_VALUE) {  7 		/* then we set this node to a value so set it back */ ) 		PREVIOUS_STATE(node) = UNDEFINED_STATE; ( 		PRESENT_STATE(node) = UNDEFINED_STATE;'         	NODESET_USED(node) = NOT_USED;       	}    #ifdef NODE_STATE_ONLYM      printf("######### node %s new state %g and strength %d. prev state %g ", V      NODE_NAME(node),node_state.voltage, node_state.strength, PREVIOUS_STATE( node )); #endifR         if(node_state.voltage != PREVIOUS_STATE(node) || forcedSchedule == TRUE) { #ifdef NODE_STATE_ONLY6         if(node_state.voltage != PREVIOUS_STATE(node)) 		printf("+\n");'         else if(forcedSchedule == TRUE)  		printf("*\n"); #endif- 		PRESENT_STATE( node ) = node_state.voltage; 1 		PRESENT_STRENGTH( node ) = node_state.strength; . 		PREVIOUS_STATE( node ) = node_state.voltage; #ifdef DCDEBUG7 		printf("scheduling fanouts of %s\n",NODE_NAME(node));  #endif$ 		ScheduleFanoutsOfThisNode( node ); 	} #ifdef NODE_STATE_ONLY 	else {  		printf("-\n"); 	} #endif      }.      super_node_list[node] = NOT_IN_NODE_LIST; }      LogicSim(subptr) struct subcircuit *subptr; { & 	struct event *event_list, *next_item; 	int node,i;  0 	/* initialize super node list and event list */&     	if( maxnode >= MAX_WIRED_NODES) {5 		printf(" MAX_WIRED_NODES too small in dcsol.c!\n"); 
 		exit(0);     	}+     	if( maxnode >= MAX_NODES_IN_CIRCUIT) { 5 		printf(" MAX_WIRED_NODES too small in dcsol.c!\n"); 
 		exit(0);     	}$ 	for(i=1; i< MAX_WIRED_NODES ; i++) ( 		super_node_list[i] = NOT_IN_NODE_LIST;" 	super_node_list[0] = END_OF_LIST;) 	for(i=0; i< MAX_NODES_IN_CIRCUIT ; i++)  $ 		event_list_array[i] = END_OF_LIST;  " 	input_list_head = GetInputList();*         for( next_item = input_list_head; ?      		next_item->next_node != 0 ; next_item = next_item->next) ; 	        ScheduleFanoutsOfThisNode( next_item->next_node );   ? 	/* GetInputList figures out high and low so check them here */ @ 	if(low == high) return; /* if high=low=0.0, skip DC solution */   	SchedAndInitAllOtherNodes();   # 	while( event_list_head != NULL ) { $ 		node = event_list_head->next_node; 		if(free_list_head == NULL) {$ 			free_list_head = event_list_head;$ 			free_list_tail = event_list_head;+ 			event_list_head = event_list_head->next;  			free_list_tail->next = NULL;  			free_list_counter = 1;  		}  		else {* 			free_list_tail->next = event_list_head;$ 			free_list_tail = event_list_head;+ 			event_list_head = event_list_head->next;  			free_list_tail->next = NULL;  			free_list_counter++;  		} : 		if((node > 0) && (NODESET_USED( node ) != USER_VALUE)) { 		   ProcessNode( node ); / 		   if(numberOfNodesProcessed > 5 * maxnode) { 4 			printf("Note: Cycle Limit in Initialization.\n");!   			for(i=1; i < maxnode; i++) { 6      			   if(PREVIOUS_STATE(i) == UNDEFINED_STATE) { , 				PRESENT_STATE( i ) = NODESET_VALUE( i );- 				PREVIOUS_STATE( i ) = NODESET_VALUE( i );  			   } "     			   PRESENT_STRENGTH(i) = 0; 			}
 			return; 		   } 		}  	} 	ReprocessUndefNodes();    #ifdef DUMP_STATS ! 	printf("DC SOLUTION STATS: \n"); I 	printf(" Number of Nodes =%d Space Allocated =%d\n",maxnode,numRallocs); K   	printf(" Number of logic nodes Processed: %d\n",numberOfNodesProcessed);  #endif 	/* THINGS LEFT TO DO: */  	/* handle diodes properly */ $ 	/* take care of NMOS low voltage */; 	/* Handle UNKNOWN node voltage better during simulation */ = 	/* after simulation, use ITA to solve nonlinear equations */ ? 	/* use level 1 initially and then level 2 or 3, if required */  } 